# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class UserAuthorization(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        UserAuthorization - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'roles': 'list[DomainRole]',
            'unused_roles': 'list[DomainRole]',
            'permissions': 'list[str]',
            'permission_policies': 'list[ResourcePermissionPolicy]'
        }

        self.attribute_map = {
            'roles': 'roles',
            'unused_roles': 'unusedRoles',
            'permissions': 'permissions',
            'permission_policies': 'permissionPolicies'
        }

        self._roles = None
        self._unused_roles = None
        self._permissions = None
        self._permission_policies = None

    @property
    def roles(self):
        """
        Gets the roles of this UserAuthorization.


        :return: The roles of this UserAuthorization.
        :rtype: list[DomainRole]
        """
        return self._roles

    @roles.setter
    def roles(self, roles):
        """
        Sets the roles of this UserAuthorization.


        :param roles: The roles of this UserAuthorization.
        :type: list[DomainRole]
        """
        

        self._roles = roles

    @property
    def unused_roles(self):
        """
        Gets the unused_roles of this UserAuthorization.
        A collection of the roles the user is not using

        :return: The unused_roles of this UserAuthorization.
        :rtype: list[DomainRole]
        """
        return self._unused_roles

    @unused_roles.setter
    def unused_roles(self, unused_roles):
        """
        Sets the unused_roles of this UserAuthorization.
        A collection of the roles the user is not using

        :param unused_roles: The unused_roles of this UserAuthorization.
        :type: list[DomainRole]
        """
        

        self._unused_roles = unused_roles

    @property
    def permissions(self):
        """
        Gets the permissions of this UserAuthorization.
        A collection of the permissions granted by all assigned roles

        :return: The permissions of this UserAuthorization.
        :rtype: list[str]
        """
        return self._permissions

    @permissions.setter
    def permissions(self, permissions):
        """
        Sets the permissions of this UserAuthorization.
        A collection of the permissions granted by all assigned roles

        :param permissions: The permissions of this UserAuthorization.
        :type: list[str]
        """
        

        self._permissions = permissions

    @property
    def permission_policies(self):
        """
        Gets the permission_policies of this UserAuthorization.
        The policies configured for assigned permissions.

        :return: The permission_policies of this UserAuthorization.
        :rtype: list[ResourcePermissionPolicy]
        """
        return self._permission_policies

    @permission_policies.setter
    def permission_policies(self, permission_policies):
        """
        Sets the permission_policies of this UserAuthorization.
        The policies configured for assigned permissions.

        :param permission_policies: The permission_policies of this UserAuthorization.
        :type: list[ResourcePermissionPolicy]
        """
        

        self._permission_policies = permission_policies

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

