# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class SearchUpdateRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        SearchUpdateRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'session_id': 'str',
            'answered': 'bool',
            'selected_answer': 'SelectedAnswer'
        }

        self.attribute_map = {
            'session_id': 'sessionId',
            'answered': 'answered',
            'selected_answer': 'selectedAnswer'
        }

        self._session_id = None
        self._answered = None
        self._selected_answer = None

    @property
    def session_id(self):
        """
        Gets the session_id of this SearchUpdateRequest.
        The unique identifier of this session

        :return: The session_id of this SearchUpdateRequest.
        :rtype: str
        """
        return self._session_id

    @session_id.setter
    def session_id(self, session_id):
        """
        Sets the session_id of this SearchUpdateRequest.
        The unique identifier of this session

        :param session_id: The session_id of this SearchUpdateRequest.
        :type: str
        """
        

        self._session_id = session_id

    @property
    def answered(self):
        """
        Gets the answered of this SearchUpdateRequest.
        Mark the search as answered/unanswered

        :return: The answered of this SearchUpdateRequest.
        :rtype: bool
        """
        return self._answered

    @answered.setter
    def answered(self, answered):
        """
        Sets the answered of this SearchUpdateRequest.
        Mark the search as answered/unanswered

        :param answered: The answered of this SearchUpdateRequest.
        :type: bool
        """
        

        self._answered = answered

    @property
    def selected_answer(self):
        """
        Gets the selected_answer of this SearchUpdateRequest.
        The selected search result chosen as the answer.

        :return: The selected_answer of this SearchUpdateRequest.
        :rtype: SelectedAnswer
        """
        return self._selected_answer

    @selected_answer.setter
    def selected_answer(self, selected_answer):
        """
        Sets the selected_answer of this SearchUpdateRequest.
        The selected search result chosen as the answer.

        :param selected_answer: The selected_answer of this SearchUpdateRequest.
        :type: SelectedAnswer
        """
        

        self._selected_answer = selected_answer

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

