# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ReverseWhitepagesLookupResult(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ReverseWhitepagesLookupResult - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'contacts': 'list[ExternalContact]',
            'external_organizations': 'list[ExternalOrganization]'
        }

        self.attribute_map = {
            'contacts': 'contacts',
            'external_organizations': 'externalOrganizations'
        }

        self._contacts = None
        self._external_organizations = None

    @property
    def contacts(self):
        """
        Gets the contacts of this ReverseWhitepagesLookupResult.


        :return: The contacts of this ReverseWhitepagesLookupResult.
        :rtype: list[ExternalContact]
        """
        return self._contacts

    @contacts.setter
    def contacts(self, contacts):
        """
        Sets the contacts of this ReverseWhitepagesLookupResult.


        :param contacts: The contacts of this ReverseWhitepagesLookupResult.
        :type: list[ExternalContact]
        """
        

        self._contacts = contacts

    @property
    def external_organizations(self):
        """
        Gets the external_organizations of this ReverseWhitepagesLookupResult.


        :return: The external_organizations of this ReverseWhitepagesLookupResult.
        :rtype: list[ExternalOrganization]
        """
        return self._external_organizations

    @external_organizations.setter
    def external_organizations(self, external_organizations):
        """
        Sets the external_organizations of this ReverseWhitepagesLookupResult.


        :param external_organizations: The external_organizations of this ReverseWhitepagesLookupResult.
        :type: list[ExternalOrganization]
        """
        

        self._external_organizations = external_organizations

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

