# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class OutboundSettings(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        OutboundSettings - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'version': 'int',
            'max_calls_per_agent': 'int',
            'max_configurable_calls_per_agent': 'int',
            'max_line_utilization': 'float',
            'abandon_seconds': 'float',
            'compliance_abandon_rate_denominator': 'str',
            'automatic_time_zone_mapping': 'AutomaticTimeZoneMappingSettings',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'version': 'version',
            'max_calls_per_agent': 'maxCallsPerAgent',
            'max_configurable_calls_per_agent': 'maxConfigurableCallsPerAgent',
            'max_line_utilization': 'maxLineUtilization',
            'abandon_seconds': 'abandonSeconds',
            'compliance_abandon_rate_denominator': 'complianceAbandonRateDenominator',
            'automatic_time_zone_mapping': 'automaticTimeZoneMapping',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._date_created = None
        self._date_modified = None
        self._version = None
        self._max_calls_per_agent = None
        self._max_configurable_calls_per_agent = None
        self._max_line_utilization = None
        self._abandon_seconds = None
        self._compliance_abandon_rate_denominator = None
        self._automatic_time_zone_mapping = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this OutboundSettings.
        The globally unique identifier for the object.

        :return: The id of this OutboundSettings.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this OutboundSettings.
        The globally unique identifier for the object.

        :param id: The id of this OutboundSettings.
        :type: str
        """
        

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this OutboundSettings.


        :return: The name of this OutboundSettings.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this OutboundSettings.


        :param name: The name of this OutboundSettings.
        :type: str
        """
        

        self._name = name

    @property
    def date_created(self):
        """
        Gets the date_created of this OutboundSettings.
        Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this OutboundSettings.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created):
        """
        Sets the date_created of this OutboundSettings.
        Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this OutboundSettings.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_modified(self):
        """
        Gets the date_modified of this OutboundSettings.
        Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this OutboundSettings.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified):
        """
        Sets the date_modified of this OutboundSettings.
        Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this OutboundSettings.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def version(self):
        """
        Gets the version of this OutboundSettings.
        Required for updates, must match the version number of the most recent update

        :return: The version of this OutboundSettings.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this OutboundSettings.
        Required for updates, must match the version number of the most recent update

        :param version: The version of this OutboundSettings.
        :type: int
        """
        

        self._version = version

    @property
    def max_calls_per_agent(self):
        """
        Gets the max_calls_per_agent of this OutboundSettings.
        The maximum number of calls that can be placed per agent on any campaign

        :return: The max_calls_per_agent of this OutboundSettings.
        :rtype: int
        """
        return self._max_calls_per_agent

    @max_calls_per_agent.setter
    def max_calls_per_agent(self, max_calls_per_agent):
        """
        Sets the max_calls_per_agent of this OutboundSettings.
        The maximum number of calls that can be placed per agent on any campaign

        :param max_calls_per_agent: The max_calls_per_agent of this OutboundSettings.
        :type: int
        """
        

        self._max_calls_per_agent = max_calls_per_agent

    @property
    def max_configurable_calls_per_agent(self):
        """
        Gets the max_configurable_calls_per_agent of this OutboundSettings.
        The maximum number of calls that can be configured to be placed per agent on any campaign

        :return: The max_configurable_calls_per_agent of this OutboundSettings.
        :rtype: int
        """
        return self._max_configurable_calls_per_agent

    @max_configurable_calls_per_agent.setter
    def max_configurable_calls_per_agent(self, max_configurable_calls_per_agent):
        """
        Sets the max_configurable_calls_per_agent of this OutboundSettings.
        The maximum number of calls that can be configured to be placed per agent on any campaign

        :param max_configurable_calls_per_agent: The max_configurable_calls_per_agent of this OutboundSettings.
        :type: int
        """
        

        self._max_configurable_calls_per_agent = max_configurable_calls_per_agent

    @property
    def max_line_utilization(self):
        """
        Gets the max_line_utilization of this OutboundSettings.
        The maximum percentage of lines that should be used for Outbound, expressed as a decimal in the range [0.0, 1.0]

        :return: The max_line_utilization of this OutboundSettings.
        :rtype: float
        """
        return self._max_line_utilization

    @max_line_utilization.setter
    def max_line_utilization(self, max_line_utilization):
        """
        Sets the max_line_utilization of this OutboundSettings.
        The maximum percentage of lines that should be used for Outbound, expressed as a decimal in the range [0.0, 1.0]

        :param max_line_utilization: The max_line_utilization of this OutboundSettings.
        :type: float
        """
        

        self._max_line_utilization = max_line_utilization

    @property
    def abandon_seconds(self):
        """
        Gets the abandon_seconds of this OutboundSettings.
        The number of seconds used to determine if a call is abandoned

        :return: The abandon_seconds of this OutboundSettings.
        :rtype: float
        """
        return self._abandon_seconds

    @abandon_seconds.setter
    def abandon_seconds(self, abandon_seconds):
        """
        Sets the abandon_seconds of this OutboundSettings.
        The number of seconds used to determine if a call is abandoned

        :param abandon_seconds: The abandon_seconds of this OutboundSettings.
        :type: float
        """
        

        self._abandon_seconds = abandon_seconds

    @property
    def compliance_abandon_rate_denominator(self):
        """
        Gets the compliance_abandon_rate_denominator of this OutboundSettings.
        The denominator to be used in determining the compliance abandon rate

        :return: The compliance_abandon_rate_denominator of this OutboundSettings.
        :rtype: str
        """
        return self._compliance_abandon_rate_denominator

    @compliance_abandon_rate_denominator.setter
    def compliance_abandon_rate_denominator(self, compliance_abandon_rate_denominator):
        """
        Sets the compliance_abandon_rate_denominator of this OutboundSettings.
        The denominator to be used in determining the compliance abandon rate

        :param compliance_abandon_rate_denominator: The compliance_abandon_rate_denominator of this OutboundSettings.
        :type: str
        """
        allowed_values = ["ALL_CALLS", "CALLS_THAT_REACHED_QUEUE"]
        if compliance_abandon_rate_denominator.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for compliance_abandon_rate_denominator -> " + compliance_abandon_rate_denominator)
            self._compliance_abandon_rate_denominator = "outdated_sdk_version"
        else:
            self._compliance_abandon_rate_denominator = compliance_abandon_rate_denominator

    @property
    def automatic_time_zone_mapping(self):
        """
        Gets the automatic_time_zone_mapping of this OutboundSettings.
        The settings for automatic time zone mapping. Note that changing these settings will change them for both voice and messaging campaigns.

        :return: The automatic_time_zone_mapping of this OutboundSettings.
        :rtype: AutomaticTimeZoneMappingSettings
        """
        return self._automatic_time_zone_mapping

    @automatic_time_zone_mapping.setter
    def automatic_time_zone_mapping(self, automatic_time_zone_mapping):
        """
        Sets the automatic_time_zone_mapping of this OutboundSettings.
        The settings for automatic time zone mapping. Note that changing these settings will change them for both voice and messaging campaigns.

        :param automatic_time_zone_mapping: The automatic_time_zone_mapping of this OutboundSettings.
        :type: AutomaticTimeZoneMappingSettings
        """
        

        self._automatic_time_zone_mapping = automatic_time_zone_mapping

    @property
    def self_uri(self):
        """
        Gets the self_uri of this OutboundSettings.
        The URI for this object

        :return: The self_uri of this OutboundSettings.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this OutboundSettings.
        The URI for this object

        :param self_uri: The self_uri of this OutboundSettings.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

