# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class OrphanUpdateRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        OrphanUpdateRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'archive_date': 'datetime',
            'delete_date': 'datetime',
            'export_date': 'datetime',
            'integration_id': 'str',
            'conversation_id': 'str'
        }

        self.attribute_map = {
            'archive_date': 'archiveDate',
            'delete_date': 'deleteDate',
            'export_date': 'exportDate',
            'integration_id': 'integrationId',
            'conversation_id': 'conversationId'
        }

        self._archive_date = None
        self._delete_date = None
        self._export_date = None
        self._integration_id = None
        self._conversation_id = None

    @property
    def archive_date(self):
        """
        Gets the archive_date of this OrphanUpdateRequest.
        The orphan recording's archive date. Must be greater than 1 day from now if set. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The archive_date of this OrphanUpdateRequest.
        :rtype: datetime
        """
        return self._archive_date

    @archive_date.setter
    def archive_date(self, archive_date):
        """
        Sets the archive_date of this OrphanUpdateRequest.
        The orphan recording's archive date. Must be greater than 1 day from now if set. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param archive_date: The archive_date of this OrphanUpdateRequest.
        :type: datetime
        """
        

        self._archive_date = archive_date

    @property
    def delete_date(self):
        """
        Gets the delete_date of this OrphanUpdateRequest.
        The orphan recording's delete date. Must be greater than archiveDate and exportDate if set, otherwise one day from now. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The delete_date of this OrphanUpdateRequest.
        :rtype: datetime
        """
        return self._delete_date

    @delete_date.setter
    def delete_date(self, delete_date):
        """
        Sets the delete_date of this OrphanUpdateRequest.
        The orphan recording's delete date. Must be greater than archiveDate and exportDate if set, otherwise one day from now. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param delete_date: The delete_date of this OrphanUpdateRequest.
        :type: datetime
        """
        

        self._delete_date = delete_date

    @property
    def export_date(self):
        """
        Gets the export_date of this OrphanUpdateRequest.
        The orphan recording's export date. Must be greater than 1 day from now if set. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The export_date of this OrphanUpdateRequest.
        :rtype: datetime
        """
        return self._export_date

    @export_date.setter
    def export_date(self, export_date):
        """
        Sets the export_date of this OrphanUpdateRequest.
        The orphan recording's export date. Must be greater than 1 day from now if set. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param export_date: The export_date of this OrphanUpdateRequest.
        :type: datetime
        """
        

        self._export_date = export_date

    @property
    def integration_id(self):
        """
        Gets the integration_id of this OrphanUpdateRequest.
        IntegrationId to access AWS S3 bucket for export. This field is required if exportDate is set.

        :return: The integration_id of this OrphanUpdateRequest.
        :rtype: str
        """
        return self._integration_id

    @integration_id.setter
    def integration_id(self, integration_id):
        """
        Sets the integration_id of this OrphanUpdateRequest.
        IntegrationId to access AWS S3 bucket for export. This field is required if exportDate is set.

        :param integration_id: The integration_id of this OrphanUpdateRequest.
        :type: str
        """
        

        self._integration_id = integration_id

    @property
    def conversation_id(self):
        """
        Gets the conversation_id of this OrphanUpdateRequest.
        A conversation Id that this orphan's recording is to be attached to. If not present, the conversationId will be deduced from the recording media.

        :return: The conversation_id of this OrphanUpdateRequest.
        :rtype: str
        """
        return self._conversation_id

    @conversation_id.setter
    def conversation_id(self, conversation_id):
        """
        Sets the conversation_id of this OrphanUpdateRequest.
        A conversation Id that this orphan's recording is to be attached to. If not present, the conversationId will be deduced from the recording media.

        :param conversation_id: The conversation_id of this OrphanUpdateRequest.
        :type: str
        """
        

        self._conversation_id = conversation_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

