# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ListedProgram(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ListedProgram - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'description': 'str',
            'published': 'bool',
            'topics_count': 'int',
            'tags': 'list[str]',
            'modified_by': 'AddressableEntityRef',
            'date_modified': 'datetime',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'published': 'published',
            'topics_count': 'topicsCount',
            'tags': 'tags',
            'modified_by': 'modifiedBy',
            'date_modified': 'dateModified',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._description = None
        self._published = None
        self._topics_count = None
        self._tags = None
        self._modified_by = None
        self._date_modified = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this ListedProgram.
        The globally unique identifier for the object.

        :return: The id of this ListedProgram.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ListedProgram.
        The globally unique identifier for the object.

        :param id: The id of this ListedProgram.
        :type: str
        """
        

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this ListedProgram.


        :return: The name of this ListedProgram.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ListedProgram.


        :param name: The name of this ListedProgram.
        :type: str
        """
        

        self._name = name

    @property
    def description(self):
        """
        Gets the description of this ListedProgram.


        :return: The description of this ListedProgram.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ListedProgram.


        :param description: The description of this ListedProgram.
        :type: str
        """
        

        self._description = description

    @property
    def published(self):
        """
        Gets the published of this ListedProgram.


        :return: The published of this ListedProgram.
        :rtype: bool
        """
        return self._published

    @published.setter
    def published(self, published):
        """
        Sets the published of this ListedProgram.


        :param published: The published of this ListedProgram.
        :type: bool
        """
        

        self._published = published

    @property
    def topics_count(self):
        """
        Gets the topics_count of this ListedProgram.


        :return: The topics_count of this ListedProgram.
        :rtype: int
        """
        return self._topics_count

    @topics_count.setter
    def topics_count(self, topics_count):
        """
        Sets the topics_count of this ListedProgram.


        :param topics_count: The topics_count of this ListedProgram.
        :type: int
        """
        

        self._topics_count = topics_count

    @property
    def tags(self):
        """
        Gets the tags of this ListedProgram.


        :return: The tags of this ListedProgram.
        :rtype: list[str]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this ListedProgram.


        :param tags: The tags of this ListedProgram.
        :type: list[str]
        """
        

        self._tags = tags

    @property
    def modified_by(self):
        """
        Gets the modified_by of this ListedProgram.


        :return: The modified_by of this ListedProgram.
        :rtype: AddressableEntityRef
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by):
        """
        Sets the modified_by of this ListedProgram.


        :param modified_by: The modified_by of this ListedProgram.
        :type: AddressableEntityRef
        """
        

        self._modified_by = modified_by

    @property
    def date_modified(self):
        """
        Gets the date_modified of this ListedProgram.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this ListedProgram.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified):
        """
        Sets the date_modified of this ListedProgram.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this ListedProgram.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def self_uri(self):
        """
        Gets the self_uri of this ListedProgram.
        The URI for this object

        :return: The self_uri of this ListedProgram.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this ListedProgram.
        The URI for this object

        :param self_uri: The self_uri of this ListedProgram.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

