# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class IntradayPlanningGroupRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        IntradayPlanningGroupRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'business_unit_date': 'date',
            'categories': 'list[str]',
            'planning_group_ids': 'list[str]',
            'interval_length_minutes': 'int'
        }

        self.attribute_map = {
            'business_unit_date': 'businessUnitDate',
            'categories': 'categories',
            'planning_group_ids': 'planningGroupIds',
            'interval_length_minutes': 'intervalLengthMinutes'
        }

        self._business_unit_date = None
        self._categories = None
        self._planning_group_ids = None
        self._interval_length_minutes = None

    @property
    def business_unit_date(self):
        """
        Gets the business_unit_date of this IntradayPlanningGroupRequest.
        Requested date in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The business_unit_date of this IntradayPlanningGroupRequest.
        :rtype: date
        """
        return self._business_unit_date

    @business_unit_date.setter
    def business_unit_date(self, business_unit_date):
        """
        Sets the business_unit_date of this IntradayPlanningGroupRequest.
        Requested date in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param business_unit_date: The business_unit_date of this IntradayPlanningGroupRequest.
        :type: date
        """
        

        self._business_unit_date = business_unit_date

    @property
    def categories(self):
        """
        Gets the categories of this IntradayPlanningGroupRequest.
        The metric categories

        :return: The categories of this IntradayPlanningGroupRequest.
        :rtype: list[str]
        """
        return self._categories

    @categories.setter
    def categories(self, categories):
        """
        Sets the categories of this IntradayPlanningGroupRequest.
        The metric categories

        :param categories: The categories of this IntradayPlanningGroupRequest.
        :type: list[str]
        """
        

        self._categories = categories

    @property
    def planning_group_ids(self):
        """
        Gets the planning_group_ids of this IntradayPlanningGroupRequest.
        The IDs of the planning groups for which to fetch data.  Omitting or passing an empty list will return all available planning groups

        :return: The planning_group_ids of this IntradayPlanningGroupRequest.
        :rtype: list[str]
        """
        return self._planning_group_ids

    @planning_group_ids.setter
    def planning_group_ids(self, planning_group_ids):
        """
        Sets the planning_group_ids of this IntradayPlanningGroupRequest.
        The IDs of the planning groups for which to fetch data.  Omitting or passing an empty list will return all available planning groups

        :param planning_group_ids: The planning_group_ids of this IntradayPlanningGroupRequest.
        :type: list[str]
        """
        

        self._planning_group_ids = planning_group_ids

    @property
    def interval_length_minutes(self):
        """
        Gets the interval_length_minutes of this IntradayPlanningGroupRequest.
        The period/interval in minutes for which to aggregate the data. Required, defaults to 15

        :return: The interval_length_minutes of this IntradayPlanningGroupRequest.
        :rtype: int
        """
        return self._interval_length_minutes

    @interval_length_minutes.setter
    def interval_length_minutes(self, interval_length_minutes):
        """
        Sets the interval_length_minutes of this IntradayPlanningGroupRequest.
        The period/interval in minutes for which to aggregate the data. Required, defaults to 15

        :param interval_length_minutes: The interval_length_minutes of this IntradayPlanningGroupRequest.
        :type: int
        """
        

        self._interval_length_minutes = interval_length_minutes

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

