# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class DetectedNamedEntity(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        DetectedNamedEntity - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'entity_type': 'str',
            'probability': 'float',
            'value': 'DetectedNamedEntityValue'
        }

        self.attribute_map = {
            'name': 'name',
            'entity_type': 'entityType',
            'probability': 'probability',
            'value': 'value'
        }

        self._name = None
        self._entity_type = None
        self._probability = None
        self._value = None

    @property
    def name(self):
        """
        Gets the name of this DetectedNamedEntity.
        The name of the detected named entity.

        :return: The name of this DetectedNamedEntity.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this DetectedNamedEntity.
        The name of the detected named entity.

        :param name: The name of this DetectedNamedEntity.
        :type: str
        """
        

        self._name = name

    @property
    def entity_type(self):
        """
        Gets the entity_type of this DetectedNamedEntity.
        The type of the detected named entity.

        :return: The entity_type of this DetectedNamedEntity.
        :rtype: str
        """
        return self._entity_type

    @entity_type.setter
    def entity_type(self, entity_type):
        """
        Sets the entity_type of this DetectedNamedEntity.
        The type of the detected named entity.

        :param entity_type: The entity_type of this DetectedNamedEntity.
        :type: str
        """
        

        self._entity_type = entity_type

    @property
    def probability(self):
        """
        Gets the probability of this DetectedNamedEntity.
        The probability of the detected named entity.

        :return: The probability of this DetectedNamedEntity.
        :rtype: float
        """
        return self._probability

    @probability.setter
    def probability(self, probability):
        """
        Sets the probability of this DetectedNamedEntity.
        The probability of the detected named entity.

        :param probability: The probability of this DetectedNamedEntity.
        :type: float
        """
        

        self._probability = probability

    @property
    def value(self):
        """
        Gets the value of this DetectedNamedEntity.
        The value of the detected named entity.

        :return: The value of this DetectedNamedEntity.
        :rtype: DetectedNamedEntityValue
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this DetectedNamedEntity.
        The value of the detected named entity.

        :param value: The value of this DetectedNamedEntity.
        :type: DetectedNamedEntityValue
        """
        

        self._value = value

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

