# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class CreateWebChatConversationResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        CreateWebChatConversationResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'jwt': 'str',
            'event_stream_uri': 'str',
            'member': 'WebChatMemberInfo'
        }

        self.attribute_map = {
            'id': 'id',
            'jwt': 'jwt',
            'event_stream_uri': 'eventStreamUri',
            'member': 'member'
        }

        self._id = None
        self._jwt = None
        self._event_stream_uri = None
        self._member = None

    @property
    def id(self):
        """
        Gets the id of this CreateWebChatConversationResponse.
        Chat Conversation identifier

        :return: The id of this CreateWebChatConversationResponse.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this CreateWebChatConversationResponse.
        Chat Conversation identifier

        :param id: The id of this CreateWebChatConversationResponse.
        :type: str
        """
        

        self._id = id

    @property
    def jwt(self):
        """
        Gets the jwt of this CreateWebChatConversationResponse.
        The JWT that you can use to identify subsequent calls on this conversation

        :return: The jwt of this CreateWebChatConversationResponse.
        :rtype: str
        """
        return self._jwt

    @jwt.setter
    def jwt(self, jwt):
        """
        Sets the jwt of this CreateWebChatConversationResponse.
        The JWT that you can use to identify subsequent calls on this conversation

        :param jwt: The jwt of this CreateWebChatConversationResponse.
        :type: str
        """
        

        self._jwt = jwt

    @property
    def event_stream_uri(self):
        """
        Gets the event_stream_uri of this CreateWebChatConversationResponse.
        The URI which provides the conversation event stream.

        :return: The event_stream_uri of this CreateWebChatConversationResponse.
        :rtype: str
        """
        return self._event_stream_uri

    @event_stream_uri.setter
    def event_stream_uri(self, event_stream_uri):
        """
        Sets the event_stream_uri of this CreateWebChatConversationResponse.
        The URI which provides the conversation event stream.

        :param event_stream_uri: The event_stream_uri of this CreateWebChatConversationResponse.
        :type: str
        """
        

        self._event_stream_uri = event_stream_uri

    @property
    def member(self):
        """
        Gets the member of this CreateWebChatConversationResponse.
        Chat Member

        :return: The member of this CreateWebChatConversationResponse.
        :rtype: WebChatMemberInfo
        """
        return self._member

    @member.setter
    def member(self, member):
        """
        Sets the member of this CreateWebChatConversationResponse.
        Chat Member

        :param member: The member of this CreateWebChatConversationResponse.
        :type: WebChatMemberInfo
        """
        

        self._member = member

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

