# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ConversationMetricsTopicConversationMetricRecord(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ConversationMetricsTopicConversationMetricRecord - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'metric': 'str',
            'metric_date': 'datetime',
            'value': 'int',
            'record_id': 'str',
            'active_skill_ids': 'list[str]',
            'address_from': 'str',
            'address_to': 'str',
            'agent_assistant_id': 'str',
            'agent_bullseye_ring': 'int',
            'agent_owned': 'bool',
            'ani': 'str',
            'assigner_id': 'str',
            'authenticated': 'bool',
            'conversation_id': 'str',
            'conversation_initiator': 'str',
            'converted_from': 'str',
            'converted_to': 'str',
            'customer_participation': 'bool',
            'delivery_status': 'str',
            'destination_addresses': 'list[str]',
            'direction': 'str',
            'disconnect_type': 'str',
            'division_ids': 'list[str]',
            'dnis': 'str',
            'edge_id': 'str',
            'eligible_agent_counts': 'list[int]',
            'error_code': 'str',
            'extended_delivery_status': 'str',
            'external_contact_id': 'str',
            'external_media_count': 'int',
            'external_organization_id': 'str',
            'external_tag': 'str',
            'first_queue': 'bool',
            'flagged_reason': 'str',
            'flow_in_type': 'str',
            'flow_out_type': 'str',
            'group_id': 'str',
            'interaction_type': 'str',
            'journey_action_id': 'str',
            'journey_action_map_id': 'str',
            'journey_action_map_version': 'int',
            'journey_customer_id': 'str',
            'journey_customer_id_type': 'str',
            'journey_customer_session_id': 'str',
            'journey_customer_session_id_type': 'str',
            'knowledge_base_ids': 'list[str]',
            'media_count': 'int',
            'media_type': 'str',
            'message_type': 'str',
            'originating_direction': 'str',
            'outbound_campaign_id': 'str',
            'outbound_contact_id': 'str',
            'outbound_contact_list_id': 'str',
            'participant_name': 'str',
            'peer_id': 'str',
            'provider': 'str',
            'purpose': 'str',
            'queue_id': 'str',
            'remote': 'str',
            'removed_skill_ids': 'list[str]',
            'reoffered': 'bool',
            'requested_language_id': 'str',
            'requested_routing_skill_ids': 'list[str]',
            'requested_routings': 'list[str]',
            'room_id': 'str',
            'routing_priority': 'int',
            'routing_ring': 'int',
            'selected_agent_id': 'str',
            'selected_agent_rank': 'int',
            'self_served': 'bool',
            'session_dnis': 'str',
            'session_id': 'str',
            'station_id': 'str',
            'team_id': 'str',
            'used_routing': 'str',
            'user_id': 'str',
            'waiting_interaction_counts': 'list[int]',
            'wrap_up_code': 'str',
            'proposed_agents': 'list[ConversationMetricsTopicConversationProposedAgent]',
            'scored_agents': 'list[ConversationMetricsTopicConversationScoredAgent]'
        }

        self.attribute_map = {
            'metric': 'metric',
            'metric_date': 'metricDate',
            'value': 'value',
            'record_id': 'recordId',
            'active_skill_ids': 'activeSkillIds',
            'address_from': 'addressFrom',
            'address_to': 'addressTo',
            'agent_assistant_id': 'agentAssistantId',
            'agent_bullseye_ring': 'agentBullseyeRing',
            'agent_owned': 'agentOwned',
            'ani': 'ani',
            'assigner_id': 'assignerId',
            'authenticated': 'authenticated',
            'conversation_id': 'conversationId',
            'conversation_initiator': 'conversationInitiator',
            'converted_from': 'convertedFrom',
            'converted_to': 'convertedTo',
            'customer_participation': 'customerParticipation',
            'delivery_status': 'deliveryStatus',
            'destination_addresses': 'destinationAddresses',
            'direction': 'direction',
            'disconnect_type': 'disconnectType',
            'division_ids': 'divisionIds',
            'dnis': 'dnis',
            'edge_id': 'edgeId',
            'eligible_agent_counts': 'eligibleAgentCounts',
            'error_code': 'errorCode',
            'extended_delivery_status': 'extendedDeliveryStatus',
            'external_contact_id': 'externalContactId',
            'external_media_count': 'externalMediaCount',
            'external_organization_id': 'externalOrganizationId',
            'external_tag': 'externalTag',
            'first_queue': 'firstQueue',
            'flagged_reason': 'flaggedReason',
            'flow_in_type': 'flowInType',
            'flow_out_type': 'flowOutType',
            'group_id': 'groupId',
            'interaction_type': 'interactionType',
            'journey_action_id': 'journeyActionId',
            'journey_action_map_id': 'journeyActionMapId',
            'journey_action_map_version': 'journeyActionMapVersion',
            'journey_customer_id': 'journeyCustomerId',
            'journey_customer_id_type': 'journeyCustomerIdType',
            'journey_customer_session_id': 'journeyCustomerSessionId',
            'journey_customer_session_id_type': 'journeyCustomerSessionIdType',
            'knowledge_base_ids': 'knowledgeBaseIds',
            'media_count': 'mediaCount',
            'media_type': 'mediaType',
            'message_type': 'messageType',
            'originating_direction': 'originatingDirection',
            'outbound_campaign_id': 'outboundCampaignId',
            'outbound_contact_id': 'outboundContactId',
            'outbound_contact_list_id': 'outboundContactListId',
            'participant_name': 'participantName',
            'peer_id': 'peerId',
            'provider': 'provider',
            'purpose': 'purpose',
            'queue_id': 'queueId',
            'remote': 'remote',
            'removed_skill_ids': 'removedSkillIds',
            'reoffered': 'reoffered',
            'requested_language_id': 'requestedLanguageId',
            'requested_routing_skill_ids': 'requestedRoutingSkillIds',
            'requested_routings': 'requestedRoutings',
            'room_id': 'roomId',
            'routing_priority': 'routingPriority',
            'routing_ring': 'routingRing',
            'selected_agent_id': 'selectedAgentId',
            'selected_agent_rank': 'selectedAgentRank',
            'self_served': 'selfServed',
            'session_dnis': 'sessionDnis',
            'session_id': 'sessionId',
            'station_id': 'stationId',
            'team_id': 'teamId',
            'used_routing': 'usedRouting',
            'user_id': 'userId',
            'waiting_interaction_counts': 'waitingInteractionCounts',
            'wrap_up_code': 'wrapUpCode',
            'proposed_agents': 'proposedAgents',
            'scored_agents': 'scoredAgents'
        }

        self._metric = None
        self._metric_date = None
        self._value = None
        self._record_id = None
        self._active_skill_ids = None
        self._address_from = None
        self._address_to = None
        self._agent_assistant_id = None
        self._agent_bullseye_ring = None
        self._agent_owned = None
        self._ani = None
        self._assigner_id = None
        self._authenticated = None
        self._conversation_id = None
        self._conversation_initiator = None
        self._converted_from = None
        self._converted_to = None
        self._customer_participation = None
        self._delivery_status = None
        self._destination_addresses = None
        self._direction = None
        self._disconnect_type = None
        self._division_ids = None
        self._dnis = None
        self._edge_id = None
        self._eligible_agent_counts = None
        self._error_code = None
        self._extended_delivery_status = None
        self._external_contact_id = None
        self._external_media_count = None
        self._external_organization_id = None
        self._external_tag = None
        self._first_queue = None
        self._flagged_reason = None
        self._flow_in_type = None
        self._flow_out_type = None
        self._group_id = None
        self._interaction_type = None
        self._journey_action_id = None
        self._journey_action_map_id = None
        self._journey_action_map_version = None
        self._journey_customer_id = None
        self._journey_customer_id_type = None
        self._journey_customer_session_id = None
        self._journey_customer_session_id_type = None
        self._knowledge_base_ids = None
        self._media_count = None
        self._media_type = None
        self._message_type = None
        self._originating_direction = None
        self._outbound_campaign_id = None
        self._outbound_contact_id = None
        self._outbound_contact_list_id = None
        self._participant_name = None
        self._peer_id = None
        self._provider = None
        self._purpose = None
        self._queue_id = None
        self._remote = None
        self._removed_skill_ids = None
        self._reoffered = None
        self._requested_language_id = None
        self._requested_routing_skill_ids = None
        self._requested_routings = None
        self._room_id = None
        self._routing_priority = None
        self._routing_ring = None
        self._selected_agent_id = None
        self._selected_agent_rank = None
        self._self_served = None
        self._session_dnis = None
        self._session_id = None
        self._station_id = None
        self._team_id = None
        self._used_routing = None
        self._user_id = None
        self._waiting_interaction_counts = None
        self._wrap_up_code = None
        self._proposed_agents = None
        self._scored_agents = None

    @property
    def metric(self):
        """
        Gets the metric of this ConversationMetricsTopicConversationMetricRecord.
        Metric name

        :return: The metric of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._metric

    @metric.setter
    def metric(self, metric):
        """
        Sets the metric of this ConversationMetricsTopicConversationMetricRecord.
        Metric name

        :param metric: The metric of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        allowed_values = ["nBlindTransferred", "nCobrowseSessions", "nConnected", "nConsult", "nConsultTransferred", "nError", "nOffered", "nOutbound", "nOutboundAbandoned", "nOutboundAttempted", "nOutboundConnected", "nOverSla", "nTransferred", "oExternalMediaCount", "oMediaCount", "oMessageTurn", "tAbandon", "tAcd", "tAcw", "tAgentResponseTime", "tAlert", "tAnswered", "tBarging", "tCallback", "tCallbackComplete", "tCoaching", "tCoachingComplete", "tConnected", "tContacting", "tDialing", "tFirstConnect", "tFirstDial", "tFlowOut", "tHandle", "tHeld", "tHeldComplete", "tIvr", "tMonitoring", "tMonitoringComplete", "tNotResponding", "tTalk", "tTalkComplete", "tUserResponseTime", "tVoicemail"]
        if metric.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for metric -> " + metric)
            self._metric = "outdated_sdk_version"
        else:
            self._metric = metric

    @property
    def metric_date(self):
        """
        Gets the metric_date of this ConversationMetricsTopicConversationMetricRecord.
        The date and time of metric creation

        :return: The metric_date of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: datetime
        """
        return self._metric_date

    @metric_date.setter
    def metric_date(self, metric_date):
        """
        Sets the metric_date of this ConversationMetricsTopicConversationMetricRecord.
        The date and time of metric creation

        :param metric_date: The metric_date of this ConversationMetricsTopicConversationMetricRecord.
        :type: datetime
        """
        

        self._metric_date = metric_date

    @property
    def value(self):
        """
        Gets the value of this ConversationMetricsTopicConversationMetricRecord.
        Metric value

        :return: The value of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: int
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this ConversationMetricsTopicConversationMetricRecord.
        Metric value

        :param value: The value of this ConversationMetricsTopicConversationMetricRecord.
        :type: int
        """
        

        self._value = value

    @property
    def record_id(self):
        """
        Gets the record_id of this ConversationMetricsTopicConversationMetricRecord.
        Record identifier

        :return: The record_id of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._record_id

    @record_id.setter
    def record_id(self, record_id):
        """
        Sets the record_id of this ConversationMetricsTopicConversationMetricRecord.
        Record identifier

        :param record_id: The record_id of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._record_id = record_id

    @property
    def active_skill_ids(self):
        """
        Gets the active_skill_ids of this ConversationMetricsTopicConversationMetricRecord.
        ID(s) of Skill(s) that are active on the conversation

        :return: The active_skill_ids of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: list[str]
        """
        return self._active_skill_ids

    @active_skill_ids.setter
    def active_skill_ids(self, active_skill_ids):
        """
        Sets the active_skill_ids of this ConversationMetricsTopicConversationMetricRecord.
        ID(s) of Skill(s) that are active on the conversation

        :param active_skill_ids: The active_skill_ids of this ConversationMetricsTopicConversationMetricRecord.
        :type: list[str]
        """
        

        self._active_skill_ids = active_skill_ids

    @property
    def address_from(self):
        """
        Gets the address_from of this ConversationMetricsTopicConversationMetricRecord.
        The address that initiated an action

        :return: The address_from of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._address_from

    @address_from.setter
    def address_from(self, address_from):
        """
        Sets the address_from of this ConversationMetricsTopicConversationMetricRecord.
        The address that initiated an action

        :param address_from: The address_from of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._address_from = address_from

    @property
    def address_to(self):
        """
        Gets the address_to of this ConversationMetricsTopicConversationMetricRecord.
        The address receiving an action

        :return: The address_to of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._address_to

    @address_to.setter
    def address_to(self, address_to):
        """
        Sets the address_to of this ConversationMetricsTopicConversationMetricRecord.
        The address receiving an action

        :param address_to: The address_to of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._address_to = address_to

    @property
    def agent_assistant_id(self):
        """
        Gets the agent_assistant_id of this ConversationMetricsTopicConversationMetricRecord.
        Unique identifier of the active virtual agent assistant

        :return: The agent_assistant_id of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._agent_assistant_id

    @agent_assistant_id.setter
    def agent_assistant_id(self, agent_assistant_id):
        """
        Sets the agent_assistant_id of this ConversationMetricsTopicConversationMetricRecord.
        Unique identifier of the active virtual agent assistant

        :param agent_assistant_id: The agent_assistant_id of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._agent_assistant_id = agent_assistant_id

    @property
    def agent_bullseye_ring(self):
        """
        Gets the agent_bullseye_ring of this ConversationMetricsTopicConversationMetricRecord.
        Bullseye ring of the targeted agent

        :return: The agent_bullseye_ring of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: int
        """
        return self._agent_bullseye_ring

    @agent_bullseye_ring.setter
    def agent_bullseye_ring(self, agent_bullseye_ring):
        """
        Sets the agent_bullseye_ring of this ConversationMetricsTopicConversationMetricRecord.
        Bullseye ring of the targeted agent

        :param agent_bullseye_ring: The agent_bullseye_ring of this ConversationMetricsTopicConversationMetricRecord.
        :type: int
        """
        

        self._agent_bullseye_ring = agent_bullseye_ring

    @property
    def agent_owned(self):
        """
        Gets the agent_owned of this ConversationMetricsTopicConversationMetricRecord.
        Flag indicating an agent-owned callback

        :return: The agent_owned of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: bool
        """
        return self._agent_owned

    @agent_owned.setter
    def agent_owned(self, agent_owned):
        """
        Sets the agent_owned of this ConversationMetricsTopicConversationMetricRecord.
        Flag indicating an agent-owned callback

        :param agent_owned: The agent_owned of this ConversationMetricsTopicConversationMetricRecord.
        :type: bool
        """
        

        self._agent_owned = agent_owned

    @property
    def ani(self):
        """
        Gets the ani of this ConversationMetricsTopicConversationMetricRecord.
        Automatic Number Identification (caller's number)

        :return: The ani of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._ani

    @ani.setter
    def ani(self, ani):
        """
        Sets the ani of this ConversationMetricsTopicConversationMetricRecord.
        Automatic Number Identification (caller's number)

        :param ani: The ani of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._ani = ani

    @property
    def assigner_id(self):
        """
        Gets the assigner_id of this ConversationMetricsTopicConversationMetricRecord.
        ID of the user that manually assigned a conversation

        :return: The assigner_id of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._assigner_id

    @assigner_id.setter
    def assigner_id(self, assigner_id):
        """
        Sets the assigner_id of this ConversationMetricsTopicConversationMetricRecord.
        ID of the user that manually assigned a conversation

        :param assigner_id: The assigner_id of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._assigner_id = assigner_id

    @property
    def authenticated(self):
        """
        Gets the authenticated of this ConversationMetricsTopicConversationMetricRecord.
        Flag that indicates that the identity of the customer has been asserted as verified by the provider.

        :return: The authenticated of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: bool
        """
        return self._authenticated

    @authenticated.setter
    def authenticated(self, authenticated):
        """
        Sets the authenticated of this ConversationMetricsTopicConversationMetricRecord.
        Flag that indicates that the identity of the customer has been asserted as verified by the provider.

        :param authenticated: The authenticated of this ConversationMetricsTopicConversationMetricRecord.
        :type: bool
        """
        

        self._authenticated = authenticated

    @property
    def conversation_id(self):
        """
        Gets the conversation_id of this ConversationMetricsTopicConversationMetricRecord.
        Unique identifier for the conversation

        :return: The conversation_id of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._conversation_id

    @conversation_id.setter
    def conversation_id(self, conversation_id):
        """
        Sets the conversation_id of this ConversationMetricsTopicConversationMetricRecord.
        Unique identifier for the conversation

        :param conversation_id: The conversation_id of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._conversation_id = conversation_id

    @property
    def conversation_initiator(self):
        """
        Gets the conversation_initiator of this ConversationMetricsTopicConversationMetricRecord.
        Indicates the participant purpose of the participant initiating a message conversation

        :return: The conversation_initiator of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._conversation_initiator

    @conversation_initiator.setter
    def conversation_initiator(self, conversation_initiator):
        """
        Sets the conversation_initiator of this ConversationMetricsTopicConversationMetricRecord.
        Indicates the participant purpose of the participant initiating a message conversation

        :param conversation_initiator: The conversation_initiator of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        allowed_values = ["acd", "agent", "api", "botflow", "campaign", "customer", "dialer", "external", "fax", "group", "inbound", "ivr", "manual", "outbound", "station", "user", "voicemail", "workflow"]
        if conversation_initiator.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for conversation_initiator -> " + conversation_initiator)
            self._conversation_initiator = "outdated_sdk_version"
        else:
            self._conversation_initiator = conversation_initiator

    @property
    def converted_from(self):
        """
        Gets the converted_from of this ConversationMetricsTopicConversationMetricRecord.
        Session media type that was converted from in case of a media type conversion

        :return: The converted_from of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._converted_from

    @converted_from.setter
    def converted_from(self, converted_from):
        """
        Sets the converted_from of this ConversationMetricsTopicConversationMetricRecord.
        Session media type that was converted from in case of a media type conversion

        :param converted_from: The converted_from of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._converted_from = converted_from

    @property
    def converted_to(self):
        """
        Gets the converted_to of this ConversationMetricsTopicConversationMetricRecord.
        Session media type that was converted to in case of a media type conversion

        :return: The converted_to of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._converted_to

    @converted_to.setter
    def converted_to(self, converted_to):
        """
        Sets the converted_to of this ConversationMetricsTopicConversationMetricRecord.
        Session media type that was converted to in case of a media type conversion

        :param converted_to: The converted_to of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._converted_to = converted_to

    @property
    def customer_participation(self):
        """
        Gets the customer_participation of this ConversationMetricsTopicConversationMetricRecord.
        Indicates a messaging conversation in which the customer participated by sending at least one message

        :return: The customer_participation of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: bool
        """
        return self._customer_participation

    @customer_participation.setter
    def customer_participation(self, customer_participation):
        """
        Sets the customer_participation of this ConversationMetricsTopicConversationMetricRecord.
        Indicates a messaging conversation in which the customer participated by sending at least one message

        :param customer_participation: The customer_participation of this ConversationMetricsTopicConversationMetricRecord.
        :type: bool
        """
        

        self._customer_participation = customer_participation

    @property
    def delivery_status(self):
        """
        Gets the delivery_status of this ConversationMetricsTopicConversationMetricRecord.
        The email or SMS delivery status

        :return: The delivery_status of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._delivery_status

    @delivery_status.setter
    def delivery_status(self, delivery_status):
        """
        Sets the delivery_status of this ConversationMetricsTopicConversationMetricRecord.
        The email or SMS delivery status

        :param delivery_status: The delivery_status of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        allowed_values = ["DeliveryFailed", "DeliverySuccess", "Failed", "Queued", "Read", "Received", "Sent"]
        if delivery_status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for delivery_status -> " + delivery_status)
            self._delivery_status = "outdated_sdk_version"
        else:
            self._delivery_status = delivery_status

    @property
    def destination_addresses(self):
        """
        Gets the destination_addresses of this ConversationMetricsTopicConversationMetricRecord.
        Destination address(es) of transfers or consults

        :return: The destination_addresses of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: list[str]
        """
        return self._destination_addresses

    @destination_addresses.setter
    def destination_addresses(self, destination_addresses):
        """
        Sets the destination_addresses of this ConversationMetricsTopicConversationMetricRecord.
        Destination address(es) of transfers or consults

        :param destination_addresses: The destination_addresses of this ConversationMetricsTopicConversationMetricRecord.
        :type: list[str]
        """
        

        self._destination_addresses = destination_addresses

    @property
    def direction(self):
        """
        Gets the direction of this ConversationMetricsTopicConversationMetricRecord.
        The direction of the communication

        :return: The direction of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._direction

    @direction.setter
    def direction(self, direction):
        """
        Sets the direction of this ConversationMetricsTopicConversationMetricRecord.
        The direction of the communication

        :param direction: The direction of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        allowed_values = ["inbound", "outbound"]
        if direction.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for direction -> " + direction)
            self._direction = "outdated_sdk_version"
        else:
            self._direction = direction

    @property
    def disconnect_type(self):
        """
        Gets the disconnect_type of this ConversationMetricsTopicConversationMetricRecord.
        The session disconnect type

        :return: The disconnect_type of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._disconnect_type

    @disconnect_type.setter
    def disconnect_type(self, disconnect_type):
        """
        Sets the disconnect_type of this ConversationMetricsTopicConversationMetricRecord.
        The session disconnect type

        :param disconnect_type: The disconnect_type of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        allowed_values = ["client", "conferenceTransfer", "consultTransfer", "endpoint", "error", "forwardTransfer", "noAnswerTransfer", "notAvailableTransfer", "other", "peer", "spam", "system", "timeout", "transfer", "transportFailure", "uncallable"]
        if disconnect_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for disconnect_type -> " + disconnect_type)
            self._disconnect_type = "outdated_sdk_version"
        else:
            self._disconnect_type = disconnect_type

    @property
    def division_ids(self):
        """
        Gets the division_ids of this ConversationMetricsTopicConversationMetricRecord.
        Identifier(s) of division(s) associated with a conversation

        :return: The division_ids of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: list[str]
        """
        return self._division_ids

    @division_ids.setter
    def division_ids(self, division_ids):
        """
        Sets the division_ids of this ConversationMetricsTopicConversationMetricRecord.
        Identifier(s) of division(s) associated with a conversation

        :param division_ids: The division_ids of this ConversationMetricsTopicConversationMetricRecord.
        :type: list[str]
        """
        

        self._division_ids = division_ids

    @property
    def dnis(self):
        """
        Gets the dnis of this ConversationMetricsTopicConversationMetricRecord.
        Dialed number identification service (number dialed by the calling party)

        :return: The dnis of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._dnis

    @dnis.setter
    def dnis(self, dnis):
        """
        Sets the dnis of this ConversationMetricsTopicConversationMetricRecord.
        Dialed number identification service (number dialed by the calling party)

        :param dnis: The dnis of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._dnis = dnis

    @property
    def edge_id(self):
        """
        Gets the edge_id of this ConversationMetricsTopicConversationMetricRecord.
        Unique identifier of the edge device

        :return: The edge_id of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._edge_id

    @edge_id.setter
    def edge_id(self, edge_id):
        """
        Sets the edge_id of this ConversationMetricsTopicConversationMetricRecord.
        Unique identifier of the edge device

        :param edge_id: The edge_id of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._edge_id = edge_id

    @property
    def eligible_agent_counts(self):
        """
        Gets the eligible_agent_counts of this ConversationMetricsTopicConversationMetricRecord.
        Number of eligible agents for each predictive routing attempt

        :return: The eligible_agent_counts of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: list[int]
        """
        return self._eligible_agent_counts

    @eligible_agent_counts.setter
    def eligible_agent_counts(self, eligible_agent_counts):
        """
        Sets the eligible_agent_counts of this ConversationMetricsTopicConversationMetricRecord.
        Number of eligible agents for each predictive routing attempt

        :param eligible_agent_counts: The eligible_agent_counts of this ConversationMetricsTopicConversationMetricRecord.
        :type: list[int]
        """
        

        self._eligible_agent_counts = eligible_agent_counts

    @property
    def error_code(self):
        """
        Gets the error_code of this ConversationMetricsTopicConversationMetricRecord.
        A code corresponding to the error that occurred

        :return: The error_code of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._error_code

    @error_code.setter
    def error_code(self, error_code):
        """
        Sets the error_code of this ConversationMetricsTopicConversationMetricRecord.
        A code corresponding to the error that occurred

        :param error_code: The error_code of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._error_code = error_code

    @property
    def extended_delivery_status(self):
        """
        Gets the extended_delivery_status of this ConversationMetricsTopicConversationMetricRecord.
        Extended delivery status

        :return: The extended_delivery_status of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._extended_delivery_status

    @extended_delivery_status.setter
    def extended_delivery_status(self, extended_delivery_status):
        """
        Sets the extended_delivery_status of this ConversationMetricsTopicConversationMetricRecord.
        Extended delivery status

        :param extended_delivery_status: The extended_delivery_status of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._extended_delivery_status = extended_delivery_status

    @property
    def external_contact_id(self):
        """
        Gets the external_contact_id of this ConversationMetricsTopicConversationMetricRecord.
        External contact identifier

        :return: The external_contact_id of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._external_contact_id

    @external_contact_id.setter
    def external_contact_id(self, external_contact_id):
        """
        Sets the external_contact_id of this ConversationMetricsTopicConversationMetricRecord.
        External contact identifier

        :param external_contact_id: The external_contact_id of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._external_contact_id = external_contact_id

    @property
    def external_media_count(self):
        """
        Gets the external_media_count of this ConversationMetricsTopicConversationMetricRecord.
        Count of any media (images, files, etc) included on the external session

        :return: The external_media_count of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: int
        """
        return self._external_media_count

    @external_media_count.setter
    def external_media_count(self, external_media_count):
        """
        Sets the external_media_count of this ConversationMetricsTopicConversationMetricRecord.
        Count of any media (images, files, etc) included on the external session

        :param external_media_count: The external_media_count of this ConversationMetricsTopicConversationMetricRecord.
        :type: int
        """
        

        self._external_media_count = external_media_count

    @property
    def external_organization_id(self):
        """
        Gets the external_organization_id of this ConversationMetricsTopicConversationMetricRecord.
        External organization identifier

        :return: The external_organization_id of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._external_organization_id

    @external_organization_id.setter
    def external_organization_id(self, external_organization_id):
        """
        Sets the external_organization_id of this ConversationMetricsTopicConversationMetricRecord.
        External organization identifier

        :param external_organization_id: The external_organization_id of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._external_organization_id = external_organization_id

    @property
    def external_tag(self):
        """
        Gets the external_tag of this ConversationMetricsTopicConversationMetricRecord.
        External tag for the conversation

        :return: The external_tag of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._external_tag

    @external_tag.setter
    def external_tag(self, external_tag):
        """
        Sets the external_tag of this ConversationMetricsTopicConversationMetricRecord.
        External tag for the conversation

        :param external_tag: The external_tag of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._external_tag = external_tag

    @property
    def first_queue(self):
        """
        Gets the first_queue of this ConversationMetricsTopicConversationMetricRecord.
        Marker that is set if the current queue is the first queue in a conversation

        :return: The first_queue of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: bool
        """
        return self._first_queue

    @first_queue.setter
    def first_queue(self, first_queue):
        """
        Sets the first_queue of this ConversationMetricsTopicConversationMetricRecord.
        Marker that is set if the current queue is the first queue in a conversation

        :param first_queue: The first_queue of this ConversationMetricsTopicConversationMetricRecord.
        :type: bool
        """
        

        self._first_queue = first_queue

    @property
    def flagged_reason(self):
        """
        Gets the flagged_reason of this ConversationMetricsTopicConversationMetricRecord.
        Reason for which participant flagged conversation

        :return: The flagged_reason of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._flagged_reason

    @flagged_reason.setter
    def flagged_reason(self, flagged_reason):
        """
        Sets the flagged_reason of this ConversationMetricsTopicConversationMetricRecord.
        Reason for which participant flagged conversation

        :param flagged_reason: The flagged_reason of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        allowed_values = ["general"]
        if flagged_reason.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for flagged_reason -> " + flagged_reason)
            self._flagged_reason = "outdated_sdk_version"
        else:
            self._flagged_reason = flagged_reason

    @property
    def flow_in_type(self):
        """
        Gets the flow_in_type of this ConversationMetricsTopicConversationMetricRecord.
        Type of flow in that occurred when entering ACD.

        :return: The flow_in_type of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._flow_in_type

    @flow_in_type.setter
    def flow_in_type(self, flow_in_type):
        """
        Sets the flow_in_type of this ConversationMetricsTopicConversationMetricRecord.
        Type of flow in that occurred when entering ACD.

        :param flow_in_type: The flow_in_type of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._flow_in_type = flow_in_type

    @property
    def flow_out_type(self):
        """
        Gets the flow_out_type of this ConversationMetricsTopicConversationMetricRecord.
        Type of flow out that occurred when emitting tFlowOut.

        :return: The flow_out_type of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._flow_out_type

    @flow_out_type.setter
    def flow_out_type(self, flow_out_type):
        """
        Sets the flow_out_type of this ConversationMetricsTopicConversationMetricRecord.
        Type of flow out that occurred when emitting tFlowOut.

        :param flow_out_type: The flow_out_type of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._flow_out_type = flow_out_type

    @property
    def group_id(self):
        """
        Gets the group_id of this ConversationMetricsTopicConversationMetricRecord.
        Unique identifier for a PureCloud group

        :return: The group_id of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._group_id

    @group_id.setter
    def group_id(self, group_id):
        """
        Sets the group_id of this ConversationMetricsTopicConversationMetricRecord.
        Unique identifier for a PureCloud group

        :param group_id: The group_id of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._group_id = group_id

    @property
    def interaction_type(self):
        """
        Gets the interaction_type of this ConversationMetricsTopicConversationMetricRecord.
        The interaction type (enterprise or contactCenter)

        :return: The interaction_type of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._interaction_type

    @interaction_type.setter
    def interaction_type(self, interaction_type):
        """
        Sets the interaction_type of this ConversationMetricsTopicConversationMetricRecord.
        The interaction type (enterprise or contactCenter)

        :param interaction_type: The interaction_type of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._interaction_type = interaction_type

    @property
    def journey_action_id(self):
        """
        Gets the journey_action_id of this ConversationMetricsTopicConversationMetricRecord.
        Identifier of the journey action.

        :return: The journey_action_id of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._journey_action_id

    @journey_action_id.setter
    def journey_action_id(self, journey_action_id):
        """
        Sets the journey_action_id of this ConversationMetricsTopicConversationMetricRecord.
        Identifier of the journey action.

        :param journey_action_id: The journey_action_id of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._journey_action_id = journey_action_id

    @property
    def journey_action_map_id(self):
        """
        Gets the journey_action_map_id of this ConversationMetricsTopicConversationMetricRecord.
        Identifier of the journey action map that triggered the action.

        :return: The journey_action_map_id of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._journey_action_map_id

    @journey_action_map_id.setter
    def journey_action_map_id(self, journey_action_map_id):
        """
        Sets the journey_action_map_id of this ConversationMetricsTopicConversationMetricRecord.
        Identifier of the journey action map that triggered the action.

        :param journey_action_map_id: The journey_action_map_id of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._journey_action_map_id = journey_action_map_id

    @property
    def journey_action_map_version(self):
        """
        Gets the journey_action_map_version of this ConversationMetricsTopicConversationMetricRecord.
        Version of the journey action map that triggered the action.

        :return: The journey_action_map_version of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: int
        """
        return self._journey_action_map_version

    @journey_action_map_version.setter
    def journey_action_map_version(self, journey_action_map_version):
        """
        Sets the journey_action_map_version of this ConversationMetricsTopicConversationMetricRecord.
        Version of the journey action map that triggered the action.

        :param journey_action_map_version: The journey_action_map_version of this ConversationMetricsTopicConversationMetricRecord.
        :type: int
        """
        

        self._journey_action_map_version = journey_action_map_version

    @property
    def journey_customer_id(self):
        """
        Gets the journey_customer_id of this ConversationMetricsTopicConversationMetricRecord.
        Primary identifier of the journey customer in the source where the activities originate from.

        :return: The journey_customer_id of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._journey_customer_id

    @journey_customer_id.setter
    def journey_customer_id(self, journey_customer_id):
        """
        Sets the journey_customer_id of this ConversationMetricsTopicConversationMetricRecord.
        Primary identifier of the journey customer in the source where the activities originate from.

        :param journey_customer_id: The journey_customer_id of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._journey_customer_id = journey_customer_id

    @property
    def journey_customer_id_type(self):
        """
        Gets the journey_customer_id_type of this ConversationMetricsTopicConversationMetricRecord.
        Type of primary identifier of the journey customer (e.g. cookie).

        :return: The journey_customer_id_type of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._journey_customer_id_type

    @journey_customer_id_type.setter
    def journey_customer_id_type(self, journey_customer_id_type):
        """
        Sets the journey_customer_id_type of this ConversationMetricsTopicConversationMetricRecord.
        Type of primary identifier of the journey customer (e.g. cookie).

        :param journey_customer_id_type: The journey_customer_id_type of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._journey_customer_id_type = journey_customer_id_type

    @property
    def journey_customer_session_id(self):
        """
        Gets the journey_customer_session_id of this ConversationMetricsTopicConversationMetricRecord.
        Unique identifier of the journey session.

        :return: The journey_customer_session_id of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._journey_customer_session_id

    @journey_customer_session_id.setter
    def journey_customer_session_id(self, journey_customer_session_id):
        """
        Sets the journey_customer_session_id of this ConversationMetricsTopicConversationMetricRecord.
        Unique identifier of the journey session.

        :param journey_customer_session_id: The journey_customer_session_id of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._journey_customer_session_id = journey_customer_session_id

    @property
    def journey_customer_session_id_type(self):
        """
        Gets the journey_customer_session_id_type of this ConversationMetricsTopicConversationMetricRecord.
        Type or category of journey sessions (e.g. web, ticket, delivery, atm).

        :return: The journey_customer_session_id_type of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._journey_customer_session_id_type

    @journey_customer_session_id_type.setter
    def journey_customer_session_id_type(self, journey_customer_session_id_type):
        """
        Sets the journey_customer_session_id_type of this ConversationMetricsTopicConversationMetricRecord.
        Type or category of journey sessions (e.g. web, ticket, delivery, atm).

        :param journey_customer_session_id_type: The journey_customer_session_id_type of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._journey_customer_session_id_type = journey_customer_session_id_type

    @property
    def knowledge_base_ids(self):
        """
        Gets the knowledge_base_ids of this ConversationMetricsTopicConversationMetricRecord.
        The unique identifier(s) of the knowledge base(s) used

        :return: The knowledge_base_ids of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: list[str]
        """
        return self._knowledge_base_ids

    @knowledge_base_ids.setter
    def knowledge_base_ids(self, knowledge_base_ids):
        """
        Sets the knowledge_base_ids of this ConversationMetricsTopicConversationMetricRecord.
        The unique identifier(s) of the knowledge base(s) used

        :param knowledge_base_ids: The knowledge_base_ids of this ConversationMetricsTopicConversationMetricRecord.
        :type: list[str]
        """
        

        self._knowledge_base_ids = knowledge_base_ids

    @property
    def media_count(self):
        """
        Gets the media_count of this ConversationMetricsTopicConversationMetricRecord.
        Count of any media (images, files, etc) included in this session

        :return: The media_count of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: int
        """
        return self._media_count

    @media_count.setter
    def media_count(self, media_count):
        """
        Sets the media_count of this ConversationMetricsTopicConversationMetricRecord.
        Count of any media (images, files, etc) included in this session

        :param media_count: The media_count of this ConversationMetricsTopicConversationMetricRecord.
        :type: int
        """
        

        self._media_count = media_count

    @property
    def media_type(self):
        """
        Gets the media_type of this ConversationMetricsTopicConversationMetricRecord.
        The session media type

        :return: The media_type of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._media_type

    @media_type.setter
    def media_type(self, media_type):
        """
        Sets the media_type of this ConversationMetricsTopicConversationMetricRecord.
        The session media type

        :param media_type: The media_type of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        allowed_values = ["callback", "chat", "cobrowse", "email", "message", "screenshare", "unknown", "video", "voice"]
        if media_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for media_type -> " + media_type)
            self._media_type = "outdated_sdk_version"
        else:
            self._media_type = media_type

    @property
    def message_type(self):
        """
        Gets the message_type of this ConversationMetricsTopicConversationMetricRecord.
        Message type for messaging services. E.g.: sms, facebook, twitter, line

        :return: The message_type of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._message_type

    @message_type.setter
    def message_type(self, message_type):
        """
        Sets the message_type of this ConversationMetricsTopicConversationMetricRecord.
        Message type for messaging services. E.g.: sms, facebook, twitter, line

        :param message_type: The message_type of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._message_type = message_type

    @property
    def originating_direction(self):
        """
        Gets the originating_direction of this ConversationMetricsTopicConversationMetricRecord.
        The original direction of the conversation

        :return: The originating_direction of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._originating_direction

    @originating_direction.setter
    def originating_direction(self, originating_direction):
        """
        Sets the originating_direction of this ConversationMetricsTopicConversationMetricRecord.
        The original direction of the conversation

        :param originating_direction: The originating_direction of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        allowed_values = ["inbound", "outbound"]
        if originating_direction.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for originating_direction -> " + originating_direction)
            self._originating_direction = "outdated_sdk_version"
        else:
            self._originating_direction = originating_direction

    @property
    def outbound_campaign_id(self):
        """
        Gets the outbound_campaign_id of this ConversationMetricsTopicConversationMetricRecord.
        (Dialer) Unique identifier of the outbound campaign

        :return: The outbound_campaign_id of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._outbound_campaign_id

    @outbound_campaign_id.setter
    def outbound_campaign_id(self, outbound_campaign_id):
        """
        Sets the outbound_campaign_id of this ConversationMetricsTopicConversationMetricRecord.
        (Dialer) Unique identifier of the outbound campaign

        :param outbound_campaign_id: The outbound_campaign_id of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._outbound_campaign_id = outbound_campaign_id

    @property
    def outbound_contact_id(self):
        """
        Gets the outbound_contact_id of this ConversationMetricsTopicConversationMetricRecord.
        (Dialer) Unique identifier of the contact

        :return: The outbound_contact_id of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._outbound_contact_id

    @outbound_contact_id.setter
    def outbound_contact_id(self, outbound_contact_id):
        """
        Sets the outbound_contact_id of this ConversationMetricsTopicConversationMetricRecord.
        (Dialer) Unique identifier of the contact

        :param outbound_contact_id: The outbound_contact_id of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._outbound_contact_id = outbound_contact_id

    @property
    def outbound_contact_list_id(self):
        """
        Gets the outbound_contact_list_id of this ConversationMetricsTopicConversationMetricRecord.
        (Dialer) Unique identifier of the contact list that this contact belongs to

        :return: The outbound_contact_list_id of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._outbound_contact_list_id

    @outbound_contact_list_id.setter
    def outbound_contact_list_id(self, outbound_contact_list_id):
        """
        Sets the outbound_contact_list_id of this ConversationMetricsTopicConversationMetricRecord.
        (Dialer) Unique identifier of the contact list that this contact belongs to

        :param outbound_contact_list_id: The outbound_contact_list_id of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._outbound_contact_list_id = outbound_contact_list_id

    @property
    def participant_name(self):
        """
        Gets the participant_name of this ConversationMetricsTopicConversationMetricRecord.
        A human readable name identifying the participant

        :return: The participant_name of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._participant_name

    @participant_name.setter
    def participant_name(self, participant_name):
        """
        Sets the participant_name of this ConversationMetricsTopicConversationMetricRecord.
        A human readable name identifying the participant

        :param participant_name: The participant_name of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._participant_name = participant_name

    @property
    def peer_id(self):
        """
        Gets the peer_id of this ConversationMetricsTopicConversationMetricRecord.
        This identifies pairs of related sessions on a conversation. E.g. an external session’s peerId will be the session that the call originally connected to, e.g. if an IVR was dialed, the IVR session, which will also have the external session’s ID as its peer. After that point, any transfers of that session to other internal components (acd, agent, etc.) will all spawn new sessions whose peerIds point back to that original external session.

        :return: The peer_id of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._peer_id

    @peer_id.setter
    def peer_id(self, peer_id):
        """
        Sets the peer_id of this ConversationMetricsTopicConversationMetricRecord.
        This identifies pairs of related sessions on a conversation. E.g. an external session’s peerId will be the session that the call originally connected to, e.g. if an IVR was dialed, the IVR session, which will also have the external session’s ID as its peer. After that point, any transfers of that session to other internal components (acd, agent, etc.) will all spawn new sessions whose peerIds point back to that original external session.

        :param peer_id: The peer_id of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._peer_id = peer_id

    @property
    def provider(self):
        """
        Gets the provider of this ConversationMetricsTopicConversationMetricRecord.
        The source provider for the communication.

        :return: The provider of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._provider

    @provider.setter
    def provider(self, provider):
        """
        Sets the provider of this ConversationMetricsTopicConversationMetricRecord.
        The source provider for the communication.

        :param provider: The provider of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._provider = provider

    @property
    def purpose(self):
        """
        Gets the purpose of this ConversationMetricsTopicConversationMetricRecord.
        The participant's purpose

        :return: The purpose of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._purpose

    @purpose.setter
    def purpose(self, purpose):
        """
        Sets the purpose of this ConversationMetricsTopicConversationMetricRecord.
        The participant's purpose

        :param purpose: The purpose of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        allowed_values = ["acd", "agent", "api", "botflow", "campaign", "customer", "dialer", "external", "fax", "group", "inbound", "ivr", "manual", "outbound", "station", "user", "voicemail", "workflow"]
        if purpose.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for purpose -> " + purpose)
            self._purpose = "outdated_sdk_version"
        else:
            self._purpose = purpose

    @property
    def queue_id(self):
        """
        Gets the queue_id of this ConversationMetricsTopicConversationMetricRecord.
        Queue identifier

        :return: The queue_id of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._queue_id

    @queue_id.setter
    def queue_id(self, queue_id):
        """
        Sets the queue_id of this ConversationMetricsTopicConversationMetricRecord.
        Queue identifier

        :param queue_id: The queue_id of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._queue_id = queue_id

    @property
    def remote(self):
        """
        Gets the remote of this ConversationMetricsTopicConversationMetricRecord.
        Name, phone number, or email address of the remote party.

        :return: The remote of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._remote

    @remote.setter
    def remote(self, remote):
        """
        Sets the remote of this ConversationMetricsTopicConversationMetricRecord.
        Name, phone number, or email address of the remote party.

        :param remote: The remote of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._remote = remote

    @property
    def removed_skill_ids(self):
        """
        Gets the removed_skill_ids of this ConversationMetricsTopicConversationMetricRecord.
        ID(s) of Skill(s) that have been removed by bullseye routing

        :return: The removed_skill_ids of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: list[str]
        """
        return self._removed_skill_ids

    @removed_skill_ids.setter
    def removed_skill_ids(self, removed_skill_ids):
        """
        Sets the removed_skill_ids of this ConversationMetricsTopicConversationMetricRecord.
        ID(s) of Skill(s) that have been removed by bullseye routing

        :param removed_skill_ids: The removed_skill_ids of this ConversationMetricsTopicConversationMetricRecord.
        :type: list[str]
        """
        

        self._removed_skill_ids = removed_skill_ids

    @property
    def reoffered(self):
        """
        Gets the reoffered of this ConversationMetricsTopicConversationMetricRecord.
        Marker for an interaction that got reoffered to the same queue by an in-queue flow

        :return: The reoffered of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: bool
        """
        return self._reoffered

    @reoffered.setter
    def reoffered(self, reoffered):
        """
        Sets the reoffered of this ConversationMetricsTopicConversationMetricRecord.
        Marker for an interaction that got reoffered to the same queue by an in-queue flow

        :param reoffered: The reoffered of this ConversationMetricsTopicConversationMetricRecord.
        :type: bool
        """
        

        self._reoffered = reoffered

    @property
    def requested_language_id(self):
        """
        Gets the requested_language_id of this ConversationMetricsTopicConversationMetricRecord.
        Unique identifier for the language requested for an interaction

        :return: The requested_language_id of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._requested_language_id

    @requested_language_id.setter
    def requested_language_id(self, requested_language_id):
        """
        Sets the requested_language_id of this ConversationMetricsTopicConversationMetricRecord.
        Unique identifier for the language requested for an interaction

        :param requested_language_id: The requested_language_id of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._requested_language_id = requested_language_id

    @property
    def requested_routing_skill_ids(self):
        """
        Gets the requested_routing_skill_ids of this ConversationMetricsTopicConversationMetricRecord.
        Unique identifier(s) for skill(s) requested for an interaction

        :return: The requested_routing_skill_ids of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: list[str]
        """
        return self._requested_routing_skill_ids

    @requested_routing_skill_ids.setter
    def requested_routing_skill_ids(self, requested_routing_skill_ids):
        """
        Sets the requested_routing_skill_ids of this ConversationMetricsTopicConversationMetricRecord.
        Unique identifier(s) for skill(s) requested for an interaction

        :param requested_routing_skill_ids: The requested_routing_skill_ids of this ConversationMetricsTopicConversationMetricRecord.
        :type: list[str]
        """
        

        self._requested_routing_skill_ids = requested_routing_skill_ids

    @property
    def requested_routings(self):
        """
        Gets the requested_routings of this ConversationMetricsTopicConversationMetricRecord.
        Routing type(s) for requested/attempted routing methods.

        :return: The requested_routings of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: list[str]
        """
        return self._requested_routings

    @requested_routings.setter
    def requested_routings(self, requested_routings):
        """
        Sets the requested_routings of this ConversationMetricsTopicConversationMetricRecord.
        Routing type(s) for requested/attempted routing methods.

        :param requested_routings: The requested_routings of this ConversationMetricsTopicConversationMetricRecord.
        :type: list[str]
        """
        

        self._requested_routings = requested_routings

    @property
    def room_id(self):
        """
        Gets the room_id of this ConversationMetricsTopicConversationMetricRecord.
        Unique identifier for the room

        :return: The room_id of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._room_id

    @room_id.setter
    def room_id(self, room_id):
        """
        Sets the room_id of this ConversationMetricsTopicConversationMetricRecord.
        Unique identifier for the room

        :param room_id: The room_id of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._room_id = room_id

    @property
    def routing_priority(self):
        """
        Gets the routing_priority of this ConversationMetricsTopicConversationMetricRecord.
        Routing priority for the current interaction

        :return: The routing_priority of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: int
        """
        return self._routing_priority

    @routing_priority.setter
    def routing_priority(self, routing_priority):
        """
        Sets the routing_priority of this ConversationMetricsTopicConversationMetricRecord.
        Routing priority for the current interaction

        :param routing_priority: The routing_priority of this ConversationMetricsTopicConversationMetricRecord.
        :type: int
        """
        

        self._routing_priority = routing_priority

    @property
    def routing_ring(self):
        """
        Gets the routing_ring of this ConversationMetricsTopicConversationMetricRecord.
        Routing ring for bullseye or preferred agent routing

        :return: The routing_ring of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: int
        """
        return self._routing_ring

    @routing_ring.setter
    def routing_ring(self, routing_ring):
        """
        Sets the routing_ring of this ConversationMetricsTopicConversationMetricRecord.
        Routing ring for bullseye or preferred agent routing

        :param routing_ring: The routing_ring of this ConversationMetricsTopicConversationMetricRecord.
        :type: int
        """
        

        self._routing_ring = routing_ring

    @property
    def selected_agent_id(self):
        """
        Gets the selected_agent_id of this ConversationMetricsTopicConversationMetricRecord.
        Selected agent ID

        :return: The selected_agent_id of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._selected_agent_id

    @selected_agent_id.setter
    def selected_agent_id(self, selected_agent_id):
        """
        Sets the selected_agent_id of this ConversationMetricsTopicConversationMetricRecord.
        Selected agent ID

        :param selected_agent_id: The selected_agent_id of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._selected_agent_id = selected_agent_id

    @property
    def selected_agent_rank(self):
        """
        Gets the selected_agent_rank of this ConversationMetricsTopicConversationMetricRecord.
        Selected agent GPR rank

        :return: The selected_agent_rank of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: int
        """
        return self._selected_agent_rank

    @selected_agent_rank.setter
    def selected_agent_rank(self, selected_agent_rank):
        """
        Sets the selected_agent_rank of this ConversationMetricsTopicConversationMetricRecord.
        Selected agent GPR rank

        :param selected_agent_rank: The selected_agent_rank of this ConversationMetricsTopicConversationMetricRecord.
        :type: int
        """
        

        self._selected_agent_rank = selected_agent_rank

    @property
    def self_served(self):
        """
        Gets the self_served of this ConversationMetricsTopicConversationMetricRecord.
        Indicates whether all flow sessions were self serviced

        :return: The self_served of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: bool
        """
        return self._self_served

    @self_served.setter
    def self_served(self, self_served):
        """
        Sets the self_served of this ConversationMetricsTopicConversationMetricRecord.
        Indicates whether all flow sessions were self serviced

        :param self_served: The self_served of this ConversationMetricsTopicConversationMetricRecord.
        :type: bool
        """
        

        self._self_served = self_served

    @property
    def session_dnis(self):
        """
        Gets the session_dnis of this ConversationMetricsTopicConversationMetricRecord.
        Dialed number for the current session; this can be different from dnis, e.g. if the call was transferred

        :return: The session_dnis of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._session_dnis

    @session_dnis.setter
    def session_dnis(self, session_dnis):
        """
        Sets the session_dnis of this ConversationMetricsTopicConversationMetricRecord.
        Dialed number for the current session; this can be different from dnis, e.g. if the call was transferred

        :param session_dnis: The session_dnis of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._session_dnis = session_dnis

    @property
    def session_id(self):
        """
        Gets the session_id of this ConversationMetricsTopicConversationMetricRecord.
        The unique identifier of this session

        :return: The session_id of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._session_id

    @session_id.setter
    def session_id(self, session_id):
        """
        Sets the session_id of this ConversationMetricsTopicConversationMetricRecord.
        The unique identifier of this session

        :param session_id: The session_id of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._session_id = session_id

    @property
    def station_id(self):
        """
        Gets the station_id of this ConversationMetricsTopicConversationMetricRecord.
        Unique identifier for a phone

        :return: The station_id of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._station_id

    @station_id.setter
    def station_id(self, station_id):
        """
        Sets the station_id of this ConversationMetricsTopicConversationMetricRecord.
        Unique identifier for a phone

        :param station_id: The station_id of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._station_id = station_id

    @property
    def team_id(self):
        """
        Gets the team_id of this ConversationMetricsTopicConversationMetricRecord.
        The team ID the user is a member of

        :return: The team_id of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._team_id

    @team_id.setter
    def team_id(self, team_id):
        """
        Sets the team_id of this ConversationMetricsTopicConversationMetricRecord.
        The team ID the user is a member of

        :param team_id: The team_id of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._team_id = team_id

    @property
    def used_routing(self):
        """
        Gets the used_routing of this ConversationMetricsTopicConversationMetricRecord.
        Complete routing method

        :return: The used_routing of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._used_routing

    @used_routing.setter
    def used_routing(self, used_routing):
        """
        Sets the used_routing of this ConversationMetricsTopicConversationMetricRecord.
        Complete routing method

        :param used_routing: The used_routing of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        allowed_values = ["Bullseye", "Conditional", "Last", "Manual", "Predictive", "Preferred", "Standard", "Vip"]
        if used_routing.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for used_routing -> " + used_routing)
            self._used_routing = "outdated_sdk_version"
        else:
            self._used_routing = used_routing

    @property
    def user_id(self):
        """
        Gets the user_id of this ConversationMetricsTopicConversationMetricRecord.
        Unique identifier for the user

        :return: The user_id of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """
        Sets the user_id of this ConversationMetricsTopicConversationMetricRecord.
        Unique identifier for the user

        :param user_id: The user_id of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._user_id = user_id

    @property
    def waiting_interaction_counts(self):
        """
        Gets the waiting_interaction_counts of this ConversationMetricsTopicConversationMetricRecord.
        Number of waiting interactions for each predictive routing attempt

        :return: The waiting_interaction_counts of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: list[int]
        """
        return self._waiting_interaction_counts

    @waiting_interaction_counts.setter
    def waiting_interaction_counts(self, waiting_interaction_counts):
        """
        Sets the waiting_interaction_counts of this ConversationMetricsTopicConversationMetricRecord.
        Number of waiting interactions for each predictive routing attempt

        :param waiting_interaction_counts: The waiting_interaction_counts of this ConversationMetricsTopicConversationMetricRecord.
        :type: list[int]
        """
        

        self._waiting_interaction_counts = waiting_interaction_counts

    @property
    def wrap_up_code(self):
        """
        Gets the wrap_up_code of this ConversationMetricsTopicConversationMetricRecord.
        Wrap up code

        :return: The wrap_up_code of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: str
        """
        return self._wrap_up_code

    @wrap_up_code.setter
    def wrap_up_code(self, wrap_up_code):
        """
        Sets the wrap_up_code of this ConversationMetricsTopicConversationMetricRecord.
        Wrap up code

        :param wrap_up_code: The wrap_up_code of this ConversationMetricsTopicConversationMetricRecord.
        :type: str
        """
        

        self._wrap_up_code = wrap_up_code

    @property
    def proposed_agents(self):
        """
        Gets the proposed_agents of this ConversationMetricsTopicConversationMetricRecord.
        Proposed agents

        :return: The proposed_agents of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: list[ConversationMetricsTopicConversationProposedAgent]
        """
        return self._proposed_agents

    @proposed_agents.setter
    def proposed_agents(self, proposed_agents):
        """
        Sets the proposed_agents of this ConversationMetricsTopicConversationMetricRecord.
        Proposed agents

        :param proposed_agents: The proposed_agents of this ConversationMetricsTopicConversationMetricRecord.
        :type: list[ConversationMetricsTopicConversationProposedAgent]
        """
        

        self._proposed_agents = proposed_agents

    @property
    def scored_agents(self):
        """
        Gets the scored_agents of this ConversationMetricsTopicConversationMetricRecord.
        Scored agents

        :return: The scored_agents of this ConversationMetricsTopicConversationMetricRecord.
        :rtype: list[ConversationMetricsTopicConversationScoredAgent]
        """
        return self._scored_agents

    @scored_agents.setter
    def scored_agents(self, scored_agents):
        """
        Sets the scored_agents of this ConversationMetricsTopicConversationMetricRecord.
        Scored agents

        :param scored_agents: The scored_agents of this ConversationMetricsTopicConversationMetricRecord.
        :type: list[ConversationMetricsTopicConversationScoredAgent]
        """
        

        self._scored_agents = scored_agents

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

