# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class BuQueryAdherenceExplanationsRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        BuQueryAdherenceExplanationsRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'start_date': 'datetime',
            'end_date': 'datetime',
            'management_unit_ids': 'list[str]',
            'agent_ids': 'list[str]'
        }

        self.attribute_map = {
            'start_date': 'startDate',
            'end_date': 'endDate',
            'management_unit_ids': 'managementUnitIds',
            'agent_ids': 'agentIds'
        }

        self._start_date = None
        self._end_date = None
        self._management_unit_ids = None
        self._agent_ids = None

    @property
    def start_date(self):
        """
        Gets the start_date of this BuQueryAdherenceExplanationsRequest.
        The start date of the range to query. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The start_date of this BuQueryAdherenceExplanationsRequest.
        :rtype: datetime
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date):
        """
        Sets the start_date of this BuQueryAdherenceExplanationsRequest.
        The start date of the range to query. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param start_date: The start_date of this BuQueryAdherenceExplanationsRequest.
        :type: datetime
        """
        

        self._start_date = start_date

    @property
    def end_date(self):
        """
        Gets the end_date of this BuQueryAdherenceExplanationsRequest.
        The end date of the range to query. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The end_date of this BuQueryAdherenceExplanationsRequest.
        :rtype: datetime
        """
        return self._end_date

    @end_date.setter
    def end_date(self, end_date):
        """
        Sets the end_date of this BuQueryAdherenceExplanationsRequest.
        The end date of the range to query. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param end_date: The end_date of this BuQueryAdherenceExplanationsRequest.
        :type: datetime
        """
        

        self._end_date = end_date

    @property
    def management_unit_ids(self):
        """
        Gets the management_unit_ids of this BuQueryAdherenceExplanationsRequest.
        A filter for which management units to query. Leave empty or omit entirely for all management units in the business unit

        :return: The management_unit_ids of this BuQueryAdherenceExplanationsRequest.
        :rtype: list[str]
        """
        return self._management_unit_ids

    @management_unit_ids.setter
    def management_unit_ids(self, management_unit_ids):
        """
        Sets the management_unit_ids of this BuQueryAdherenceExplanationsRequest.
        A filter for which management units to query. Leave empty or omit entirely for all management units in the business unit

        :param management_unit_ids: The management_unit_ids of this BuQueryAdherenceExplanationsRequest.
        :type: list[str]
        """
        

        self._management_unit_ids = management_unit_ids

    @property
    def agent_ids(self):
        """
        Gets the agent_ids of this BuQueryAdherenceExplanationsRequest.
        A filter for which agents within the business unit to query. Leave empty or omit entirely for all agents in the business unit (or management units if specified)

        :return: The agent_ids of this BuQueryAdherenceExplanationsRequest.
        :rtype: list[str]
        """
        return self._agent_ids

    @agent_ids.setter
    def agent_ids(self, agent_ids):
        """
        Sets the agent_ids of this BuQueryAdherenceExplanationsRequest.
        A filter for which agents within the business unit to query. Leave empty or omit entirely for all agents in the business unit (or management units if specified)

        :param agent_ids: The agent_ids of this BuQueryAdherenceExplanationsRequest.
        :type: list[str]
        """
        

        self._agent_ids = agent_ids

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

