# coding: utf-8

"""
OAuthApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class OAuthApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_oauth_client(self, client_id, **kwargs):
        """
        Delete OAuth Client
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_oauth_client(client_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str client_id: Client ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_oauth_client" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'client_id' is set
        if ('client_id' not in params) or (params['client_id'] is None):
            raise ValueError("Missing the required parameter `client_id` when calling `delete_oauth_client`")


        resource_path = '/api/v2/oauth/clients/{clientId}'.replace('{format}', 'json')
        path_params = {}
        if 'client_id' in params:
            path_params['clientId'] = params['client_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_oauth_authorization(self, client_id, **kwargs):
        """
        Get a client that is authorized by the resource owner
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_oauth_authorization(client_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str client_id: The ID of client (required)
        :param str accept_language: The language in which to display the client descriptions.
        :return: OAuthAuthorization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_id', 'accept_language']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_oauth_authorization" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'client_id' is set
        if ('client_id' not in params) or (params['client_id'] is None):
            raise ValueError("Missing the required parameter `client_id` when calling `get_oauth_authorization`")


        resource_path = '/api/v2/oauth/authorizations/{clientId}'.replace('{format}', 'json')
        path_params = {}
        if 'client_id' in params:
            path_params['clientId'] = params['client_id']

        query_params = {}

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OAuthAuthorization',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_oauth_authorizations(self, **kwargs):
        """
        List clients that have been authorized, requested, or revoked by the resource owner
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_oauth_authorizations(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str accept_language: The language in which to display the client descriptions.
        :return: OAuthAuthorizationListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['accept_language']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_oauth_authorizations" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/oauth/authorizations'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OAuthAuthorizationListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_oauth_client(self, client_id, **kwargs):
        """
        Get OAuth Client
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_oauth_client(client_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str client_id: Client ID (required)
        :return: OAuthClient
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_oauth_client" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'client_id' is set
        if ('client_id' not in params) or (params['client_id'] is None):
            raise ValueError("Missing the required parameter `client_id` when calling `get_oauth_client`")


        resource_path = '/api/v2/oauth/clients/{clientId}'.replace('{format}', 'json')
        path_params = {}
        if 'client_id' in params:
            path_params['clientId'] = params['client_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OAuthClient',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_oauth_client_usage_query_result(self, execution_id, client_id, **kwargs):
        """
        Get the results of a usage query
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_oauth_client_usage_query_result(execution_id, client_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str execution_id: ID of the query execution (required)
        :param str client_id: Client ID (required)
        :return: ApiUsageQueryResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['execution_id', 'client_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_oauth_client_usage_query_result" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'execution_id' is set
        if ('execution_id' not in params) or (params['execution_id'] is None):
            raise ValueError("Missing the required parameter `execution_id` when calling `get_oauth_client_usage_query_result`")
        # verify the required parameter 'client_id' is set
        if ('client_id' not in params) or (params['client_id'] is None):
            raise ValueError("Missing the required parameter `client_id` when calling `get_oauth_client_usage_query_result`")


        resource_path = '/api/v2/oauth/clients/{clientId}/usage/query/results/{executionId}'.replace('{format}', 'json')
        path_params = {}
        if 'execution_id' in params:
            path_params['executionId'] = params['execution_id']
        if 'client_id' in params:
            path_params['clientId'] = params['client_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ApiUsageQueryResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_oauth_client_usage_summary(self, client_id, **kwargs):
        """
        Get a summary of OAuth client API usage
        After calling this method, you will then need to poll for the query results based on the returned execution Id

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_oauth_client_usage_summary(client_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str client_id: Client ID (required)
        :param str days: Previous number of days to query
        :return: UsageExecutionResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_id', 'days']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_oauth_client_usage_summary" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'client_id' is set
        if ('client_id' not in params) or (params['client_id'] is None):
            raise ValueError("Missing the required parameter `client_id` when calling `get_oauth_client_usage_summary`")


        resource_path = '/api/v2/oauth/clients/{clientId}/usage/summary'.replace('{format}', 'json')
        path_params = {}
        if 'client_id' in params:
            path_params['clientId'] = params['client_id']

        query_params = {}
        if 'days' in params:
            query_params['days'] = params['days']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UsageExecutionResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_oauth_clients(self, **kwargs):
        """
        The list of OAuth clients
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_oauth_clients(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: OAuthClientEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_oauth_clients" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/oauth/clients'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OAuthClientEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_oauth_scope(self, scope_id, **kwargs):
        """
        An OAuth scope
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_oauth_scope(scope_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str scope_id: Scope ID (required)
        :param str accept_language: The language with which to display the scope description.
        :return: OAuthScope
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['scope_id', 'accept_language']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_oauth_scope" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'scope_id' is set
        if ('scope_id' not in params) or (params['scope_id'] is None):
            raise ValueError("Missing the required parameter `scope_id` when calling `get_oauth_scope`")


        resource_path = '/api/v2/oauth/scopes/{scopeId}'.replace('{format}', 'json')
        path_params = {}
        if 'scope_id' in params:
            path_params['scopeId'] = params['scope_id']

        query_params = {}

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OAuthScope',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_oauth_scopes(self, **kwargs):
        """
        The list of OAuth scopes
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_oauth_scopes(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str accept_language: The language with which to display the scope descriptions.
        :return: OAuthScopeListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['accept_language']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_oauth_scopes" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/oauth/scopes'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OAuthScopeListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_oauth_client_secret(self, client_id, **kwargs):
        """
        Regenerate Client Secret
        This operation will set the client secret to a randomly generated cryptographically random value. All clients must be updated with the new secret. This operation should be used with caution.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_oauth_client_secret(client_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str client_id: Client ID (required)
        :return: OAuthClient
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_oauth_client_secret" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'client_id' is set
        if ('client_id' not in params) or (params['client_id'] is None):
            raise ValueError("Missing the required parameter `client_id` when calling `post_oauth_client_secret`")


        resource_path = '/api/v2/oauth/clients/{clientId}/secret'.replace('{format}', 'json')
        path_params = {}
        if 'client_id' in params:
            path_params['clientId'] = params['client_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OAuthClient',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_oauth_client_usage_query(self, client_id, body, **kwargs):
        """
        Query for OAuth client API usage
        After calling this method, you will then need to poll for the query results based on the returned execution Id

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_oauth_client_usage_query(client_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str client_id: Client ID (required)
        :param ApiUsageQuery body: Query (required)
        :return: UsageExecutionResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_oauth_client_usage_query" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'client_id' is set
        if ('client_id' not in params) or (params['client_id'] is None):
            raise ValueError("Missing the required parameter `client_id` when calling `post_oauth_client_usage_query`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_oauth_client_usage_query`")


        resource_path = '/api/v2/oauth/clients/{clientId}/usage/query'.replace('{format}', 'json')
        path_params = {}
        if 'client_id' in params:
            path_params['clientId'] = params['client_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UsageExecutionResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_oauth_clients(self, body, **kwargs):
        """
        Create OAuth client
        The OAuth Grant/Client is required in order to create an authentication token and gain access to PureCloud.  The preferred authorizedGrantTypes is 'CODE' which requires applications to send a client ID and client secret. This is typically a web server.  If the client is unable to secure the client secret then the 'TOKEN' grant type aka IMPLICIT should be used. This is would be for browser or mobile apps.  If a client is to be used outside of the context of a user then the 'CLIENT-CREDENTIALS' grant may be used. In this case the client must be granted roles  via the 'roleIds' field.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_oauth_clients(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param OAuthClientRequest body: Client (required)
        :return: OAuthClient
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_oauth_clients" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_oauth_clients`")


        resource_path = '/api/v2/oauth/clients'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OAuthClient',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_oauth_client(self, client_id, body, **kwargs):
        """
        Update OAuth Client
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_oauth_client(client_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str client_id: Client ID (required)
        :param OAuthClientRequest body: Client (required)
        :return: OAuthClient
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_oauth_client" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'client_id' is set
        if ('client_id' not in params) or (params['client_id'] is None):
            raise ValueError("Missing the required parameter `client_id` when calling `put_oauth_client`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_oauth_client`")


        resource_path = '/api/v2/oauth/clients/{clientId}'.replace('{format}', 'json')
        path_params = {}
        if 'client_id' in params:
            path_params['clientId'] = params['client_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OAuthClient',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
