# coding: utf-8

"""
GamificationApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class GamificationApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_employeeperformance_externalmetrics_definition(self, metric_id, **kwargs):
        """
        Delete an External Metric Definition
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_employeeperformance_externalmetrics_definition(metric_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str metric_id: Specifies the External Metric Definition ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['metric_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_employeeperformance_externalmetrics_definition" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'metric_id' is set
        if ('metric_id' not in params) or (params['metric_id'] is None):
            raise ValueError("Missing the required parameter `metric_id` when calling `delete_employeeperformance_externalmetrics_definition`")


        resource_path = '/api/v2/employeeperformance/externalmetrics/definitions/{metricId}'.replace('{format}', 'json')
        path_params = {}
        if 'metric_id' in params:
            path_params['metricId'] = params['metric_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_employeeperformance_externalmetrics_definition(self, metric_id, **kwargs):
        """
        Get an External Metric Definition
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_employeeperformance_externalmetrics_definition(metric_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str metric_id: Specifies the External Metric Definition ID (required)
        :return: ExternalMetricDefinition
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['metric_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_employeeperformance_externalmetrics_definition" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'metric_id' is set
        if ('metric_id' not in params) or (params['metric_id'] is None):
            raise ValueError("Missing the required parameter `metric_id` when calling `get_employeeperformance_externalmetrics_definition`")


        resource_path = '/api/v2/employeeperformance/externalmetrics/definitions/{metricId}'.replace('{format}', 'json')
        path_params = {}
        if 'metric_id' in params:
            path_params['metricId'] = params['metric_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalMetricDefinition',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_employeeperformance_externalmetrics_definitions(self, **kwargs):
        """
        Get a list of External Metric Definitions of an organization, sorted by name in ascending order
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_employeeperformance_externalmetrics_definitions(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :return: ExternalMetricDefinitionListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_employeeperformance_externalmetrics_definitions" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/employeeperformance/externalmetrics/definitions'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalMetricDefinitionListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_leaderboard(self, start_workday, end_workday, **kwargs):
        """
        Leaderboard of the requesting user's division or performance profile
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_leaderboard(start_workday, end_workday, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param date start_workday: Start workday to retrieve for the leaderboard. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param date end_workday: End workday to retrieve for the leaderboard. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param str metric_id: Metric Id for which the leaderboard is to be generated. The total points is used if nothing is given.
        :return: Leaderboard
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['start_workday', 'end_workday', 'metric_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_leaderboard" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'start_workday' is set
        if ('start_workday' not in params) or (params['start_workday'] is None):
            raise ValueError("Missing the required parameter `start_workday` when calling `get_gamification_leaderboard`")
        # verify the required parameter 'end_workday' is set
        if ('end_workday' not in params) or (params['end_workday'] is None):
            raise ValueError("Missing the required parameter `end_workday` when calling `get_gamification_leaderboard`")


        resource_path = '/api/v2/gamification/leaderboard'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'start_workday' in params:
            query_params['startWorkday'] = params['start_workday']
        if 'end_workday' in params:
            query_params['endWorkday'] = params['end_workday']
        if 'metric_id' in params:
            query_params['metricId'] = params['metric_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Leaderboard',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_leaderboard_all(self, filter_type, filter_id, start_workday, end_workday, **kwargs):
        """
        Leaderboard by filter type
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_leaderboard_all(filter_type, filter_id, start_workday, end_workday, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str filter_type: Filter type for the query request. (required)
        :param str filter_id: ID for the filter type. For example, division or performance profile Id (required)
        :param date start_workday: Start workday to retrieve for the leaderboard. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param date end_workday: End workday to retrieve for the leaderboard. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param str metric_id: Metric Id for which the leaderboard is to be generated. The total points is used if nothing is given.
        :return: Leaderboard
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter_type', 'filter_id', 'start_workday', 'end_workday', 'metric_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_leaderboard_all" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'filter_type' is set
        if ('filter_type' not in params) or (params['filter_type'] is None):
            raise ValueError("Missing the required parameter `filter_type` when calling `get_gamification_leaderboard_all`")
        # verify the required parameter 'filter_id' is set
        if ('filter_id' not in params) or (params['filter_id'] is None):
            raise ValueError("Missing the required parameter `filter_id` when calling `get_gamification_leaderboard_all`")
        # verify the required parameter 'start_workday' is set
        if ('start_workday' not in params) or (params['start_workday'] is None):
            raise ValueError("Missing the required parameter `start_workday` when calling `get_gamification_leaderboard_all`")
        # verify the required parameter 'end_workday' is set
        if ('end_workday' not in params) or (params['end_workday'] is None):
            raise ValueError("Missing the required parameter `end_workday` when calling `get_gamification_leaderboard_all`")


        resource_path = '/api/v2/gamification/leaderboard/all'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'filter_id' in params:
            query_params['filterId'] = params['filter_id']
        if 'start_workday' in params:
            query_params['startWorkday'] = params['start_workday']
        if 'end_workday' in params:
            query_params['endWorkday'] = params['end_workday']
        if 'metric_id' in params:
            query_params['metricId'] = params['metric_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Leaderboard',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_leaderboard_all_bestpoints(self, filter_type, filter_id, **kwargs):
        """
        Best Points by division or performance profile
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_leaderboard_all_bestpoints(filter_type, filter_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str filter_type: Filter type for the query request. (required)
        :param str filter_id: ID for the filter type. For example, division or performance profile Id (required)
        :return: OverallBestPoints
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter_type', 'filter_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_leaderboard_all_bestpoints" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'filter_type' is set
        if ('filter_type' not in params) or (params['filter_type'] is None):
            raise ValueError("Missing the required parameter `filter_type` when calling `get_gamification_leaderboard_all_bestpoints`")
        # verify the required parameter 'filter_id' is set
        if ('filter_id' not in params) or (params['filter_id'] is None):
            raise ValueError("Missing the required parameter `filter_id` when calling `get_gamification_leaderboard_all_bestpoints`")


        resource_path = '/api/v2/gamification/leaderboard/all/bestpoints'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'filter_id' in params:
            query_params['filterId'] = params['filter_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OverallBestPoints',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_leaderboard_bestpoints(self, **kwargs):
        """
        Best Points of the requesting user's current performance profile or division
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_leaderboard_bestpoints(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: OverallBestPoints
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_leaderboard_bestpoints" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/gamification/leaderboard/bestpoints'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OverallBestPoints',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_metricdefinition(self, metric_definition_id, **kwargs):
        """
        Metric definition by id
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_metricdefinition(metric_definition_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str metric_definition_id: metric definition id (required)
        :return: MetricDefinition
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['metric_definition_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_metricdefinition" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'metric_definition_id' is set
        if ('metric_definition_id' not in params) or (params['metric_definition_id'] is None):
            raise ValueError("Missing the required parameter `metric_definition_id` when calling `get_gamification_metricdefinition`")


        resource_path = '/api/v2/gamification/metricdefinitions/{metricDefinitionId}'.replace('{format}', 'json')
        path_params = {}
        if 'metric_definition_id' in params:
            path_params['metricDefinitionId'] = params['metric_definition_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MetricDefinition',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_metricdefinitions(self, **kwargs):
        """
        All metric definitions
        Retrieves the metric definitions and their corresponding default objectives used to create a gamified metric

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_metricdefinitions(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: GetMetricDefinitionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_metricdefinitions" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/gamification/metricdefinitions'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GetMetricDefinitionsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_profile(self, profile_id, **kwargs):
        """
        Performance profile by id
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_profile(profile_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str profile_id: performanceProfileId (required)
        :return: PerformanceProfile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['profile_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_profile" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'profile_id' is set
        if ('profile_id' not in params) or (params['profile_id'] is None):
            raise ValueError("Missing the required parameter `profile_id` when calling `get_gamification_profile`")


        resource_path = '/api/v2/gamification/profiles/{profileId}'.replace('{format}', 'json')
        path_params = {}
        if 'profile_id' in params:
            path_params['profileId'] = params['profile_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PerformanceProfile',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_profile_members(self, profile_id, **kwargs):
        """
        Members of a given performance profile
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_profile_members(profile_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str profile_id: Profile Id (required)
        :return: MemberListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['profile_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_profile_members" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'profile_id' is set
        if ('profile_id' not in params) or (params['profile_id'] is None):
            raise ValueError("Missing the required parameter `profile_id` when calling `get_gamification_profile_members`")


        resource_path = '/api/v2/gamification/profiles/{profileId}/members'.replace('{format}', 'json')
        path_params = {}
        if 'profile_id' in params:
            path_params['profileId'] = params['profile_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MemberListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_profile_metric(self, profile_id, metric_id, **kwargs):
        """
        Performance profile gamified metric by id
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_profile_metric(profile_id, metric_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str profile_id: Performance Profile Id (required)
        :param str metric_id: Metric Id (required)
        :param date workday: The objective query workday. If not specified, then it retrieves the current objective. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd
        :return: Metric
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['profile_id', 'metric_id', 'workday']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_profile_metric" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'profile_id' is set
        if ('profile_id' not in params) or (params['profile_id'] is None):
            raise ValueError("Missing the required parameter `profile_id` when calling `get_gamification_profile_metric`")
        # verify the required parameter 'metric_id' is set
        if ('metric_id' not in params) or (params['metric_id'] is None):
            raise ValueError("Missing the required parameter `metric_id` when calling `get_gamification_profile_metric`")


        resource_path = '/api/v2/gamification/profiles/{profileId}/metrics/{metricId}'.replace('{format}', 'json')
        path_params = {}
        if 'profile_id' in params:
            path_params['profileId'] = params['profile_id']
        if 'metric_id' in params:
            path_params['metricId'] = params['metric_id']

        query_params = {}
        if 'workday' in params:
            query_params['workday'] = params['workday']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Metric',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_profile_metrics(self, profile_id, **kwargs):
        """
        All gamified metrics for a given performance profile
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_profile_metrics(profile_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str profile_id: Performance Profile Id (required)
        :param list[str] expand: Which fields, if any, to expand.
        :param date workday: The objective query workday. If not specified, then it retrieves the current objective. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd
        :param str metric_ids: List of metric ids to filter the response (Optional, comma-separated).
        :return: GetMetricResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['profile_id', 'expand', 'workday', 'metric_ids']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_profile_metrics" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'profile_id' is set
        if ('profile_id' not in params) or (params['profile_id'] is None):
            raise ValueError("Missing the required parameter `profile_id` when calling `get_gamification_profile_metrics`")


        resource_path = '/api/v2/gamification/profiles/{profileId}/metrics'.replace('{format}', 'json')
        path_params = {}
        if 'profile_id' in params:
            path_params['profileId'] = params['profile_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'workday' in params:
            query_params['workday'] = params['workday']
        if 'metric_ids' in params:
            query_params['metricIds'] = params['metric_ids']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GetMetricResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_profile_metrics_objectivedetails(self, profile_id, **kwargs):
        """
        All metrics for a given performance profile with objective details such as order and maxPoints
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_profile_metrics_objectivedetails(profile_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str profile_id: Performance Profile Id (required)
        :param date workday: The objective query workday. If not specified, then it retrieves the current objective. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd
        :return: GetMetricsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['profile_id', 'workday']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_profile_metrics_objectivedetails" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'profile_id' is set
        if ('profile_id' not in params) or (params['profile_id'] is None):
            raise ValueError("Missing the required parameter `profile_id` when calling `get_gamification_profile_metrics_objectivedetails`")


        resource_path = '/api/v2/gamification/profiles/{profileId}/metrics/objectivedetails'.replace('{format}', 'json')
        path_params = {}
        if 'profile_id' in params:
            path_params['profileId'] = params['profile_id']

        query_params = {}
        if 'workday' in params:
            query_params['workday'] = params['workday']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GetMetricsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_profiles(self, **kwargs):
        """
        All performance profiles
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_profiles(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: GetProfilesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_profiles" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/gamification/profiles'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GetProfilesResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_profiles_user(self, user_id, **kwargs):
        """
        Performance profile of a user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_profiles_user(user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id:  (required)
        :param date workday: Target querying workday. If not provided, then queries the current performance profile. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd
        :return: PerformanceProfile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'workday']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_profiles_user" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_gamification_profiles_user`")


        resource_path = '/api/v2/gamification/profiles/users/{userId}'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}
        if 'workday' in params:
            query_params['workday'] = params['workday']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PerformanceProfile',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_profiles_users_me(self, **kwargs):
        """
        Performance profile of the requesting user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_profiles_users_me(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param date workday: Target querying workday. If not provided, then queries the current performance profile. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd
        :return: PerformanceProfile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workday']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_profiles_users_me" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/gamification/profiles/users/me'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'workday' in params:
            query_params['workday'] = params['workday']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PerformanceProfile',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_scorecards(self, workday, **kwargs):
        """
        Workday performance metrics of the requesting user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_scorecards(workday, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param date workday: Target querying workday. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param list[str] expand: Which fields, if any, to expand.
        :return: WorkdayMetricListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workday', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_scorecards" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workday' is set
        if ('workday' not in params) or (params['workday'] is None):
            raise ValueError("Missing the required parameter `workday` when calling `get_gamification_scorecards`")


        resource_path = '/api/v2/gamification/scorecards'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'workday' in params:
            query_params['workday'] = params['workday']
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkdayMetricListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_scorecards_attendance(self, start_workday, end_workday, **kwargs):
        """
        Attendance status metrics of the requesting user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_scorecards_attendance(start_workday, end_workday, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param date start_workday: Start workday of querying workdays range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param date end_workday: End workday of querying workdays range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :return: AttendanceStatusListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['start_workday', 'end_workday']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_scorecards_attendance" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'start_workday' is set
        if ('start_workday' not in params) or (params['start_workday'] is None):
            raise ValueError("Missing the required parameter `start_workday` when calling `get_gamification_scorecards_attendance`")
        # verify the required parameter 'end_workday' is set
        if ('end_workday' not in params) or (params['end_workday'] is None):
            raise ValueError("Missing the required parameter `end_workday` when calling `get_gamification_scorecards_attendance`")


        resource_path = '/api/v2/gamification/scorecards/attendance'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'start_workday' in params:
            query_params['startWorkday'] = params['start_workday']
        if 'end_workday' in params:
            query_params['endWorkday'] = params['end_workday']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AttendanceStatusListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_scorecards_bestpoints(self, **kwargs):
        """
        Best points of the requesting user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_scorecards_bestpoints(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: UserBestPoints
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_scorecards_bestpoints" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/gamification/scorecards/bestpoints'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UserBestPoints',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_scorecards_points_alltime(self, end_workday, **kwargs):
        """
        All-time points of the requesting user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_scorecards_points_alltime(end_workday, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param date end_workday: End workday of querying workdays range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :return: AllTimePoints
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['end_workday']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_scorecards_points_alltime" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'end_workday' is set
        if ('end_workday' not in params) or (params['end_workday'] is None):
            raise ValueError("Missing the required parameter `end_workday` when calling `get_gamification_scorecards_points_alltime`")


        resource_path = '/api/v2/gamification/scorecards/points/alltime'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'end_workday' in params:
            query_params['endWorkday'] = params['end_workday']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AllTimePoints',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_scorecards_points_average(self, workday, **kwargs):
        """
        Average points of the requesting user's division or performance profile
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_scorecards_points_average(workday, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param date workday: The target workday. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :return: SingleWorkdayAveragePoints
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workday']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_scorecards_points_average" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workday' is set
        if ('workday' not in params) or (params['workday'] is None):
            raise ValueError("Missing the required parameter `workday` when calling `get_gamification_scorecards_points_average`")


        resource_path = '/api/v2/gamification/scorecards/points/average'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'workday' in params:
            query_params['workday'] = params['workday']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SingleWorkdayAveragePoints',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_scorecards_points_trends(self, start_workday, end_workday, **kwargs):
        """
        Points trends of the requesting user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_scorecards_points_trends(start_workday, end_workday, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param date start_workday: Start workday of querying workdays range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param date end_workday: End workday of querying workdays range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param str day_of_week: Optional filter to specify which day of weeks to be included in the response
        :return: WorkdayPointsTrend
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['start_workday', 'end_workday', 'day_of_week']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_scorecards_points_trends" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'start_workday' is set
        if ('start_workday' not in params) or (params['start_workday'] is None):
            raise ValueError("Missing the required parameter `start_workday` when calling `get_gamification_scorecards_points_trends`")
        # verify the required parameter 'end_workday' is set
        if ('end_workday' not in params) or (params['end_workday'] is None):
            raise ValueError("Missing the required parameter `end_workday` when calling `get_gamification_scorecards_points_trends`")


        resource_path = '/api/v2/gamification/scorecards/points/trends'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'start_workday' in params:
            query_params['startWorkday'] = params['start_workday']
        if 'end_workday' in params:
            query_params['endWorkday'] = params['end_workday']
        if 'day_of_week' in params:
            query_params['dayOfWeek'] = params['day_of_week']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkdayPointsTrend',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_scorecards_profile_metric_user_values_trends(self, profile_id, metric_id, user_id, start_workday, end_workday, **kwargs):
        """
        Average performance values trends by metric of a user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_scorecards_profile_metric_user_values_trends(profile_id, metric_id, user_id, start_workday, end_workday, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str profile_id: performanceProfileId (required)
        :param str metric_id: metricId (required)
        :param str user_id:  (required)
        :param date start_workday: Start workday of querying workdays range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param date end_workday: End workday of querying workdays range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param date reference_workday: Reference workday for the trend. Used to determine the associated metric definition. If not set, then the value of endWorkday is used. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd
        :param str time_zone: Timezone for the workday. Defaults to UTC
        :return: MetricValueTrendAverage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['profile_id', 'metric_id', 'user_id', 'start_workday', 'end_workday', 'reference_workday', 'time_zone']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_scorecards_profile_metric_user_values_trends" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'profile_id' is set
        if ('profile_id' not in params) or (params['profile_id'] is None):
            raise ValueError("Missing the required parameter `profile_id` when calling `get_gamification_scorecards_profile_metric_user_values_trends`")
        # verify the required parameter 'metric_id' is set
        if ('metric_id' not in params) or (params['metric_id'] is None):
            raise ValueError("Missing the required parameter `metric_id` when calling `get_gamification_scorecards_profile_metric_user_values_trends`")
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_gamification_scorecards_profile_metric_user_values_trends`")
        # verify the required parameter 'start_workday' is set
        if ('start_workday' not in params) or (params['start_workday'] is None):
            raise ValueError("Missing the required parameter `start_workday` when calling `get_gamification_scorecards_profile_metric_user_values_trends`")
        # verify the required parameter 'end_workday' is set
        if ('end_workday' not in params) or (params['end_workday'] is None):
            raise ValueError("Missing the required parameter `end_workday` when calling `get_gamification_scorecards_profile_metric_user_values_trends`")


        resource_path = '/api/v2/gamification/scorecards/profiles/{profileId}/metrics/{metricId}/users/{userId}/values/trends'.replace('{format}', 'json')
        path_params = {}
        if 'profile_id' in params:
            path_params['profileId'] = params['profile_id']
        if 'metric_id' in params:
            path_params['metricId'] = params['metric_id']
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}
        if 'start_workday' in params:
            query_params['startWorkday'] = params['start_workday']
        if 'end_workday' in params:
            query_params['endWorkday'] = params['end_workday']
        if 'reference_workday' in params:
            query_params['referenceWorkday'] = params['reference_workday']
        if 'time_zone' in params:
            query_params['timeZone'] = params['time_zone']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MetricValueTrendAverage',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_scorecards_profile_metric_users_values_trends(self, profile_id, metric_id, filter_type, start_workday, end_workday, **kwargs):
        """
        Average performance values trends by metric of a division or a performance profile
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_scorecards_profile_metric_users_values_trends(profile_id, metric_id, filter_type, start_workday, end_workday, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str profile_id: performanceProfileId (required)
        :param str metric_id: metricId (required)
        :param str filter_type: Filter type for the query request. (required)
        :param date start_workday: Start workday of querying workdays range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param date end_workday: End workday of querying workdays range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param str filter_id: ID for the filter type. Only required when filterType is Division.
        :param date reference_workday: Reference workday for the trend. Used to determine the associated metric definition. If not set, then the value of endWorkday is used. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd
        :param str time_zone: Timezone for the workday. Defaults to UTC
        :return: MetricValueTrendAverage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['profile_id', 'metric_id', 'filter_type', 'start_workday', 'end_workday', 'filter_id', 'reference_workday', 'time_zone']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_scorecards_profile_metric_users_values_trends" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'profile_id' is set
        if ('profile_id' not in params) or (params['profile_id'] is None):
            raise ValueError("Missing the required parameter `profile_id` when calling `get_gamification_scorecards_profile_metric_users_values_trends`")
        # verify the required parameter 'metric_id' is set
        if ('metric_id' not in params) or (params['metric_id'] is None):
            raise ValueError("Missing the required parameter `metric_id` when calling `get_gamification_scorecards_profile_metric_users_values_trends`")
        # verify the required parameter 'filter_type' is set
        if ('filter_type' not in params) or (params['filter_type'] is None):
            raise ValueError("Missing the required parameter `filter_type` when calling `get_gamification_scorecards_profile_metric_users_values_trends`")
        # verify the required parameter 'start_workday' is set
        if ('start_workday' not in params) or (params['start_workday'] is None):
            raise ValueError("Missing the required parameter `start_workday` when calling `get_gamification_scorecards_profile_metric_users_values_trends`")
        # verify the required parameter 'end_workday' is set
        if ('end_workday' not in params) or (params['end_workday'] is None):
            raise ValueError("Missing the required parameter `end_workday` when calling `get_gamification_scorecards_profile_metric_users_values_trends`")


        resource_path = '/api/v2/gamification/scorecards/profiles/{profileId}/metrics/{metricId}/users/values/trends'.replace('{format}', 'json')
        path_params = {}
        if 'profile_id' in params:
            path_params['profileId'] = params['profile_id']
        if 'metric_id' in params:
            path_params['metricId'] = params['metric_id']

        query_params = {}
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'filter_id' in params:
            query_params['filterId'] = params['filter_id']
        if 'start_workday' in params:
            query_params['startWorkday'] = params['start_workday']
        if 'end_workday' in params:
            query_params['endWorkday'] = params['end_workday']
        if 'reference_workday' in params:
            query_params['referenceWorkday'] = params['reference_workday']
        if 'time_zone' in params:
            query_params['timeZone'] = params['time_zone']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MetricValueTrendAverage',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_scorecards_profile_metric_values_trends(self, profile_id, metric_id, start_workday, end_workday, **kwargs):
        """
        Average performance values trends by metric of the requesting user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_scorecards_profile_metric_values_trends(profile_id, metric_id, start_workday, end_workday, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str profile_id: performanceProfileId (required)
        :param str metric_id: metricId (required)
        :param date start_workday: Start workday of querying workdays range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param date end_workday: End workday of querying workdays range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param str filter_type: Filter type for the query request. If not set, returns the values trends of the requesting user
        :param date reference_workday: Reference workday for the trend. Used to determine the associated metric definition. If not set, then the value of endWorkday is used. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd
        :param str time_zone: Timezone for the workday. Defaults to UTC
        :return: MetricValueTrendAverage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['profile_id', 'metric_id', 'start_workday', 'end_workday', 'filter_type', 'reference_workday', 'time_zone']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_scorecards_profile_metric_values_trends" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'profile_id' is set
        if ('profile_id' not in params) or (params['profile_id'] is None):
            raise ValueError("Missing the required parameter `profile_id` when calling `get_gamification_scorecards_profile_metric_values_trends`")
        # verify the required parameter 'metric_id' is set
        if ('metric_id' not in params) or (params['metric_id'] is None):
            raise ValueError("Missing the required parameter `metric_id` when calling `get_gamification_scorecards_profile_metric_values_trends`")
        # verify the required parameter 'start_workday' is set
        if ('start_workday' not in params) or (params['start_workday'] is None):
            raise ValueError("Missing the required parameter `start_workday` when calling `get_gamification_scorecards_profile_metric_values_trends`")
        # verify the required parameter 'end_workday' is set
        if ('end_workday' not in params) or (params['end_workday'] is None):
            raise ValueError("Missing the required parameter `end_workday` when calling `get_gamification_scorecards_profile_metric_values_trends`")


        resource_path = '/api/v2/gamification/scorecards/profiles/{profileId}/metrics/{metricId}/values/trends'.replace('{format}', 'json')
        path_params = {}
        if 'profile_id' in params:
            path_params['profileId'] = params['profile_id']
        if 'metric_id' in params:
            path_params['metricId'] = params['metric_id']

        query_params = {}
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'start_workday' in params:
            query_params['startWorkday'] = params['start_workday']
        if 'end_workday' in params:
            query_params['endWorkday'] = params['end_workday']
        if 'reference_workday' in params:
            query_params['referenceWorkday'] = params['reference_workday']
        if 'time_zone' in params:
            query_params['timeZone'] = params['time_zone']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MetricValueTrendAverage',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_scorecards_user(self, user_id, workday, **kwargs):
        """
        Workday performance metrics for a user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_scorecards_user(user_id, workday, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id:  (required)
        :param date workday: Target querying workday. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param list[str] expand: Which fields, if any, to expand.
        :return: WorkdayMetricListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'workday', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_scorecards_user" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_gamification_scorecards_user`")
        # verify the required parameter 'workday' is set
        if ('workday' not in params) or (params['workday'] is None):
            raise ValueError("Missing the required parameter `workday` when calling `get_gamification_scorecards_user`")


        resource_path = '/api/v2/gamification/scorecards/users/{userId}'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}
        if 'workday' in params:
            query_params['workday'] = params['workday']
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkdayMetricListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_scorecards_user_attendance(self, user_id, start_workday, end_workday, **kwargs):
        """
        Attendance status metrics for a user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_scorecards_user_attendance(user_id, start_workday, end_workday, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id:  (required)
        :param date start_workday: Start workday of querying workdays range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param date end_workday: End workday of querying workdays range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :return: AttendanceStatusListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'start_workday', 'end_workday']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_scorecards_user_attendance" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_gamification_scorecards_user_attendance`")
        # verify the required parameter 'start_workday' is set
        if ('start_workday' not in params) or (params['start_workday'] is None):
            raise ValueError("Missing the required parameter `start_workday` when calling `get_gamification_scorecards_user_attendance`")
        # verify the required parameter 'end_workday' is set
        if ('end_workday' not in params) or (params['end_workday'] is None):
            raise ValueError("Missing the required parameter `end_workday` when calling `get_gamification_scorecards_user_attendance`")


        resource_path = '/api/v2/gamification/scorecards/users/{userId}/attendance'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}
        if 'start_workday' in params:
            query_params['startWorkday'] = params['start_workday']
        if 'end_workday' in params:
            query_params['endWorkday'] = params['end_workday']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AttendanceStatusListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_scorecards_user_bestpoints(self, user_id, **kwargs):
        """
        Best points of a user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_scorecards_user_bestpoints(user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id:  (required)
        :return: UserBestPoints
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_scorecards_user_bestpoints" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_gamification_scorecards_user_bestpoints`")


        resource_path = '/api/v2/gamification/scorecards/users/{userId}/bestpoints'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UserBestPoints',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_scorecards_user_points_alltime(self, user_id, end_workday, **kwargs):
        """
        All-time points for a user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_scorecards_user_points_alltime(user_id, end_workday, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id:  (required)
        :param date end_workday: End workday of querying workdays range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :return: AllTimePoints
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'end_workday']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_scorecards_user_points_alltime" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_gamification_scorecards_user_points_alltime`")
        # verify the required parameter 'end_workday' is set
        if ('end_workday' not in params) or (params['end_workday'] is None):
            raise ValueError("Missing the required parameter `end_workday` when calling `get_gamification_scorecards_user_points_alltime`")


        resource_path = '/api/v2/gamification/scorecards/users/{userId}/points/alltime'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}
        if 'end_workday' in params:
            query_params['endWorkday'] = params['end_workday']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AllTimePoints',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_scorecards_user_points_trends(self, user_id, start_workday, end_workday, **kwargs):
        """
        Points trend for a user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_scorecards_user_points_trends(user_id, start_workday, end_workday, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id:  (required)
        :param date start_workday: Start workday of querying workdays range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param date end_workday: End workday of querying workdays range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param str day_of_week: Optional filter to specify which day of weeks to be included in the response
        :return: WorkdayPointsTrend
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'start_workday', 'end_workday', 'day_of_week']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_scorecards_user_points_trends" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_gamification_scorecards_user_points_trends`")
        # verify the required parameter 'start_workday' is set
        if ('start_workday' not in params) or (params['start_workday'] is None):
            raise ValueError("Missing the required parameter `start_workday` when calling `get_gamification_scorecards_user_points_trends`")
        # verify the required parameter 'end_workday' is set
        if ('end_workday' not in params) or (params['end_workday'] is None):
            raise ValueError("Missing the required parameter `end_workday` when calling `get_gamification_scorecards_user_points_trends`")


        resource_path = '/api/v2/gamification/scorecards/users/{userId}/points/trends'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}
        if 'start_workday' in params:
            query_params['startWorkday'] = params['start_workday']
        if 'end_workday' in params:
            query_params['endWorkday'] = params['end_workday']
        if 'day_of_week' in params:
            query_params['dayOfWeek'] = params['day_of_week']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkdayPointsTrend',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_scorecards_user_values_trends(self, user_id, start_workday, end_workday, **kwargs):
        """
        Values trends of a user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_scorecards_user_values_trends(user_id, start_workday, end_workday, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id:  (required)
        :param date start_workday: Start workday of querying workdays range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param date end_workday: End workday of querying workdays range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param str time_zone: Timezone for the workday. Defaults to UTC
        :return: WorkdayValuesTrend
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'start_workday', 'end_workday', 'time_zone']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_scorecards_user_values_trends" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_gamification_scorecards_user_values_trends`")
        # verify the required parameter 'start_workday' is set
        if ('start_workday' not in params) or (params['start_workday'] is None):
            raise ValueError("Missing the required parameter `start_workday` when calling `get_gamification_scorecards_user_values_trends`")
        # verify the required parameter 'end_workday' is set
        if ('end_workday' not in params) or (params['end_workday'] is None):
            raise ValueError("Missing the required parameter `end_workday` when calling `get_gamification_scorecards_user_values_trends`")


        resource_path = '/api/v2/gamification/scorecards/users/{userId}/values/trends'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}
        if 'start_workday' in params:
            query_params['startWorkday'] = params['start_workday']
        if 'end_workday' in params:
            query_params['endWorkday'] = params['end_workday']
        if 'time_zone' in params:
            query_params['timeZone'] = params['time_zone']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkdayValuesTrend',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_scorecards_users_points_average(self, filter_type, filter_id, workday, **kwargs):
        """
        Workday average points by target group
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_scorecards_users_points_average(filter_type, filter_id, workday, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str filter_type: Filter type for the query request. (required)
        :param str filter_id: ID for the filter type. (required)
        :param date workday: The target workday. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :return: SingleWorkdayAveragePoints
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter_type', 'filter_id', 'workday']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_scorecards_users_points_average" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'filter_type' is set
        if ('filter_type' not in params) or (params['filter_type'] is None):
            raise ValueError("Missing the required parameter `filter_type` when calling `get_gamification_scorecards_users_points_average`")
        # verify the required parameter 'filter_id' is set
        if ('filter_id' not in params) or (params['filter_id'] is None):
            raise ValueError("Missing the required parameter `filter_id` when calling `get_gamification_scorecards_users_points_average`")
        # verify the required parameter 'workday' is set
        if ('workday' not in params) or (params['workday'] is None):
            raise ValueError("Missing the required parameter `workday` when calling `get_gamification_scorecards_users_points_average`")


        resource_path = '/api/v2/gamification/scorecards/users/points/average'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'filter_id' in params:
            query_params['filterId'] = params['filter_id']
        if 'workday' in params:
            query_params['workday'] = params['workday']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SingleWorkdayAveragePoints',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_scorecards_users_values_average(self, filter_type, filter_id, workday, **kwargs):
        """
        Workday average values by target group
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_scorecards_users_values_average(filter_type, filter_id, workday, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str filter_type: Filter type for the query request. (required)
        :param str filter_id: ID for the filter type. For example, division Id (required)
        :param date workday: The target workday. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param str time_zone: Timezone for the workday. Defaults to UTC
        :return: SingleWorkdayAverageValues
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter_type', 'filter_id', 'workday', 'time_zone']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_scorecards_users_values_average" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'filter_type' is set
        if ('filter_type' not in params) or (params['filter_type'] is None):
            raise ValueError("Missing the required parameter `filter_type` when calling `get_gamification_scorecards_users_values_average`")
        # verify the required parameter 'filter_id' is set
        if ('filter_id' not in params) or (params['filter_id'] is None):
            raise ValueError("Missing the required parameter `filter_id` when calling `get_gamification_scorecards_users_values_average`")
        # verify the required parameter 'workday' is set
        if ('workday' not in params) or (params['workday'] is None):
            raise ValueError("Missing the required parameter `workday` when calling `get_gamification_scorecards_users_values_average`")


        resource_path = '/api/v2/gamification/scorecards/users/values/average'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'filter_id' in params:
            query_params['filterId'] = params['filter_id']
        if 'workday' in params:
            query_params['workday'] = params['workday']
        if 'time_zone' in params:
            query_params['timeZone'] = params['time_zone']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SingleWorkdayAverageValues',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_scorecards_users_values_trends(self, filter_type, filter_id, start_workday, end_workday, **kwargs):
        """
        Values trend by target group
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_scorecards_users_values_trends(filter_type, filter_id, start_workday, end_workday, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str filter_type: Filter type for the query request. (required)
        :param str filter_id: ID for the filter type. (required)
        :param date start_workday: Start workday of querying workdays range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param date end_workday: End workday of querying workdays range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param str time_zone: Timezone for the workday. Defaults to UTC
        :return: WorkdayValuesTrend
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter_type', 'filter_id', 'start_workday', 'end_workday', 'time_zone']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_scorecards_users_values_trends" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'filter_type' is set
        if ('filter_type' not in params) or (params['filter_type'] is None):
            raise ValueError("Missing the required parameter `filter_type` when calling `get_gamification_scorecards_users_values_trends`")
        # verify the required parameter 'filter_id' is set
        if ('filter_id' not in params) or (params['filter_id'] is None):
            raise ValueError("Missing the required parameter `filter_id` when calling `get_gamification_scorecards_users_values_trends`")
        # verify the required parameter 'start_workday' is set
        if ('start_workday' not in params) or (params['start_workday'] is None):
            raise ValueError("Missing the required parameter `start_workday` when calling `get_gamification_scorecards_users_values_trends`")
        # verify the required parameter 'end_workday' is set
        if ('end_workday' not in params) or (params['end_workday'] is None):
            raise ValueError("Missing the required parameter `end_workday` when calling `get_gamification_scorecards_users_values_trends`")


        resource_path = '/api/v2/gamification/scorecards/users/values/trends'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'filter_id' in params:
            query_params['filterId'] = params['filter_id']
        if 'start_workday' in params:
            query_params['startWorkday'] = params['start_workday']
        if 'end_workday' in params:
            query_params['endWorkday'] = params['end_workday']
        if 'time_zone' in params:
            query_params['timeZone'] = params['time_zone']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkdayValuesTrend',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_scorecards_values_average(self, workday, **kwargs):
        """
        Average values of the requesting user's division or performance profile
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_scorecards_values_average(workday, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param date workday: The target workday. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param str time_zone: Timezone for the workday. Defaults to UTC
        :return: SingleWorkdayAverageValues
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workday', 'time_zone']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_scorecards_values_average" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workday' is set
        if ('workday' not in params) or (params['workday'] is None):
            raise ValueError("Missing the required parameter `workday` when calling `get_gamification_scorecards_values_average`")


        resource_path = '/api/v2/gamification/scorecards/values/average'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'workday' in params:
            query_params['workday'] = params['workday']
        if 'time_zone' in params:
            query_params['timeZone'] = params['time_zone']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SingleWorkdayAverageValues',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_scorecards_values_trends(self, start_workday, end_workday, **kwargs):
        """
        Values trends of the requesting user or group
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_scorecards_values_trends(start_workday, end_workday, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param date start_workday: Start workday of querying workdays range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param date end_workday: End workday of querying workdays range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
        :param str filter_type: Filter type for the query request. If not set, then the request is for the requesting user.
        :param date reference_workday: Reference workday for the trend. Used to determine the profile of the user as of this date. If not set, then the user's current profile will be used. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd
        :param str time_zone: Timezone for the workday. Defaults to UTC
        :return: WorkdayValuesTrend
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['start_workday', 'end_workday', 'filter_type', 'reference_workday', 'time_zone']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_scorecards_values_trends" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'start_workday' is set
        if ('start_workday' not in params) or (params['start_workday'] is None):
            raise ValueError("Missing the required parameter `start_workday` when calling `get_gamification_scorecards_values_trends`")
        # verify the required parameter 'end_workday' is set
        if ('end_workday' not in params) or (params['end_workday'] is None):
            raise ValueError("Missing the required parameter `end_workday` when calling `get_gamification_scorecards_values_trends`")


        resource_path = '/api/v2/gamification/scorecards/values/trends'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'reference_workday' in params:
            query_params['referenceWorkday'] = params['reference_workday']
        if 'start_workday' in params:
            query_params['startWorkday'] = params['start_workday']
        if 'end_workday' in params:
            query_params['endWorkday'] = params['end_workday']
        if 'time_zone' in params:
            query_params['timeZone'] = params['time_zone']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkdayValuesTrend',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_status(self, **kwargs):
        """
        Gamification activation status
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_status(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: GamificationStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_status" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/gamification/status'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GamificationStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_template(self, template_id, **kwargs):
        """
        Objective template by id
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_template(template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str template_id: template id (required)
        :return: ObjectiveTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['template_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_template" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `get_gamification_template`")


        resource_path = '/api/v2/gamification/templates/{templateId}'.replace('{format}', 'json')
        path_params = {}
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ObjectiveTemplate',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gamification_templates(self, **kwargs):
        """
        All objective templates
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gamification_templates(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: GetTemplatesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gamification_templates" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/gamification/templates'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GetTemplatesResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_employeeperformance_externalmetrics_definition(self, metric_id, body, **kwargs):
        """
        Update External Metric Definition
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_employeeperformance_externalmetrics_definition(metric_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str metric_id: Specifies the metric definition ID (required)
        :param ExternalMetricDefinitionUpdateRequest body: The External Metric Definition parameters to be updated (required)
        :return: ExternalMetricDefinition
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['metric_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_employeeperformance_externalmetrics_definition" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'metric_id' is set
        if ('metric_id' not in params) or (params['metric_id'] is None):
            raise ValueError("Missing the required parameter `metric_id` when calling `patch_employeeperformance_externalmetrics_definition`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_employeeperformance_externalmetrics_definition`")


        resource_path = '/api/v2/employeeperformance/externalmetrics/definitions/{metricId}'.replace('{format}', 'json')
        path_params = {}
        if 'metric_id' in params:
            path_params['metricId'] = params['metric_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalMetricDefinition',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_employeeperformance_externalmetrics_data(self, **kwargs):
        """
        Write External Metric Data
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_employeeperformance_externalmetrics_data(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ExternalMetricDataWriteRequest body: The External Metric Data to be added
        :return: ExternalMetricDataWriteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_employeeperformance_externalmetrics_data" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/employeeperformance/externalmetrics/data'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalMetricDataWriteResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_employeeperformance_externalmetrics_definitions(self, **kwargs):
        """
        Create External Metric Definition
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_employeeperformance_externalmetrics_definitions(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ExternalMetricDefinitionCreateRequest body: The External Metric Definition to be created
        :return: ExternalMetricDefinition
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_employeeperformance_externalmetrics_definitions" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/employeeperformance/externalmetrics/definitions'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalMetricDefinition',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_gamification_profile_activate(self, profile_id, **kwargs):
        """
        Activate a performance profile
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_gamification_profile_activate(profile_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str profile_id: performanceProfileId (required)
        :return: PerformanceProfile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['profile_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_gamification_profile_activate" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'profile_id' is set
        if ('profile_id' not in params) or (params['profile_id'] is None):
            raise ValueError("Missing the required parameter `profile_id` when calling `post_gamification_profile_activate`")


        resource_path = '/api/v2/gamification/profiles/{profileId}/activate'.replace('{format}', 'json')
        path_params = {}
        if 'profile_id' in params:
            path_params['profileId'] = params['profile_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PerformanceProfile',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_gamification_profile_deactivate(self, profile_id, **kwargs):
        """
        Deactivate a performance profile
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_gamification_profile_deactivate(profile_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str profile_id: performanceProfileId (required)
        :return: PerformanceProfile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['profile_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_gamification_profile_deactivate" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'profile_id' is set
        if ('profile_id' not in params) or (params['profile_id'] is None):
            raise ValueError("Missing the required parameter `profile_id` when calling `post_gamification_profile_deactivate`")


        resource_path = '/api/v2/gamification/profiles/{profileId}/deactivate'.replace('{format}', 'json')
        path_params = {}
        if 'profile_id' in params:
            path_params['profileId'] = params['profile_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PerformanceProfile',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_gamification_profile_members(self, profile_id, body, **kwargs):
        """
        Assign members to a given performance profile
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_gamification_profile_members(profile_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str profile_id: Profile Id (required)
        :param AssignUsers body: assignUsers (required)
        :return: Assignment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['profile_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_gamification_profile_members" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'profile_id' is set
        if ('profile_id' not in params) or (params['profile_id'] is None):
            raise ValueError("Missing the required parameter `profile_id` when calling `post_gamification_profile_members`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_gamification_profile_members`")


        resource_path = '/api/v2/gamification/profiles/{profileId}/members'.replace('{format}', 'json')
        path_params = {}
        if 'profile_id' in params:
            path_params['profileId'] = params['profile_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Assignment',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_gamification_profile_members_validate(self, profile_id, body, **kwargs):
        """
        Validate member assignment
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_gamification_profile_members_validate(profile_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str profile_id: Profile Id (required)
        :param ValidateAssignUsers body: memberAssignments (required)
        :return: AssignmentValidation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['profile_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_gamification_profile_members_validate" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'profile_id' is set
        if ('profile_id' not in params) or (params['profile_id'] is None):
            raise ValueError("Missing the required parameter `profile_id` when calling `post_gamification_profile_members_validate`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_gamification_profile_members_validate`")


        resource_path = '/api/v2/gamification/profiles/{profileId}/members/validate'.replace('{format}', 'json')
        path_params = {}
        if 'profile_id' in params:
            path_params['profileId'] = params['profile_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AssignmentValidation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_gamification_profile_metric_link(self, source_profile_id, source_metric_id, body, **kwargs):
        """
        Creates a linked metric
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_gamification_profile_metric_link(source_profile_id, source_metric_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str source_profile_id: Source Performance Profile Id (required)
        :param str source_metric_id: Source Metric Id (required)
        :param TargetPerformanceProfile body: linkedMetric (required)
        :return: Metric
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['source_profile_id', 'source_metric_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_gamification_profile_metric_link" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'source_profile_id' is set
        if ('source_profile_id' not in params) or (params['source_profile_id'] is None):
            raise ValueError("Missing the required parameter `source_profile_id` when calling `post_gamification_profile_metric_link`")
        # verify the required parameter 'source_metric_id' is set
        if ('source_metric_id' not in params) or (params['source_metric_id'] is None):
            raise ValueError("Missing the required parameter `source_metric_id` when calling `post_gamification_profile_metric_link`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_gamification_profile_metric_link`")


        resource_path = '/api/v2/gamification/profiles/{sourceProfileId}/metrics/{sourceMetricId}/link'.replace('{format}', 'json')
        path_params = {}
        if 'source_profile_id' in params:
            path_params['sourceProfileId'] = params['source_profile_id']
        if 'source_metric_id' in params:
            path_params['sourceMetricId'] = params['source_metric_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Metric',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_gamification_profile_metrics(self, profile_id, body, **kwargs):
        """
        Creates a gamified metric with a given metric definition and metric objective under in a performance profile
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_gamification_profile_metrics(profile_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str profile_id: Performance Profile Id (required)
        :param CreateMetric body: Metric (required)
        :return: Metric
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['profile_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_gamification_profile_metrics" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'profile_id' is set
        if ('profile_id' not in params) or (params['profile_id'] is None):
            raise ValueError("Missing the required parameter `profile_id` when calling `post_gamification_profile_metrics`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_gamification_profile_metrics`")


        resource_path = '/api/v2/gamification/profiles/{profileId}/metrics'.replace('{format}', 'json')
        path_params = {}
        if 'profile_id' in params:
            path_params['profileId'] = params['profile_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Metric',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_gamification_profiles(self, body, **kwargs):
        """
        Create a new custom performance profile
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_gamification_profiles(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CreatePerformanceProfile body: performanceProfile (required)
        :param bool copy_metrics: Flag to copy metrics. If set to false, there will be no metrics associated with the new profile. If set to true or is absent (the default behavior), all metrics from the default profile will be copied over into the new profile.
        :return: PerformanceProfile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'copy_metrics']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_gamification_profiles" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_gamification_profiles`")


        resource_path = '/api/v2/gamification/profiles'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'copy_metrics' in params:
            query_params['copyMetrics'] = params['copy_metrics']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PerformanceProfile',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_gamification_profile(self, profile_id, **kwargs):
        """
        Updates a performance profile
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_gamification_profile(profile_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str profile_id: performanceProfileId (required)
        :param PerformanceProfile body: performanceProfile
        :return: PerformanceProfile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['profile_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_gamification_profile" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'profile_id' is set
        if ('profile_id' not in params) or (params['profile_id'] is None):
            raise ValueError("Missing the required parameter `profile_id` when calling `put_gamification_profile`")


        resource_path = '/api/v2/gamification/profiles/{profileId}'.replace('{format}', 'json')
        path_params = {}
        if 'profile_id' in params:
            path_params['profileId'] = params['profile_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PerformanceProfile',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_gamification_profile_metric(self, profile_id, metric_id, body, **kwargs):
        """
        Updates a metric in performance profile
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_gamification_profile_metric(profile_id, metric_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str profile_id: Performance Profile Id (required)
        :param str metric_id: Metric Id (required)
        :param CreateMetric body: Metric (required)
        :return: Metric
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['profile_id', 'metric_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_gamification_profile_metric" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'profile_id' is set
        if ('profile_id' not in params) or (params['profile_id'] is None):
            raise ValueError("Missing the required parameter `profile_id` when calling `put_gamification_profile_metric`")
        # verify the required parameter 'metric_id' is set
        if ('metric_id' not in params) or (params['metric_id'] is None):
            raise ValueError("Missing the required parameter `metric_id` when calling `put_gamification_profile_metric`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_gamification_profile_metric`")


        resource_path = '/api/v2/gamification/profiles/{profileId}/metrics/{metricId}'.replace('{format}', 'json')
        path_params = {}
        if 'profile_id' in params:
            path_params['profileId'] = params['profile_id']
        if 'metric_id' in params:
            path_params['metricId'] = params['metric_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Metric',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_gamification_status(self, status, **kwargs):
        """
        Update gamification activation status
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_gamification_status(status, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param GamificationStatus status: Gamification status (required)
        :return: GamificationStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['status']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_gamification_status" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'status' is set
        if ('status' not in params) or (params['status'] is None):
            raise ValueError("Missing the required parameter `status` when calling `put_gamification_status`")


        resource_path = '/api/v2/gamification/status'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'status' in params:
            body_params = params['status']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GamificationStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
