"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnWebhook = exports.CfnWebhookPropsInsecureSsl = exports.CfnWebhookPropsContentType = exports.CfnWebhookPropsName = exports.toJson_CfnWebhookProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnWebhookProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnWebhookProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Owner': obj.owner,
        'Name': obj.name,
        'Active': obj.active,
        'Events': obj.events?.map(y => y),
        'Repository': obj.repository,
        'ContentType': obj.contentType,
        'Url': obj.url,
        'Secret': obj.secret,
        'InsecureSsl': obj.insecureSsl,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnWebhookProps = toJson_CfnWebhookProps;
/* eslint-enable max-len, quote-props */
/**
 * Use web to create a webhook. Default: web. This parameter only accepts the value web.
 *
 * @schema CfnWebhookPropsName
 */
var CfnWebhookPropsName;
(function (CfnWebhookPropsName) {
    /** web */
    CfnWebhookPropsName["WEB"] = "web";
})(CfnWebhookPropsName = exports.CfnWebhookPropsName || (exports.CfnWebhookPropsName = {}));
/**
 * The media type used to serialize the payloads. Supported values include json and form. The default is form.
 *
 * @schema CfnWebhookPropsContentType
 */
var CfnWebhookPropsContentType;
(function (CfnWebhookPropsContentType) {
    /** form */
    CfnWebhookPropsContentType["FORM"] = "form";
    /** json */
    CfnWebhookPropsContentType["JSON"] = "json";
})(CfnWebhookPropsContentType = exports.CfnWebhookPropsContentType || (exports.CfnWebhookPropsContentType = {}));
/**
 * Determines whether the SSL certificate of the host for url will be verified when delivering payloads. Supported values include 0 (verification is performed) and 1 (verification is not performed). The default is 0. We strongly recommend not setting this to 1 as you are subject to man-in-the-middle and other attacks.
 *
 * @schema CfnWebhookPropsInsecureSsl
 */
var CfnWebhookPropsInsecureSsl;
(function (CfnWebhookPropsInsecureSsl) {
    /** 0 */
    CfnWebhookPropsInsecureSsl[CfnWebhookPropsInsecureSsl["VALUE_0"] = 0] = "VALUE_0";
    /** 1 */
    CfnWebhookPropsInsecureSsl[CfnWebhookPropsInsecureSsl["VALUE_1"] = 1] = "VALUE_1";
})(CfnWebhookPropsInsecureSsl = exports.CfnWebhookPropsInsecureSsl || (exports.CfnWebhookPropsInsecureSsl = {}));
/**
 * A CloudFormation `GitHub::Repositories::Webhook`
 *
 * @cloudformationResource GitHub::Repositories::Webhook
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-github-resource-providers.git
 */
class CfnWebhook extends cdk.CfnResource {
    /**
     * Create a new `GitHub::Repositories::Webhook`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnWebhook.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnWebhookProps(props) });
        this.props = props;
        this.attrId = cdk.Token.asNumber(this.getAtt('Id'));
    }
}
exports.CfnWebhook = CfnWebhook;
_a = JSII_RTTI_SYMBOL_1;
CfnWebhook[_a] = { fqn: "@cdk-cloudformation/github-repositories-webhook.CfnWebhook", version: "1.2.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnWebhook.CFN_RESOURCE_TYPE_NAME = "GitHub::Repositories::Webhook";
//# sourceMappingURL=data:application/json;base64,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