# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['pytest_split']

package_data = \
{'': ['*']}

install_requires = \
['pytest>=5,<8']

entry_points = \
{'console_scripts': ['slowest-tests = pytest_split.cli:list_slowest_tests'],
 'pytest11': ['pytest-split = pytest_split.plugin']}

setup_kwargs = {
    'name': 'pytest-split',
    'version': '0.8.0',
    'description': 'Pytest plugin which splits the test suite to equally sized sub suites based on test execution time.',
    'long_description': '# pytest-split\n\n[![PyPI](https://img.shields.io/pypi/v/pytest-split?style=flat-square)](https://pypi.python.org/pypi/pytest-split/)\n[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/pytest-split?style=flat-square)](https://pypi.python.org/pypi/pytest-split/)\n[![PyPI - License](https://img.shields.io/pypi/l/pytest-split?style=flat-square)](https://pypi.python.org/pypi/pytest-split/)\n[![Coookiecutter - Wolt](https://img.shields.io/badge/cookiecutter-Wolt-00c2e8?style=flat-square&logo=cookiecutter&logoColor=D4AA00&link=https://github.com/woltapp/wolt-python-package-cookiecutter)](https://github.com/woltapp/wolt-python-package-cookiecutter)\n\n\n---\n\n**Documentation**: [https://jerry-git.github.io/pytest-split](https://jerry-git.github.io/pytest-split)\n\n**Source Code**: [https://github.com/jerry-git/pytest-split](https://github.com/jerry-git/pytest-split)\n\n**PyPI**: [https://pypi.org/project/pytest-split/](https://pypi.org/project/pytest-split/)\n\n---\n\nPytest plugin which splits the test suite to equally sized "sub suites" based on test execution time.\n\n## Motivation\n* Splitting the test suite is a prerequisite for parallelization (who does not want faster CI builds?). It\'s valuable to have sub suites which execution time is around the same.\n* [`pytest-test-groups`](https://pypi.org/project/pytest-test-groups/) is great but it does not take into account the execution time of sub suites which can lead to notably unbalanced execution times between the sub suites.\n* [`pytest-xdist`](https://pypi.org/project/pytest-xdist/) is great but it\'s not suitable for all use cases.\nFor example, some test suites may be fragile considering the order in which the tests are executed.\nThis is of course a fundamental problem in the suite itself but sometimes it\'s not worth the effort to refactor, especially if the suite is huge (and smells a bit like legacy).\nAdditionally, `pytest-split` may be a better fit in some use cases considering distributed execution.\n\n## Installation\n```sh\npip install pytest-split\n```\n\n## Usage\nFirst we have to store test durations from a complete test suite run.\nThis produces .test_durations file which should be stored in the repo in order to have it available during future test runs.\nThe file path is configurable via `--durations-path` CLI option.\n```sh\npytest --store-durations\n```\n\nThen we can have as many splits as we want:\n```sh\npytest --splits 3 --group 1\npytest --splits 3 --group 2\npytest --splits 3 --group 3\n```\n\nTime goes by, new tests are added and old ones are removed/renamed during development. No worries!\n`pytest-split` assumes average test execution time (calculated based on the stored information) for every test which does not have duration information stored.\nThus, there\'s no need to store durations after changing the test suite.\nHowever, when there are major changes in the suite compared to what\'s stored in .test_durations, it\'s recommended to update the duration information with `--store-durations` to ensure that the splitting is in balance.\n\nThe splitting algorithm can be controlled with the `--splitting-algorithm` CLI option and defaults to `duration_based_chunks`. For more information about the different algorithms and their tradeoffs, please see the section below.\n\n### CLI commands\n#### slowest-tests\nLists the slowest tests based on the information stored in the test durations file. See `slowest-tests --help` for more\n information.\n\n## Interactions with other pytest plugins\n* [`pytest-random-order`](https://github.com/jbasko/pytest-random-order) and [`pytest-randomly`](https://github.com/pytest-dev/pytest-randomly):\n   ⚠️ `pytest-split` running with the `duration_based_chunks` algorithm is **incompatible** with test-order-randomization plugins.\n  Test selection in the groups happens after randomization, potentially causing some tests to be selected in several groups and others not at all.\n  Instead, a global random seed needs to be computed before running the tests (for example using `$RANDOM` from the shell) and that single seed then needs to be used for all groups by setting the `--random-order-seed` option.\n\n* [`nbval`](https://github.com/computationalmodelling/nbval): `pytest-split` could, in principle, break up a single IPython Notebook into different test groups. This most likely causes broken up pieces to fail (for the very least, package `import`s are usually done at Cell 1, and so, any broken up piece that doesn\'t contain Cell 1 will certainly fail). To avoid this, after splitting step is done, test groups are reorganized based on a simple algorithm illustrated in the following cartoon:\n\n![image](https://user-images.githubusercontent.com/14086031/145830494-07afcaf0-5a0f-4817-b9ee-f84a459652a8.png)\n\nwhere the letters (A to E) refer to individual IPython Notebooks, and the numbers refer to the corresponding cell number.\n\n## Splitting algorithms\nThe plugin supports multiple algorithms to split tests into groups.\nEach algorithm makes different tradeoffs, but generally `least_duration` should give more balanced groups.\n\n| Algorithm      | Maintains Absolute Order | Maintains Relative Order | Split Quality | Works with random ordering |\n|----------------|--------------------------|--------------------------|---------------|----------------------------|\n| duration_based_chunks | ✅                | ✅                       | Good          | ❌                         |\n| least_duration | ❌                       | ✅                       | Better        | ✅                         |\n\nExplanation of the terms in the table:\n* Absolute Order: whether each group contains all tests between first and last element in the same order as the original list of tests\n* Relative Order: whether each test in each group has the same relative order to its neighbours in the group as in the original list of tests\n* Works with random ordering: whether the algorithm works with test-shuffling tools such as [`pytest-randomly`](https://github.com/pytest-dev/pytest-randomly)\n\nThe `duration_based_chunks` algorithm aims to find optimal boundaries for the list of tests and every test group contains all tests between the start and end boundary.\nThe `least_duration` algorithm walks the list of tests and assigns each test to the group with the smallest current duration.\n\n\n[**Demo with GitHub Actions**](https://github.com/jerry-git/pytest-split-gh-actions-demo)\n\n\n## Development\n\n* Clone this repository\n* Requirements:\n  * [Poetry](https://python-poetry.org/)\n  * Python 3.7+\n* Create a virtual environment and install the dependencies\n\n```sh\npoetry install\n```\n\n* Activate the virtual environment\n\n```sh\npoetry shell\n```\n\n### Testing\n\n```sh\npytest\n```\n\n### Documentation\n\nThe documentation is automatically generated from the content of the [docs directory](./docs) and from the docstrings\n of the public signatures of the source code. The documentation is updated and published as a [Github project page\n ](https://pages.github.com/) automatically as part each release.\n\n### Releasing\n\nTrigger the [Draft release workflow](https://github.com/jerry-git/pytest-split/actions/workflows/draft_release.yml)\n(press _Run workflow_). This will update the changelog & version and create a GitHub release which is in _Draft_ state.\n\nFind the draft release from the\n[GitHub releases](https://github.com/jerry-git/pytest-split/releases) and publish it. When\n a release is published, it\'ll trigger [release](https://github.com/jerry-git/pytest-split/blob/master/.github/workflows/release.yml) workflow which creates PyPI\n release and deploys updated documentation.\n\n### Pre-commit\n\nPre-commit hooks run all the auto-formatters (e.g. `black`, `isort`), linters (e.g. `mypy`, `flake8`), and other quality\n checks to make sure the changeset is in good shape before a commit/push happens.\n\nYou can install the hooks with (runs for each commit):\n\n```sh\npre-commit install\n```\n\nOr if you want them to run only for each push:\n\n```sh\npre-commit install -t pre-push\n```\n\nOr if you want e.g. want to run all checks manually for all files:\n\n```sh\npre-commit run --all-files\n```\n\n---\n\nThis project was generated using the [wolt-python-package-cookiecutter](https://github.com/woltapp/wolt-python-package-cookiecutter) template.\n',
    'author': 'Jerry Pussinen',
    'author_email': 'jerry.pussinen@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://jerry-git.github.io/pytest-split',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7.1,<4.0',
}


setup(**setup_kwargs)
