# coding: utf-8

# flake8: noqa

"""
    Confidentify API

    Services that let you build confidence and identify matches in customer data. ## Features overview * Contact data processing services (tagged with `process`) which offer   validation and enrichment backed by inference and knowledge on complex   data types such as names, email addresses, phone numbers.  * Data matching and searching services (tagged with `matching`) that    allow you to identify duplicated data or matches against third party   contact data list.  * Dataset management services (tagged with `dataset`) that allow record storage and retrieval. ## Integrator notes: * Use the `/auth` endpoint to get an access token. Access tokens are temporary, so design the client the be capable of renewing it. * The APIs are rate-limited, so design the client to be capable of retrying with some delay upon HTTP 429 responses.   # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

__version__ = "1.0.0"

# import apis into sdk package
from confidentify_client.api.accounts_api import AccountsApi
from confidentify_client.api.auth_api import AuthApi
from confidentify_client.api.datasets_api import DatasetsApi
from confidentify_client.api.matching_api import MatchingApi
from confidentify_client.api.process_api import ProcessApi

# import ApiClient
from confidentify_client.api_client import ApiClient
from confidentify_client.configuration import Configuration
from confidentify_client.exceptions import OpenApiException
from confidentify_client.exceptions import ApiTypeError
from confidentify_client.exceptions import ApiValueError
from confidentify_client.exceptions import ApiKeyError
from confidentify_client.exceptions import ApiException
# import models into sdk package
from confidentify_client.models.auth_request import AuthRequest
from confidentify_client.models.auth_response import AuthResponse
from confidentify_client.models.confidentify_account import ConfidentifyAccount
from confidentify_client.models.confidentify_user import ConfidentifyUser
from confidentify_client.models.dataset_all import DatasetAll
from confidentify_client.models.dataset_all_all_of import DatasetAllAllOf
from confidentify_client.models.dataset_base import DatasetBase
from confidentify_client.models.dataset_create_request import DatasetCreateRequest
from confidentify_client.models.dataset_create_response import DatasetCreateResponse
from confidentify_client.models.dataset_list_item import DatasetListItem
from confidentify_client.models.dataset_list_item_all_of import DatasetListItemAllOf
from confidentify_client.models.dataset_list_response import DatasetListResponse
from confidentify_client.models.dataset_schema import DatasetSchema
from confidentify_client.models.dataset_schema_property import DatasetSchemaProperty
from confidentify_client.models.dataset_schema_property_items import DatasetSchemaPropertyItems
from confidentify_client.models.dataset_schema_property_type import DatasetSchemaPropertyType
from confidentify_client.models.dataset_stats import DatasetStats
from confidentify_client.models.email_request import EmailRequest
from confidentify_client.models.email_request_record import EmailRequestRecord
from confidentify_client.models.email_response import EmailResponse
from confidentify_client.models.email_response_record import EmailResponseRecord
from confidentify_client.models.identify_request import IdentifyRequest
from confidentify_client.models.identify_request_record import IdentifyRequestRecord
from confidentify_client.models.identify_response import IdentifyResponse
from confidentify_client.models.identify_response_record import IdentifyResponseRecord
from confidentify_client.models.identify_response_record_entity import IdentifyResponseRecordEntity
from confidentify_client.models.ingest_documents_request import IngestDocumentsRequest
from confidentify_client.models.ingest_file_request import IngestFileRequest
from confidentify_client.models.ingest_file_response import IngestFileResponse
from confidentify_client.models.ingest_file_response_upload_to import IngestFileResponseUploadTo
from confidentify_client.models.organization_name_request import OrganizationNameRequest
from confidentify_client.models.organization_name_request_record import OrganizationNameRequestRecord
from confidentify_client.models.organization_name_response import OrganizationNameResponse
from confidentify_client.models.organization_name_response_record import OrganizationNameResponseRecord
from confidentify_client.models.person_name_all import PersonNameAll
from confidentify_client.models.person_name_all_all_of import PersonNameAllAllOf
from confidentify_client.models.person_name_base import PersonNameBase
from confidentify_client.models.person_name_request import PersonNameRequest
from confidentify_client.models.person_name_request_record import PersonNameRequestRecord
from confidentify_client.models.person_name_response import PersonNameResponse
from confidentify_client.models.person_name_response_record import PersonNameResponseRecord
from confidentify_client.models.person_name_response_record_entity import PersonNameResponseRecordEntity
from confidentify_client.models.person_name_response_record_entity_all_of import PersonNameResponseRecordEntityAllOf
from confidentify_client.models.phone_request import PhoneRequest
from confidentify_client.models.phone_request_record import PhoneRequestRecord
from confidentify_client.models.phone_response import PhoneResponse
from confidentify_client.models.phone_response_record import PhoneResponseRecord
from confidentify_client.models.processor_outcome import ProcessorOutcome
from confidentify_client.models.processor_verdict import ProcessorVerdict
from confidentify_client.models.records_upload_request import RecordsUploadRequest

