"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GithubWebhookHandler = void 0;
const cdk = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const constructs_1 = require("constructs");
const utils_1 = require("./utils");
/**
 * Create a Lambda with a public URL to handle GitHub webhook events. After validating the event with the given secret, the orchestrator step function is called with information about the workflow job.
 *
 * This construct is not meant to be used by itself.
 */
class GithubWebhookHandler extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.handler = new utils_1.BundledNodejsFunction(this, 'webhook-handler', {
            environment: {
                STEP_FUNCTION_ARN: props.orchestrator.stateMachineArn,
                WEBHOOK_SECRET_ARN: props.secrets.webhook.secretArn,
            },
            timeout: cdk.Duration.seconds(30),
        });
        this.url = this.handler.addFunctionUrl({ authType: aws_lambda_1.FunctionUrlAuthType.NONE }).url;
        props.secrets.webhook.grantRead(this.handler);
        props.orchestrator.grantStartExecution(this.handler);
    }
}
exports.GithubWebhookHandler = GithubWebhookHandler;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoid2ViaG9vay5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy93ZWJob29rLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUNBLG1DQUFtQztBQUNuQyx1REFBNkQ7QUFDN0QsMkNBQXVDO0FBRXZDLG1DQUFnRDtBQWtCaEQ7Ozs7R0FJRztBQUNILE1BQWEsb0JBQXFCLFNBQVEsc0JBQVM7SUFZakQsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFnQztRQUN4RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLElBQUksQ0FBQyxPQUFPLEdBQUcsSUFBSSw2QkFBcUIsQ0FDdEMsSUFBSSxFQUNKLGlCQUFpQixFQUNqQjtZQUNFLFdBQVcsRUFBRTtnQkFDWCxpQkFBaUIsRUFBRSxLQUFLLENBQUMsWUFBWSxDQUFDLGVBQWU7Z0JBQ3JELGtCQUFrQixFQUFFLEtBQUssQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLFNBQVM7YUFDcEQ7WUFDRCxPQUFPLEVBQUUsR0FBRyxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsRUFBRSxDQUFDO1NBQ2xDLENBQ0YsQ0FBQztRQUVGLElBQUksQ0FBQyxHQUFHLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxjQUFjLENBQUMsRUFBRSxRQUFRLEVBQUUsZ0NBQW1CLENBQUMsSUFBSSxFQUFFLENBQUMsQ0FBQyxHQUFHLENBQUM7UUFFbkYsS0FBSyxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUM5QyxLQUFLLENBQUMsWUFBWSxDQUFDLG1CQUFtQixDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQztJQUN2RCxDQUFDO0NBQ0Y7QUFoQ0Qsb0RBZ0NDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgYXdzX3N0ZXBmdW5jdGlvbnMgYXMgc3RlcGZ1bmN0aW9ucyB9IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCAqIGFzIGNkayBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgeyBGdW5jdGlvblVybEF1dGhUeXBlIH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWxhbWJkYSc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IFNlY3JldHMgfSBmcm9tICcuL3NlY3JldHMnO1xuaW1wb3J0IHsgQnVuZGxlZE5vZGVqc0Z1bmN0aW9uIH0gZnJvbSAnLi91dGlscyc7XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgR2l0aHViV2ViaG9va0hhbmRsZXJcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBHaXRodWJXZWJob29rSGFuZGxlclByb3BzIHtcblxuICAvKipcbiAgICogU3RlcCBmdW5jdGlvbiBpbiBjaGFyZ2Ugb2YgaGFuZGxpbmcgdGhlIHdvcmtmbG93IGpvYiBldmVudHMgYW5kIHN0YXJ0IHRoZSBydW5uZXJzLlxuICAgKi9cbiAgcmVhZG9ubHkgb3JjaGVzdHJhdG9yOiBzdGVwZnVuY3Rpb25zLlN0YXRlTWFjaGluZTtcblxuICAvKipcbiAgICogU2VjcmV0cyB1c2VkIHRvIGNvbW11bmljYXRlIHdpdGggR2l0SHViLlxuICAgKi9cbiAgcmVhZG9ubHkgc2VjcmV0czogU2VjcmV0cztcbn1cblxuLyoqXG4gKiBDcmVhdGUgYSBMYW1iZGEgd2l0aCBhIHB1YmxpYyBVUkwgdG8gaGFuZGxlIEdpdEh1YiB3ZWJob29rIGV2ZW50cy4gQWZ0ZXIgdmFsaWRhdGluZyB0aGUgZXZlbnQgd2l0aCB0aGUgZ2l2ZW4gc2VjcmV0LCB0aGUgb3JjaGVzdHJhdG9yIHN0ZXAgZnVuY3Rpb24gaXMgY2FsbGVkIHdpdGggaW5mb3JtYXRpb24gYWJvdXQgdGhlIHdvcmtmbG93IGpvYi5cbiAqXG4gKiBUaGlzIGNvbnN0cnVjdCBpcyBub3QgbWVhbnQgdG8gYmUgdXNlZCBieSBpdHNlbGYuXG4gKi9cbmV4cG9ydCBjbGFzcyBHaXRodWJXZWJob29rSGFuZGxlciBleHRlbmRzIENvbnN0cnVjdCB7XG5cbiAgLyoqXG4gICAqIFB1YmxpYyBVUkwgb2Ygd2ViaG9vayB0byBiZSB1c2VkIHdpdGggR2l0SHViLlxuICAgKi9cbiAgcmVhZG9ubHkgdXJsOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFdlYmhvb2sgZXZlbnQgaGFuZGxlci5cbiAgICovXG4gIHJlYWRvbmx5IGhhbmRsZXI6IEJ1bmRsZWROb2RlanNGdW5jdGlvbjtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogR2l0aHViV2ViaG9va0hhbmRsZXJQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICB0aGlzLmhhbmRsZXIgPSBuZXcgQnVuZGxlZE5vZGVqc0Z1bmN0aW9uKFxuICAgICAgdGhpcyxcbiAgICAgICd3ZWJob29rLWhhbmRsZXInLFxuICAgICAge1xuICAgICAgICBlbnZpcm9ubWVudDoge1xuICAgICAgICAgIFNURVBfRlVOQ1RJT05fQVJOOiBwcm9wcy5vcmNoZXN0cmF0b3Iuc3RhdGVNYWNoaW5lQXJuLFxuICAgICAgICAgIFdFQkhPT0tfU0VDUkVUX0FSTjogcHJvcHMuc2VjcmV0cy53ZWJob29rLnNlY3JldEFybixcbiAgICAgICAgfSxcbiAgICAgICAgdGltZW91dDogY2RrLkR1cmF0aW9uLnNlY29uZHMoMzApLFxuICAgICAgfSxcbiAgICApO1xuXG4gICAgdGhpcy51cmwgPSB0aGlzLmhhbmRsZXIuYWRkRnVuY3Rpb25VcmwoeyBhdXRoVHlwZTogRnVuY3Rpb25VcmxBdXRoVHlwZS5OT05FIH0pLnVybDtcblxuICAgIHByb3BzLnNlY3JldHMud2ViaG9vay5ncmFudFJlYWQodGhpcy5oYW5kbGVyKTtcbiAgICBwcm9wcy5vcmNoZXN0cmF0b3IuZ3JhbnRTdGFydEV4ZWN1dGlvbih0aGlzLmhhbmRsZXIpO1xuICB9XG59Il19