**pyseisdl**
======

## Description

**pyseisdl** is a python package for different dictionary learning methods and their applications in seismology. DL has a variety of applications in seismology, including but not limited to seismic denoising, seismic reconstruction, seismic diffraction separation, constrained LSRTM, constrained FWI, etc.

## Reference
    Chen, Y. (2020). Fast dictionary learning for noise attenuation of multidimensional seismic data. Geophysical Journal International, 222(3), 1717-1727.
    
BibTeX:

	@article{chen2020sgk,
	  title={Fast dictionary learning for noise attenuation of multidimensional seismic data},
	  author={Yangkang Chen},
	  journal={Geophysical Journal International},
	  volume={222},
	  number={3},
	  issue={3},
	  pages={1717-1727},
	  year={2020}
	}

-----------
## Copyright
    Initial version: Yangkang Chen (chenyk2016@gmail.com), 2021-2022
	Later version: pyseisdl developing team, 2022-present
-----------

## License
    GNU General Public License, Version 3
    (http://www.gnu.org/copyleft/gpl.html)   

-----------

## Install
Using the latest version

    git clone https://github.com/chenyk1990/pyseisdl
    cd pyseisdl
    pip install -v -e .
or using Pypi

    pip install pyseisdl

-----------
## Examples
    The "demo" directory contains all runable scripts to demonstrate different applications of pyseisdl. 

-----------
## Dependence Packages
* scipy 
* numpy 
* matplotlib

-----------
## Development
    The development team welcomes voluntary contributions from any open-source enthusiast. 
    If you want to make contribution to this project, feel free to contact the development team. 

-----------
## Contact
    Regarding any questions, bugs, developments, collaborations, please contact  
    Yangkang Chen
    chenyk2016@gmail.com

-----------


