# Python Client
Programmatically 💻 interact with Tamr using Python 🐍

[![Version](https://img.shields.io/pypi/v/tamr-unify-client.svg?style=flat-square)](https://pypi.org/project/tamr-unify-client/)
[![Documentation Status](https://readthedocs.org/projects/tamr-client/badge/?version=stable&style=flat-square)](https://tamr-client.readthedocs.io/en/stable/?badge=stable)
[![Build Status](https://img.shields.io/github/workflow/status/Datatamer/tamr-client/CI?&style=flat-square)](https://github.com/Datatamer/tamr-client/actions?query=workflow%3ACI)
![Supported Python Versions](https://img.shields.io/pypi/pyversions/tamr-unify-client.svg?style=flat-square)
[![License](https://img.shields.io/pypi/l/tamr-unify-client.svg?style=flat-square)](LICENSE)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg?style=flat-square)](https://github.com/ambv/black)

---

*Quick links:*
**[Docs](https://tamr-client.readthedocs.io/en/stable/)** |
**[Contributing](https://tamr-client.readthedocs.io/en/stable/contributor-guide.html)** |
**[License](https://github.com/Datatamer/tamr-client/blob/main/LICENSE)**

---

## Install

```sh
pip install tamr-unify-client
```

## Features
- 🐍 Python objects/methods/functions instead of raw HTTP requests
- 🤖 Automate operational workflows
  - Continuous Mastering
  - Continuous Categorization
- 🚀 Kick-off synchronous/asynchronous operations
  - Refresh datasets in your pipeline
  - Train Tamr's machine learning models
  - Generate predictions from trained models
- 🔒 Authenticate with Tamr

For more see the [official docs](https://tamr-client.readthedocs.io/en/stable/).

## Maintainers

- [Pedro Cattori](https://github.com/pcattori)
- [Samuel Kalish](https://github.com/skalish)
