# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables

__all__ = ['Time']


class Time(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 node_name: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Create a Time resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] node_name: The node name
        :param pulumi.Input[str] time_zone: The time zone
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if node_name is None:
                raise TypeError("Missing required property 'node_name'")
            __props__['node_name'] = node_name
            if time_zone is None:
                raise TypeError("Missing required property 'time_zone'")
            __props__['time_zone'] = time_zone
            __props__['local_time'] = None
            __props__['utc_time'] = None
        super(Time, __self__).__init__(
            'proxmox:System/time:Time',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            local_time: Optional[pulumi.Input[str]] = None,
            node_name: Optional[pulumi.Input[str]] = None,
            time_zone: Optional[pulumi.Input[str]] = None,
            utc_time: Optional[pulumi.Input[str]] = None) -> 'Time':
        """
        Get an existing Time resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] local_time: The local timestamp
        :param pulumi.Input[str] node_name: The node name
        :param pulumi.Input[str] time_zone: The time zone
        :param pulumi.Input[str] utc_time: The UTC timestamp
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["local_time"] = local_time
        __props__["node_name"] = node_name
        __props__["time_zone"] = time_zone
        __props__["utc_time"] = utc_time
        return Time(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="localTime")
    def local_time(self) -> pulumi.Output[str]:
        """
        The local timestamp
        """
        return pulumi.get(self, "local_time")

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> pulumi.Output[str]:
        """
        The node name
        """
        return pulumi.get(self, "node_name")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[str]:
        """
        The time zone
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="utcTime")
    def utc_time(self) -> pulumi.Output[str]:
        """
        The UTC timestamp
        """
        return pulumi.get(self, "utc_time")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

