# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Container']


class Container(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 clone: Optional[pulumi.Input[pulumi.InputType['ContainerCloneArgs']]] = None,
                 console: Optional[pulumi.Input[pulumi.InputType['ContainerConsoleArgs']]] = None,
                 cpu: Optional[pulumi.Input[pulumi.InputType['ContainerCpuArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disk: Optional[pulumi.Input[pulumi.InputType['ContainerDiskArgs']]] = None,
                 initialization: Optional[pulumi.Input[pulumi.InputType['ContainerInitializationArgs']]] = None,
                 memory: Optional[pulumi.Input[pulumi.InputType['ContainerMemoryArgs']]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContainerNetworkInterfaceArgs']]]]] = None,
                 node_name: Optional[pulumi.Input[str]] = None,
                 operating_system: Optional[pulumi.Input[pulumi.InputType['ContainerOperatingSystemArgs']]] = None,
                 pool_id: Optional[pulumi.Input[str]] = None,
                 started: Optional[pulumi.Input[bool]] = None,
                 template: Optional[pulumi.Input[bool]] = None,
                 vm_id: Optional[pulumi.Input[int]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Create a Container resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ContainerCloneArgs']] clone: The cloning configuration
        :param pulumi.Input[pulumi.InputType['ContainerConsoleArgs']] console: The console configuration
        :param pulumi.Input[pulumi.InputType['ContainerCpuArgs']] cpu: The CPU allocation
        :param pulumi.Input[str] description: The description
        :param pulumi.Input[pulumi.InputType['ContainerDiskArgs']] disk: The disks
        :param pulumi.Input[pulumi.InputType['ContainerInitializationArgs']] initialization: The initialization configuration
        :param pulumi.Input[pulumi.InputType['ContainerMemoryArgs']] memory: The memory allocation
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContainerNetworkInterfaceArgs']]]] network_interfaces: The network interfaces
        :param pulumi.Input[str] node_name: The node name
        :param pulumi.Input[pulumi.InputType['ContainerOperatingSystemArgs']] operating_system: The operating system configuration
        :param pulumi.Input[str] pool_id: The ID of the pool to assign the container to
        :param pulumi.Input[bool] started: Whether to start the container
        :param pulumi.Input[bool] template: Whether to create a template
        :param pulumi.Input[int] vm_id: The VM identifier
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['clone'] = clone
            __props__['console'] = console
            __props__['cpu'] = cpu
            __props__['description'] = description
            __props__['disk'] = disk
            __props__['initialization'] = initialization
            __props__['memory'] = memory
            __props__['network_interfaces'] = network_interfaces
            if node_name is None:
                raise TypeError("Missing required property 'node_name'")
            __props__['node_name'] = node_name
            __props__['operating_system'] = operating_system
            __props__['pool_id'] = pool_id
            __props__['started'] = started
            __props__['template'] = template
            __props__['vm_id'] = vm_id
        super(Container, __self__).__init__(
            'proxmox:CT/container:Container',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            clone: Optional[pulumi.Input[pulumi.InputType['ContainerCloneArgs']]] = None,
            console: Optional[pulumi.Input[pulumi.InputType['ContainerConsoleArgs']]] = None,
            cpu: Optional[pulumi.Input[pulumi.InputType['ContainerCpuArgs']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            disk: Optional[pulumi.Input[pulumi.InputType['ContainerDiskArgs']]] = None,
            initialization: Optional[pulumi.Input[pulumi.InputType['ContainerInitializationArgs']]] = None,
            memory: Optional[pulumi.Input[pulumi.InputType['ContainerMemoryArgs']]] = None,
            network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContainerNetworkInterfaceArgs']]]]] = None,
            node_name: Optional[pulumi.Input[str]] = None,
            operating_system: Optional[pulumi.Input[pulumi.InputType['ContainerOperatingSystemArgs']]] = None,
            pool_id: Optional[pulumi.Input[str]] = None,
            started: Optional[pulumi.Input[bool]] = None,
            template: Optional[pulumi.Input[bool]] = None,
            vm_id: Optional[pulumi.Input[int]] = None) -> 'Container':
        """
        Get an existing Container resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ContainerCloneArgs']] clone: The cloning configuration
        :param pulumi.Input[pulumi.InputType['ContainerConsoleArgs']] console: The console configuration
        :param pulumi.Input[pulumi.InputType['ContainerCpuArgs']] cpu: The CPU allocation
        :param pulumi.Input[str] description: The description
        :param pulumi.Input[pulumi.InputType['ContainerDiskArgs']] disk: The disks
        :param pulumi.Input[pulumi.InputType['ContainerInitializationArgs']] initialization: The initialization configuration
        :param pulumi.Input[pulumi.InputType['ContainerMemoryArgs']] memory: The memory allocation
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContainerNetworkInterfaceArgs']]]] network_interfaces: The network interfaces
        :param pulumi.Input[str] node_name: The node name
        :param pulumi.Input[pulumi.InputType['ContainerOperatingSystemArgs']] operating_system: The operating system configuration
        :param pulumi.Input[str] pool_id: The ID of the pool to assign the container to
        :param pulumi.Input[bool] started: Whether to start the container
        :param pulumi.Input[bool] template: Whether to create a template
        :param pulumi.Input[int] vm_id: The VM identifier
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["clone"] = clone
        __props__["console"] = console
        __props__["cpu"] = cpu
        __props__["description"] = description
        __props__["disk"] = disk
        __props__["initialization"] = initialization
        __props__["memory"] = memory
        __props__["network_interfaces"] = network_interfaces
        __props__["node_name"] = node_name
        __props__["operating_system"] = operating_system
        __props__["pool_id"] = pool_id
        __props__["started"] = started
        __props__["template"] = template
        __props__["vm_id"] = vm_id
        return Container(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def clone(self) -> pulumi.Output[Optional['outputs.ContainerClone']]:
        """
        The cloning configuration
        """
        return pulumi.get(self, "clone")

    @property
    @pulumi.getter
    def console(self) -> pulumi.Output[Optional['outputs.ContainerConsole']]:
        """
        The console configuration
        """
        return pulumi.get(self, "console")

    @property
    @pulumi.getter
    def cpu(self) -> pulumi.Output[Optional['outputs.ContainerCpu']]:
        """
        The CPU allocation
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disk(self) -> pulumi.Output[Optional['outputs.ContainerDisk']]:
        """
        The disks
        """
        return pulumi.get(self, "disk")

    @property
    @pulumi.getter
    def initialization(self) -> pulumi.Output[Optional['outputs.ContainerInitialization']]:
        """
        The initialization configuration
        """
        return pulumi.get(self, "initialization")

    @property
    @pulumi.getter
    def memory(self) -> pulumi.Output[Optional['outputs.ContainerMemory']]:
        """
        The memory allocation
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Output[Optional[Sequence['outputs.ContainerNetworkInterface']]]:
        """
        The network interfaces
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> pulumi.Output[str]:
        """
        The node name
        """
        return pulumi.get(self, "node_name")

    @property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> pulumi.Output[Optional['outputs.ContainerOperatingSystem']]:
        """
        The operating system configuration
        """
        return pulumi.get(self, "operating_system")

    @property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the pool to assign the container to
        """
        return pulumi.get(self, "pool_id")

    @property
    @pulumi.getter
    def started(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to start the container
        """
        return pulumi.get(self, "started")

    @property
    @pulumi.getter
    def template(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to create a template
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter(name="vmId")
    def vm_id(self) -> pulumi.Output[Optional[int]]:
        """
        The VM identifier
        """
        return pulumi.get(self, "vm_id")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

