# heatrapy

[![pypi](https://badge.fury.io/py/heatrapy.svg)](https://badge.fury.io/py/heatrapy)
[![Downloads](https://pepy.tech/badge/heatrapy)](https://pepy.tech/project/heatrapy)
[![License: MIT](https://img.shields.io/badge/License-MIT-blue.svg)](https://github.com/djsilva99/heatrapy/blob/master/LICENSE)
[![issue](https://img.shields.io/badge/issue_tracking-github-blue.svg)](https://github.com/djsilva99/heatrapy/issues)

<img src="https://github.com/danieljosesilva/heatrapy/blob/master/img/heatrapy.png" alt="Drawing" height="30"/> heatrapy v2.0.2

This package is a module for simulating dynamic 1D and 2D heat transfer processes by using the finite difference method. The packages is based on thermal objects. Two different approaches can be used: single thermal object and a system of thermal objects that can contact with each other. Heatrapy includes both the modeling of caloric effects and the incorporation of phase transitions.

For full documentation visit the <a href='https://djsilva99.github.io/heatrapy'>heatrapy website</a>.

author: Daniel Silva (djsilva@gmx.com) <br> current version: v2.0.2

![heatrapy-example](https://github.com/djsilva99/heatrapy/blob/master/img/example.gif)


### Installation

To install heatrapy use the pip package manager:

```bash
$ pip install heatrapy
```

To import the heatrapy module type in the python shell:

```python
>>> import heatrapy as htp
```


### Citing heatrapy

Please acknowledge heatrapy if it contributes to a project that leads to a publication by citing <a href='https://www.sciencedirect.com/science/article/pii/S2352711018301298'>this paper</a>.
