"use strict";
(self["webpackChunkipyflex"] = self["webpackChunkipyflex"] || []).push([["vendors-node_modules_flexlayout-react_lib_index_js-node_modules_flexlayout-react_lib_view_Layout_js"],{

/***/ "./node_modules/flexlayout-react/lib/Attribute.js":
/*!********************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/Attribute.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
/** @hidden @internal */
var Attribute = /** @class */ (function () {
    function Attribute(name, modelName, defaultValue, alwaysWriteJson) {
        this.name = name;
        this.modelName = modelName;
        this.defaultValue = defaultValue;
        this.alwaysWriteJson = alwaysWriteJson;
        this.required = false;
        this.fixed = false;
        this.type = "any";
    }
    Attribute.prototype.setType = function (value) {
        this.type = value;
        return this;
    };
    Attribute.prototype.setRequired = function () {
        this.required = true;
        return this;
    };
    Attribute.prototype.setFixed = function () {
        this.fixed = true;
        return this;
    };
    Attribute.NUMBER = "number";
    Attribute.STRING = "string";
    Attribute.BOOLEAN = "boolean";
    return Attribute;
}());
/** @hidden @internal */
exports["default"] = Attribute;
//# sourceMappingURL=Attribute.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/lib/AttributeDefinitions.js":
/*!*******************************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/AttributeDefinitions.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
var Attribute_1 = __webpack_require__(/*! ./Attribute */ "./node_modules/flexlayout-react/lib/Attribute.js");
/** @hidden @internal */
var AttributeDefinitions = /** @class */ (function () {
    function AttributeDefinitions() {
        this.attributes = [];
        this.nameToAttribute = {};
    }
    AttributeDefinitions.prototype.addWithAll = function (name, modelName, defaultValue, alwaysWriteJson) {
        var attr = new Attribute_1.default(name, modelName, defaultValue, alwaysWriteJson);
        this.attributes.push(attr);
        this.nameToAttribute[name] = attr;
        return attr;
    };
    AttributeDefinitions.prototype.addInherited = function (name, modelName) {
        return this.addWithAll(name, modelName, undefined, false);
    };
    AttributeDefinitions.prototype.add = function (name, defaultValue, alwaysWriteJson) {
        return this.addWithAll(name, undefined, defaultValue, alwaysWriteJson);
    };
    AttributeDefinitions.prototype.getAttributes = function () {
        return this.attributes;
    };
    AttributeDefinitions.prototype.getModelName = function (name) {
        var conversion = this.nameToAttribute[name];
        if (conversion !== undefined) {
            return conversion.modelName;
        }
        return undefined;
    };
    AttributeDefinitions.prototype.toJson = function (jsonObj, obj) {
        this.attributes.forEach(function (attr) {
            var fromValue = obj[attr.name];
            if (attr.alwaysWriteJson || fromValue !== attr.defaultValue) {
                jsonObj[attr.name] = fromValue;
            }
        });
    };
    AttributeDefinitions.prototype.fromJson = function (jsonObj, obj) {
        this.attributes.forEach(function (attr) {
            var fromValue = jsonObj[attr.name];
            if (fromValue === undefined) {
                obj[attr.name] = attr.defaultValue;
            }
            else {
                obj[attr.name] = fromValue;
            }
        });
    };
    AttributeDefinitions.prototype.update = function (jsonObj, obj) {
        this.attributes.forEach(function (attr) {
            var fromValue = jsonObj[attr.name];
            if (fromValue !== undefined) {
                obj[attr.name] = fromValue;
            }
        });
    };
    AttributeDefinitions.prototype.setDefaults = function (obj) {
        this.attributes.forEach(function (attr) {
            obj[attr.name] = attr.defaultValue;
        });
    };
    AttributeDefinitions.prototype.toTypescriptInterface = function (name, parentAttributes) {
        var lines = [];
        var sorted = this.attributes.sort(function (a, b) { return a.name.localeCompare(b.name); });
        // const sorted = this.attributes;
        lines.push("export interface I" + name + "Attributes {");
        for (var i = 0; i < sorted.length; i++) {
            var c = sorted[i];
            var type = c.type;
            var defaultValue = undefined;
            var attr = c;
            var inherited = undefined;
            if (attr.defaultValue !== undefined) {
                defaultValue = attr.defaultValue;
            }
            else if (attr.modelName !== undefined
                && parentAttributes !== undefined
                && parentAttributes.nameToAttribute[attr.modelName] !== undefined) {
                inherited = attr.modelName;
                attr = parentAttributes.nameToAttribute[attr.modelName];
                defaultValue = attr.defaultValue;
                type = attr.type;
            }
            var defValue = JSON.stringify(defaultValue);
            var required = attr.required || attr.fixed ? "" : "?";
            if (c.fixed) {
                lines.push("\t" + c.name + ": " + defValue + ";");
            }
            else {
                var comment = (defaultValue !== undefined ? "default: " + defValue : "") +
                    (inherited !== undefined ? " - inherited from global " + inherited : "");
                lines.push("\t" + c.name + required + ": " + type + ";" +
                    (comment.length > 0 ? " // " + comment : ""));
            }
        }
        lines.push("}");
        return lines.join("\n");
    };
    return AttributeDefinitions;
}());
/** @hidden @internal */
exports["default"] = AttributeDefinitions;
//# sourceMappingURL=AttributeDefinitions.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/lib/DockLocation.js":
/*!***********************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/DockLocation.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
var Orientation_1 = __webpack_require__(/*! ./Orientation */ "./node_modules/flexlayout-react/lib/Orientation.js");
var Rect_1 = __webpack_require__(/*! ./Rect */ "./node_modules/flexlayout-react/lib/Rect.js");
var DockLocation = /** @class */ (function () {
    /** @hidden @internal */
    function DockLocation(name, orientation, indexPlus) {
        this._name = name;
        this._orientation = orientation;
        this._indexPlus = indexPlus;
        DockLocation.values[this._name] = this;
    }
    /** @hidden @internal */
    DockLocation.getByName = function (name) {
        return DockLocation.values[name];
    };
    /** @hidden @internal */
    DockLocation.getLocation = function (rect, x, y) {
        x = (x - rect.x) / rect.width;
        y = (y - rect.y) / rect.height;
        if (x >= 0.25 && x < 0.75 && y >= 0.25 && y < 0.75) {
            return DockLocation.CENTER;
        }
        // Whether or not the point is in the bottom-left half of the rect
        // +-----+
        // |\    |
        // |x\   |
        // |xx\  |
        // |xxx\ |
        // |xxxx\|
        // +-----+
        var bl = y >= x;
        // Whether or not the point is in the bottom-right half of the rect
        // +-----+
        // |    /|
        // |   /x|
        // |  /xx|
        // | /xxx|
        // |/xxxx|
        // +-----+
        var br = y >= 1 - x;
        if (bl) {
            return br ? DockLocation.BOTTOM : DockLocation.LEFT;
        }
        else {
            return br ? DockLocation.RIGHT : DockLocation.TOP;
        }
    };
    DockLocation.prototype.getName = function () {
        return this._name;
    };
    DockLocation.prototype.getOrientation = function () {
        return this._orientation;
    };
    /** @hidden @internal */
    DockLocation.prototype.getDockRect = function (r) {
        if (this === DockLocation.TOP) {
            return new Rect_1.default(r.x, r.y, r.width, r.height / 2);
        }
        else if (this === DockLocation.BOTTOM) {
            return new Rect_1.default(r.x, r.getBottom() - r.height / 2, r.width, r.height / 2);
        }
        if (this === DockLocation.LEFT) {
            return new Rect_1.default(r.x, r.y, r.width / 2, r.height);
        }
        else if (this === DockLocation.RIGHT) {
            return new Rect_1.default(r.getRight() - r.width / 2, r.y, r.width / 2, r.height);
        }
        else {
            return r.clone();
        }
    };
    /** @hidden @internal */
    DockLocation.prototype.split = function (rect, size) {
        if (this === DockLocation.TOP) {
            var r1 = new Rect_1.default(rect.x, rect.y, rect.width, size);
            var r2 = new Rect_1.default(rect.x, rect.y + size, rect.width, rect.height - size);
            return { start: r1, end: r2 };
        }
        else if (this === DockLocation.LEFT) {
            var r1 = new Rect_1.default(rect.x, rect.y, size, rect.height);
            var r2 = new Rect_1.default(rect.x + size, rect.y, rect.width - size, rect.height);
            return { start: r1, end: r2 };
        }
        if (this === DockLocation.RIGHT) {
            var r1 = new Rect_1.default(rect.getRight() - size, rect.y, size, rect.height);
            var r2 = new Rect_1.default(rect.x, rect.y, rect.width - size, rect.height);
            return { start: r1, end: r2 };
        }
        else {
            // if (this === DockLocation.BOTTOM) {
            var r1 = new Rect_1.default(rect.x, rect.getBottom() - size, rect.width, size);
            var r2 = new Rect_1.default(rect.x, rect.y, rect.width, rect.height - size);
            return { start: r1, end: r2 };
        }
    };
    /** @hidden @internal */
    DockLocation.prototype.reflect = function () {
        if (this === DockLocation.TOP) {
            return DockLocation.BOTTOM;
        }
        else if (this === DockLocation.LEFT) {
            return DockLocation.RIGHT;
        }
        if (this === DockLocation.RIGHT) {
            return DockLocation.LEFT;
        }
        else {
            // if (this === DockLocation.BOTTOM) {
            return DockLocation.TOP;
        }
    };
    DockLocation.prototype.toString = function () {
        return "(DockLocation: name=" + this._name + ", orientation=" + this._orientation + ")";
    };
    DockLocation.values = {};
    DockLocation.TOP = new DockLocation("top", Orientation_1.default.VERT, 0);
    DockLocation.BOTTOM = new DockLocation("bottom", Orientation_1.default.VERT, 1);
    DockLocation.LEFT = new DockLocation("left", Orientation_1.default.HORZ, 0);
    DockLocation.RIGHT = new DockLocation("right", Orientation_1.default.HORZ, 1);
    DockLocation.CENTER = new DockLocation("center", Orientation_1.default.VERT, 0);
    return DockLocation;
}());
exports["default"] = DockLocation;
//# sourceMappingURL=DockLocation.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/lib/DragDrop.js":
/*!*******************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/DragDrop.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
var Rect_1 = __webpack_require__(/*! ./Rect */ "./node_modules/flexlayout-react/lib/Rect.js");
/** @hidden @internal */
var canUseDOM = !!(typeof window !== "undefined" && window.document && window.document.createElement);
var DragDrop = /** @class */ (function () {
    /** @hidden @internal */
    function DragDrop() {
        /** @hidden @internal */
        this._manualGlassManagement = false;
        /** @hidden @internal */
        this._startX = 0;
        /** @hidden @internal */
        this._startY = 0;
        /** @hidden @internal */
        this._dragDepth = 0;
        /** @hidden @internal */
        this._glassShowing = false;
        /** @hidden @internal */
        this._dragging = false;
        /** @hidden @internal */
        this._active = false; // drag and drop is in progress, can be used on ios to prevent body scrolling (see demo)
        if (canUseDOM) {
            // check for serverside rendering
            this._glass = document.createElement("div");
            this._glass.style.zIndex = "998";
            this._glass.style.backgroundColor = "transparent";
            this._glass.style.outline = "none";
        }
        this._defaultGlassCursor = "default";
        this._onMouseMove = this._onMouseMove.bind(this);
        this._onMouseUp = this._onMouseUp.bind(this);
        this._onKeyPress = this._onKeyPress.bind(this);
        this._onDragCancel = this._onDragCancel.bind(this);
        this._onDragEnter = this._onDragEnter.bind(this);
        this._onDragLeave = this._onDragLeave.bind(this);
        this.resizeGlass = this.resizeGlass.bind(this);
        this._lastClick = 0;
        this._clickX = 0;
        this._clickY = 0;
    }
    // if you add the glass pane then you should remove it
    DragDrop.prototype.addGlass = function (fCancel) {
        var _a;
        if (!this._glassShowing) {
            if (!this._document) {
                this._document = window.document;
            }
            if (!this._rootElement) {
                this._rootElement = this._document.body;
            }
            this.resizeGlass();
            (_a = this._document.defaultView) === null || _a === void 0 ? void 0 : _a.addEventListener('resize', this.resizeGlass);
            this._document.body.appendChild(this._glass);
            this._glass.tabIndex = -1;
            this._glass.focus();
            this._glass.addEventListener("keydown", this._onKeyPress);
            this._glass.addEventListener("dragenter", this._onDragEnter, { passive: false });
            this._glass.addEventListener("dragover", this._onMouseMove, { passive: false });
            this._glass.addEventListener("dragleave", this._onDragLeave, { passive: false });
            this._glassShowing = true;
            this._fDragCancel = fCancel;
            this._manualGlassManagement = false;
        }
        else {
            // second call to addGlass (via dragstart)
            this._manualGlassManagement = true;
        }
    };
    DragDrop.prototype.resizeGlass = function () {
        var glassRect = Rect_1.default.fromElement(this._rootElement);
        glassRect.positionElement(this._glass, "fixed");
    };
    DragDrop.prototype.hideGlass = function () {
        var _a;
        if (this._glassShowing) {
            this._document.body.removeChild(this._glass);
            (_a = this._document.defaultView) === null || _a === void 0 ? void 0 : _a.removeEventListener('resize', this.resizeGlass);
            this._glassShowing = false;
            this._document = undefined;
            this._rootElement = undefined;
            this.setGlassCursorOverride(undefined);
        }
    };
    /** @hidden @internal */
    DragDrop.prototype._updateGlassCursor = function () {
        var _a;
        this._glass.style.cursor = (_a = this._glassCursorOverride) !== null && _a !== void 0 ? _a : this._defaultGlassCursor;
    };
    /** @hidden @internal */
    DragDrop.prototype._setDefaultGlassCursor = function (cursor) {
        this._defaultGlassCursor = cursor;
        this._updateGlassCursor();
    };
    DragDrop.prototype.setGlassCursorOverride = function (cursor) {
        this._glassCursorOverride = cursor;
        this._updateGlassCursor();
    };
    DragDrop.prototype.startDrag = function (event, fDragStart, fDragMove, fDragEnd, fDragCancel, fClick, fDblClick, currentDocument, rootElement) {
        // prevent 'duplicate' action (mouse event for same action as previous touch event (a fix for ios))
        if (event && this._lastEvent && this._lastEvent.type.startsWith("touch") && event.type.startsWith("mouse") && event.timeStamp - this._lastEvent.timeStamp < 500) {
            return;
        }
        this._lastEvent = event;
        if (currentDocument) {
            this._document = currentDocument;
        }
        else {
            this._document = window.document;
        }
        if (rootElement) {
            this._rootElement = rootElement;
        }
        else {
            this._rootElement = this._document.body;
        }
        var posEvent = this._getLocationEvent(event);
        this.addGlass(fDragCancel);
        if (this._dragging) {
            console.warn("this._dragging true on startDrag should never happen");
        }
        if (event) {
            this._startX = posEvent.clientX;
            this._startY = posEvent.clientY;
            if (!window.matchMedia || window.matchMedia("(pointer: fine)").matches) {
                this._setDefaultGlassCursor(getComputedStyle(event.target).cursor);
            }
            this._stopPropagation(event);
            this._preventDefault(event);
        }
        else {
            this._startX = 0;
            this._startY = 0;
            this._setDefaultGlassCursor("default");
        }
        this._dragging = false;
        this._fDragStart = fDragStart;
        this._fDragMove = fDragMove;
        this._fDragEnd = fDragEnd;
        this._fDragCancel = fDragCancel;
        this._fClick = fClick;
        this._fDblClick = fDblClick;
        this._active = true;
        if ((event === null || event === void 0 ? void 0 : event.type) === 'dragenter') {
            this._dragDepth = 1;
            this._rootElement.addEventListener("dragenter", this._onDragEnter, { passive: false });
            this._rootElement.addEventListener("dragover", this._onMouseMove, { passive: false });
            this._rootElement.addEventListener("dragleave", this._onDragLeave, { passive: false });
            this._document.addEventListener("dragend", this._onDragCancel, { passive: false });
            this._document.addEventListener("drop", this._onMouseUp, { passive: false });
        }
        else {
            this._document.addEventListener("mouseup", this._onMouseUp, { passive: false });
            this._document.addEventListener("mousemove", this._onMouseMove, { passive: false });
            this._document.addEventListener("touchend", this._onMouseUp, { passive: false });
            this._document.addEventListener("touchmove", this._onMouseMove, { passive: false });
        }
    };
    DragDrop.prototype.isDragging = function () {
        return this._dragging;
    };
    DragDrop.prototype.isActive = function () {
        return this._active;
    };
    DragDrop.prototype.toString = function () {
        var rtn = "(DragDrop: " + "startX=" + this._startX + ", startY=" + this._startY + ", dragging=" + this._dragging + ")";
        return rtn;
    };
    /** @hidden @internal */
    DragDrop.prototype._onKeyPress = function (event) {
        if (event.keyCode === 27) {
            // esc
            this._onDragCancel();
        }
    };
    /** @hidden @internal */
    DragDrop.prototype._onDragCancel = function () {
        this._rootElement.removeEventListener("dragenter", this._onDragEnter);
        this._rootElement.removeEventListener("dragover", this._onMouseMove);
        this._rootElement.removeEventListener("dragleave", this._onDragLeave);
        this._document.removeEventListener("dragend", this._onDragCancel);
        this._document.removeEventListener("drop", this._onMouseUp);
        this._document.removeEventListener("mousemove", this._onMouseMove);
        this._document.removeEventListener("mouseup", this._onMouseUp);
        this._document.removeEventListener("touchend", this._onMouseUp);
        this._document.removeEventListener("touchmove", this._onMouseMove);
        this.hideGlass();
        if (this._fDragCancel !== undefined) {
            this._fDragCancel(this._dragging);
        }
        this._dragging = false;
        this._active = false;
    };
    /** @hidden @internal */
    DragDrop.prototype._getLocationEvent = function (event) {
        var posEvent = event;
        if (event && event.touches) {
            posEvent = event.touches[0];
        }
        return posEvent;
    };
    /** @hidden @internal */
    DragDrop.prototype._getLocationEventEnd = function (event) {
        var posEvent = event;
        if (event.changedTouches) {
            posEvent = event.changedTouches[0];
        }
        return posEvent;
    };
    /** @hidden @internal */
    DragDrop.prototype._stopPropagation = function (event) {
        if (event.stopPropagation) {
            event.stopPropagation();
        }
    };
    /** @hidden @internal */
    DragDrop.prototype._preventDefault = function (event) {
        if (event.preventDefault && event.cancelable) {
            event.preventDefault();
        }
        return event;
    };
    /** @hidden @internal */
    DragDrop.prototype._onMouseMove = function (event) {
        this._lastEvent = event;
        var posEvent = this._getLocationEvent(event);
        this._stopPropagation(event);
        this._preventDefault(event);
        if (!this._dragging && (Math.abs(this._startX - posEvent.clientX) > 5 || Math.abs(this._startY - posEvent.clientY) > 5)) {
            this._dragging = true;
            if (this._fDragStart) {
                this._setDefaultGlassCursor("move");
                this._dragging = this._fDragStart({ clientX: this._startX, clientY: this._startY });
            }
        }
        if (this._dragging) {
            if (this._fDragMove) {
                this._fDragMove(posEvent);
            }
        }
        return false;
    };
    /** @hidden @internal */
    DragDrop.prototype._onMouseUp = function (event) {
        this._lastEvent = event;
        var posEvent = this._getLocationEventEnd(event);
        this._stopPropagation(event);
        this._preventDefault(event);
        this._active = false;
        this._rootElement.removeEventListener("dragenter", this._onDragEnter);
        this._rootElement.removeEventListener("dragover", this._onMouseMove);
        this._rootElement.removeEventListener("dragleave", this._onDragLeave);
        this._document.removeEventListener("dragend", this._onDragCancel);
        this._document.removeEventListener("drop", this._onMouseUp);
        this._document.removeEventListener("mousemove", this._onMouseMove);
        this._document.removeEventListener("mouseup", this._onMouseUp);
        this._document.removeEventListener("touchend", this._onMouseUp);
        this._document.removeEventListener("touchmove", this._onMouseMove);
        if (!this._manualGlassManagement) {
            this.hideGlass();
        }
        if (this._dragging) {
            this._dragging = false;
            if (this._fDragEnd) {
                this._fDragEnd(event);
            }
            // dump("set dragging = false\n");
        }
        else {
            if (this._fDragCancel) {
                this._fDragCancel(this._dragging);
            }
            if (Math.abs(this._startX - posEvent.clientX) <= 5 && Math.abs(this._startY - posEvent.clientY) <= 5) {
                var clickTime = new Date().getTime();
                // check for double click
                if (Math.abs(this._clickX - posEvent.clientX) <= 5 && Math.abs(this._clickY - posEvent.clientY) <= 5) {
                    if (clickTime - this._lastClick < 500) {
                        if (this._fDblClick) {
                            this._fDblClick(event);
                        }
                    }
                }
                if (this._fClick) {
                    this._fClick(event);
                }
                this._lastClick = clickTime;
                this._clickX = posEvent.clientX;
                this._clickY = posEvent.clientY;
            }
        }
        return false;
    };
    /** @hidden @internal */
    DragDrop.prototype._onDragEnter = function (event) {
        this._preventDefault(event);
        this._stopPropagation(event);
        this._dragDepth++;
        return false;
    };
    /** @hidden @internal */
    DragDrop.prototype._onDragLeave = function (event) {
        this._preventDefault(event);
        this._stopPropagation(event);
        this._dragDepth--;
        if (this._dragDepth <= 0) {
            this._onDragCancel();
        }
        return false;
    };
    DragDrop.instance = new DragDrop();
    return DragDrop;
}());
exports["default"] = DragDrop;
//# sourceMappingURL=DragDrop.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/lib/DropInfo.js":
/*!*******************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/DropInfo.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
var DropInfo = /** @class */ (function () {
    function DropInfo(node, rect, location, index, className) {
        this.node = node;
        this.rect = rect;
        this.location = location;
        this.index = index;
        this.className = className;
    }
    return DropInfo;
}());
exports["default"] = DropInfo;
//# sourceMappingURL=DropInfo.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/lib/I18nLabel.js":
/*!********************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/I18nLabel.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.I18nLabel = void 0;
var I18nLabel;
(function (I18nLabel) {
    I18nLabel["Close_Tab"] = "Close";
    I18nLabel["Close_Tabset"] = "Close tabset";
    I18nLabel["Move_Tab"] = "Move: ";
    I18nLabel["Move_Tabset"] = "Move tabset";
    I18nLabel["Maximize"] = "Maximize tabset";
    I18nLabel["Restore"] = "Restore tabset";
    I18nLabel["Float_Tab"] = "Show selected tab in floating window";
    I18nLabel["Overflow_Menu_Tooltip"] = "Hidden tabs";
    I18nLabel["Floating_Window_Message"] = "This panel is shown in a floating window";
    I18nLabel["Floating_Window_Show_Window"] = "Show window";
    I18nLabel["Floating_Window_Dock_Window"] = "Dock window";
    I18nLabel["Error_rendering_component"] = "Error rendering component";
})(I18nLabel = exports.I18nLabel || (exports.I18nLabel = {}));
//# sourceMappingURL=I18nLabel.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/lib/Orientation.js":
/*!**********************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/Orientation.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
var Orientation = /** @class */ (function () {
    /** @hidden @internal */
    function Orientation(name) {
        this._name = name;
    }
    Orientation.flip = function (from) {
        if (from === Orientation.HORZ) {
            return Orientation.VERT;
        }
        else {
            return Orientation.HORZ;
        }
    };
    Orientation.prototype.getName = function () {
        return this._name;
    };
    Orientation.prototype.toString = function () {
        return this._name;
    };
    Orientation.HORZ = new Orientation("horz");
    Orientation.VERT = new Orientation("vert");
    return Orientation;
}());
exports["default"] = Orientation;
//# sourceMappingURL=Orientation.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/lib/PopupMenu.js":
/*!********************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/PopupMenu.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.showPopup = void 0;
var React = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
var ReactDOM = __webpack_require__(/*! react-dom */ "webpack/sharing/consume/default/react-dom");
/** @hidden @internal */
function showPopup(layoutDiv, triggerElement, items, onSelect, classNameMapper) {
    var currentDocument = triggerElement.ownerDocument;
    var triggerRect = triggerElement.getBoundingClientRect();
    var layoutRect = layoutDiv.getBoundingClientRect();
    var elm = currentDocument.createElement("div");
    elm.className = classNameMapper("flexlayout__popup_menu_container");
    if (triggerRect.left < layoutRect.left + layoutRect.width / 2) {
        elm.style.left = triggerRect.left - layoutRect.left + "px";
    }
    else {
        elm.style.right = layoutRect.right - triggerRect.right + "px";
    }
    if (triggerRect.top < layoutRect.top + layoutRect.height / 2) {
        elm.style.top = triggerRect.top - layoutRect.top + "px";
    }
    else {
        elm.style.bottom = layoutRect.bottom - triggerRect.bottom + "px";
    }
    layoutDiv.appendChild(elm);
    var onHide = function () {
        layoutDiv.removeChild(elm);
        ReactDOM.unmountComponentAtNode(elm);
        elm.removeEventListener("mouseup", onElementMouseUp);
        currentDocument.removeEventListener("mouseup", onDocMouseUp);
    };
    var onElementMouseUp = function (event) {
        event.stopPropagation();
    };
    var onDocMouseUp = function (event) {
        onHide();
    };
    elm.addEventListener("mouseup", onElementMouseUp);
    currentDocument.addEventListener("mouseup", onDocMouseUp);
    ReactDOM.render(React.createElement(PopupMenu, { currentDocument: currentDocument, onSelect: onSelect, onHide: onHide, items: items, classNameMapper: classNameMapper }), elm);
}
exports.showPopup = showPopup;
/** @hidden @internal */
var PopupMenu = function (props) {
    var items = props.items, onHide = props.onHide, onSelect = props.onSelect, classNameMapper = props.classNameMapper;
    var onItemClick = function (item, event) {
        onSelect(item);
        onHide();
        event.stopPropagation();
    };
    var itemElements = items.map(function (item) { return (React.createElement("div", { key: item.index, className: classNameMapper("flexlayout__popup_menu_item"), onClick: function (event) { return onItemClick(item, event); }, title: item.node.getHelpText() }, item.node._getRenderedName())); });
    return React.createElement("div", { className: classNameMapper("flexlayout__popup_menu") }, itemElements);
};
//# sourceMappingURL=PopupMenu.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/lib/Rect.js":
/*!***************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/Rect.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
var Orientation_1 = __webpack_require__(/*! ./Orientation */ "./node_modules/flexlayout-react/lib/Orientation.js");
var Rect = /** @class */ (function () {
    function Rect(x, y, width, height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }
    Rect.empty = function () {
        return new Rect(0, 0, 0, 0);
    };
    Rect.fromElement = function (element) {
        var _a = element.getBoundingClientRect(), x = _a.x, y = _a.y, width = _a.width, height = _a.height;
        return new Rect(x, y, width, height);
    };
    Rect.prototype.clone = function () {
        return new Rect(this.x, this.y, this.width, this.height);
    };
    Rect.prototype.equals = function (rect) {
        if (this.x === rect.x && this.y === rect.y && this.width === rect.width && this.height === rect.height) {
            return true;
        }
        else {
            return false;
        }
    };
    Rect.prototype.getBottom = function () {
        return this.y + this.height;
    };
    Rect.prototype.getRight = function () {
        return this.x + this.width;
    };
    Rect.prototype.positionElement = function (element, position) {
        this.styleWithPosition(element.style, position);
    };
    Rect.prototype.styleWithPosition = function (style, position) {
        if (position === void 0) { position = "absolute"; }
        style.left = this.x + "px";
        style.top = this.y + "px";
        style.width = Math.max(0, this.width) + "px"; // need Math.max to prevent -ve, cause error in IE
        style.height = Math.max(0, this.height) + "px";
        style.position = position;
        return style;
    };
    Rect.prototype.contains = function (x, y) {
        if (this.x <= x && x <= this.getRight() && this.y <= y && y <= this.getBottom()) {
            return true;
        }
        else {
            return false;
        }
    };
    Rect.prototype.removeInsets = function (insets) {
        return new Rect(this.x + insets.left, this.y + insets.top, Math.max(0, this.width - insets.left - insets.right), Math.max(0, this.height - insets.top - insets.bottom));
    };
    Rect.prototype.centerInRect = function (outerRect) {
        this.x = (outerRect.width - this.width) / 2;
        this.y = (outerRect.height - this.height) / 2;
    };
    /** @hidden @internal */
    Rect.prototype._getSize = function (orientation) {
        var prefSize = this.width;
        if (orientation === Orientation_1.default.VERT) {
            prefSize = this.height;
        }
        return prefSize;
    };
    Rect.prototype.toString = function () {
        return "(Rect: x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + ")";
    };
    return Rect;
}());
exports["default"] = Rect;
//# sourceMappingURL=Rect.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/lib/Types.js":
/*!****************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/Types.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CLASSES = void 0;
var CLASSES;
(function (CLASSES) {
    CLASSES["FLEXLAYOUT__BORDER"] = "flexlayout__border";
    CLASSES["FLEXLAYOUT__BORDER_"] = "flexlayout__border_";
    CLASSES["FLEXLAYOUT__BORDER_BUTTON"] = "flexlayout__border_button";
    CLASSES["FLEXLAYOUT__BORDER_BUTTON_"] = "flexlayout__border_button_";
    CLASSES["FLEXLAYOUT__BORDER_BUTTON_CONTENT"] = "flexlayout__border_button_content";
    CLASSES["FLEXLAYOUT__BORDER_BUTTON_LEADING"] = "flexlayout__border_button_leading";
    CLASSES["FLEXLAYOUT__BORDER_BUTTON_TRAILING"] = "flexlayout__border_button_trailing";
    CLASSES["FLEXLAYOUT__BORDER_BUTTON__SELECTED"] = "flexlayout__border_button--selected";
    CLASSES["FLEXLAYOUT__BORDER_BUTTON__UNSELECTED"] = "flexlayout__border_button--unselected";
    CLASSES["FLEXLAYOUT__BORDER_INNER"] = "flexlayout__border_inner";
    CLASSES["FLEXLAYOUT__BORDER_INNER_"] = "flexlayout__border_inner_";
    CLASSES["FLEXLAYOUT__BORDER_INNER_TAB_CONTAINER"] = "flexlayout__border_inner_tab_container";
    CLASSES["FLEXLAYOUT__BORDER_INNER_TAB_CONTAINER_"] = "flexlayout__border_inner_tab_container_";
    CLASSES["FLEXLAYOUT__BORDER_SIZER"] = "flexlayout__border_sizer";
    CLASSES["FLEXLAYOUT__BORDER_TOOLBAR"] = "flexlayout__border_toolbar";
    CLASSES["FLEXLAYOUT__BORDER_TOOLBAR_"] = "flexlayout__border_toolbar_";
    CLASSES["FLEXLAYOUT__BORDER_TOOLBAR_BUTTON"] = "flexlayout__border_toolbar_button";
    CLASSES["FLEXLAYOUT__BORDER_TOOLBAR_BUTTON_FLOAT"] = "flexlayout__border_toolbar_button-float";
    CLASSES["FLEXLAYOUT__DRAG_RECT"] = "flexlayout__drag_rect";
    CLASSES["FLEXLAYOUT__EDGE_RECT"] = "flexlayout__edge_rect";
    CLASSES["FLEXLAYOUT__ERROR_BOUNDARY_CONTAINER"] = "flexlayout__error_boundary_container";
    CLASSES["FLEXLAYOUT__ERROR_BOUNDARY_CONTENT"] = "flexlayout__error_boundary_content";
    CLASSES["FLEXLAYOUT__FLOATING_WINDOW_CONTENT"] = "flexlayout__floating_window_content";
    CLASSES["FLEXLAYOUT__FLOATING_WINDOW_TAB"] = "flexlayout__floating_window_tab";
    CLASSES["FLEXLAYOUT__LAYOUT"] = "flexlayout__layout";
    CLASSES["FLEXLAYOUT__OUTLINE_RECT"] = "flexlayout__outline_rect";
    CLASSES["FLEXLAYOUT__SPLITTER"] = "flexlayout__splitter";
    CLASSES["FLEXLAYOUT__SPLITTER_EXTRA"] = "flexlayout__splitter_extra";
    CLASSES["FLEXLAYOUT__SPLITTER_"] = "flexlayout__splitter_";
    CLASSES["FLEXLAYOUT__SPLITTER_BORDER"] = "flexlayout__splitter_border";
    CLASSES["FLEXLAYOUT__SPLITTER_DRAG"] = "flexlayout__splitter_drag";
    CLASSES["FLEXLAYOUT__TAB"] = "flexlayout__tab";
    CLASSES["FLEXLAYOUT__TABSET"] = "flexlayout__tabset";
    CLASSES["FLEXLAYOUT__TABSET_HEADER"] = "flexlayout__tabset_header";
    CLASSES["FLEXLAYOUT__TABSET_HEADER_SIZER"] = "flexlayout__tabset_header_sizer";
    CLASSES["FLEXLAYOUT__TABSET_HEADER_CONTENT"] = "flexlayout__tabset_header_content";
    CLASSES["FLEXLAYOUT__TABSET_MAXIMIZED"] = "flexlayout__tabset-maximized";
    CLASSES["FLEXLAYOUT__TABSET_SELECTED"] = "flexlayout__tabset-selected";
    CLASSES["FLEXLAYOUT__TABSET_SIZER"] = "flexlayout__tabset_sizer";
    CLASSES["FLEXLAYOUT__TABSET_TABBAR_INNER"] = "flexlayout__tabset_tabbar_inner";
    CLASSES["FLEXLAYOUT__TABSET_TABBAR_INNER_"] = "flexlayout__tabset_tabbar_inner_";
    CLASSES["FLEXLAYOUT__TABSET_TABBAR_INNER_TAB_CONTAINER"] = "flexlayout__tabset_tabbar_inner_tab_container";
    CLASSES["FLEXLAYOUT__TABSET_TABBAR_INNER_TAB_CONTAINER_"] = "flexlayout__tabset_tabbar_inner_tab_container_";
    CLASSES["FLEXLAYOUT__TABSET_TABBAR_OUTER"] = "flexlayout__tabset_tabbar_outer";
    CLASSES["FLEXLAYOUT__TABSET_TABBAR_OUTER_"] = "flexlayout__tabset_tabbar_outer_";
    CLASSES["FLEXLAYOUT__TAB_BORDER"] = "flexlayout__tab_border";
    CLASSES["FLEXLAYOUT__TAB_BORDER_"] = "flexlayout__tab_border_";
    CLASSES["FLEXLAYOUT__TAB_BUTTON"] = "flexlayout__tab_button";
    CLASSES["FLEXLAYOUT__TAB_BUTTON_CONTENT"] = "flexlayout__tab_button_content";
    CLASSES["FLEXLAYOUT__TAB_BUTTON_LEADING"] = "flexlayout__tab_button_leading";
    CLASSES["FLEXLAYOUT__TAB_BUTTON_OVERFLOW"] = "flexlayout__tab_button_overflow";
    CLASSES["FLEXLAYOUT__TAB_BUTTON_TEXTBOX"] = "flexlayout__tab_button_textbox";
    CLASSES["FLEXLAYOUT__TAB_BUTTON_TRAILING"] = "flexlayout__tab_button_trailing";
    CLASSES["FLEXLAYOUT__TAB_FLOATING"] = "flexlayout__tab_floating";
    CLASSES["FLEXLAYOUT__TAB_FLOATING_INNER"] = "flexlayout__tab_floating_inner";
    CLASSES["FLEXLAYOUT__TAB_TOOLBAR"] = "flexlayout__tab_toolbar";
    CLASSES["FLEXLAYOUT__TAB_TOOLBAR_BUTTON"] = "flexlayout__tab_toolbar_button";
    CLASSES["FLEXLAYOUT__TAB_TOOLBAR_BUTTON_"] = "flexlayout__tab_toolbar_button-";
    CLASSES["FLEXLAYOUT__TAB_TOOLBAR_BUTTON_FLOAT"] = "flexlayout__tab_toolbar_button-float";
    CLASSES["FLEXLAYOUT__TAB_TOOLBAR_STICKY_BUTTONS_CONTAINER"] = "flexlayout__tab_toolbar_sticky_buttons_container";
    CLASSES["FLEXLAYOUT__TAB_TOOLBAR_BUTTON_CLOSE"] = "flexlayout__tab_toolbar_button-close";
})(CLASSES = exports.CLASSES || (exports.CLASSES = {}));
//# sourceMappingURL=Types.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/lib/index.js":
/*!****************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/index.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Rect = exports.DropInfo = exports.DragDrop = exports.Orientation = exports.DockLocation = exports.BorderSet = exports.BorderNode = exports.TabSetNode = exports.TabNode = exports.SplitterNode = exports.RowNode = exports.Node = exports.Model = exports.Action = exports.Actions = exports.I18nLabel = exports.Layout = void 0;
var DockLocation_1 = __webpack_require__(/*! ./DockLocation */ "./node_modules/flexlayout-react/lib/DockLocation.js");
exports.DockLocation = DockLocation_1.default;
var DragDrop_1 = __webpack_require__(/*! ./DragDrop */ "./node_modules/flexlayout-react/lib/DragDrop.js");
exports.DragDrop = DragDrop_1.default;
var DropInfo_1 = __webpack_require__(/*! ./DropInfo */ "./node_modules/flexlayout-react/lib/DropInfo.js");
exports.DropInfo = DropInfo_1.default;
var I18nLabel_1 = __webpack_require__(/*! ./I18nLabel */ "./node_modules/flexlayout-react/lib/I18nLabel.js");
Object.defineProperty(exports, "I18nLabel", ({ enumerable: true, get: function () { return I18nLabel_1.I18nLabel; } }));
var Action_1 = __webpack_require__(/*! ./model/Action */ "./node_modules/flexlayout-react/lib/model/Action.js");
exports.Action = Action_1.default;
var Actions_1 = __webpack_require__(/*! ./model/Actions */ "./node_modules/flexlayout-react/lib/model/Actions.js");
exports.Actions = Actions_1.default;
var BorderNode_1 = __webpack_require__(/*! ./model/BorderNode */ "./node_modules/flexlayout-react/lib/model/BorderNode.js");
exports.BorderNode = BorderNode_1.default;
var BorderSet_1 = __webpack_require__(/*! ./model/BorderSet */ "./node_modules/flexlayout-react/lib/model/BorderSet.js");
exports.BorderSet = BorderSet_1.default;
var Model_1 = __webpack_require__(/*! ./model/Model */ "./node_modules/flexlayout-react/lib/model/Model.js");
exports.Model = Model_1.default;
var Node_1 = __webpack_require__(/*! ./model/Node */ "./node_modules/flexlayout-react/lib/model/Node.js");
exports.Node = Node_1.default;
var RowNode_1 = __webpack_require__(/*! ./model/RowNode */ "./node_modules/flexlayout-react/lib/model/RowNode.js");
exports.RowNode = RowNode_1.default;
var SplitterNode_1 = __webpack_require__(/*! ./model/SplitterNode */ "./node_modules/flexlayout-react/lib/model/SplitterNode.js");
exports.SplitterNode = SplitterNode_1.default;
var TabNode_1 = __webpack_require__(/*! ./model/TabNode */ "./node_modules/flexlayout-react/lib/model/TabNode.js");
exports.TabNode = TabNode_1.default;
var TabSetNode_1 = __webpack_require__(/*! ./model/TabSetNode */ "./node_modules/flexlayout-react/lib/model/TabSetNode.js");
exports.TabSetNode = TabSetNode_1.default;
var Orientation_1 = __webpack_require__(/*! ./Orientation */ "./node_modules/flexlayout-react/lib/Orientation.js");
exports.Orientation = Orientation_1.default;
var Rect_1 = __webpack_require__(/*! ./Rect */ "./node_modules/flexlayout-react/lib/Rect.js");
exports.Rect = Rect_1.default;
var Layout_1 = __webpack_require__(/*! ./view/Layout */ "./node_modules/flexlayout-react/lib/view/Layout.js");
exports.Layout = Layout_1.default;
exports["default"] = {
    Layout: Layout_1.default,
    I18nLabel: I18nLabel_1.I18nLabel,
    Actions: Actions_1.default,
    Action: Action_1.default,
    Model: Model_1.default,
    Node: Node_1.default,
    RowNode: RowNode_1.default,
    SplitterNode: SplitterNode_1.default,
    TabNode: TabNode_1.default,
    TabSetNode: TabSetNode_1.default,
    BorderNode: BorderNode_1.default,
    BorderSet: BorderSet_1.default,
    DockLocation: DockLocation_1.default,
    Orientation: Orientation_1.default,
    DragDrop: DragDrop_1.default,
    DropInfo: DropInfo_1.default,
    Rect: Rect_1.default,
};
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/lib/model/Action.js":
/*!***********************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/model/Action.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
var Action = /** @class */ (function () {
    function Action(type, data) {
        this.type = type;
        this.data = data;
    }
    return Action;
}());
exports["default"] = Action;
//# sourceMappingURL=Action.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/lib/model/Actions.js":
/*!************************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/model/Actions.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
var Action_1 = __webpack_require__(/*! ./Action */ "./node_modules/flexlayout-react/lib/model/Action.js");
/**
 * The Action creator class for FlexLayout model actions
 */
var Actions = /** @class */ (function () {
    function Actions() {
    }
    /**
     * Adds a tab node to the given tabset node
     * @param json the json for the new tab node e.g {type:"tab", component:"table"}
     * @param toNodeId the new tab node will be added to the tabset with this node id
     * @param location the location where the new tab will be added, one of the DockLocation enum values.
     * @param index for docking to the center this value is the index of the tab, use -1 to add to the end.
     * @param select (optional) whether to select the new tab, overriding autoSelectTab
     * @returns {Action} the action
     */
    Actions.addNode = function (json, toNodeId, location, index, select) {
        return new Action_1.default(Actions.ADD_NODE, {
            json: json,
            toNode: toNodeId,
            location: location.getName(),
            index: index,
            select: select,
        });
    };
    /**
     * Moves a node (tab or tabset) from one location to another
     * @param fromNodeId the id of the node to move
     * @param toNodeId the id of the node to receive the moved node
     * @param location the location where the moved node will be added, one of the DockLocation enum values.
     * @param index for docking to the center this value is the index of the tab, use -1 to add to the end.
     * @param select (optional) whether to select the moved tab(s) in new tabset, overriding autoSelectTab
     * @returns {Action} the action
     */
    Actions.moveNode = function (fromNodeId, toNodeId, location, index, select) {
        return new Action_1.default(Actions.MOVE_NODE, {
            fromNode: fromNodeId,
            toNode: toNodeId,
            location: location.getName(),
            index: index,
            select: select,
        });
    };
    /**
     * Deletes a tab node from the layout
     * @param tabsetNodeId the id of the tab node to delete
     * @returns {Action} the action
     */
    Actions.deleteTab = function (tabNodeId) {
        return new Action_1.default(Actions.DELETE_TAB, { node: tabNodeId });
    };
    /**
     * Deletes a tabset node and all it's child tab nodes from the layout
     * @param tabsetNodeId the id of the tabset node to delete
     * @returns {Action} the action
     */
    Actions.deleteTabset = function (tabsetNodeId) {
        return new Action_1.default(Actions.DELETE_TABSET, { node: tabsetNodeId });
    };
    /**
     * Change the given nodes tab text
     * @param tabNodeId the id of the node to rename
     * @param text the test of the tab
     * @returns {Action} the action
     */
    Actions.renameTab = function (tabNodeId, text) {
        return new Action_1.default(Actions.RENAME_TAB, { node: tabNodeId, text: text });
    };
    /**
     * Selects the given tab in its parent tabset
     * @param tabNodeId the id of the node to set selected
     * @returns {Action} the action
     */
    Actions.selectTab = function (tabNodeId) {
        return new Action_1.default(Actions.SELECT_TAB, { tabNode: tabNodeId });
    };
    /**
     * Set the given tabset node as the active tabset
     * @param tabsetNodeId the id of the tabset node to set as active
     * @returns {Action} the action
     */
    Actions.setActiveTabset = function (tabsetNodeId) {
        return new Action_1.default(Actions.SET_ACTIVE_TABSET, { tabsetNode: tabsetNodeId });
    };
    /**
     * Adjust the splitter between two tabsets
     * @example
     *  Actions.adjustSplit({node1: "1", weight1:30, pixelWidth1:300, node2: "2", weight2:70, pixelWidth2:700});
     *
     * @param splitSpec an object the defines the new split between two tabsets, see example below.
     * @returns {Action} the action
     */
    Actions.adjustSplit = function (splitSpec) {
        var node1 = splitSpec.node1Id;
        var node2 = splitSpec.node2Id;
        return new Action_1.default(Actions.ADJUST_SPLIT, {
            node1: node1,
            weight1: splitSpec.weight1,
            pixelWidth1: splitSpec.pixelWidth1,
            node2: node2,
            weight2: splitSpec.weight2,
            pixelWidth2: splitSpec.pixelWidth2,
        });
    };
    Actions.adjustBorderSplit = function (nodeId, pos) {
        return new Action_1.default(Actions.ADJUST_BORDER_SPLIT, { node: nodeId, pos: pos });
    };
    /**
     * Maximizes the given tabset
     * @param tabsetNodeId the id of the tabset to maximize
     * @returns {Action} the action
     */
    Actions.maximizeToggle = function (tabsetNodeId) {
        return new Action_1.default(Actions.MAXIMIZE_TOGGLE, { node: tabsetNodeId });
    };
    /**
     * Updates the global model jsone attributes
     * @param attributes the json for the model attributes to update (merge into the existing attributes)
     * @returns {Action} the action
     */
    Actions.updateModelAttributes = function (attributes) {
        return new Action_1.default(Actions.UPDATE_MODEL_ATTRIBUTES, { json: attributes });
    };
    /**
     * Updates the given nodes json attributes
     * @param nodeId the id of the node to update
     * @param attributes the json attributes to update (merge with the existing attributes)
     * @returns {Action} the action
     */
    Actions.updateNodeAttributes = function (nodeId, attributes) {
        return new Action_1.default(Actions.UPDATE_NODE_ATTRIBUTES, { node: nodeId, json: attributes });
    };
    Actions.floatTab = function (nodeId) {
        return new Action_1.default(Actions.FLOAT_TAB, { node: nodeId });
    };
    Actions.unFloatTab = function (nodeId) {
        return new Action_1.default(Actions.UNFLOAT_TAB, { node: nodeId });
    };
    Actions.ADD_NODE = "FlexLayout_AddNode";
    Actions.MOVE_NODE = "FlexLayout_MoveNode";
    Actions.DELETE_TAB = "FlexLayout_DeleteTab";
    Actions.DELETE_TABSET = "FlexLayout_DeleteTabset";
    Actions.RENAME_TAB = "FlexLayout_RenameTab";
    Actions.SELECT_TAB = "FlexLayout_SelectTab";
    Actions.SET_ACTIVE_TABSET = "FlexLayout_SetActiveTabset";
    Actions.ADJUST_SPLIT = "FlexLayout_AdjustSplit";
    Actions.ADJUST_BORDER_SPLIT = "FlexLayout_AdjustBorderSplit";
    Actions.MAXIMIZE_TOGGLE = "FlexLayout_MaximizeToggle";
    Actions.UPDATE_MODEL_ATTRIBUTES = "FlexLayout_UpdateModelAttributes";
    Actions.UPDATE_NODE_ATTRIBUTES = "FlexLayout_UpdateNodeAttributes";
    Actions.FLOAT_TAB = "FlexLayout_FloatTab";
    Actions.UNFLOAT_TAB = "FlexLayout_UnFloatTab";
    return Actions;
}());
exports["default"] = Actions;
//# sourceMappingURL=Actions.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/lib/model/BorderNode.js":
/*!***************************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/model/BorderNode.js ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
var Attribute_1 = __webpack_require__(/*! ../Attribute */ "./node_modules/flexlayout-react/lib/Attribute.js");
var AttributeDefinitions_1 = __webpack_require__(/*! ../AttributeDefinitions */ "./node_modules/flexlayout-react/lib/AttributeDefinitions.js");
var DockLocation_1 = __webpack_require__(/*! ../DockLocation */ "./node_modules/flexlayout-react/lib/DockLocation.js");
var DropInfo_1 = __webpack_require__(/*! ../DropInfo */ "./node_modules/flexlayout-react/lib/DropInfo.js");
var Orientation_1 = __webpack_require__(/*! ../Orientation */ "./node_modules/flexlayout-react/lib/Orientation.js");
var Rect_1 = __webpack_require__(/*! ../Rect */ "./node_modules/flexlayout-react/lib/Rect.js");
var Node_1 = __webpack_require__(/*! ./Node */ "./node_modules/flexlayout-react/lib/model/Node.js");
var SplitterNode_1 = __webpack_require__(/*! ./SplitterNode */ "./node_modules/flexlayout-react/lib/model/SplitterNode.js");
var TabNode_1 = __webpack_require__(/*! ./TabNode */ "./node_modules/flexlayout-react/lib/model/TabNode.js");
var Utils_1 = __webpack_require__(/*! ./Utils */ "./node_modules/flexlayout-react/lib/model/Utils.js");
var BorderNode = /** @class */ (function (_super) {
    __extends(BorderNode, _super);
    /** @hidden @internal */
    function BorderNode(location, json, model) {
        var _this = _super.call(this, model) || this;
        /** @hidden @internal */
        _this._adjustedSize = 0;
        /** @hidden @internal */
        _this._calculatedBorderBarSize = 0;
        _this._location = location;
        _this._drawChildren = [];
        _this._attributes.id = "border_" + location.getName();
        BorderNode._attributeDefinitions.fromJson(json, _this._attributes);
        model._addNode(_this);
        return _this;
    }
    /** @hidden @internal */
    BorderNode._fromJson = function (json, model) {
        var location = DockLocation_1.default.getByName(json.location);
        var border = new BorderNode(location, json, model);
        if (json.children) {
            border._children = json.children.map(function (jsonChild) {
                var child = TabNode_1.default._fromJson(jsonChild, model);
                child._setParent(border);
                return child;
            });
        }
        return border;
    };
    /** @hidden @internal */
    BorderNode._createAttributeDefinitions = function () {
        var attributeDefinitions = new AttributeDefinitions_1.default();
        attributeDefinitions.add("type", BorderNode.TYPE, true).setType(Attribute_1.default.STRING).setFixed();
        attributeDefinitions.add("selected", -1).setType(Attribute_1.default.NUMBER);
        attributeDefinitions.add("show", true).setType(Attribute_1.default.BOOLEAN);
        attributeDefinitions.add("config", undefined).setType("any");
        attributeDefinitions.addInherited("barSize", "borderBarSize").setType(Attribute_1.default.NUMBER);
        attributeDefinitions.addInherited("enableDrop", "borderEnableDrop").setType(Attribute_1.default.BOOLEAN);
        attributeDefinitions.addInherited("className", "borderClassName").setType(Attribute_1.default.STRING);
        attributeDefinitions.addInherited("autoSelectTabWhenOpen", "borderAutoSelectTabWhenOpen").setType(Attribute_1.default.BOOLEAN);
        attributeDefinitions.addInherited("autoSelectTabWhenClosed", "borderAutoSelectTabWhenClosed").setType(Attribute_1.default.BOOLEAN);
        attributeDefinitions.addInherited("size", "borderSize").setType(Attribute_1.default.NUMBER);
        attributeDefinitions.addInherited("minSize", "borderMinSize").setType(Attribute_1.default.NUMBER);
        return attributeDefinitions;
    };
    BorderNode.prototype.getLocation = function () {
        return this._location;
    };
    BorderNode.prototype.getTabHeaderRect = function () {
        return this._tabHeaderRect;
    };
    BorderNode.prototype.getRect = function () {
        return this._tabHeaderRect;
    };
    BorderNode.prototype.getContentRect = function () {
        return this._contentRect;
    };
    BorderNode.prototype.isEnableDrop = function () {
        return this._getAttr("enableDrop");
    };
    BorderNode.prototype.isAutoSelectTab = function (whenOpen) {
        if (whenOpen == null) {
            whenOpen = this.getSelected() !== -1;
        }
        if (whenOpen) {
            return this._getAttr("autoSelectTabWhenOpen");
        }
        else {
            return this._getAttr("autoSelectTabWhenClosed");
        }
    };
    BorderNode.prototype.getClassName = function () {
        return this._getAttr("className");
    };
    /** @hidden @internal */
    BorderNode.prototype.calcBorderBarSize = function (metrics) {
        var barSize = this._getAttr("barSize");
        if (barSize !== 0) {
            // its defined
            this._calculatedBorderBarSize = barSize;
        }
        else {
            this._calculatedBorderBarSize = metrics.borderBarSize;
        }
    };
    BorderNode.prototype.getBorderBarSize = function () {
        return this._calculatedBorderBarSize;
    };
    BorderNode.prototype.getSize = function () {
        var defaultSize = this._getAttr("size");
        var selected = this.getSelected();
        if (selected === -1) {
            return defaultSize;
        }
        else {
            var tabNode = this._children[selected];
            var tabBorderSize = (this._location._orientation === Orientation_1.default.HORZ) ? tabNode._getAttr("borderWidth") : tabNode._getAttr("borderHeight");
            if (tabBorderSize === -1) {
                return defaultSize;
            }
            else {
                return tabBorderSize;
            }
        }
    };
    BorderNode.prototype.getMinSize = function () {
        return this._getAttr("minSize");
    };
    BorderNode.prototype.getSelected = function () {
        return this._attributes.selected;
    };
    BorderNode.prototype.getSelectedNode = function () {
        if (this.getSelected() !== -1) {
            return this._children[this.getSelected()];
        }
        return undefined;
    };
    BorderNode.prototype.getOrientation = function () {
        return this._location.getOrientation();
    };
    /**
     * Returns the config attribute that can be used to store node specific data that
     * WILL be saved to the json. The config attribute should be changed via the action Actions.updateNodeAttributes rather
     * than directly, for example:
     * this.state.model.doAction(
     *   FlexLayout.Actions.updateNodeAttributes(node.getId(), {config:myConfigObject}));
     */
    BorderNode.prototype.getConfig = function () {
        return this._attributes.config;
    };
    BorderNode.prototype.isMaximized = function () {
        return false;
    };
    BorderNode.prototype.isShowing = function () {
        return this._attributes.show;
    };
    /** @hidden @internal */
    BorderNode.prototype._setSelected = function (index) {
        this._attributes.selected = index;
    };
    /** @hidden @internal */
    BorderNode.prototype._setSize = function (pos) {
        var selected = this.getSelected();
        if (selected === -1) {
            this._attributes.size = pos;
        }
        else {
            var tabNode = this._children[selected];
            var tabBorderSize = (this._location._orientation === Orientation_1.default.HORZ) ? tabNode._getAttr("borderWidth") : tabNode._getAttr("borderHeight");
            if (tabBorderSize === -1) {
                this._attributes.size = pos;
            }
            else {
                if (this._location._orientation === Orientation_1.default.HORZ) {
                    tabNode._setBorderWidth(pos);
                }
                else {
                    tabNode._setBorderHeight(pos);
                }
            }
        }
    };
    /** @hidden @internal */
    BorderNode.prototype._updateAttrs = function (json) {
        BorderNode._attributeDefinitions.update(json, this._attributes);
    };
    /** @hidden @internal */
    BorderNode.prototype._getDrawChildren = function () {
        return this._drawChildren;
    };
    /** @hidden @internal */
    BorderNode.prototype._setAdjustedSize = function (size) {
        this._adjustedSize = size;
    };
    /** @hidden @internal */
    BorderNode.prototype._getAdjustedSize = function () {
        return this._adjustedSize;
    };
    /** @hidden @internal */
    BorderNode.prototype._layoutBorderOuter = function (outer, metrics) {
        this.calcBorderBarSize(metrics);
        var split1 = this._location.split(outer, this.getBorderBarSize()); // split border outer
        this._tabHeaderRect = split1.start;
        return split1.end;
    };
    /** @hidden @internal */
    BorderNode.prototype._layoutBorderInner = function (inner, metrics) {
        var _this = this;
        this._drawChildren = [];
        var location = this._location;
        var split1 = location.split(inner, this._adjustedSize + this._model.getSplitterSize()); // split off tab contents
        var split2 = location.reflect().split(split1.start, this._model.getSplitterSize()); // split contents into content and splitter
        this._contentRect = split2.end;
        this._children.forEach(function (child, i) {
            child._layout(_this._contentRect, metrics);
            child._setVisible(i === _this.getSelected());
            _this._drawChildren.push(child);
        });
        if (this.getSelected() === -1) {
            return inner;
        }
        else {
            var newSplitter = new SplitterNode_1.default(this._model);
            newSplitter._setParent(this);
            newSplitter._setRect(split2.start);
            this._drawChildren.push(newSplitter);
            return split1.end;
        }
    };
    /** @hidden @internal */
    BorderNode.prototype._remove = function (node) {
        var removedIndex = this._removeChild(node);
        if (this.getSelected() !== -1) {
            Utils_1.adjustSelectedIndex(this, removedIndex);
        }
    };
    /** @hidden @internal */
    BorderNode.prototype.canDrop = function (dragNode, x, y) {
        if (dragNode.getType() !== TabNode_1.default.TYPE) {
            return undefined;
        }
        var dropInfo;
        var dockLocation = DockLocation_1.default.CENTER;
        if (this._tabHeaderRect.contains(x, y)) {
            if (this._location._orientation === Orientation_1.default.VERT) {
                if (this._children.length > 0) {
                    var child = this._children[0];
                    var childRect = child.getTabRect();
                    var childY = childRect.y;
                    var childHeight = childRect.height;
                    var pos = this._tabHeaderRect.x;
                    var childCenter = 0;
                    for (var i = 0; i < this._children.length; i++) {
                        child = this._children[i];
                        childRect = child.getTabRect();
                        childCenter = childRect.x + childRect.width / 2;
                        if (x >= pos && x < childCenter) {
                            var outlineRect = new Rect_1.default(childRect.x - 2, childY, 3, childHeight);
                            dropInfo = new DropInfo_1.default(this, outlineRect, dockLocation, i, "flexlayout__outline_rect");
                            break;
                        }
                        pos = childCenter;
                    }
                    if (dropInfo == null) {
                        var outlineRect = new Rect_1.default(childRect.getRight() - 2, childY, 3, childHeight);
                        dropInfo = new DropInfo_1.default(this, outlineRect, dockLocation, this._children.length, "flexlayout__outline_rect");
                    }
                }
                else {
                    var outlineRect = new Rect_1.default(this._tabHeaderRect.x + 1, this._tabHeaderRect.y + 2, 3, 18);
                    dropInfo = new DropInfo_1.default(this, outlineRect, dockLocation, 0, "flexlayout__outline_rect");
                }
            }
            else {
                if (this._children.length > 0) {
                    var child = this._children[0];
                    var childRect = child.getTabRect();
                    var childX = childRect.x;
                    var childWidth = childRect.width;
                    var pos = this._tabHeaderRect.y;
                    var childCenter = 0;
                    for (var i = 0; i < this._children.length; i++) {
                        child = this._children[i];
                        childRect = child.getTabRect();
                        childCenter = childRect.y + childRect.height / 2;
                        if (y >= pos && y < childCenter) {
                            var outlineRect = new Rect_1.default(childX, childRect.y - 2, childWidth, 3);
                            dropInfo = new DropInfo_1.default(this, outlineRect, dockLocation, i, "flexlayout__outline_rect");
                            break;
                        }
                        pos = childCenter;
                    }
                    if (dropInfo == null) {
                        var outlineRect = new Rect_1.default(childX, childRect.getBottom() - 2, childWidth, 3);
                        dropInfo = new DropInfo_1.default(this, outlineRect, dockLocation, this._children.length, "flexlayout__outline_rect");
                    }
                }
                else {
                    var outlineRect = new Rect_1.default(this._tabHeaderRect.x + 2, this._tabHeaderRect.y + 1, 18, 3);
                    dropInfo = new DropInfo_1.default(this, outlineRect, dockLocation, 0, "flexlayout__outline_rect");
                }
            }
            if (!dragNode._canDockInto(dragNode, dropInfo)) {
                return undefined;
            }
        }
        else if (this.getSelected() !== -1 && this._contentRect.contains(x, y)) {
            var outlineRect = this._contentRect;
            dropInfo = new DropInfo_1.default(this, outlineRect, dockLocation, -1, "flexlayout__outline_rect");
            if (!dragNode._canDockInto(dragNode, dropInfo)) {
                return undefined;
            }
        }
        return dropInfo;
    };
    /** @hidden @internal */
    BorderNode.prototype.drop = function (dragNode, location, index, select) {
        var fromIndex = 0;
        var dragParent = dragNode.getParent();
        if (dragParent !== undefined) {
            fromIndex = dragParent._removeChild(dragNode);
            Utils_1.adjustSelectedIndex(dragParent, fromIndex);
        }
        // if dropping a tab back to same tabset and moving to forward position then reduce insertion index
        if (dragNode.getType() === TabNode_1.default.TYPE && dragParent === this && fromIndex < index && index > 0) {
            index--;
        }
        // simple_bundled dock to existing tabset
        var insertPos = index;
        if (insertPos === -1) {
            insertPos = this._children.length;
        }
        if (dragNode.getType() === TabNode_1.default.TYPE) {
            this._addChild(dragNode, insertPos);
        }
        if (select || (select !== false && this.isAutoSelectTab())) {
            this._setSelected(insertPos);
        }
        this._model._tidy();
    };
    BorderNode.prototype.toJson = function () {
        var json = {};
        BorderNode._attributeDefinitions.toJson(json, this._attributes);
        json.location = this._location.getName();
        json.children = this._children.map(function (child) { return child.toJson(); });
        return json;
    };
    /** @hidden @internal */
    BorderNode.prototype._getSplitterBounds = function (splitter, useMinSize) {
        if (useMinSize === void 0) { useMinSize = false; }
        var pBounds = [0, 0];
        var minSize = useMinSize ? this.getMinSize() : 0;
        var outerRect = this._model._getOuterInnerRects().outer;
        var innerRect = this._model._getOuterInnerRects().inner;
        var rootRow = this._model.getRoot();
        if (this._location === DockLocation_1.default.TOP) {
            pBounds[0] = outerRect.y + minSize;
            pBounds[1] = Math.max(pBounds[0], innerRect.getBottom() - splitter.getHeight() - rootRow.getMinHeight());
        }
        else if (this._location === DockLocation_1.default.LEFT) {
            pBounds[0] = outerRect.x + minSize;
            pBounds[1] = Math.max(pBounds[0], innerRect.getRight() - splitter.getWidth() - rootRow.getMinWidth());
        }
        else if (this._location === DockLocation_1.default.BOTTOM) {
            pBounds[1] = outerRect.getBottom() - splitter.getHeight() - minSize;
            pBounds[0] = Math.min(pBounds[1], innerRect.y + rootRow.getMinHeight());
        }
        else if (this._location === DockLocation_1.default.RIGHT) {
            pBounds[1] = outerRect.getRight() - splitter.getWidth() - minSize;
            pBounds[0] = Math.min(pBounds[1], innerRect.x + rootRow.getMinWidth());
        }
        return pBounds;
    };
    /** @hidden @internal */
    BorderNode.prototype._calculateSplit = function (splitter, splitterPos) {
        var pBounds = this._getSplitterBounds(splitter);
        if (this._location === DockLocation_1.default.BOTTOM || this._location === DockLocation_1.default.RIGHT) {
            return Math.max(0, pBounds[1] - splitterPos);
        }
        else {
            return Math.max(0, splitterPos - pBounds[0]);
        }
    };
    /** @hidden @internal */
    BorderNode.prototype._getAttributeDefinitions = function () {
        return BorderNode._attributeDefinitions;
    };
    /** @hidden @internal */
    BorderNode.getAttributeDefinitions = function () {
        return BorderNode._attributeDefinitions;
    };
    BorderNode.TYPE = "border";
    /** @hidden @internal */
    BorderNode._attributeDefinitions = BorderNode._createAttributeDefinitions();
    return BorderNode;
}(Node_1.default));
exports["default"] = BorderNode;
//# sourceMappingURL=BorderNode.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/lib/model/BorderSet.js":
/*!**************************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/model/BorderSet.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
var Orientation_1 = __webpack_require__(/*! ../Orientation */ "./node_modules/flexlayout-react/lib/Orientation.js");
var BorderNode_1 = __webpack_require__(/*! ./BorderNode */ "./node_modules/flexlayout-react/lib/model/BorderNode.js");
var BorderSet = /** @class */ (function () {
    /** @hidden @internal */
    function BorderSet(model) {
        this._model = model;
        this._borders = [];
    }
    /** @hidden @internal */
    BorderSet._fromJson = function (json, model) {
        var borderSet = new BorderSet(model);
        borderSet._borders = json.map(function (borderJson) { return BorderNode_1.default._fromJson(borderJson, model); });
        return borderSet;
    };
    BorderSet.prototype.getBorders = function () {
        return this._borders;
    };
    /** @hidden @internal */
    BorderSet.prototype._forEachNode = function (fn) {
        this._borders.forEach(function (borderNode) {
            fn(borderNode, 0);
            borderNode.getChildren().forEach(function (node) {
                node._forEachNode(fn, 1);
            });
        });
    };
    /** @hidden @internal */
    BorderSet.prototype._toJson = function () {
        return this._borders.map(function (borderNode) { return borderNode.toJson(); });
    };
    /** @hidden @internal */
    BorderSet.prototype._layoutBorder = function (outerInnerRects, metrics) {
        var rect = outerInnerRects.outer;
        var rootRow = this._model.getRoot();
        var height = Math.max(0, rect.height - rootRow.getMinHeight());
        var width = Math.max(0, rect.width - rootRow.getMinWidth());
        var sumHeight = 0;
        var sumWidth = 0;
        var adjustableHeight = 0;
        var adjustableWidth = 0;
        var showingBorders = this._borders.filter(function (border) { return border.isShowing(); });
        // sum size of borders to see they will fit
        for (var _i = 0, showingBorders_1 = showingBorders; _i < showingBorders_1.length; _i++) {
            var border = showingBorders_1[_i];
            if (border.isShowing()) {
                border._setAdjustedSize(border.getSize());
                var visible = border.getSelected() !== -1;
                if (border.getLocation().getOrientation() === Orientation_1.default.HORZ) {
                    sumWidth += border.getBorderBarSize();
                    if (visible) {
                        width -= this._model.getSplitterSize();
                        sumWidth += border.getSize();
                        adjustableWidth += border.getSize();
                    }
                }
                else {
                    sumHeight += border.getBorderBarSize();
                    if (visible) {
                        height -= this._model.getSplitterSize();
                        sumHeight += border.getSize();
                        adjustableHeight += border.getSize();
                    }
                }
            }
        }
        // adjust border sizes if too large
        var j = 0;
        var adjusted = false;
        while ((sumWidth > width && adjustableWidth > 0) || (sumHeight > height && adjustableHeight > 0)) {
            var border = showingBorders[j];
            if (border.getSelected() !== -1) {
                // visible
                var size = border._getAdjustedSize();
                if (sumWidth > width && adjustableWidth > 0 && border.getLocation().getOrientation() === Orientation_1.default.HORZ && size > 0
                    && size > border.getMinSize()) {
                    border._setAdjustedSize(size - 1);
                    sumWidth--;
                    adjustableWidth--;
                    adjusted = true;
                }
                else if (sumHeight > height && adjustableHeight > 0 && border.getLocation().getOrientation() === Orientation_1.default.VERT && size > 0
                    && size > border.getMinSize()) {
                    border._setAdjustedSize(size - 1);
                    sumHeight--;
                    adjustableHeight--;
                    adjusted = true;
                }
            }
            j = (j + 1) % showingBorders.length;
            if (j === 0) {
                if (adjusted) {
                    adjusted = false;
                }
                else {
                    break;
                }
            }
        }
        showingBorders.forEach(function (border) {
            outerInnerRects.outer = border._layoutBorderOuter(outerInnerRects.outer, metrics);
        });
        outerInnerRects.inner = outerInnerRects.outer;
        showingBorders.forEach(function (border) {
            outerInnerRects.inner = border._layoutBorderInner(outerInnerRects.inner, metrics);
        });
        return outerInnerRects;
    };
    /** @hidden @internal */
    BorderSet.prototype._findDropTargetNode = function (dragNode, x, y) {
        for (var _i = 0, _a = this._borders; _i < _a.length; _i++) {
            var border = _a[_i];
            if (border.isShowing()) {
                var dropInfo = border.canDrop(dragNode, x, y);
                if (dropInfo !== undefined) {
                    return dropInfo;
                }
            }
        }
        return undefined;
    };
    return BorderSet;
}());
exports["default"] = BorderSet;
//# sourceMappingURL=BorderSet.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/lib/model/ICloseType.js":
/*!***************************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/model/ICloseType.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ICloseType = void 0;
var ICloseType;
(function (ICloseType) {
    ICloseType[ICloseType["Visible"] = 1] = "Visible";
    ICloseType[ICloseType["Always"] = 2] = "Always";
    ICloseType[ICloseType["Selected"] = 3] = "Selected";
})(ICloseType = exports.ICloseType || (exports.ICloseType = {}));
//# sourceMappingURL=ICloseType.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/lib/model/Model.js":
/*!**********************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/model/Model.js ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var Attribute_1 = __webpack_require__(/*! ../Attribute */ "./node_modules/flexlayout-react/lib/Attribute.js");
var AttributeDefinitions_1 = __webpack_require__(/*! ../AttributeDefinitions */ "./node_modules/flexlayout-react/lib/AttributeDefinitions.js");
var DockLocation_1 = __webpack_require__(/*! ../DockLocation */ "./node_modules/flexlayout-react/lib/DockLocation.js");
var Orientation_1 = __webpack_require__(/*! ../Orientation */ "./node_modules/flexlayout-react/lib/Orientation.js");
var Rect_1 = __webpack_require__(/*! ../Rect */ "./node_modules/flexlayout-react/lib/Rect.js");
var Actions_1 = __webpack_require__(/*! ./Actions */ "./node_modules/flexlayout-react/lib/model/Actions.js");
var BorderNode_1 = __webpack_require__(/*! ./BorderNode */ "./node_modules/flexlayout-react/lib/model/BorderNode.js");
var BorderSet_1 = __webpack_require__(/*! ./BorderSet */ "./node_modules/flexlayout-react/lib/model/BorderSet.js");
var RowNode_1 = __webpack_require__(/*! ./RowNode */ "./node_modules/flexlayout-react/lib/model/RowNode.js");
var TabNode_1 = __webpack_require__(/*! ./TabNode */ "./node_modules/flexlayout-react/lib/model/TabNode.js");
var TabSetNode_1 = __webpack_require__(/*! ./TabSetNode */ "./node_modules/flexlayout-react/lib/model/TabSetNode.js");
var Utils_1 = __webpack_require__(/*! ./Utils */ "./node_modules/flexlayout-react/lib/model/Utils.js");
var uuid = __webpack_require__(/*! uuid */ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/index.js");
/**
 * Class containing the Tree of Nodes used by the FlexLayout component
 */
var Model = /** @class */ (function () {
    /**
     * 'private' constructor. Use the static method Model.fromJson(json) to create a model
     *  @hidden @internal
     */
    function Model() {
        /** @hidden @internal */
        this._borderRects = { inner: Rect_1.default.empty(), outer: Rect_1.default.empty() };
        this._attributes = {};
        this._idMap = {};
        this._borders = new BorderSet_1.default(this);
        this._pointerFine = true;
    }
    /**
     * Loads the model from the given json object
     * @param json the json model to load
     * @returns {Model} a new Model object
     */
    Model.fromJson = function (json) {
        var model = new Model();
        Model._attributeDefinitions.fromJson(json.global, model._attributes);
        if (json.borders) {
            model._borders = BorderSet_1.default._fromJson(json.borders, model);
        }
        model._root = RowNode_1.default._fromJson(json.layout, model);
        model._tidy(); // initial tidy of node tree
        return model;
    };
    /** @hidden @internal */
    Model._createAttributeDefinitions = function () {
        var attributeDefinitions = new AttributeDefinitions_1.default();
        // splitter
        attributeDefinitions.add("splitterSize", -1).setType(Attribute_1.default.NUMBER);
        attributeDefinitions.add("splitterExtra", 0).setType(Attribute_1.default.NUMBER);
        attributeDefinitions.add("enableEdgeDock", true).setType(Attribute_1.default.BOOLEAN);
        attributeDefinitions.add("rootOrientationVertical", false).setType(Attribute_1.default.BOOLEAN);
        attributeDefinitions.add("marginInsets", { top: 0, right: 0, bottom: 0, left: 0 })
            .setType("IInsets");
        // tab
        attributeDefinitions.add("tabEnableClose", true).setType(Attribute_1.default.BOOLEAN);
        attributeDefinitions.add("tabCloseType", 1).setType("ICloseType");
        attributeDefinitions.add("tabEnableFloat", false).setType(Attribute_1.default.BOOLEAN);
        attributeDefinitions.add("tabEnableDrag", true).setType(Attribute_1.default.BOOLEAN);
        attributeDefinitions.add("tabEnableRename", true).setType(Attribute_1.default.BOOLEAN);
        attributeDefinitions.add("tabClassName", undefined).setType(Attribute_1.default.STRING);
        attributeDefinitions.add("tabIcon", undefined).setType(Attribute_1.default.STRING);
        attributeDefinitions.add("tabEnableRenderOnDemand", true).setType(Attribute_1.default.BOOLEAN);
        attributeDefinitions.add("tabDragSpeed", 0.3).setType(Attribute_1.default.NUMBER);
        attributeDefinitions.add("tabBorderWidth", -1).setType(Attribute_1.default.NUMBER);
        attributeDefinitions.add("tabBorderHeight", -1).setType(Attribute_1.default.NUMBER);
        // tabset
        attributeDefinitions.add("tabSetEnableDeleteWhenEmpty", true).setType(Attribute_1.default.BOOLEAN);
        attributeDefinitions.add("tabSetEnableDrop", true).setType(Attribute_1.default.BOOLEAN);
        attributeDefinitions.add("tabSetEnableDrag", true).setType(Attribute_1.default.BOOLEAN);
        attributeDefinitions.add("tabSetEnableDivide", true).setType(Attribute_1.default.BOOLEAN);
        attributeDefinitions.add("tabSetEnableMaximize", true).setType(Attribute_1.default.BOOLEAN);
        attributeDefinitions.add("tabSetEnableClose", false).setType(Attribute_1.default.BOOLEAN);
        attributeDefinitions.add("tabSetAutoSelectTab", true).setType(Attribute_1.default.BOOLEAN);
        attributeDefinitions.add("tabSetClassNameTabStrip", undefined).setType(Attribute_1.default.STRING);
        attributeDefinitions.add("tabSetClassNameHeader", undefined).setType(Attribute_1.default.STRING);
        attributeDefinitions.add("tabSetEnableTabStrip", true).setType(Attribute_1.default.BOOLEAN);
        attributeDefinitions.add("tabSetHeaderHeight", 0).setType(Attribute_1.default.NUMBER);
        attributeDefinitions.add("tabSetTabStripHeight", 0).setType(Attribute_1.default.NUMBER);
        attributeDefinitions.add("tabSetMarginInsets", { top: 0, right: 0, bottom: 0, left: 0 })
            .setType("IInsets");
        attributeDefinitions.add("tabSetBorderInsets", { top: 0, right: 0, bottom: 0, left: 0 })
            .setType("IInsets");
        attributeDefinitions.add("tabSetTabLocation", "top").setType("ITabLocation");
        attributeDefinitions.add("tabSetMinWidth", 0).setType(Attribute_1.default.NUMBER);
        attributeDefinitions.add("tabSetMinHeight", 0).setType(Attribute_1.default.NUMBER);
        // border
        attributeDefinitions.add("borderSize", 200).setType(Attribute_1.default.NUMBER);
        attributeDefinitions.add("borderMinSize", 0).setType(Attribute_1.default.NUMBER);
        attributeDefinitions.add("borderBarSize", 0).setType(Attribute_1.default.NUMBER);
        attributeDefinitions.add("borderEnableDrop", true).setType(Attribute_1.default.BOOLEAN);
        attributeDefinitions.add("borderAutoSelectTabWhenOpen", true).setType(Attribute_1.default.BOOLEAN);
        attributeDefinitions.add("borderAutoSelectTabWhenClosed", false).setType(Attribute_1.default.BOOLEAN);
        attributeDefinitions.add("borderClassName", undefined).setType(Attribute_1.default.STRING);
        return attributeDefinitions;
    };
    /** @hidden @internal */
    Model.prototype._setChangeListener = function (listener) {
        this._changeListener = listener;
    };
    /**
     * Get the currently active tabset node
     */
    Model.prototype.getActiveTabset = function () {
        if (this._activeTabSet && this.getNodeById(this._activeTabSet.getId())) {
            return this._activeTabSet;
        }
        else {
            return undefined;
        }
    };
    /** @hidden @internal */
    Model.prototype._setActiveTabset = function (tabsetNode) {
        this._activeTabSet = tabsetNode;
    };
    /**
     * Get the currently maximized tabset node
     */
    Model.prototype.getMaximizedTabset = function () {
        return this._maximizedTabSet;
    };
    /** @hidden @internal */
    Model.prototype._setMaximizedTabset = function (tabsetNode) {
        this._maximizedTabSet = tabsetNode;
    };
    /**
     * Gets the root RowNode of the model
     * @returns {RowNode}
     */
    Model.prototype.getRoot = function () {
        return this._root;
    };
    Model.prototype.isRootOrientationVertical = function () {
        return this._attributes.rootOrientationVertical;
    };
    /**
     * Gets the
     * @returns {BorderSet|*}
     */
    Model.prototype.getBorderSet = function () {
        return this._borders;
    };
    /** @hidden @internal */
    Model.prototype._getOuterInnerRects = function () {
        return this._borderRects;
    };
    /** @hidden @internal */
    Model.prototype._getPointerFine = function () {
        return this._pointerFine;
    };
    /** @hidden @internal */
    Model.prototype._setPointerFine = function (pointerFine) {
        this._pointerFine = pointerFine;
    };
    /**
     * Visits all the nodes in the model and calls the given function for each
     * @param fn a function that takes visited node and a integer level as parameters
     */
    Model.prototype.visitNodes = function (fn) {
        this._borders._forEachNode(fn);
        this._root._forEachNode(fn, 0);
    };
    /**
     * Gets a node by its id
     * @param id the id to find
     */
    Model.prototype.getNodeById = function (id) {
        return this._idMap[id];
    };
    /**
     * Update the node tree by performing the given action,
     * Actions should be generated via static methods on the Actions class
     * @param action the action to perform
     * @returns added Node for Actions.addNode; undefined otherwise
     */
    Model.prototype.doAction = function (action) {
        var returnVal = undefined;
        // console.log(action);
        switch (action.type) {
            case Actions_1.default.ADD_NODE: {
                var newNode = new TabNode_1.default(this, action.data.json, true);
                var toNode = this._idMap[action.data.toNode];
                if (toNode instanceof TabSetNode_1.default || toNode instanceof BorderNode_1.default || toNode instanceof RowNode_1.default) {
                    toNode.drop(newNode, DockLocation_1.default.getByName(action.data.location), action.data.index, action.data.select);
                    returnVal = newNode;
                }
                break;
            }
            case Actions_1.default.MOVE_NODE: {
                var fromNode = this._idMap[action.data.fromNode];
                if (fromNode instanceof TabNode_1.default || fromNode instanceof TabSetNode_1.default) {
                    var toNode = this._idMap[action.data.toNode];
                    if (toNode instanceof TabSetNode_1.default || toNode instanceof BorderNode_1.default || toNode instanceof RowNode_1.default) {
                        toNode.drop(fromNode, DockLocation_1.default.getByName(action.data.location), action.data.index, action.data.select);
                    }
                }
                break;
            }
            case Actions_1.default.DELETE_TAB: {
                var node = this._idMap[action.data.node];
                if (node instanceof TabNode_1.default) {
                    node._delete();
                }
                break;
            }
            case Actions_1.default.DELETE_TABSET: {
                var node = this._idMap[action.data.node];
                if (node instanceof TabSetNode_1.default) {
                    // first delete all child tabs
                    var children = __spreadArray([], node.getChildren());
                    children.forEach(function (child, i) {
                        child._delete();
                    });
                    node._delete();
                    this._tidy();
                }
                break;
            }
            case Actions_1.default.FLOAT_TAB: {
                var node = this._idMap[action.data.node];
                if (node instanceof TabNode_1.default) {
                    node._setFloating(true);
                    Utils_1.adjustSelectedIndexAfterFloat(node);
                }
                break;
            }
            case Actions_1.default.UNFLOAT_TAB: {
                var node = this._idMap[action.data.node];
                if (node instanceof TabNode_1.default) {
                    node._setFloating(false);
                    Utils_1.adjustSelectedIndexAfterDock(node);
                }
                break;
            }
            case Actions_1.default.RENAME_TAB: {
                var node = this._idMap[action.data.node];
                if (node instanceof TabNode_1.default) {
                    node._setName(action.data.text);
                }
                break;
            }
            case Actions_1.default.SELECT_TAB: {
                var tabNode = this._idMap[action.data.tabNode];
                if (tabNode instanceof TabNode_1.default) {
                    var parent_1 = tabNode.getParent();
                    var pos = parent_1.getChildren().indexOf(tabNode);
                    if (parent_1 instanceof BorderNode_1.default) {
                        if (parent_1.getSelected() === pos) {
                            parent_1._setSelected(-1);
                        }
                        else {
                            parent_1._setSelected(pos);
                        }
                    }
                    else if (parent_1 instanceof TabSetNode_1.default) {
                        if (parent_1.getSelected() !== pos) {
                            parent_1._setSelected(pos);
                        }
                        this._activeTabSet = parent_1;
                    }
                }
                break;
            }
            case Actions_1.default.SET_ACTIVE_TABSET: {
                var tabsetNode = this._idMap[action.data.tabsetNode];
                if (tabsetNode instanceof TabSetNode_1.default) {
                    this._activeTabSet = tabsetNode;
                }
                break;
            }
            case Actions_1.default.ADJUST_SPLIT: {
                var node1 = this._idMap[action.data.node1];
                var node2 = this._idMap[action.data.node2];
                if ((node1 instanceof TabSetNode_1.default || node1 instanceof RowNode_1.default) && (node2 instanceof TabSetNode_1.default || node2 instanceof RowNode_1.default)) {
                    this._adjustSplitSide(node1, action.data.weight1, action.data.pixelWidth1);
                    this._adjustSplitSide(node2, action.data.weight2, action.data.pixelWidth2);
                }
                break;
            }
            case Actions_1.default.ADJUST_BORDER_SPLIT: {
                var node = this._idMap[action.data.node];
                if (node instanceof BorderNode_1.default) {
                    node._setSize(action.data.pos);
                }
                break;
            }
            case Actions_1.default.MAXIMIZE_TOGGLE: {
                var node = this._idMap[action.data.node];
                if (node instanceof TabSetNode_1.default) {
                    if (node === this._maximizedTabSet) {
                        this._maximizedTabSet = undefined;
                    }
                    else {
                        this._maximizedTabSet = node;
                        this._activeTabSet = node;
                    }
                }
                break;
            }
            case Actions_1.default.UPDATE_MODEL_ATTRIBUTES: {
                this._updateAttrs(action.data.json);
                break;
            }
            case Actions_1.default.UPDATE_NODE_ATTRIBUTES: {
                var node = this._idMap[action.data.node];
                node._updateAttrs(action.data.json);
                break;
            }
            default:
                break;
        }
        this._updateIdMap();
        if (this._changeListener !== undefined) {
            this._changeListener();
        }
        return returnVal;
    };
    /** @hidden @internal */
    Model.prototype._updateIdMap = function () {
        var _this = this;
        // regenerate idMap to stop it building up
        this._idMap = {};
        this.visitNodes(function (node) { return (_this._idMap[node.getId()] = node); });
        // console.log(JSON.stringify(Object.keys(this._idMap)));
    };
    /** @hidden @internal */
    Model.prototype._adjustSplitSide = function (node, weight, pixels) {
        node._setWeight(weight);
        if (node.getWidth() != null && node.getOrientation() === Orientation_1.default.VERT) {
            node._updateAttrs({ width: pixels });
        }
        else if (node.getHeight() != null && node.getOrientation() === Orientation_1.default.HORZ) {
            node._updateAttrs({ height: pixels });
        }
    };
    /**
     * Converts the model to a json object
     * @returns {IJsonModel} json object that represents this model
     */
    Model.prototype.toJson = function () {
        var global = {};
        Model._attributeDefinitions.toJson(global, this._attributes);
        // save state of nodes
        this.visitNodes(function (node) {
            node._fireEvent("save", undefined);
        });
        return { global: global, borders: this._borders._toJson(), layout: this._root.toJson() };
    };
    Model.prototype.getSplitterSize = function () {
        var splitterSize = this._attributes.splitterSize;
        if (splitterSize === -1) {
            // use defaults
            splitterSize = this._pointerFine ? 8 : 12; // larger for mobile
        }
        return splitterSize;
    };
    Model.prototype.getSplitterExtra = function () {
        return this._attributes.splitterExtra;
    };
    Model.prototype.isEnableEdgeDock = function () {
        return this._attributes.enableEdgeDock;
    };
    /** @hidden @internal */
    Model.prototype._addNode = function (node) {
        var id = node.getId();
        if (this._idMap[id] !== undefined) {
            throw new Error("Error: each node must have a unique id, duplicate id:" + node.getId());
        }
        if (node.getType() !== "splitter") {
            this._idMap[id] = node;
        }
    };
    /** @hidden @internal */
    Model.prototype._layout = function (rect, metrics) {
        var _a;
        // let start = Date.now();
        this._borderRects = this._borders._layoutBorder({ outer: rect, inner: rect }, metrics);
        rect = this._borderRects.inner.removeInsets(this._getAttribute("marginInsets"));
        (_a = this._root) === null || _a === void 0 ? void 0 : _a.calcMinSize();
        this._root._layout(rect, metrics);
        // console.log("layout time: " + (Date.now() - start));
        return rect;
    };
    /** @hidden @internal */
    Model.prototype._findDropTargetNode = function (dragNode, x, y) {
        var node = this._root._findDropTargetNode(dragNode, x, y);
        if (node === undefined) {
            node = this._borders._findDropTargetNode(dragNode, x, y);
        }
        return node;
    };
    /** @hidden @internal */
    Model.prototype._tidy = function () {
        // console.log("before _tidy", this.toString());
        this._root._tidy();
        // console.log("after _tidy", this.toString());
    };
    /** @hidden @internal */
    Model.prototype._updateAttrs = function (json) {
        Model._attributeDefinitions.update(json, this._attributes);
    };
    /** @hidden @internal */
    Model.prototype._nextUniqueId = function () {
        return '#' + uuid.v4();
    };
    /** @hidden @internal */
    Model.prototype._getAttribute = function (name) {
        return this._attributes[name];
    };
    /**
     * Sets a function to allow/deny dropping a node
     * @param onAllowDrop function that takes the drag node and DropInfo and returns true if the drop is allowed
     */
    Model.prototype.setOnAllowDrop = function (onAllowDrop) {
        this._onAllowDrop = onAllowDrop;
    };
    /** @hidden @internal */
    Model.prototype._getOnAllowDrop = function () {
        return this._onAllowDrop;
    };
    /**
     * set callback called when a new TabSet is created.
     * The tabNode can be undefined if it's the auto created first tabset in the root row (when the last
     * tab is deleted, the root tabset can be recreated)
     * @param onCreateTabSet
     */
    Model.prototype.setOnCreateTabSet = function (onCreateTabSet) {
        this._onCreateTabSet = onCreateTabSet;
    };
    /** @hidden @internal */
    Model.prototype._getOnCreateTabSet = function () {
        return this._onCreateTabSet;
    };
    Model.toTypescriptInterfaces = function () {
        console.log(Model._attributeDefinitions.toTypescriptInterface("Global", undefined));
        console.log(RowNode_1.default.getAttributeDefinitions().toTypescriptInterface("Row", Model._attributeDefinitions));
        console.log(TabSetNode_1.default.getAttributeDefinitions().toTypescriptInterface("TabSet", Model._attributeDefinitions));
        console.log(TabNode_1.default.getAttributeDefinitions().toTypescriptInterface("Tab", Model._attributeDefinitions));
        console.log(BorderNode_1.default.getAttributeDefinitions().toTypescriptInterface("Border", Model._attributeDefinitions));
    };
    Model.prototype.toString = function () {
        return JSON.stringify(this.toJson());
    };
    /** @hidden @internal */
    Model._attributeDefinitions = Model._createAttributeDefinitions();
    return Model;
}());
exports["default"] = Model;
//# sourceMappingURL=Model.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/lib/model/Node.js":
/*!*********************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/model/Node.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
var DockLocation_1 = __webpack_require__(/*! ../DockLocation */ "./node_modules/flexlayout-react/lib/DockLocation.js");
var Orientation_1 = __webpack_require__(/*! ../Orientation */ "./node_modules/flexlayout-react/lib/Orientation.js");
var Rect_1 = __webpack_require__(/*! ../Rect */ "./node_modules/flexlayout-react/lib/Rect.js");
var Node = /** @class */ (function () {
    /** @hidden @internal */
    function Node(model) {
        /** @hidden @internal */
        this._dirty = false;
        /** @hidden @internal */
        this._tempSize = 0;
        this._model = model;
        this._attributes = {};
        this._children = [];
        this._fixed = false;
        this._rect = Rect_1.default.empty();
        this._visible = false;
        this._listeners = {};
    }
    Node.prototype.getId = function () {
        var id = this._attributes.id;
        if (id !== undefined) {
            return id;
        }
        id = this._model._nextUniqueId();
        this._setId(id);
        return id;
    };
    Node.prototype.getModel = function () {
        return this._model;
    };
    Node.prototype.getType = function () {
        return this._attributes.type;
    };
    Node.prototype.getParent = function () {
        return this._parent;
    };
    Node.prototype.getChildren = function () {
        return this._children;
    };
    Node.prototype.getRect = function () {
        return this._rect;
    };
    Node.prototype.isVisible = function () {
        return this._visible;
    };
    Node.prototype.getOrientation = function () {
        if (this._parent === undefined) {
            return this._model.isRootOrientationVertical() ? Orientation_1.default.VERT : Orientation_1.default.HORZ;
        }
        else {
            return Orientation_1.default.flip(this._parent.getOrientation());
        }
    };
    // event can be: resize, visibility, maximize (on tabset), close
    Node.prototype.setEventListener = function (event, callback) {
        this._listeners[event] = callback;
    };
    Node.prototype.removeEventListener = function (event) {
        delete this._listeners[event];
    };
    /** @hidden @internal */
    Node.prototype._setId = function (id) {
        this._attributes.id = id;
    };
    /** @hidden @internal */
    Node.prototype._fireEvent = function (event, params) {
        // console.log(this._type, " fireEvent " + event + " " + JSON.stringify(params));
        if (this._listeners[event] !== undefined) {
            this._listeners[event](params);
        }
    };
    /** @hidden @internal */
    Node.prototype._getAttr = function (name) {
        var val = this._attributes[name];
        if (val === undefined) {
            var modelName = this._getAttributeDefinitions().getModelName(name);
            if (modelName !== undefined) {
                val = this._model._getAttribute(modelName);
            }
        }
        // console.log(name + "=" + val);
        return val;
    };
    /** @hidden @internal */
    Node.prototype._forEachNode = function (fn, level) {
        fn(this, level);
        level++;
        this._children.forEach(function (node) {
            node._forEachNode(fn, level);
        });
    };
    /** @hidden @internal */
    Node.prototype._setVisible = function (visible) {
        if (visible !== this._visible) {
            this._fireEvent("visibility", { visible: visible });
            this._visible = visible;
        }
    };
    /** @hidden @internal */
    Node.prototype._getDrawChildren = function () {
        return this._children;
    };
    /** @hidden @internal */
    Node.prototype._setParent = function (parent) {
        this._parent = parent;
    };
    /** @hidden @internal */
    Node.prototype._setRect = function (rect) {
        this._rect = rect;
    };
    /** @hidden @internal */
    Node.prototype._setWeight = function (weight) {
        this._attributes.weight = weight;
    };
    /** @hidden @internal */
    Node.prototype._setSelected = function (index) {
        this._attributes.selected = index;
    };
    /** @hidden @internal */
    Node.prototype._isFixed = function () {
        return this._fixed;
    };
    /** @hidden @internal */
    Node.prototype._layout = function (rect, metrics) {
        this._rect = rect;
    };
    /** @hidden @internal */
    Node.prototype._findDropTargetNode = function (dragNode, x, y) {
        var rtn;
        if (this._rect.contains(x, y)) {
            rtn = this.canDrop(dragNode, x, y);
            if (rtn === undefined) {
                if (this._children.length !== 0) {
                    for (var _i = 0, _a = this._children; _i < _a.length; _i++) {
                        var child = _a[_i];
                        rtn = child._findDropTargetNode(dragNode, x, y);
                        if (rtn !== undefined) {
                            break;
                        }
                    }
                }
            }
        }
        return rtn;
    };
    /** @hidden @internal */
    Node.prototype.canDrop = function (dragNode, x, y) {
        return undefined;
    };
    /** @hidden @internal */
    Node.prototype._canDockInto = function (dragNode, dropInfo) {
        if (dropInfo != null) {
            if (dropInfo.location === DockLocation_1.default.CENTER && dropInfo.node.isEnableDrop() === false) {
                return false;
            }
            // prevent named tabset docking into another tabset, since this would lose the header
            if (dropInfo.location === DockLocation_1.default.CENTER && dragNode.getType() === "tabset" && dragNode.getName() !== undefined) {
                return false;
            }
            if (dropInfo.location !== DockLocation_1.default.CENTER && dropInfo.node.isEnableDivide() === false) {
                return false;
            }
            // finally check model callback to check if drop allowed
            if (this._model._getOnAllowDrop()) {
                return this._model._getOnAllowDrop()(dragNode, dropInfo);
            }
        }
        return true;
    };
    /** @hidden @internal */
    Node.prototype._removeChild = function (childNode) {
        var pos = this._children.indexOf(childNode);
        if (pos !== -1) {
            this._children.splice(pos, 1);
        }
        this._dirty = true;
        return pos;
    };
    /** @hidden @internal */
    Node.prototype._addChild = function (childNode, pos) {
        if (pos != null) {
            this._children.splice(pos, 0, childNode);
        }
        else {
            this._children.push(childNode);
            pos = this._children.length - 1;
        }
        childNode._parent = this;
        this._dirty = true;
        return pos;
    };
    /** @hidden @internal */
    Node.prototype._removeAll = function () {
        this._children = [];
        this._dirty = true;
    };
    /** @hidden @internal */
    Node.prototype._styleWithPosition = function (style) {
        if (style == null) {
            style = {};
        }
        return this._rect.styleWithPosition(style);
    };
    /** @hidden @internal */
    Node.prototype._getTempSize = function () {
        return this._tempSize;
    };
    /** @hidden @internal */
    Node.prototype._setTempSize = function (value) {
        this._tempSize = value;
    };
    /** @hidden @internal */
    Node.prototype.isEnableDivide = function () {
        return true;
    };
    /** @hidden @internal */
    Node.prototype._toAttributeString = function () {
        return JSON.stringify(this._attributes, undefined, "\t");
    };
    return Node;
}());
exports["default"] = Node;
//# sourceMappingURL=Node.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/lib/model/RowNode.js":
/*!************************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/model/RowNode.js ***!
  \************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
var Attribute_1 = __webpack_require__(/*! ../Attribute */ "./node_modules/flexlayout-react/lib/Attribute.js");
var AttributeDefinitions_1 = __webpack_require__(/*! ../AttributeDefinitions */ "./node_modules/flexlayout-react/lib/AttributeDefinitions.js");
var DockLocation_1 = __webpack_require__(/*! ../DockLocation */ "./node_modules/flexlayout-react/lib/DockLocation.js");
var DropInfo_1 = __webpack_require__(/*! ../DropInfo */ "./node_modules/flexlayout-react/lib/DropInfo.js");
var Orientation_1 = __webpack_require__(/*! ../Orientation */ "./node_modules/flexlayout-react/lib/Orientation.js");
var Rect_1 = __webpack_require__(/*! ../Rect */ "./node_modules/flexlayout-react/lib/Rect.js");
var BorderNode_1 = __webpack_require__(/*! ./BorderNode */ "./node_modules/flexlayout-react/lib/model/BorderNode.js");
var Node_1 = __webpack_require__(/*! ./Node */ "./node_modules/flexlayout-react/lib/model/Node.js");
var SplitterNode_1 = __webpack_require__(/*! ./SplitterNode */ "./node_modules/flexlayout-react/lib/model/SplitterNode.js");
var TabSetNode_1 = __webpack_require__(/*! ./TabSetNode */ "./node_modules/flexlayout-react/lib/model/TabSetNode.js");
var RowNode = /** @class */ (function (_super) {
    __extends(RowNode, _super);
    /** @hidden @internal */
    function RowNode(model, json) {
        var _this = _super.call(this, model) || this;
        _this._dirty = true;
        _this._drawChildren = [];
        _this.minHeight = 0;
        _this.minWidth = 0;
        RowNode._attributeDefinitions.fromJson(json, _this._attributes);
        model._addNode(_this);
        return _this;
    }
    /** @hidden @internal */
    RowNode._fromJson = function (json, model) {
        var newLayoutNode = new RowNode(model, json);
        if (json.children != null) {
            for (var _i = 0, _a = json.children; _i < _a.length; _i++) {
                var jsonChild = _a[_i];
                if (jsonChild.type === TabSetNode_1.default.TYPE) {
                    var child = TabSetNode_1.default._fromJson(jsonChild, model);
                    newLayoutNode._addChild(child);
                }
                else {
                    var child = RowNode._fromJson(jsonChild, model);
                    newLayoutNode._addChild(child);
                }
            }
        }
        return newLayoutNode;
    };
    /** @hidden @internal */
    RowNode._createAttributeDefinitions = function () {
        var attributeDefinitions = new AttributeDefinitions_1.default();
        attributeDefinitions.add("type", RowNode.TYPE, true).setType(Attribute_1.default.STRING).setFixed();
        attributeDefinitions.add("id", undefined).setType(Attribute_1.default.STRING);
        attributeDefinitions.add("weight", 100).setType(Attribute_1.default.NUMBER);
        attributeDefinitions.add("width", undefined).setType(Attribute_1.default.NUMBER);
        attributeDefinitions.add("height", undefined).setType(Attribute_1.default.NUMBER);
        return attributeDefinitions;
    };
    RowNode.prototype.getWeight = function () {
        return this._attributes.weight;
    };
    RowNode.prototype.getWidth = function () {
        return this._getAttr("width");
    };
    RowNode.prototype.getHeight = function () {
        return this._getAttr("height");
    };
    /** @hidden @internal */
    RowNode.prototype._setWeight = function (weight) {
        this._attributes.weight = weight;
    };
    /** @hidden @internal */
    RowNode.prototype._layout = function (rect, metrics) {
        _super.prototype._layout.call(this, rect, metrics);
        var pixelSize = this._rect._getSize(this.getOrientation());
        var totalWeight = 0;
        var fixedPixels = 0;
        var prefPixels = 0;
        var totalPrefWeight = 0;
        var drawChildren = this._getDrawChildren();
        for (var _i = 0, drawChildren_1 = drawChildren; _i < drawChildren_1.length; _i++) {
            var child = drawChildren_1[_i];
            var prefSize = child._getPrefSize(this.getOrientation());
            if (child._isFixed()) {
                if (prefSize !== undefined) {
                    fixedPixels += prefSize;
                }
            }
            else {
                if (prefSize === undefined) {
                    totalWeight += child.getWeight();
                }
                else {
                    prefPixels += prefSize;
                    totalPrefWeight += child.getWeight();
                }
            }
        }
        var resizePreferred = false;
        var availablePixels = pixelSize - fixedPixels - prefPixels;
        if (availablePixels < 0) {
            availablePixels = pixelSize - fixedPixels;
            resizePreferred = true;
            totalWeight += totalPrefWeight;
        }
        // assign actual pixel sizes
        var totalSizeGiven = 0;
        var variableSize = 0;
        for (var _a = 0, drawChildren_2 = drawChildren; _a < drawChildren_2.length; _a++) {
            var child = drawChildren_2[_a];
            var prefSize = child._getPrefSize(this.getOrientation());
            if (child._isFixed()) {
                if (prefSize !== undefined) {
                    child._setTempSize(prefSize);
                }
            }
            else {
                if (prefSize == null || resizePreferred) {
                    if (totalWeight === 0) {
                        child._setTempSize(0);
                    }
                    else {
                        var minSize = child.getMinSize(this.getOrientation());
                        var size = Math.floor(availablePixels * (child.getWeight() / totalWeight));
                        child._setTempSize(Math.max(minSize, size));
                    }
                    variableSize += child._getTempSize();
                }
                else {
                    child._setTempSize(prefSize);
                }
            }
            totalSizeGiven += child._getTempSize();
        }
        // adjust sizes to exactly fit
        if (variableSize > 0) {
            while (totalSizeGiven < pixelSize) {
                for (var _b = 0, drawChildren_3 = drawChildren; _b < drawChildren_3.length; _b++) {
                    var child = drawChildren_3[_b];
                    if (!(child instanceof SplitterNode_1.default)) {
                        var prefSize = child._getPrefSize(this.getOrientation());
                        if (!child._isFixed() && (prefSize === undefined || resizePreferred) && totalSizeGiven < pixelSize) {
                            child._setTempSize(child._getTempSize() + 1);
                            totalSizeGiven++;
                        }
                    }
                }
            }
            // decrease size using nodes not at there minimum
            while (totalSizeGiven > pixelSize) {
                var changed = false;
                for (var _c = 0, drawChildren_4 = drawChildren; _c < drawChildren_4.length; _c++) {
                    var child = drawChildren_4[_c];
                    if (!(child instanceof SplitterNode_1.default)) {
                        var minSize = child.getMinSize(this.getOrientation());
                        var size = child._getTempSize();
                        if (size > minSize && totalSizeGiven > pixelSize) {
                            child._setTempSize(child._getTempSize() - 1);
                            totalSizeGiven--;
                            changed = true;
                        }
                    }
                }
                if (!changed) {
                    // all children are at min values
                    break;
                }
            }
            // if still too big then simply reduce all nodes until fits
            while (totalSizeGiven > pixelSize) {
                var changed = false;
                for (var _d = 0, drawChildren_5 = drawChildren; _d < drawChildren_5.length; _d++) {
                    var child = drawChildren_5[_d];
                    if (!(child instanceof SplitterNode_1.default)) {
                        var size = child._getTempSize();
                        if (size > 0 && totalSizeGiven > pixelSize) {
                            child._setTempSize(child._getTempSize() - 1);
                            totalSizeGiven--;
                            changed = true;
                        }
                    }
                }
                if (!changed) {
                    // all children are at 0 values
                    break;
                }
            }
        }
        // layout children
        var p = 0;
        for (var _e = 0, drawChildren_6 = drawChildren; _e < drawChildren_6.length; _e++) {
            var child = drawChildren_6[_e];
            if (this.getOrientation() === Orientation_1.default.HORZ) {
                child._layout(new Rect_1.default(this._rect.x + p, this._rect.y, child._getTempSize(), this._rect.height), metrics);
            }
            else {
                child._layout(new Rect_1.default(this._rect.x, this._rect.y + p, this._rect.width, child._getTempSize()), metrics);
            }
            p += child._getTempSize();
        }
        return true;
    };
    /** @hidden @internal */
    RowNode.prototype._getSplitterBounds = function (splitterNode, useMinSize) {
        if (useMinSize === void 0) { useMinSize = false; }
        var pBounds = [0, 0];
        var drawChildren = this._getDrawChildren();
        var p = drawChildren.indexOf(splitterNode);
        var node1 = drawChildren[p - 1];
        var node2 = drawChildren[p + 1];
        if (this.getOrientation() === Orientation_1.default.HORZ) {
            var minSize1 = useMinSize ? node1.getMinWidth() : 0;
            var minSize2 = useMinSize ? node2.getMinWidth() : 0;
            pBounds[0] = node1.getRect().x + minSize1;
            pBounds[1] = node2.getRect().getRight() - splitterNode.getWidth() - minSize2;
        }
        else {
            var minSize1 = useMinSize ? node1.getMinHeight() : 0;
            var minSize2 = useMinSize ? node2.getMinHeight() : 0;
            pBounds[0] = node1.getRect().y + minSize1;
            pBounds[1] = node2.getRect().getBottom() - splitterNode.getHeight() - minSize2;
        }
        return pBounds;
    };
    /** @hidden @internal */
    RowNode.prototype._calculateSplit = function (splitter, splitterPos) {
        var rtn;
        var drawChildren = this._getDrawChildren();
        var p = drawChildren.indexOf(splitter);
        var pBounds = this._getSplitterBounds(splitter);
        var weightedLength = drawChildren[p - 1].getWeight() + drawChildren[p + 1].getWeight();
        var pixelWidth1 = Math.max(0, splitterPos - pBounds[0]);
        var pixelWidth2 = Math.max(0, pBounds[1] - splitterPos);
        if (pixelWidth1 + pixelWidth2 > 0) {
            var weight1 = (pixelWidth1 * weightedLength) / (pixelWidth1 + pixelWidth2);
            var weight2 = (pixelWidth2 * weightedLength) / (pixelWidth1 + pixelWidth2);
            rtn = {
                node1Id: drawChildren[p - 1].getId(),
                weight1: weight1,
                pixelWidth1: pixelWidth1,
                node2Id: drawChildren[p + 1].getId(),
                weight2: weight2,
                pixelWidth2: pixelWidth2,
            };
        }
        return rtn;
    };
    /** @hidden @internal */
    RowNode.prototype._getDrawChildren = function () {
        if (this._dirty) {
            this._drawChildren = [];
            for (var i = 0; i < this._children.length; i++) {
                var child = this._children[i];
                if (i !== 0) {
                    var newSplitter = new SplitterNode_1.default(this._model);
                    newSplitter._setParent(this);
                    this._drawChildren.push(newSplitter);
                }
                this._drawChildren.push(child);
            }
            this._dirty = false;
        }
        return this._drawChildren;
    };
    /** @hidden @internal */
    RowNode.prototype.getMinSize = function (orientation) {
        if (orientation === Orientation_1.default.HORZ) {
            return this.getMinWidth();
        }
        else {
            return this.getMinHeight();
        }
    };
    /** @hidden @internal */
    RowNode.prototype.getMinWidth = function () {
        return this.minWidth;
    };
    /** @hidden @internal */
    RowNode.prototype.getMinHeight = function () {
        return this.minHeight;
    };
    /** @hidden @internal */
    RowNode.prototype.calcMinSize = function () {
        var _this = this;
        this.minHeight = 0;
        this.minWidth = 0;
        var first = true;
        this._children.forEach(function (child) {
            var c = child;
            if (c instanceof RowNode) {
                c.calcMinSize();
            }
            if (_this.getOrientation() === Orientation_1.default.VERT) {
                _this.minHeight += c.getMinHeight();
                if (!first) {
                    _this.minHeight += _this._model.getSplitterSize();
                }
                _this.minWidth = Math.max(_this.minWidth, c.getMinWidth());
            }
            else {
                _this.minWidth += c.getMinWidth();
                if (!first) {
                    _this.minWidth += _this._model.getSplitterSize();
                }
                _this.minHeight = Math.max(_this.minHeight, c.getMinHeight());
            }
            first = false;
        });
    };
    /** @hidden @internal */
    RowNode.prototype._tidy = function () {
        var i = 0;
        while (i < this._children.length) {
            var child = this._children[i];
            if (child instanceof RowNode) {
                child._tidy();
                var childChildren = child.getChildren();
                if (childChildren.length === 0) {
                    this._removeChild(child);
                }
                else if (childChildren.length === 1) {
                    // hoist child/children up to this level
                    var subchild = childChildren[0];
                    this._removeChild(child);
                    if (subchild instanceof RowNode) {
                        var subChildrenTotal = 0;
                        var subChildChildren = subchild.getChildren();
                        for (var _i = 0, subChildChildren_1 = subChildChildren; _i < subChildChildren_1.length; _i++) {
                            var ssc = subChildChildren_1[_i];
                            var subsubChild = ssc;
                            subChildrenTotal += subsubChild.getWeight();
                        }
                        for (var j = 0; j < subChildChildren.length; j++) {
                            var subsubChild = subChildChildren[j];
                            subsubChild._setWeight((child.getWeight() * subsubChild.getWeight()) / subChildrenTotal);
                            this._addChild(subsubChild, i + j);
                        }
                    }
                    else {
                        subchild._setWeight(child.getWeight());
                        this._addChild(subchild, i);
                    }
                }
                else {
                    i++;
                }
            }
            else if (child instanceof TabSetNode_1.default && child.getChildren().length === 0) {
                if (child.isEnableDeleteWhenEmpty()) {
                    this._removeChild(child);
                    if (child === this._model.getMaximizedTabset()) {
                        this._model._setMaximizedTabset(undefined);
                    }
                }
                else {
                    i++;
                }
            }
            else {
                i++;
            }
        }
        // add tabset into empty root
        if (this === this._model.getRoot() && this._children.length === 0) {
            var callback = this._model._getOnCreateTabSet();
            var child = new TabSetNode_1.default(this._model, callback ? callback() : {});
            this._model._setActiveTabset(child);
            this._addChild(child);
        }
    };
    /** @hidden @internal */
    RowNode.prototype.canDrop = function (dragNode, x, y) {
        var yy = y - this._rect.y;
        var xx = x - this._rect.x;
        var w = this._rect.width;
        var h = this._rect.height;
        var margin = 10; // height of edge rect
        var half = 50; // half width of edge rect
        var dropInfo;
        if (this._model.isEnableEdgeDock() && this._parent === undefined) {
            // _root row
            if (x < this._rect.x + margin && yy > h / 2 - half && yy < h / 2 + half) {
                var dockLocation = DockLocation_1.default.LEFT;
                var outlineRect = dockLocation.getDockRect(this._rect);
                outlineRect.width = outlineRect.width / 2;
                dropInfo = new DropInfo_1.default(this, outlineRect, dockLocation, -1, "flexlayout__outline_rect_edge");
            }
            else if (x > this._rect.getRight() - margin && yy > h / 2 - half && yy < h / 2 + half) {
                var dockLocation = DockLocation_1.default.RIGHT;
                var outlineRect = dockLocation.getDockRect(this._rect);
                outlineRect.width = outlineRect.width / 2;
                outlineRect.x += outlineRect.width;
                dropInfo = new DropInfo_1.default(this, outlineRect, dockLocation, -1, "flexlayout__outline_rect_edge");
            }
            else if (y < this._rect.y + margin && xx > w / 2 - half && xx < w / 2 + half) {
                var dockLocation = DockLocation_1.default.TOP;
                var outlineRect = dockLocation.getDockRect(this._rect);
                outlineRect.height = outlineRect.height / 2;
                dropInfo = new DropInfo_1.default(this, outlineRect, dockLocation, -1, "flexlayout__outline_rect_edge");
            }
            else if (y > this._rect.getBottom() - margin && xx > w / 2 - half && xx < w / 2 + half) {
                var dockLocation = DockLocation_1.default.BOTTOM;
                var outlineRect = dockLocation.getDockRect(this._rect);
                outlineRect.height = outlineRect.height / 2;
                outlineRect.y += outlineRect.height;
                dropInfo = new DropInfo_1.default(this, outlineRect, dockLocation, -1, "flexlayout__outline_rect_edge");
            }
            if (dropInfo !== undefined) {
                if (!dragNode._canDockInto(dragNode, dropInfo)) {
                    return undefined;
                }
            }
        }
        return dropInfo;
    };
    /** @hidden @internal */
    RowNode.prototype.drop = function (dragNode, location, index) {
        var dockLocation = location;
        var parent = dragNode.getParent();
        if (parent) {
            parent._removeChild(dragNode);
        }
        if (parent !== undefined && parent.getType() === TabSetNode_1.default.TYPE) {
            parent._setSelected(0);
        }
        if (parent !== undefined && parent.getType() === BorderNode_1.default.TYPE) {
            parent._setSelected(-1);
        }
        var tabSet;
        if (dragNode instanceof TabSetNode_1.default) {
            tabSet = dragNode;
        }
        else {
            var callback = this._model._getOnCreateTabSet();
            tabSet = new TabSetNode_1.default(this._model, callback ? callback(dragNode) : {});
            tabSet._addChild(dragNode);
        }
        var size = this._children.reduce(function (sum, child) {
            return sum + child.getWeight();
        }, 0);
        if (size === 0) {
            size = 100;
        }
        tabSet._setWeight(size / 3);
        var horz = !this._model.isRootOrientationVertical();
        if (horz && dockLocation === DockLocation_1.default.LEFT || !horz && dockLocation === DockLocation_1.default.TOP) {
            this._addChild(tabSet, 0);
        }
        else if (horz && dockLocation === DockLocation_1.default.RIGHT || !horz && dockLocation === DockLocation_1.default.BOTTOM) {
            this._addChild(tabSet);
        }
        else if (horz && dockLocation === DockLocation_1.default.TOP || !horz && dockLocation === DockLocation_1.default.LEFT) {
            var vrow = new RowNode(this._model, {});
            var hrow_1 = new RowNode(this._model, {});
            hrow_1._setWeight(75);
            tabSet._setWeight(25);
            this._children.forEach(function (child) {
                hrow_1._addChild(child);
            });
            this._removeAll();
            vrow._addChild(tabSet);
            vrow._addChild(hrow_1);
            this._addChild(vrow);
        }
        else if (horz && dockLocation === DockLocation_1.default.BOTTOM || !horz && dockLocation === DockLocation_1.default.RIGHT) {
            var vrow = new RowNode(this._model, {});
            var hrow_2 = new RowNode(this._model, {});
            hrow_2._setWeight(75);
            tabSet._setWeight(25);
            this._children.forEach(function (child) {
                hrow_2._addChild(child);
            });
            this._removeAll();
            vrow._addChild(hrow_2);
            vrow._addChild(tabSet);
            this._addChild(vrow);
        }
        this._model._setActiveTabset(tabSet);
        this._model._tidy();
    };
    RowNode.prototype.toJson = function () {
        var json = {};
        RowNode._attributeDefinitions.toJson(json, this._attributes);
        json.children = [];
        this._children.forEach(function (child) {
            json.children.push(child.toJson());
        });
        return json;
    };
    RowNode.prototype.isEnableDrop = function () {
        return true;
    };
    /** @hidden @internal */
    RowNode.prototype._getPrefSize = function (orientation) {
        var prefSize = this.getWidth();
        if (orientation === Orientation_1.default.VERT) {
            prefSize = this.getHeight();
        }
        return prefSize;
    };
    /** @hidden @internal */
    RowNode.prototype._getAttributeDefinitions = function () {
        return RowNode._attributeDefinitions;
    };
    /** @hidden @internal */
    RowNode.prototype._updateAttrs = function (json) {
        RowNode._attributeDefinitions.update(json, this._attributes);
    };
    /** @hidden @internal */
    RowNode.getAttributeDefinitions = function () {
        return RowNode._attributeDefinitions;
    };
    RowNode.TYPE = "row";
    /** @hidden @internal */
    RowNode._attributeDefinitions = RowNode._createAttributeDefinitions();
    return RowNode;
}(Node_1.default));
exports["default"] = RowNode;
//# sourceMappingURL=RowNode.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/lib/model/SplitterNode.js":
/*!*****************************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/model/SplitterNode.js ***!
  \*****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
var AttributeDefinitions_1 = __webpack_require__(/*! ../AttributeDefinitions */ "./node_modules/flexlayout-react/lib/AttributeDefinitions.js");
var Orientation_1 = __webpack_require__(/*! ../Orientation */ "./node_modules/flexlayout-react/lib/Orientation.js");
var Node_1 = __webpack_require__(/*! ./Node */ "./node_modules/flexlayout-react/lib/model/Node.js");
var SplitterNode = /** @class */ (function (_super) {
    __extends(SplitterNode, _super);
    /** @hidden @internal */
    function SplitterNode(model) {
        var _this = _super.call(this, model) || this;
        _this._fixed = true;
        _this._attributes.type = SplitterNode.TYPE;
        model._addNode(_this);
        return _this;
    }
    /** @hidden @internal */
    SplitterNode.prototype.getWidth = function () {
        return this._model.getSplitterSize();
    };
    /** @hidden @internal */
    SplitterNode.prototype.getMinWidth = function () {
        if (this.getOrientation() === Orientation_1.default.VERT) {
            return this._model.getSplitterSize();
        }
        else {
            return 0;
        }
    };
    /** @hidden @internal */
    SplitterNode.prototype.getHeight = function () {
        return this._model.getSplitterSize();
    };
    /** @hidden @internal */
    SplitterNode.prototype.getMinHeight = function () {
        if (this.getOrientation() === Orientation_1.default.HORZ) {
            return this._model.getSplitterSize();
        }
        else {
            return 0;
        }
    };
    /** @hidden @internal */
    SplitterNode.prototype.getMinSize = function (orientation) {
        if (orientation === Orientation_1.default.HORZ) {
            return this.getMinWidth();
        }
        else {
            return this.getMinHeight();
        }
    };
    /** @hidden @internal */
    SplitterNode.prototype.getWeight = function () {
        return 0;
    };
    /** @hidden @internal */
    SplitterNode.prototype._setWeight = function (value) { };
    /** @hidden @internal */
    SplitterNode.prototype._getPrefSize = function (orientation) {
        return this._model.getSplitterSize();
    };
    /** @hidden @internal */
    SplitterNode.prototype._updateAttrs = function (json) { };
    /** @hidden @internal */
    SplitterNode.prototype._getAttributeDefinitions = function () {
        return new AttributeDefinitions_1.default();
    };
    SplitterNode.prototype.toJson = function () {
        return undefined;
    };
    SplitterNode.TYPE = "splitter";
    return SplitterNode;
}(Node_1.default));
exports["default"] = SplitterNode;
//# sourceMappingURL=SplitterNode.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/lib/model/TabNode.js":
/*!************************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/model/TabNode.js ***!
  \************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
var Attribute_1 = __webpack_require__(/*! ../Attribute */ "./node_modules/flexlayout-react/lib/Attribute.js");
var AttributeDefinitions_1 = __webpack_require__(/*! ../AttributeDefinitions */ "./node_modules/flexlayout-react/lib/AttributeDefinitions.js");
var Node_1 = __webpack_require__(/*! ./Node */ "./node_modules/flexlayout-react/lib/model/Node.js");
var TabNode = /** @class */ (function (_super) {
    __extends(TabNode, _super);
    /** @hidden @internal */
    function TabNode(model, json, addToModel) {
        if (addToModel === void 0) { addToModel = true; }
        var _this = _super.call(this, model) || this;
        _this._extra = {}; // extra data added to node not saved in json
        TabNode._attributeDefinitions.fromJson(json, _this._attributes);
        if (addToModel === true) {
            model._addNode(_this);
        }
        return _this;
    }
    /** @hidden @internal */
    TabNode._fromJson = function (json, model, addToModel) {
        if (addToModel === void 0) { addToModel = true; }
        var newLayoutNode = new TabNode(model, json, addToModel);
        return newLayoutNode;
    };
    /** @hidden @internal */
    TabNode._createAttributeDefinitions = function () {
        var attributeDefinitions = new AttributeDefinitions_1.default();
        attributeDefinitions.add("type", TabNode.TYPE, true).setType(Attribute_1.default.STRING);
        attributeDefinitions.add("id", undefined).setType(Attribute_1.default.STRING);
        attributeDefinitions.add("name", "[Unnamed Tab]").setType(Attribute_1.default.STRING);
        attributeDefinitions.add("helpText", undefined).setType(Attribute_1.default.STRING);
        attributeDefinitions.add("component", undefined).setType(Attribute_1.default.STRING);
        attributeDefinitions.add("config", undefined).setType("any");
        attributeDefinitions.add("floating", false).setType(Attribute_1.default.BOOLEAN);
        attributeDefinitions.addInherited("enableClose", "tabEnableClose").setType(Attribute_1.default.BOOLEAN);
        attributeDefinitions.addInherited("closeType", "tabCloseType").setType("ICloseType");
        attributeDefinitions.addInherited("enableDrag", "tabEnableDrag").setType(Attribute_1.default.BOOLEAN);
        attributeDefinitions.addInherited("enableRename", "tabEnableRename").setType(Attribute_1.default.BOOLEAN);
        attributeDefinitions.addInherited("className", "tabClassName").setType(Attribute_1.default.STRING);
        attributeDefinitions.addInherited("icon", "tabIcon").setType(Attribute_1.default.STRING);
        attributeDefinitions.addInherited("enableRenderOnDemand", "tabEnableRenderOnDemand").setType(Attribute_1.default.BOOLEAN);
        attributeDefinitions.addInherited("enableFloat", "tabEnableFloat").setType(Attribute_1.default.BOOLEAN);
        attributeDefinitions.addInherited("borderWidth", "tabBorderWidth").setType(Attribute_1.default.NUMBER);
        attributeDefinitions.addInherited("borderHeight", "tabBorderHeight").setType(Attribute_1.default.NUMBER);
        return attributeDefinitions;
    };
    TabNode.prototype.getWindow = function () {
        return this._window;
    };
    TabNode.prototype.getTabRect = function () {
        return this._tabRect;
    };
    /** @hidden @internal */
    TabNode.prototype._setTabRect = function (rect) {
        this._tabRect = rect;
    };
    /** @hidden @internal */
    TabNode.prototype._setRenderedName = function (name) {
        this._renderedName = name;
    };
    /** @hidden @internal */
    TabNode.prototype._getRenderedName = function () {
        return this._renderedName;
    };
    TabNode.prototype.getName = function () {
        return this._getAttr("name");
    };
    TabNode.prototype.getHelpText = function () {
        return this._getAttr("helpText");
    };
    TabNode.prototype.getComponent = function () {
        return this._getAttr("component");
    };
    /**
     * Returns the config attribute that can be used to store node specific data that
     * WILL be saved to the json. The config attribute should be changed via the action Actions.updateNodeAttributes rather
     * than directly, for example:
     * this.state.model.doAction(
     *   FlexLayout.Actions.updateNodeAttributes(node.getId(), {config:myConfigObject}));
     */
    TabNode.prototype.getConfig = function () {
        return this._attributes.config;
    };
    /**
     * Returns an object that can be used to store transient node specific data that will
     * NOT be saved in the json.
     */
    TabNode.prototype.getExtraData = function () {
        return this._extra;
    };
    TabNode.prototype.isFloating = function () {
        return this._getAttr("floating");
    };
    TabNode.prototype.getIcon = function () {
        return this._getAttr("icon");
    };
    TabNode.prototype.isEnableClose = function () {
        return this._getAttr("enableClose");
    };
    TabNode.prototype.getCloseType = function () {
        return this._getAttr("closeType");
    };
    TabNode.prototype.isEnableFloat = function () {
        return this._getAttr("enableFloat");
    };
    TabNode.prototype.isEnableDrag = function () {
        return this._getAttr("enableDrag");
    };
    TabNode.prototype.isEnableRename = function () {
        return this._getAttr("enableRename");
    };
    TabNode.prototype.getClassName = function () {
        return this._getAttr("className");
    };
    TabNode.prototype.isEnableRenderOnDemand = function () {
        return this._getAttr("enableRenderOnDemand");
    };
    /** @hidden @internal */
    TabNode.prototype._setName = function (name) {
        this._attributes.name = name;
        if (this._window && this._window.document) {
            this._window.document.title = name;
        }
    };
    /** @hidden @internal */
    TabNode.prototype._setFloating = function (float) {
        this._attributes.floating = float;
    };
    /** @hidden @internal */
    TabNode.prototype._layout = function (rect, metrics) {
        if (!rect.equals(this._rect)) {
            this._fireEvent("resize", { rect: rect });
        }
        this._rect = rect;
    };
    /** @hidden @internal */
    TabNode.prototype._delete = function () {
        this._parent._remove(this);
        this._fireEvent("close", {});
    };
    TabNode.prototype.toJson = function () {
        var json = {};
        TabNode._attributeDefinitions.toJson(json, this._attributes);
        return json;
    };
    /** @hidden @internal */
    TabNode.prototype._updateAttrs = function (json) {
        TabNode._attributeDefinitions.update(json, this._attributes);
    };
    /** @hidden @internal */
    TabNode.prototype._getAttributeDefinitions = function () {
        return TabNode._attributeDefinitions;
    };
    /** @hidden @internal */
    TabNode.prototype._setWindow = function (window) {
        this._window = window;
    };
    /** @hidden @internal */
    TabNode.prototype._setBorderWidth = function (width) {
        this._attributes.borderWidth = width;
    };
    /** @hidden @internal */
    TabNode.prototype._setBorderHeight = function (height) {
        this._attributes.borderHeight = height;
    };
    /** @hidden @internal */
    TabNode.getAttributeDefinitions = function () {
        return TabNode._attributeDefinitions;
    };
    TabNode.TYPE = "tab";
    /** @hidden @internal */
    TabNode._attributeDefinitions = TabNode._createAttributeDefinitions();
    return TabNode;
}(Node_1.default));
exports["default"] = TabNode;
//# sourceMappingURL=TabNode.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/lib/model/TabSetNode.js":
/*!***************************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/model/TabSetNode.js ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
var Attribute_1 = __webpack_require__(/*! ../Attribute */ "./node_modules/flexlayout-react/lib/Attribute.js");
var AttributeDefinitions_1 = __webpack_require__(/*! ../AttributeDefinitions */ "./node_modules/flexlayout-react/lib/AttributeDefinitions.js");
var DockLocation_1 = __webpack_require__(/*! ../DockLocation */ "./node_modules/flexlayout-react/lib/DockLocation.js");
var DropInfo_1 = __webpack_require__(/*! ../DropInfo */ "./node_modules/flexlayout-react/lib/DropInfo.js");
var Orientation_1 = __webpack_require__(/*! ../Orientation */ "./node_modules/flexlayout-react/lib/Orientation.js");
var Rect_1 = __webpack_require__(/*! ../Rect */ "./node_modules/flexlayout-react/lib/Rect.js");
var Node_1 = __webpack_require__(/*! ./Node */ "./node_modules/flexlayout-react/lib/model/Node.js");
var RowNode_1 = __webpack_require__(/*! ./RowNode */ "./node_modules/flexlayout-react/lib/model/RowNode.js");
var TabNode_1 = __webpack_require__(/*! ./TabNode */ "./node_modules/flexlayout-react/lib/model/TabNode.js");
var Utils_1 = __webpack_require__(/*! ./Utils */ "./node_modules/flexlayout-react/lib/model/Utils.js");
var TabSetNode = /** @class */ (function (_super) {
    __extends(TabSetNode, _super);
    /** @hidden @internal */
    function TabSetNode(model, json) {
        var _this = _super.call(this, model) || this;
        TabSetNode._attributeDefinitions.fromJson(json, _this._attributes);
        model._addNode(_this);
        _this.calculatedTabBarHeight = 0;
        _this.calculatedHeaderBarHeight = 0;
        return _this;
    }
    /** @hidden @internal */
    TabSetNode._fromJson = function (json, model) {
        var newLayoutNode = new TabSetNode(model, json);
        if (json.children != null) {
            json.children.forEach(function (jsonChild) {
                var child = TabNode_1.default._fromJson(jsonChild, model);
                newLayoutNode._addChild(child);
            });
        }
        if (json.maximized && json.maximized === true) {
            model._setMaximizedTabset(newLayoutNode);
        }
        if (json.active && json.active === true) {
            model._setActiveTabset(newLayoutNode);
        }
        return newLayoutNode;
    };
    /** @hidden @internal */
    TabSetNode._createAttributeDefinitions = function () {
        var attributeDefinitions = new AttributeDefinitions_1.default();
        attributeDefinitions.add("type", TabSetNode.TYPE, true).setType(Attribute_1.default.STRING).setFixed();
        attributeDefinitions.add("id", undefined).setType(Attribute_1.default.STRING);
        attributeDefinitions.add("weight", 100).setType(Attribute_1.default.NUMBER);
        attributeDefinitions.add("width", undefined).setType(Attribute_1.default.NUMBER);
        attributeDefinitions.add("height", undefined).setType(Attribute_1.default.NUMBER);
        attributeDefinitions.add("selected", 0).setType(Attribute_1.default.NUMBER);
        attributeDefinitions.add("name", undefined).setType(Attribute_1.default.STRING);
        attributeDefinitions.add("config", undefined).setType("any");
        attributeDefinitions.addInherited("enableDeleteWhenEmpty", "tabSetEnableDeleteWhenEmpty");
        attributeDefinitions.addInherited("enableDrop", "tabSetEnableDrop");
        attributeDefinitions.addInherited("enableDrag", "tabSetEnableDrag");
        attributeDefinitions.addInherited("enableDivide", "tabSetEnableDivide");
        attributeDefinitions.addInherited("enableMaximize", "tabSetEnableMaximize");
        attributeDefinitions.addInherited("enableClose", "tabSetEnableClose");
        attributeDefinitions.addInherited("classNameTabStrip", "tabSetClassNameTabStrip");
        attributeDefinitions.addInherited("classNameHeader", "tabSetClassNameHeader");
        attributeDefinitions.addInherited("enableTabStrip", "tabSetEnableTabStrip");
        attributeDefinitions.addInherited("borderInsets", "tabSetBorderInsets");
        attributeDefinitions.addInherited("marginInsets", "tabSetMarginInsets");
        attributeDefinitions.addInherited("minWidth", "tabSetMinWidth");
        attributeDefinitions.addInherited("minHeight", "tabSetMinHeight");
        attributeDefinitions.addInherited("headerHeight", "tabSetHeaderHeight");
        attributeDefinitions.addInherited("tabStripHeight", "tabSetTabStripHeight");
        attributeDefinitions.addInherited("tabLocation", "tabSetTabLocation");
        attributeDefinitions.addInherited("autoSelectTab", "tabSetAutoSelectTab").setType(Attribute_1.default.BOOLEAN);
        return attributeDefinitions;
    };
    TabSetNode.prototype.getName = function () {
        return this._getAttr("name");
    };
    TabSetNode.prototype.getSelected = function () {
        var selected = this._attributes.selected;
        if (selected !== undefined) {
            return selected;
        }
        return -1;
    };
    TabSetNode.prototype.getSelectedNode = function () {
        var selected = this.getSelected();
        if (selected !== -1) {
            return this._children[selected];
        }
        return undefined;
    };
    TabSetNode.prototype.getWeight = function () {
        return this._getAttr("weight");
    };
    TabSetNode.prototype.getWidth = function () {
        return this._getAttr("width");
    };
    TabSetNode.prototype.getMinWidth = function () {
        return this._getAttr("minWidth");
    };
    TabSetNode.prototype.getHeight = function () {
        return this._getAttr("height");
    };
    TabSetNode.prototype.getMinHeight = function () {
        return this._getAttr("minHeight");
    };
    /** @hidden @internal */
    TabSetNode.prototype.getMinSize = function (orientation) {
        if (orientation === Orientation_1.default.HORZ) {
            return this.getMinWidth();
        }
        else {
            return this.getMinHeight();
        }
    };
    /**
     * Returns the config attribute that can be used to store node specific data that
     * WILL be saved to the json. The config attribute should be changed via the action Actions.updateNodeAttributes rather
     * than directly, for example:
     * this.state.model.doAction(
     *   FlexLayout.Actions.updateNodeAttributes(node.getId(), {config:myConfigObject}));
     */
    TabSetNode.prototype.getConfig = function () {
        return this._attributes.config;
    };
    TabSetNode.prototype.isMaximized = function () {
        return this._model.getMaximizedTabset() === this;
    };
    TabSetNode.prototype.isActive = function () {
        return this._model.getActiveTabset() === this;
    };
    TabSetNode.prototype.isEnableDeleteWhenEmpty = function () {
        return this._getAttr("enableDeleteWhenEmpty");
    };
    TabSetNode.prototype.isEnableDrop = function () {
        return this._getAttr("enableDrop");
    };
    TabSetNode.prototype.isEnableDrag = function () {
        return this._getAttr("enableDrag");
    };
    TabSetNode.prototype.isEnableDivide = function () {
        return this._getAttr("enableDivide");
    };
    TabSetNode.prototype.isEnableMaximize = function () {
        return this._getAttr("enableMaximize");
    };
    TabSetNode.prototype.isEnableClose = function () {
        return this._getAttr("enableClose");
    };
    TabSetNode.prototype.canMaximize = function () {
        if (this.isEnableMaximize()) {
            // always allow maximize toggle if already maximized
            if (this.getModel().getMaximizedTabset() === this) {
                return true;
            }
            // only one tabset, so disable
            if (this.getParent() === this.getModel().getRoot() && this.getModel().getRoot().getChildren().length === 1) {
                return false;
            }
            return true;
        }
        return false;
    };
    TabSetNode.prototype.isEnableTabStrip = function () {
        return this._getAttr("enableTabStrip");
    };
    TabSetNode.prototype.isAutoSelectTab = function () {
        return this._getAttr("autoSelectTab");
    };
    TabSetNode.prototype.getClassNameTabStrip = function () {
        return this._getAttr("classNameTabStrip");
    };
    TabSetNode.prototype.getClassNameHeader = function () {
        return this._getAttr("classNameHeader");
    };
    /** @hidden @internal */
    TabSetNode.prototype.calculateHeaderBarHeight = function (metrics) {
        var headerBarHeight = this._getAttr("headerHeight");
        if (headerBarHeight !== 0) {
            // its defined
            this.calculatedHeaderBarHeight = headerBarHeight;
        }
        else {
            this.calculatedHeaderBarHeight = metrics.headerBarSize;
        }
    };
    /** @hidden @internal */
    TabSetNode.prototype.calculateTabBarHeight = function (metrics) {
        var tabBarHeight = this._getAttr("tabStripHeight");
        if (tabBarHeight !== 0) {
            // its defined
            this.calculatedTabBarHeight = tabBarHeight;
        }
        else {
            this.calculatedTabBarHeight = metrics.tabBarSize;
        }
    };
    TabSetNode.prototype.getHeaderHeight = function () {
        return this.calculatedHeaderBarHeight;
    };
    TabSetNode.prototype.getTabStripHeight = function () {
        return this.calculatedTabBarHeight;
    };
    TabSetNode.prototype.getTabLocation = function () {
        return this._getAttr("tabLocation");
    };
    /** @hidden @internal */
    TabSetNode.prototype._setWeight = function (weight) {
        this._attributes.weight = weight;
    };
    /** @hidden @internal */
    TabSetNode.prototype._setSelected = function (index) {
        this._attributes.selected = index;
    };
    /** @hidden @internal */
    TabSetNode.prototype.canDrop = function (dragNode, x, y) {
        var dropInfo;
        if (dragNode === this) {
            var dockLocation = DockLocation_1.default.CENTER;
            var outlineRect = this._tabHeaderRect;
            dropInfo = new DropInfo_1.default(this, outlineRect, dockLocation, -1, "flexlayout__outline_rect");
        }
        else if (this._contentRect.contains(x, y)) {
            var dockLocation = DockLocation_1.default.getLocation(this._contentRect, x, y);
            var outlineRect = dockLocation.getDockRect(this._rect);
            dropInfo = new DropInfo_1.default(this, outlineRect, dockLocation, -1, "flexlayout__outline_rect");
        }
        else if (this._tabHeaderRect != null && this._tabHeaderRect.contains(x, y)) {
            var r = void 0;
            var yy = void 0;
            var h = void 0;
            if (this._children.length === 0) {
                r = this._tabHeaderRect.clone();
                yy = r.y + 3;
                h = r.height - 4;
                r.width = 2;
            }
            else {
                var child = this._children[0];
                r = child.getTabRect();
                yy = r.y;
                h = r.height;
                var p = this._tabHeaderRect.x;
                var childCenter = 0;
                for (var i = 0; i < this._children.length; i++) {
                    child = this._children[i];
                    r = child.getTabRect();
                    childCenter = r.x + r.width / 2;
                    if (x >= p && x < childCenter) {
                        var dockLocation = DockLocation_1.default.CENTER;
                        var outlineRect = new Rect_1.default(r.x - 2, yy, 3, h);
                        dropInfo = new DropInfo_1.default(this, outlineRect, dockLocation, i, "flexlayout__outline_rect");
                        break;
                    }
                    p = childCenter;
                }
            }
            if (dropInfo == null) {
                var dockLocation = DockLocation_1.default.CENTER;
                var outlineRect = new Rect_1.default(r.getRight() - 2, yy, 3, h);
                dropInfo = new DropInfo_1.default(this, outlineRect, dockLocation, this._children.length, "flexlayout__outline_rect");
            }
        }
        if (!dragNode._canDockInto(dragNode, dropInfo)) {
            return undefined;
        }
        return dropInfo;
    };
    /** @hidden @internal */
    TabSetNode.prototype._layout = function (rect, metrics) {
        var _this = this;
        this.calculateHeaderBarHeight(metrics);
        this.calculateTabBarHeight(metrics);
        if (this.isMaximized()) {
            rect = this._model.getRoot().getRect();
        }
        rect = rect.removeInsets(this._getAttr("marginInsets"));
        this._rect = rect;
        rect = rect.removeInsets(this._getAttr("borderInsets"));
        var showHeader = this.getName() !== undefined;
        var y = 0;
        var h = 0;
        if (showHeader) {
            y += this.calculatedHeaderBarHeight;
            h += this.calculatedHeaderBarHeight;
        }
        if (this.isEnableTabStrip()) {
            if (this.getTabLocation() === "top") {
                this._tabHeaderRect = new Rect_1.default(rect.x, rect.y + y, rect.width, this.calculatedTabBarHeight);
            }
            else {
                this._tabHeaderRect = new Rect_1.default(rect.x, rect.y + rect.height - this.calculatedTabBarHeight, rect.width, this.calculatedTabBarHeight);
            }
            h += this.calculatedTabBarHeight;
            if (this.getTabLocation() === "top") {
                y += this.calculatedTabBarHeight;
            }
        }
        this._contentRect = new Rect_1.default(rect.x, rect.y + y, rect.width, rect.height - h);
        this._children.forEach(function (child, i) {
            child._layout(_this._contentRect, metrics);
            child._setVisible(i === _this.getSelected());
        });
    };
    /** @hidden @internal */
    TabSetNode.prototype._delete = function () {
        this._parent._removeChild(this);
    };
    /** @hidden @internal */
    TabSetNode.prototype._remove = function (node) {
        var removedIndex = this._removeChild(node);
        this._model._tidy();
        Utils_1.adjustSelectedIndex(this, removedIndex);
    };
    /** @hidden @internal */
    TabSetNode.prototype.drop = function (dragNode, location, index, select) {
        var _this = this;
        var dockLocation = location;
        if (this === dragNode) {
            // tabset drop into itself
            return; // dock back to itself
        }
        var dragParent = dragNode.getParent();
        var fromIndex = 0;
        if (dragParent !== undefined) {
            fromIndex = dragParent._removeChild(dragNode);
            Utils_1.adjustSelectedIndex(dragParent, fromIndex);
        }
        // if dropping a tab back to same tabset and moving to forward position then reduce insertion index
        if (dragNode.getType() === TabNode_1.default.TYPE && dragParent === this && fromIndex < index && index > 0) {
            index--;
        }
        // simple_bundled dock to existing tabset
        if (dockLocation === DockLocation_1.default.CENTER) {
            var insertPos_1 = index;
            if (insertPos_1 === -1) {
                insertPos_1 = this._children.length;
            }
            if (dragNode.getType() === TabNode_1.default.TYPE) {
                this._addChild(dragNode, insertPos_1);
                if (select || (select !== false && this.isAutoSelectTab())) {
                    this._setSelected(insertPos_1);
                }
                // console.log("added child at : " + insertPos);
            }
            else {
                dragNode.getChildren().forEach(function (child, i) {
                    _this._addChild(child, insertPos_1);
                    // console.log("added child at : " + insertPos);
                    insertPos_1++;
                });
            }
            this._model._setActiveTabset(this);
        }
        else {
            var tabSet = void 0;
            if (dragNode instanceof TabNode_1.default) {
                // create new tabset parent
                // console.log("create a new tabset");
                var callback = this._model._getOnCreateTabSet();
                tabSet = new TabSetNode(this._model, callback ? callback(dragNode) : {});
                tabSet._addChild(dragNode);
                // console.log("added child at end");
                dragParent = tabSet;
            }
            else {
                tabSet = dragNode;
            }
            var parentRow = this._parent;
            var pos = parentRow.getChildren().indexOf(this);
            if (parentRow.getOrientation() === dockLocation._orientation) {
                tabSet._setWeight(this.getWeight() / 2);
                this._setWeight(this.getWeight() / 2);
                // console.log("added child 50% size at: " +  pos + dockLocation.indexPlus);
                parentRow._addChild(tabSet, pos + dockLocation._indexPlus);
            }
            else {
                // create a new row to host the new tabset (it will go in the opposite direction)
                // console.log("create a new row");
                var newRow = new RowNode_1.default(this._model, {});
                newRow._setWeight(this.getWeight());
                newRow._addChild(this);
                this._setWeight(50);
                tabSet._setWeight(50);
                // console.log("added child 50% size at: " +  dockLocation.indexPlus);
                newRow._addChild(tabSet, dockLocation._indexPlus);
                parentRow._removeChild(this);
                parentRow._addChild(newRow, pos);
            }
            this._model._setActiveTabset(tabSet);
        }
        this._model._tidy();
    };
    TabSetNode.prototype.toJson = function () {
        var json = {};
        TabSetNode._attributeDefinitions.toJson(json, this._attributes);
        json.children = this._children.map(function (child) { return child.toJson(); });
        if (this.isActive()) {
            json.active = true;
        }
        if (this.isMaximized()) {
            json.maximized = true;
        }
        return json;
    };
    /** @hidden @internal */
    TabSetNode.prototype._updateAttrs = function (json) {
        TabSetNode._attributeDefinitions.update(json, this._attributes);
    };
    /** @hidden @internal */
    TabSetNode.prototype._getAttributeDefinitions = function () {
        return TabSetNode._attributeDefinitions;
    };
    /** @hidden @internal */
    TabSetNode.prototype._getPrefSize = function (orientation) {
        var prefSize = this.getWidth();
        if (orientation === Orientation_1.default.VERT) {
            prefSize = this.getHeight();
        }
        return prefSize;
    };
    /** @hidden @internal */
    TabSetNode.getAttributeDefinitions = function () {
        return TabSetNode._attributeDefinitions;
    };
    TabSetNode.TYPE = "tabset";
    /** @hidden @internal */
    TabSetNode._attributeDefinitions = TabSetNode._createAttributeDefinitions();
    return TabSetNode;
}(Node_1.default));
exports["default"] = TabSetNode;
//# sourceMappingURL=TabSetNode.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/lib/model/Utils.js":
/*!**********************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/model/Utils.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.adjustSelectedIndex = exports.adjustSelectedIndexAfterDock = exports.adjustSelectedIndexAfterFloat = void 0;
var TabSetNode_1 = __webpack_require__(/*! ./TabSetNode */ "./node_modules/flexlayout-react/lib/model/TabSetNode.js");
var BorderNode_1 = __webpack_require__(/*! ./BorderNode */ "./node_modules/flexlayout-react/lib/model/BorderNode.js");
/** @hidden @internal */
function adjustSelectedIndexAfterFloat(node) {
    var parent = node.getParent();
    if (parent !== null) {
        if (parent instanceof TabSetNode_1.default) {
            var found = false;
            var newSelected = 0;
            var children = parent.getChildren();
            for (var i = 0; i < children.length; i++) {
                var child = children[i];
                if (child === node) {
                    found = true;
                }
                else {
                    if (!child.isFloating()) {
                        newSelected = i;
                        if (found)
                            break;
                    }
                }
            }
            parent._setSelected(newSelected);
        }
        else if (parent instanceof BorderNode_1.default) {
            parent._setSelected(-1);
        }
    }
}
exports.adjustSelectedIndexAfterFloat = adjustSelectedIndexAfterFloat;
/** @hidden @internal */
function adjustSelectedIndexAfterDock(node) {
    var parent = node.getParent();
    if (parent !== null && (parent instanceof TabSetNode_1.default || parent instanceof BorderNode_1.default)) {
        var children = parent.getChildren();
        for (var i = 0; i < children.length; i++) {
            var child = children[i];
            if (child === node) {
                parent._setSelected(i);
                return;
            }
        }
    }
}
exports.adjustSelectedIndexAfterDock = adjustSelectedIndexAfterDock;
/** @hidden @internal */
function adjustSelectedIndex(parent, removedIndex) {
    // for the tabset/border being removed from set the selected index
    if (parent !== undefined && (parent.getType() === TabSetNode_1.default.TYPE || parent.getType() === BorderNode_1.default.TYPE)) {
        var selectedIndex = parent.getSelected();
        if (selectedIndex !== -1) {
            if (removedIndex === selectedIndex && parent.getChildren().length > 0) {
                if (removedIndex >= parent.getChildren().length) {
                    // removed last tab; select new last tab
                    parent._setSelected(parent.getChildren().length - 1);
                }
                else {
                    // leave selected index as is, selecting next tab after this one
                }
            }
            else if (removedIndex < selectedIndex) {
                parent._setSelected(selectedIndex - 1);
            }
            else if (removedIndex > selectedIndex) {
                // leave selected index as is
            }
            else {
                parent._setSelected(-1);
            }
        }
    }
}
exports.adjustSelectedIndex = adjustSelectedIndex;
//# sourceMappingURL=Utils.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/lib/view/BorderButton.js":
/*!****************************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/view/BorderButton.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BorderButton = void 0;
var React = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
var __1 = __webpack_require__(/*! .. */ "./node_modules/flexlayout-react/lib/index.js");
var Actions_1 = __webpack_require__(/*! ../model/Actions */ "./node_modules/flexlayout-react/lib/model/Actions.js");
var Rect_1 = __webpack_require__(/*! ../Rect */ "./node_modules/flexlayout-react/lib/Rect.js");
var ICloseType_1 = __webpack_require__(/*! ../model/ICloseType */ "./node_modules/flexlayout-react/lib/model/ICloseType.js");
var Types_1 = __webpack_require__(/*! ../Types */ "./node_modules/flexlayout-react/lib/Types.js");
/** @hidden @internal */
var BorderButton = function (props) {
    var layout = props.layout, node = props.node, selected = props.selected, border = props.border, iconFactory = props.iconFactory, titleFactory = props.titleFactory, icons = props.icons;
    var selfRef = React.useRef(null);
    var onMouseDown = function (event) {
        var message = layout.i18nName(__1.I18nLabel.Move_Tab, node.getName());
        props.layout.dragStart(event, message, node, node.isEnableDrag(), onClick, function (event2) { return undefined; });
    };
    var onClick = function () {
        layout.doAction(Actions_1.default.selectTab(node.getId()));
    };
    var isClosable = function () {
        var closeType = node.getCloseType();
        if (selected || closeType === ICloseType_1.ICloseType.Always) {
            return true;
        }
        if (closeType === ICloseType_1.ICloseType.Visible) {
            // not selected but x should be visible due to hover
            if (window.matchMedia && window.matchMedia("(hover: hover) and (pointer: fine)").matches) {
                return true;
            }
        }
        return false;
    };
    var onClose = function (event) {
        if (isClosable()) {
            layout.doAction(Actions_1.default.deleteTab(node.getId()));
        }
        else {
            onClick();
        }
    };
    var onCloseMouseDown = function (event) {
        event.stopPropagation();
    };
    React.useLayoutEffect(function () {
        updateRect();
    });
    var updateRect = function () {
        // record position of tab in border
        var clientRect = layout.getDomRect();
        var r = selfRef.current.getBoundingClientRect();
        node._setTabRect(new Rect_1.default(r.left - clientRect.left, r.top - clientRect.top, r.width, r.height));
    };
    var cm = layout.getClassName;
    var classNames = cm(Types_1.CLASSES.FLEXLAYOUT__BORDER_BUTTON) + " " + cm(Types_1.CLASSES.FLEXLAYOUT__BORDER_BUTTON_ + border);
    if (selected) {
        classNames += " " + cm(Types_1.CLASSES.FLEXLAYOUT__BORDER_BUTTON__SELECTED);
    }
    else {
        classNames += " " + cm(Types_1.CLASSES.FLEXLAYOUT__BORDER_BUTTON__UNSELECTED);
    }
    if (node.getClassName() !== undefined) {
        classNames += " " + node.getClassName();
    }
    var leadingContent = iconFactory ? iconFactory(node) : undefined;
    var titleContent = node.getName();
    var name = node.getName();
    function isTitleObject(obj) {
        return obj.titleContent !== undefined;
    }
    if (titleFactory !== undefined) {
        var titleObj = titleFactory(node);
        if (titleObj !== undefined) {
            if (typeof titleObj === "string") {
                titleContent = titleObj;
                name = titleObj;
            }
            else if (isTitleObject(titleObj)) {
                titleContent = titleObj.titleContent;
                name = titleObj.name;
            }
            else {
                titleContent = titleObj;
            }
        }
    }
    if (typeof leadingContent === undefined && typeof node.getIcon() !== undefined) {
        leadingContent = React.createElement("img", { src: node.getIcon(), alt: "leadingContent" });
    }
    var buttons = [];
    // allow customization of leading contents (icon) and contents
    var renderState = { leading: leadingContent, content: titleContent, name: name, buttons: buttons };
    layout.customizeTab(node, renderState);
    node._setRenderedName(renderState.name);
    var content = React.createElement("div", { className: cm(Types_1.CLASSES.FLEXLAYOUT__BORDER_BUTTON_CONTENT) }, renderState.content);
    var leading = React.createElement("div", { className: cm(Types_1.CLASSES.FLEXLAYOUT__BORDER_BUTTON_LEADING) }, renderState.leading);
    if (node.isEnableClose()) {
        var closeTitle = layout.i18nName(__1.I18nLabel.Close_Tab);
        buttons.push(React.createElement("div", { key: "close", title: closeTitle, className: cm(Types_1.CLASSES.FLEXLAYOUT__BORDER_BUTTON_TRAILING), onMouseDown: onCloseMouseDown, onClick: onClose, onTouchStart: onCloseMouseDown }, icons === null || icons === void 0 ? void 0 : icons.close));
    }
    return (React.createElement("div", { ref: selfRef, style: {}, className: classNames, onMouseDown: onMouseDown, onTouchStart: onMouseDown, title: node.getHelpText() },
        leading,
        content,
        buttons));
};
exports.BorderButton = BorderButton;
//# sourceMappingURL=BorderButton.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/lib/view/BorderTabSet.js":
/*!****************************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/view/BorderTabSet.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BorderTabSet = void 0;
var React = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
var DockLocation_1 = __webpack_require__(/*! ../DockLocation */ "./node_modules/flexlayout-react/lib/DockLocation.js");
var BorderButton_1 = __webpack_require__(/*! ./BorderButton */ "./node_modules/flexlayout-react/lib/view/BorderButton.js");
var PopupMenu_1 = __webpack_require__(/*! ../PopupMenu */ "./node_modules/flexlayout-react/lib/PopupMenu.js");
var Actions_1 = __webpack_require__(/*! ../model/Actions */ "./node_modules/flexlayout-react/lib/model/Actions.js");
var I18nLabel_1 = __webpack_require__(/*! ../I18nLabel */ "./node_modules/flexlayout-react/lib/I18nLabel.js");
var TabOverflowHook_1 = __webpack_require__(/*! ./TabOverflowHook */ "./node_modules/flexlayout-react/lib/view/TabOverflowHook.js");
var Orientation_1 = __webpack_require__(/*! ../Orientation */ "./node_modules/flexlayout-react/lib/Orientation.js");
var Types_1 = __webpack_require__(/*! ../Types */ "./node_modules/flexlayout-react/lib/Types.js");
/** @hidden @internal */
var BorderTabSet = function (props) {
    var border = props.border, layout = props.layout, iconFactory = props.iconFactory, titleFactory = props.titleFactory, icons = props.icons;
    var toolbarRef = React.useRef(null);
    var overflowbuttonRef = React.useRef(null);
    var stickyButtonsRef = React.useRef(null);
    var _a = TabOverflowHook_1.useTabOverflow(border, Orientation_1.default.flip(border.getOrientation()), toolbarRef, stickyButtonsRef), selfRef = _a.selfRef, position = _a.position, userControlledLeft = _a.userControlledLeft, hiddenTabs = _a.hiddenTabs, onMouseWheel = _a.onMouseWheel;
    var onInterceptMouseDown = function (event) {
        event.stopPropagation();
    };
    var onOverflowClick = function () {
        var element = overflowbuttonRef.current;
        PopupMenu_1.showPopup(layout.getRootDiv(), element, hiddenTabs, onOverflowItemSelect, layout.getClassName);
    };
    var onOverflowItemSelect = function (item) {
        layout.doAction(Actions_1.default.selectTab(item.node.getId()));
        userControlledLeft.current = false;
    };
    var onFloatTab = function () {
        var selectedTabNode = border.getChildren()[border.getSelected()];
        if (selectedTabNode !== undefined) {
            layout.doAction(Actions_1.default.floatTab(selectedTabNode.getId()));
        }
    };
    var cm = layout.getClassName;
    var style = border.getTabHeaderRect().styleWithPosition({});
    var tabs = [];
    var layoutTab = function (i) {
        var isSelected = border.getSelected() === i;
        var child = border.getChildren()[i];
        tabs.push(React.createElement(BorderButton_1.BorderButton, { layout: layout, border: border.getLocation().getName(), node: child, key: child.getId(), selected: isSelected, iconFactory: iconFactory, titleFactory: titleFactory, icons: icons }));
    };
    for (var i = 0; i < border.getChildren().length; i++) {
        layoutTab(i);
    }
    var borderClasses = cm(Types_1.CLASSES.FLEXLAYOUT__BORDER) + " " + cm(Types_1.CLASSES.FLEXLAYOUT__BORDER_ + border.getLocation().getName());
    if (border.getClassName() !== undefined) {
        borderClasses += " " + border.getClassName();
    }
    // allow customization of tabset right/bottom buttons
    var buttons = [];
    var renderState = { headerContent: {}, buttons: buttons, stickyButtons: [], headerButtons: [] };
    layout.customizeTabSet(border, renderState);
    buttons = renderState.buttons;
    var toolbar;
    if (hiddenTabs.length > 0) {
        var overflowTitle = layout.i18nName(I18nLabel_1.I18nLabel.Overflow_Menu_Tooltip);
        buttons.push(React.createElement("button", { key: "overflowbutton", ref: overflowbuttonRef, className: cm("flexlayout__border_toolbar_button_overflow") + " " + cm("flexlayout__border_toolbar_button_overflow_" + border.getLocation().getName()), title: overflowTitle, onClick: onOverflowClick, onMouseDown: onInterceptMouseDown, onTouchStart: onInterceptMouseDown }, icons === null || icons === void 0 ? void 0 :
            icons.more,
            hiddenTabs.length));
    }
    var selectedIndex = border.getSelected();
    if (selectedIndex !== -1) {
        var selectedTabNode = border.getChildren()[selectedIndex];
        if (selectedTabNode !== undefined && layout.isSupportsPopout() && selectedTabNode.isEnableFloat() && !selectedTabNode.isFloating()) {
            var floatTitle = layout.i18nName(I18nLabel_1.I18nLabel.Float_Tab);
            buttons.push(React.createElement("button", { key: "float", title: floatTitle, className: cm(Types_1.CLASSES.FLEXLAYOUT__BORDER_TOOLBAR_BUTTON) + " " + cm(Types_1.CLASSES.FLEXLAYOUT__BORDER_TOOLBAR_BUTTON_FLOAT), onClick: onFloatTab, onMouseDown: onInterceptMouseDown, onTouchStart: onInterceptMouseDown }));
        }
    }
    toolbar = (React.createElement("div", { key: "toolbar", ref: toolbarRef, className: cm(Types_1.CLASSES.FLEXLAYOUT__BORDER_TOOLBAR) + " " + cm(Types_1.CLASSES.FLEXLAYOUT__BORDER_TOOLBAR_ + border.getLocation().getName()) }, buttons));
    style = layout.styleFont(style);
    var innerStyle = {};
    var borderHeight = border.getBorderBarSize() - 1;
    if (border.getLocation() === DockLocation_1.default.LEFT) {
        innerStyle = { right: borderHeight, height: borderHeight, top: position };
    }
    else if (border.getLocation() === DockLocation_1.default.RIGHT) {
        innerStyle = { left: borderHeight, height: borderHeight, top: position };
    }
    else {
        innerStyle = { height: borderHeight, left: position };
    }
    return (React.createElement("div", { ref: selfRef, style: style, className: borderClasses, onWheel: onMouseWheel },
        React.createElement("div", { style: { height: borderHeight }, className: cm(Types_1.CLASSES.FLEXLAYOUT__BORDER_INNER) + " " + cm(Types_1.CLASSES.FLEXLAYOUT__BORDER_INNER_ + border.getLocation().getName()) },
            React.createElement("div", { style: innerStyle, className: cm(Types_1.CLASSES.FLEXLAYOUT__BORDER_INNER_TAB_CONTAINER) + " " + cm(Types_1.CLASSES.FLEXLAYOUT__BORDER_INNER_TAB_CONTAINER_ + border.getLocation().getName()) }, tabs)),
        toolbar));
};
exports.BorderTabSet = BorderTabSet;
//# sourceMappingURL=BorderTabSet.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/lib/view/ErrorBoundary.js":
/*!*****************************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/view/ErrorBoundary.js ***!
  \*****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ErrorBoundary = void 0;
var React = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
var Types_1 = __webpack_require__(/*! ../Types */ "./node_modules/flexlayout-react/lib/Types.js");
/** @hidden @internal */
var ErrorBoundary = /** @class */ (function (_super) {
    __extends(ErrorBoundary, _super);
    function ErrorBoundary(props) {
        var _this = _super.call(this, props) || this;
        _this.state = { hasError: false };
        return _this;
    }
    ErrorBoundary.getDerivedStateFromError = function (error) {
        return { hasError: true };
    };
    ErrorBoundary.prototype.componentDidCatch = function (error, errorInfo) {
        console.debug(error);
        console.debug(errorInfo);
    };
    ErrorBoundary.prototype.render = function () {
        if (this.state.hasError) {
            return (React.createElement("div", { className: Types_1.CLASSES.FLEXLAYOUT__ERROR_BOUNDARY_CONTAINER },
                React.createElement("div", { className: Types_1.CLASSES.FLEXLAYOUT__ERROR_BOUNDARY_CONTENT }, this.props.message)));
        }
        return this.props.children;
    };
    return ErrorBoundary;
}(React.Component));
exports.ErrorBoundary = ErrorBoundary;
//# sourceMappingURL=ErrorBoundary.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/lib/view/FloatingWindow.js":
/*!******************************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/view/FloatingWindow.js ***!
  \******************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FloatingWindow = void 0;
var React = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
var react_dom_1 = __webpack_require__(/*! react-dom */ "webpack/sharing/consume/default/react-dom");
var Types_1 = __webpack_require__(/*! ../Types */ "./node_modules/flexlayout-react/lib/Types.js");
/** @hidden @internal */
var FloatingWindow = function (props) {
    var title = props.title, id = props.id, url = props.url, rect = props.rect, onCloseWindow = props.onCloseWindow, onSetWindow = props.onSetWindow, children = props.children;
    var popoutWindow = React.useRef(null);
    var _a = React.useState(undefined), content = _a[0], setContent = _a[1];
    React.useLayoutEffect(function () {
        var r = rect;
        // Make a local copy of the styles from the current window which will be passed into
        // the floating window. window.document.styleSheets is mutable and we can't guarantee
        // the styles will exist when 'popoutWindow.load' is called below.
        var styles = Array.from(window.document.styleSheets).reduce(function (result, styleSheet) {
            try {
                return __spreadArray(__spreadArray([], result), [
                    {
                        href: styleSheet.href,
                        type: styleSheet.type,
                        rules: Array.from(styleSheet.cssRules).map(function (rule) { return rule.cssText; }),
                    }
                ]);
            }
            catch (e) {
                // styleSheet.cssRules can throw security exception
                return result;
            }
        }, []);
        popoutWindow.current = window.open(url, id, "left=" + r.x + ",top=" + r.y + ",width=" + r.width + ",height=" + r.height);
        if (popoutWindow.current !== null) {
            onSetWindow(id, popoutWindow.current);
            // listen for parent unloading to remove all popouts
            window.addEventListener("beforeunload", function () {
                if (popoutWindow.current) {
                    popoutWindow.current.close();
                    popoutWindow.current = null;
                }
            });
            popoutWindow.current.addEventListener("load", function () {
                var popoutDocument = popoutWindow.current.document;
                popoutDocument.title = title;
                var popoutContent = popoutDocument.createElement("div");
                popoutContent.className = Types_1.CLASSES.FLEXLAYOUT__FLOATING_WINDOW_CONTENT;
                popoutDocument.body.appendChild(popoutContent);
                copyStyles(popoutDocument, styles).then(function () {
                    setContent(popoutContent);
                });
                // listen for popout unloading (needs to be after load for safari)
                popoutWindow.current.addEventListener("beforeunload", function () {
                    onCloseWindow(id);
                });
            });
        }
        else {
            console.warn("Unable to open window " + url);
            onCloseWindow(id);
        }
        return function () {
            // delay so refresh will close window
            setTimeout(function () {
                if (popoutWindow.current) {
                    popoutWindow.current.close();
                    popoutWindow.current = null;
                }
            }, 0);
        };
    }, []);
    if (content !== undefined) {
        return react_dom_1.createPortal(children, content);
    }
    else {
        return null;
    }
};
exports.FloatingWindow = FloatingWindow;
/** @hidden @internal */
function copyStyles(doc, styleSheets) {
    var head = doc.head;
    var promises = [];
    styleSheets.forEach(function (styleSheet) {
        if (styleSheet.href) {
            // prefer links since they will keep paths to images etc
            var styleElement_1 = doc.createElement("link");
            styleElement_1.type = styleSheet.type;
            styleElement_1.rel = "stylesheet";
            styleElement_1.href = styleSheet.href;
            head.appendChild(styleElement_1);
            promises.push(new Promise(function (resolve, reject) {
                styleElement_1.onload = function () { return resolve(true); };
            }));
        }
        else {
            var style_1 = doc.createElement("style");
            styleSheet.rules.forEach(function (rule) { return style_1.appendChild(doc.createTextNode(rule)); });
            head.appendChild(style_1);
        }
    });
    return Promise.all(promises);
}
//# sourceMappingURL=FloatingWindow.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/lib/view/FloatingWindowTab.js":
/*!*********************************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/view/FloatingWindowTab.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FloatingWindowTab = void 0;
var React = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
var ErrorBoundary_1 = __webpack_require__(/*! ./ErrorBoundary */ "./node_modules/flexlayout-react/lib/view/ErrorBoundary.js");
var I18nLabel_1 = __webpack_require__(/*! ../I18nLabel */ "./node_modules/flexlayout-react/lib/I18nLabel.js");
var react_1 = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
var Types_1 = __webpack_require__(/*! ../Types */ "./node_modules/flexlayout-react/lib/Types.js");
/** @hidden @internal */
var FloatingWindowTab = function (props) {
    var layout = props.layout, node = props.node, factory = props.factory;
    var cm = layout.getClassName;
    var child = factory(node);
    return (React.createElement("div", { className: cm(Types_1.CLASSES.FLEXLAYOUT__FLOATING_WINDOW_TAB) },
        React.createElement(ErrorBoundary_1.ErrorBoundary, { message: props.layout.i18nName(I18nLabel_1.I18nLabel.Error_rendering_component) },
            React.createElement(react_1.Fragment, null, child))));
};
exports.FloatingWindowTab = FloatingWindowTab;
//# sourceMappingURL=FloatingWindowTab.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/lib/view/Layout.js":
/*!**********************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/view/Layout.js ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Layout = void 0;
var React = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
var DockLocation_1 = __webpack_require__(/*! ../DockLocation */ "./node_modules/flexlayout-react/lib/DockLocation.js");
var DragDrop_1 = __webpack_require__(/*! ../DragDrop */ "./node_modules/flexlayout-react/lib/DragDrop.js");
var Actions_1 = __webpack_require__(/*! ../model/Actions */ "./node_modules/flexlayout-react/lib/model/Actions.js");
var BorderNode_1 = __webpack_require__(/*! ../model/BorderNode */ "./node_modules/flexlayout-react/lib/model/BorderNode.js");
var SplitterNode_1 = __webpack_require__(/*! ../model/SplitterNode */ "./node_modules/flexlayout-react/lib/model/SplitterNode.js");
var TabNode_1 = __webpack_require__(/*! ../model/TabNode */ "./node_modules/flexlayout-react/lib/model/TabNode.js");
var TabSetNode_1 = __webpack_require__(/*! ../model/TabSetNode */ "./node_modules/flexlayout-react/lib/model/TabSetNode.js");
var Rect_1 = __webpack_require__(/*! ../Rect */ "./node_modules/flexlayout-react/lib/Rect.js");
var Types_1 = __webpack_require__(/*! ../Types */ "./node_modules/flexlayout-react/lib/Types.js");
var BorderTabSet_1 = __webpack_require__(/*! ./BorderTabSet */ "./node_modules/flexlayout-react/lib/view/BorderTabSet.js");
var Splitter_1 = __webpack_require__(/*! ./Splitter */ "./node_modules/flexlayout-react/lib/view/Splitter.js");
var Tab_1 = __webpack_require__(/*! ./Tab */ "./node_modules/flexlayout-react/lib/view/Tab.js");
var TabSet_1 = __webpack_require__(/*! ./TabSet */ "./node_modules/flexlayout-react/lib/view/TabSet.js");
var FloatingWindow_1 = __webpack_require__(/*! ./FloatingWindow */ "./node_modules/flexlayout-react/lib/view/FloatingWindow.js");
var FloatingWindowTab_1 = __webpack_require__(/*! ./FloatingWindowTab */ "./node_modules/flexlayout-react/lib/view/FloatingWindowTab.js");
var TabFloating_1 = __webpack_require__(/*! ./TabFloating */ "./node_modules/flexlayout-react/lib/view/TabFloating.js");
// Popout windows work in latest browsers based on webkit (Chrome, Opera, Safari, latest Edge) and Firefox. They do
// not work on any version if IE or the original Edge browser
// Assume any recent desktop browser not IE or original Edge will work
/** @hidden @internal */
// @ts-ignore
var isIEorEdge = typeof window !== "undefined" && (window.document.documentMode || /Edge\//.test(window.navigator.userAgent));
/** @hidden @internal */
var isDesktop = typeof window !== "undefined" && window.matchMedia && window.matchMedia("(hover: hover) and (pointer: fine)").matches;
/** @hidden @internal */
var defaultSupportsPopout = isDesktop && !isIEorEdge;
/**
 * A React component that hosts a multi-tabbed layout
 */
var Layout = /** @class */ (function (_super) {
    __extends(Layout, _super);
    function Layout(props) {
        var _this = _super.call(this, props) || this;
        /** @hidden @internal */
        _this.firstMove = false;
        /** @hidden @internal */
        _this.dragDivText = "";
        /** @hidden @internal */
        _this.edgeRectLength = 100;
        /** @hidden @internal */
        _this.edgeRectWidth = 10;
        /** @hidden @internal */
        _this.edgesShown = false;
        /** @hidden @internal */
        _this.onModelChange = function () {
            _this.forceUpdate();
            if (_this.props.onModelChange) {
                _this.props.onModelChange(_this.props.model);
            }
        };
        /** @hidden @internal */
        _this.updateRect = function (domRect) {
            if (domRect === void 0) { domRect = _this.getDomRect(); }
            var rect = new Rect_1.default(0, 0, domRect.width, domRect.height);
            if (!rect.equals(_this.state.rect) && rect.width !== 0 && rect.height !== 0) {
                _this.setState({ rect: rect });
            }
        };
        /** @hidden @internal */
        _this.updateLayoutMetrics = function () {
            if (_this.findHeaderBarSizeRef.current) {
                var headerBarSize = _this.findHeaderBarSizeRef.current.getBoundingClientRect().height;
                if (headerBarSize !== _this.state.calculatedHeaderBarSize) {
                    _this.setState({ calculatedHeaderBarSize: headerBarSize });
                }
            }
            if (_this.findTabBarSizeRef.current) {
                var tabBarSize = _this.findTabBarSizeRef.current.getBoundingClientRect().height;
                if (tabBarSize !== _this.state.calculatedTabBarSize) {
                    _this.setState({ calculatedTabBarSize: tabBarSize });
                }
            }
            if (_this.findBorderBarSizeRef.current) {
                var borderBarSize = _this.findBorderBarSizeRef.current.getBoundingClientRect().height;
                if (borderBarSize !== _this.state.calculatedBorderBarSize) {
                    _this.setState({ calculatedBorderBarSize: borderBarSize });
                }
            }
        };
        /** @hidden @internal */
        _this.getClassName = function (defaultClassName) {
            if (_this.props.classNameMapper === undefined) {
                return defaultClassName;
            }
            else {
                return _this.props.classNameMapper(defaultClassName);
            }
        };
        /** @hidden @internal */
        _this.onCloseWindow = function (id) {
            _this.doAction(Actions_1.default.unFloatTab(id));
            try {
                _this.props.model.getNodeById(id)._setWindow(undefined);
            }
            catch (e) {
                // catch incase it was a model change
            }
        };
        /** @hidden @internal */
        _this.onSetWindow = function (id, window) {
            _this.props.model.getNodeById(id)._setWindow(window);
        };
        /** @hidden @internal */
        _this.onCancelAdd = function () {
            var _a, _b;
            var rootdiv = _this.selfRef.current;
            rootdiv.removeChild(_this.dragDiv);
            _this.dragDiv = undefined;
            if (_this.fnNewNodeDropped != null) {
                _this.fnNewNodeDropped();
                _this.fnNewNodeDropped = undefined;
            }
            try {
                (_b = (_a = _this.customDrop) === null || _a === void 0 ? void 0 : _a.invalidated) === null || _b === void 0 ? void 0 : _b.call(_a);
            }
            catch (e) {
                console.error(e);
            }
            DragDrop_1.default.instance.hideGlass();
            _this.newTabJson = undefined;
            _this.customDrop = undefined;
        };
        /** @hidden @internal */
        _this.onCancelDrag = function (wasDragging) {
            var _a, _b;
            if (wasDragging) {
                var rootdiv = _this.selfRef.current;
                try {
                    rootdiv.removeChild(_this.outlineDiv);
                }
                catch (e) { }
                try {
                    rootdiv.removeChild(_this.dragDiv);
                }
                catch (e) { }
                _this.dragDiv = undefined;
                _this.hideEdges(rootdiv);
                if (_this.fnNewNodeDropped != null) {
                    _this.fnNewNodeDropped();
                    _this.fnNewNodeDropped = undefined;
                }
                try {
                    (_b = (_a = _this.customDrop) === null || _a === void 0 ? void 0 : _a.invalidated) === null || _b === void 0 ? void 0 : _b.call(_a);
                }
                catch (e) {
                    console.error(e);
                }
                DragDrop_1.default.instance.hideGlass();
                _this.newTabJson = undefined;
                _this.customDrop = undefined;
            }
        };
        /** @hidden @internal */
        _this.onDragDivMouseDown = function (event) {
            event.preventDefault();
            _this.dragStart(event, _this.dragDivText, TabNode_1.default._fromJson(_this.newTabJson, _this.props.model, false), true, undefined, undefined);
        };
        /** @hidden @internal */
        _this.dragStart = function (event, dragDivText, node, allowDrag, onClick, onDoubleClick) {
            if (_this.props.model.getMaximizedTabset() !== undefined || !allowDrag) {
                DragDrop_1.default.instance.startDrag(event, undefined, undefined, undefined, undefined, onClick, onDoubleClick, _this.currentDocument, _this.selfRef.current);
            }
            else {
                _this.dragNode = node;
                _this.dragDivText = dragDivText;
                DragDrop_1.default.instance.startDrag(event, _this.onDragStart, _this.onDragMove, _this.onDragEnd, _this.onCancelDrag, onClick, onDoubleClick, _this.currentDocument, _this.selfRef.current);
            }
        };
        /** @hidden @internal */
        _this.onDragStart = function () {
            _this.dropInfo = undefined;
            _this.customDrop = undefined;
            var rootdiv = _this.selfRef.current;
            _this.outlineDiv = _this.currentDocument.createElement("div");
            _this.outlineDiv.className = _this.getClassName(Types_1.CLASSES.FLEXLAYOUT__OUTLINE_RECT);
            _this.outlineDiv.style.visibility = "hidden";
            rootdiv.appendChild(_this.outlineDiv);
            if (_this.dragDiv == null) {
                _this.dragDiv = _this.currentDocument.createElement("div");
                _this.dragDiv.className = _this.getClassName(Types_1.CLASSES.FLEXLAYOUT__DRAG_RECT);
                _this.dragDiv.innerHTML = _this.dragDivText;
                rootdiv.appendChild(_this.dragDiv);
            }
            // add edge indicators
            _this.showEdges(rootdiv);
            if (_this.dragNode !== undefined && _this.dragNode instanceof TabNode_1.default && _this.dragNode.getTabRect() !== undefined) {
                _this.dragNode.getTabRect().positionElement(_this.outlineDiv);
            }
            _this.firstMove = true;
            return true;
        };
        /** @hidden @internal */
        _this.onDragMove = function (event) {
            var _a, _b, _c;
            if (_this.firstMove === false) {
                var speed = _this.props.model._getAttribute("tabDragSpeed");
                _this.outlineDiv.style.transition = "top " + speed + "s, left " + speed + "s, width " + speed + "s, height " + speed + "s";
            }
            _this.firstMove = false;
            var clientRect = _this.selfRef.current.getBoundingClientRect();
            var pos = {
                x: event.clientX - clientRect.left,
                y: event.clientY - clientRect.top,
            };
            _this.dragDiv.style.left = pos.x - _this.dragDiv.getBoundingClientRect().width / 2 + "px";
            _this.dragDiv.style.top = pos.y + 5 + "px";
            var dropInfo = _this.props.model._findDropTargetNode(_this.dragNode, pos.x, pos.y);
            if (dropInfo) {
                var invalidated = (_a = _this.customDrop) === null || _a === void 0 ? void 0 : _a.invalidated;
                var currentCallback = (_b = _this.customDrop) === null || _b === void 0 ? void 0 : _b.callback;
                _this.customDrop = undefined;
                var dragging = _this.newTabJson || (_this.dragNode instanceof TabNode_1.default ? _this.dragNode : undefined);
                if (dragging && (dropInfo.node instanceof TabSetNode_1.default || dropInfo.node instanceof BorderNode_1.default) && dropInfo.index === -1) {
                    var selected = dropInfo.node.getSelectedNode();
                    var tabRect = selected === null || selected === void 0 ? void 0 : selected.getRect();
                    if (selected && (tabRect === null || tabRect === void 0 ? void 0 : tabRect.contains(pos.x, pos.y))) {
                        var customDrop = undefined;
                        try {
                            var dest = _this.onTabDrag(dragging, selected, pos.x - tabRect.x, pos.y - tabRect.y, dropInfo.location, function () { return _this.onDragMove(event); });
                            if (dest) {
                                customDrop = {
                                    rect: new Rect_1.default(dest.x + tabRect.x, dest.y + tabRect.y, dest.width, dest.height),
                                    callback: dest.callback,
                                    invalidated: dest.invalidated,
                                    dragging: dragging,
                                    over: selected,
                                    x: pos.x - tabRect.x,
                                    y: pos.y - tabRect.y,
                                    location: dropInfo.location,
                                    cursor: dest.cursor
                                };
                            }
                        }
                        catch (e) {
                            console.error(e);
                        }
                        if ((customDrop === null || customDrop === void 0 ? void 0 : customDrop.callback) == currentCallback) {
                            invalidated = undefined;
                        }
                        _this.customDrop = customDrop;
                    }
                }
                _this.dropInfo = dropInfo;
                _this.outlineDiv.className = _this.getClassName(_this.customDrop ? "flexlayout__outline_rect" : dropInfo.className);
                if (_this.customDrop) {
                    _this.customDrop.rect.positionElement(_this.outlineDiv);
                }
                else {
                    dropInfo.rect.positionElement(_this.outlineDiv);
                }
                DragDrop_1.default.instance.setGlassCursorOverride((_c = _this.customDrop) === null || _c === void 0 ? void 0 : _c.cursor);
                _this.outlineDiv.style.visibility = "visible";
                try {
                    invalidated === null || invalidated === void 0 ? void 0 : invalidated();
                }
                catch (e) {
                    console.error(e);
                }
            }
        };
        /** @hidden @internal */
        _this.onDragEnd = function (event) {
            var rootdiv = _this.selfRef.current;
            rootdiv.removeChild(_this.outlineDiv);
            rootdiv.removeChild(_this.dragDiv);
            _this.dragDiv = undefined;
            _this.hideEdges(rootdiv);
            DragDrop_1.default.instance.hideGlass();
            if (_this.dropInfo) {
                if (_this.customDrop) {
                    _this.newTabJson = undefined;
                    try {
                        var _a = _this.customDrop, callback = _a.callback, dragging = _a.dragging, over = _a.over, x = _a.x, y = _a.y, location_1 = _a.location;
                        callback(dragging, over, x, y, location_1);
                    }
                    catch (e) {
                        console.error(e);
                    }
                }
                else if (_this.newTabJson !== undefined) {
                    var newNode = _this.doAction(Actions_1.default.addNode(_this.newTabJson, _this.dropInfo.node.getId(), _this.dropInfo.location, _this.dropInfo.index));
                    if (_this.fnNewNodeDropped != null) {
                        _this.fnNewNodeDropped(newNode, event);
                        _this.fnNewNodeDropped = undefined;
                    }
                    _this.newTabJson = undefined;
                }
                else if (_this.dragNode !== undefined) {
                    _this.doAction(Actions_1.default.moveNode(_this.dragNode.getId(), _this.dropInfo.node.getId(), _this.dropInfo.location, _this.dropInfo.index));
                }
            }
        };
        _this.props.model._setChangeListener(_this.onModelChange);
        _this.tabIds = [];
        _this.selfRef = React.createRef();
        _this.findHeaderBarSizeRef = React.createRef();
        _this.findTabBarSizeRef = React.createRef();
        _this.findBorderBarSizeRef = React.createRef();
        _this.supportsPopout = props.supportsPopout !== undefined ? props.supportsPopout : defaultSupportsPopout;
        _this.popoutURL = props.popoutURL ? props.popoutURL : "popout.html";
        // For backwards compatibility, prop closeIcon sets prop icons.close:
        _this.icons = props.closeIcon ? Object.assign({ close: props.closeIcon }, props.icons) : props.icons;
        _this.firstRender = true;
        _this.state = { rect: new Rect_1.default(0, 0, 0, 0),
            calculatedHeaderBarSize: 25,
            calculatedTabBarSize: 26,
            calculatedBorderBarSize: 30,
            editingTab: undefined,
        };
        _this.onDragEnter = _this.onDragEnter.bind(_this);
        return _this;
    }
    /** @hidden @internal */
    Layout.prototype.styleFont = function (style) {
        if (this.props.font) {
            if (this.props.font.size) {
                style.fontSize = this.props.font.size;
            }
            if (this.props.font.family) {
                style.fontFamily = this.props.font.family;
            }
            if (this.props.font.style) {
                style.fontStyle = this.props.font.style;
            }
            if (this.props.font.weight) {
                style.fontWeight = this.props.font.weight;
            }
        }
        return style;
    };
    /** @hidden @internal */
    Layout.prototype.doAction = function (action) {
        if (this.props.onAction !== undefined) {
            var outcome = this.props.onAction(action);
            if (outcome !== undefined) {
                return this.props.model.doAction(outcome);
            }
            return undefined;
        }
        else {
            return this.props.model.doAction(action);
        }
    };
    /** @hidden @internal */
    Layout.prototype.componentDidMount = function () {
        var _this = this;
        this.updateRect();
        this.updateLayoutMetrics();
        // need to re-render if size changes
        this.currentDocument = this.selfRef.current.ownerDocument;
        this.currentWindow = this.currentDocument.defaultView;
        this.resizeObserver = new ResizeObserver(function (entries) {
            _this.updateRect(entries[0].contentRect);
        });
        this.resizeObserver.observe(this.selfRef.current);
    };
    /** @hidden @internal */
    Layout.prototype.componentDidUpdate = function () {
        this.updateLayoutMetrics();
        if (this.props.model !== this.previousModel) {
            if (this.previousModel !== undefined) {
                this.previousModel._setChangeListener(undefined); // stop listening to old model
            }
            this.props.model._setChangeListener(this.onModelChange);
            this.previousModel = this.props.model;
        }
        // console.log("Layout time: " + this.layoutTime + "ms Render time: " + (Date.now() - this.start) + "ms");
    };
    /** @hidden @internal */
    Layout.prototype.getCurrentDocument = function () {
        return this.currentDocument;
    };
    /** @hidden @internal */
    Layout.prototype.getDomRect = function () {
        return this.selfRef.current.getBoundingClientRect();
    };
    /** @hidden @internal */
    Layout.prototype.getRootDiv = function () {
        return this.selfRef.current;
    };
    /** @hidden @internal */
    Layout.prototype.isSupportsPopout = function () {
        return this.supportsPopout;
    };
    /** @hidden @internal */
    Layout.prototype.isRealtimeResize = function () {
        var _a;
        return (_a = this.props.realtimeResize) !== null && _a !== void 0 ? _a : false;
    };
    /** @hidden @internal */
    Layout.prototype.onTabDrag = function () {
        var _a, _b;
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        return (_b = (_a = this.props).onTabDrag) === null || _b === void 0 ? void 0 : _b.call.apply(_b, __spreadArray([_a], args));
    };
    /** @hidden @internal */
    Layout.prototype.getPopoutURL = function () {
        return this.popoutURL;
    };
    /** @hidden @internal */
    Layout.prototype.componentWillUnmount = function () {
        var _a;
        (_a = this.resizeObserver) === null || _a === void 0 ? void 0 : _a.unobserve(this.selfRef.current);
    };
    /** @hidden @internal */
    Layout.prototype.setEditingTab = function (tabNode) {
        this.setState({ editingTab: tabNode });
    };
    /** @hidden @internal */
    Layout.prototype.getEditingTab = function () {
        return this.state.editingTab;
    };
    /** @hidden @internal */
    Layout.prototype.render = function () {
        var _this = this;
        // first render will be used to find the size (via selfRef)
        if (this.firstRender) {
            this.firstRender = false;
            return (React.createElement("div", { ref: this.selfRef, className: this.getClassName(Types_1.CLASSES.FLEXLAYOUT__LAYOUT) }, this.metricsElements()));
        }
        this.props.model._setPointerFine(window && window.matchMedia && window.matchMedia("(pointer: fine)").matches);
        // this.start = Date.now();
        var borderComponents = [];
        var tabSetComponents = [];
        var floatingWindows = [];
        var tabComponents = {};
        var splitterComponents = [];
        var metrics = {
            headerBarSize: this.state.calculatedHeaderBarSize,
            tabBarSize: this.state.calculatedTabBarSize,
            borderBarSize: this.state.calculatedBorderBarSize,
        };
        this.centerRect = this.props.model._layout(this.state.rect, metrics);
        this.renderBorder(this.props.model.getBorderSet(), borderComponents, tabComponents, floatingWindows, splitterComponents);
        this.renderChildren(this.props.model.getRoot(), tabSetComponents, tabComponents, floatingWindows, splitterComponents);
        if (this.edgesShown) {
            this.repositionEdges(this.state.rect);
        }
        var nextTopIds = [];
        var nextTopIdsMap = {};
        // Keep any previous tabs in the same DOM order as before, removing any that have been deleted
        this.tabIds.forEach(function (t) {
            if (tabComponents[t]) {
                nextTopIds.push(t);
                nextTopIdsMap[t] = t;
            }
        });
        this.tabIds = nextTopIds;
        // Add tabs that have been added to the DOM
        Object.keys(tabComponents).forEach(function (t) {
            if (!nextTopIdsMap[t]) {
                _this.tabIds.push(t);
            }
        });
        // this.layoutTime = (Date.now() - this.start);
        return (React.createElement("div", { ref: this.selfRef, className: this.getClassName(Types_1.CLASSES.FLEXLAYOUT__LAYOUT), onDragEnter: this.props.onExternalDrag ? this.onDragEnter : undefined },
            tabSetComponents,
            this.tabIds.map(function (t) {
                return tabComponents[t];
            }),
            borderComponents,
            splitterComponents,
            floatingWindows,
            this.metricsElements()));
    };
    /** @hidden @internal */
    Layout.prototype.metricsElements = function () {
        // used to measure the tab and border tab sizes
        var fontStyle = this.styleFont({ visibility: "hidden" });
        return (React.createElement(React.Fragment, null,
            React.createElement("div", { key: "findHeaderBarSize", ref: this.findHeaderBarSizeRef, style: fontStyle, className: this.getClassName(Types_1.CLASSES.FLEXLAYOUT__TABSET_HEADER_SIZER) }, "FindHeaderBarSize"),
            React.createElement("div", { key: "findTabBarSize", ref: this.findTabBarSizeRef, style: fontStyle, className: this.getClassName(Types_1.CLASSES.FLEXLAYOUT__TABSET_SIZER) }, "FindTabBarSize"),
            React.createElement("div", { key: "findBorderBarSize", ref: this.findBorderBarSizeRef, style: fontStyle, className: this.getClassName(Types_1.CLASSES.FLEXLAYOUT__BORDER_SIZER) }, "FindBorderBarSize")));
    };
    /** @hidden @internal */
    Layout.prototype.renderBorder = function (borderSet, borderComponents, tabComponents, floatingWindows, splitterComponents) {
        for (var _i = 0, _a = borderSet.getBorders(); _i < _a.length; _i++) {
            var border = _a[_i];
            if (border.isShowing()) {
                borderComponents.push(React.createElement(BorderTabSet_1.BorderTabSet, { key: "border_" + border.getLocation().getName(), border: border, layout: this, iconFactory: this.props.iconFactory, titleFactory: this.props.titleFactory, icons: this.icons }));
                var drawChildren = border._getDrawChildren();
                var i = 0;
                for (var _b = 0, drawChildren_1 = drawChildren; _b < drawChildren_1.length; _b++) {
                    var child = drawChildren_1[_b];
                    if (child instanceof SplitterNode_1.default) {
                        splitterComponents.push(React.createElement(Splitter_1.Splitter, { key: child.getId(), layout: this, node: child }));
                    }
                    else if (child instanceof TabNode_1.default) {
                        if (this.supportsPopout && child.isFloating()) {
                            var rect = this._getScreenRect(child);
                            floatingWindows.push(React.createElement(FloatingWindow_1.FloatingWindow, { key: child.getId(), url: this.popoutURL, rect: rect, title: child.getName(), id: child.getId(), onSetWindow: this.onSetWindow, onCloseWindow: this.onCloseWindow },
                                React.createElement(FloatingWindowTab_1.FloatingWindowTab, { layout: this, node: child, factory: this.props.factory })));
                            tabComponents[child.getId()] = React.createElement(TabFloating_1.TabFloating, { key: child.getId(), layout: this, node: child, selected: i === border.getSelected() });
                        }
                        else {
                            tabComponents[child.getId()] = React.createElement(Tab_1.Tab, { key: child.getId(), layout: this, node: child, selected: i === border.getSelected(), factory: this.props.factory });
                        }
                    }
                    i++;
                }
            }
        }
    };
    /** @hidden @internal */
    Layout.prototype.renderChildren = function (node, tabSetComponents, tabComponents, floatingWindows, splitterComponents) {
        var drawChildren = node._getDrawChildren();
        for (var _i = 0, _a = drawChildren; _i < _a.length; _i++) {
            var child = _a[_i];
            if (child instanceof SplitterNode_1.default) {
                splitterComponents.push(React.createElement(Splitter_1.Splitter, { key: child.getId(), layout: this, node: child }));
            }
            else if (child instanceof TabSetNode_1.default) {
                tabSetComponents.push(React.createElement(TabSet_1.TabSet, { key: child.getId(), layout: this, node: child, iconFactory: this.props.iconFactory, titleFactory: this.props.titleFactory, icons: this.icons }));
                this.renderChildren(child, tabSetComponents, tabComponents, floatingWindows, splitterComponents);
            }
            else if (child instanceof TabNode_1.default) {
                var selectedTab = child.getParent().getChildren()[child.getParent().getSelected()];
                if (selectedTab === undefined) {
                    // this should not happen!
                    console.warn("undefined selectedTab should not happen");
                }
                if (this.supportsPopout && child.isFloating()) {
                    var rect = this._getScreenRect(child);
                    floatingWindows.push(React.createElement(FloatingWindow_1.FloatingWindow, { key: child.getId(), url: this.popoutURL, rect: rect, title: child.getName(), id: child.getId(), onSetWindow: this.onSetWindow, onCloseWindow: this.onCloseWindow },
                        React.createElement(FloatingWindowTab_1.FloatingWindowTab, { layout: this, node: child, factory: this.props.factory })));
                    tabComponents[child.getId()] = React.createElement(TabFloating_1.TabFloating, { key: child.getId(), layout: this, node: child, selected: child === selectedTab });
                }
                else {
                    tabComponents[child.getId()] = React.createElement(Tab_1.Tab, { key: child.getId(), layout: this, node: child, selected: child === selectedTab, factory: this.props.factory });
                }
            }
            else {
                // is row
                this.renderChildren(child, tabSetComponents, tabComponents, floatingWindows, splitterComponents);
            }
        }
    };
    /** @hidden @internal */
    Layout.prototype._getScreenRect = function (node) {
        var rect = node.getRect().clone();
        var bodyRect = this.selfRef.current.getBoundingClientRect();
        var navHeight = Math.min(80, this.currentWindow.outerHeight - this.currentWindow.innerHeight);
        var navWidth = Math.min(80, this.currentWindow.outerWidth - this.currentWindow.innerWidth);
        rect.x = rect.x + bodyRect.x + this.currentWindow.screenX + navWidth;
        rect.y = rect.y + bodyRect.y + this.currentWindow.screenY + navHeight;
        return rect;
    };
    /**
     * Adds a new tab to the given tabset
     * @param tabsetId the id of the tabset where the new tab will be added
     * @param json the json for the new tab node
     */
    Layout.prototype.addTabToTabSet = function (tabsetId, json) {
        var tabsetNode = this.props.model.getNodeById(tabsetId);
        if (tabsetNode !== undefined) {
            this.doAction(Actions_1.default.addNode(json, tabsetId, DockLocation_1.default.CENTER, -1));
        }
    };
    /**
     * Adds a new tab to the active tabset (if there is one)
     * @param json the json for the new tab node
     */
    Layout.prototype.addTabToActiveTabSet = function (json) {
        var tabsetNode = this.props.model.getActiveTabset();
        if (tabsetNode !== undefined) {
            this.doAction(Actions_1.default.addNode(json, tabsetNode.getId(), DockLocation_1.default.CENTER, -1));
        }
    };
    /**
     * Adds a new tab by dragging a labeled panel to the drop location, dragging starts immediatelly
     * @param dragText the text to show on the drag panel
     * @param json the json for the new tab node
     * @param onDrop a callback to call when the drag is complete
     */
    Layout.prototype.addTabWithDragAndDrop = function (dragText, json, onDrop) {
        this.fnNewNodeDropped = onDrop;
        this.newTabJson = json;
        this.dragStart(undefined, dragText, TabNode_1.default._fromJson(json, this.props.model, false), true, undefined, undefined);
    };
    /**
     * Adds a new tab by dragging a labeled panel to the drop location, dragging starts when you
     * mouse down on the panel
     *
     * @param dragText the text to show on the drag panel
     * @param json the json for the new tab node
     * @param onDrop a callback to call when the drag is complete
     */
    Layout.prototype.addTabWithDragAndDropIndirect = function (dragText, json, onDrop) {
        this.fnNewNodeDropped = onDrop;
        this.newTabJson = json;
        DragDrop_1.default.instance.addGlass(this.onCancelAdd);
        this.dragDivText = dragText;
        this.dragDiv = this.currentDocument.createElement("div");
        this.dragDiv.className = this.getClassName("flexlayout__drag_rect");
        this.dragDiv.innerHTML = this.dragDivText;
        this.dragDiv.addEventListener("mousedown", this.onDragDivMouseDown);
        this.dragDiv.addEventListener("touchstart", this.onDragDivMouseDown);
        var r = new Rect_1.default(10, 10, 150, 50);
        r.centerInRect(this.state.rect);
        this.dragDiv.style.left = r.x + "px";
        this.dragDiv.style.top = r.y + "px";
        var rootdiv = this.selfRef.current;
        rootdiv.appendChild(this.dragDiv);
    };
    /** @hidden @internal */
    Layout.prototype.onDragEnter = function (event) {
        // DragDrop keeps track of number of dragenters minus the number of
        // dragleaves. Only start a new drag if there isn't one already.
        if (DragDrop_1.default.instance.isDragging())
            return;
        var drag = this.props.onExternalDrag(event);
        if (drag) {
            // Mimic addTabWithDragAndDrop, but pass in DragEvent
            this.fnNewNodeDropped = drag.onDrop;
            this.newTabJson = drag.json;
            this.dragStart(event, drag.dragText, TabNode_1.default._fromJson(drag.json, this.props.model, false), true, undefined, undefined);
        }
    };
    /** @hidden @internal */
    Layout.prototype.showEdges = function (rootdiv) {
        if (this.props.model.isEnableEdgeDock()) {
            var length_1 = this.edgeRectLength + "px";
            var radius = "50px";
            var width = this.edgeRectWidth + "px";
            this.edgeTopDiv = this.currentDocument.createElement("div");
            this.edgeTopDiv.className = this.getClassName(Types_1.CLASSES.FLEXLAYOUT__EDGE_RECT);
            this.edgeTopDiv.style.width = length_1;
            this.edgeTopDiv.style.height = width;
            this.edgeTopDiv.style.borderBottomLeftRadius = radius;
            this.edgeTopDiv.style.borderBottomRightRadius = radius;
            this.edgeLeftDiv = this.currentDocument.createElement("div");
            this.edgeLeftDiv.className = this.getClassName(Types_1.CLASSES.FLEXLAYOUT__EDGE_RECT);
            this.edgeLeftDiv.style.width = width;
            this.edgeLeftDiv.style.height = length_1;
            this.edgeLeftDiv.style.borderTopRightRadius = radius;
            this.edgeLeftDiv.style.borderBottomRightRadius = radius;
            this.edgeBottomDiv = this.currentDocument.createElement("div");
            this.edgeBottomDiv.className = this.getClassName(Types_1.CLASSES.FLEXLAYOUT__EDGE_RECT);
            this.edgeBottomDiv.style.width = length_1;
            this.edgeBottomDiv.style.height = width;
            this.edgeBottomDiv.style.borderTopLeftRadius = radius;
            this.edgeBottomDiv.style.borderTopRightRadius = radius;
            this.edgeRightDiv = this.currentDocument.createElement("div");
            this.edgeRightDiv.className = this.getClassName(Types_1.CLASSES.FLEXLAYOUT__EDGE_RECT);
            this.edgeRightDiv.style.width = width;
            this.edgeRightDiv.style.height = length_1;
            this.edgeRightDiv.style.borderTopLeftRadius = radius;
            this.edgeRightDiv.style.borderBottomLeftRadius = radius;
            this.repositionEdges(this.state.rect);
            rootdiv.appendChild(this.edgeTopDiv);
            rootdiv.appendChild(this.edgeLeftDiv);
            rootdiv.appendChild(this.edgeBottomDiv);
            rootdiv.appendChild(this.edgeRightDiv);
            this.edgesShown = true;
        }
    };
    /** @hidden @internal */
    Layout.prototype.repositionEdges = function (domRect) {
        if (this.props.model.isEnableEdgeDock()) {
            var r = this.centerRect;
            this.edgeTopDiv.style.top = r.y + "px";
            this.edgeTopDiv.style.left = r.x + (r.width - this.edgeRectLength) / 2 + "px";
            this.edgeLeftDiv.style.top = r.y + (r.height - this.edgeRectLength) / 2 + "px";
            this.edgeLeftDiv.style.left = r.x + "px";
            this.edgeBottomDiv.style.bottom = domRect.height - r.getBottom() + "px";
            this.edgeBottomDiv.style.left = r.x + (r.width - this.edgeRectLength) / 2 + "px";
            this.edgeRightDiv.style.top = r.y + (r.height - this.edgeRectLength) / 2 + "px";
            this.edgeRightDiv.style.right = domRect.width - r.getRight() + "px";
        }
    };
    /** @hidden @internal */
    Layout.prototype.hideEdges = function (rootdiv) {
        if (this.props.model.isEnableEdgeDock()) {
            try {
                rootdiv.removeChild(this.edgeTopDiv);
                rootdiv.removeChild(this.edgeLeftDiv);
                rootdiv.removeChild(this.edgeBottomDiv);
                rootdiv.removeChild(this.edgeRightDiv);
            }
            catch (e) { }
        }
        this.edgesShown = false;
    };
    /** @hidden @internal */
    Layout.prototype.maximize = function (tabsetNode) {
        this.doAction(Actions_1.default.maximizeToggle(tabsetNode.getId()));
    };
    /** @hidden @internal */
    Layout.prototype.customizeTab = function (tabNode, renderValues) {
        if (this.props.onRenderTab) {
            this.props.onRenderTab(tabNode, renderValues);
        }
    };
    /** @hidden @internal */
    Layout.prototype.customizeTabSet = function (tabSetNode, renderValues) {
        if (this.props.onRenderTabSet) {
            this.props.onRenderTabSet(tabSetNode, renderValues);
        }
    };
    /** @hidden @internal */
    Layout.prototype.i18nName = function (id, param) {
        var message;
        if (this.props.i18nMapper) {
            message = this.props.i18nMapper(id, param);
        }
        if (message === undefined) {
            message = id + (param === undefined ? "" : param);
        }
        return message;
    };
    return Layout;
}(React.Component));
exports.Layout = Layout;
exports["default"] = Layout;
//# sourceMappingURL=Layout.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/lib/view/Splitter.js":
/*!************************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/view/Splitter.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Splitter = void 0;
var React = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
var DragDrop_1 = __webpack_require__(/*! ../DragDrop */ "./node_modules/flexlayout-react/lib/DragDrop.js");
var Actions_1 = __webpack_require__(/*! ../model/Actions */ "./node_modules/flexlayout-react/lib/model/Actions.js");
var BorderNode_1 = __webpack_require__(/*! ../model/BorderNode */ "./node_modules/flexlayout-react/lib/model/BorderNode.js");
var Orientation_1 = __webpack_require__(/*! ../Orientation */ "./node_modules/flexlayout-react/lib/Orientation.js");
var Types_1 = __webpack_require__(/*! ../Types */ "./node_modules/flexlayout-react/lib/Types.js");
/** @hidden @internal */
var Splitter = function (props) {
    var layout = props.layout, node = props.node;
    var pBounds = React.useRef([]);
    var outlineDiv = React.useRef(undefined);
    var parentNode = node.getParent();
    var onMouseDown = function (event) {
        DragDrop_1.default.instance.setGlassCursorOverride(node.getOrientation() === Orientation_1.default.HORZ ? "ns-resize" : "ew-resize");
        DragDrop_1.default.instance.startDrag(event, onDragStart, onDragMove, onDragEnd, onDragCancel, undefined, undefined, layout.getCurrentDocument(), layout.getRootDiv());
        pBounds.current = parentNode._getSplitterBounds(node, true);
        var rootdiv = layout.getRootDiv();
        outlineDiv.current = layout.getCurrentDocument().createElement("div");
        outlineDiv.current.style.position = "absolute";
        outlineDiv.current.className = layout.getClassName(Types_1.CLASSES.FLEXLAYOUT__SPLITTER_DRAG);
        outlineDiv.current.style.cursor = node.getOrientation() === Orientation_1.default.HORZ ? "ns-resize" : "ew-resize";
        var r = node.getRect();
        if (node.getOrientation() === Orientation_1.default.VERT && r.width < 2) {
            r.width = 2;
        }
        else if (node.getOrientation() === Orientation_1.default.HORZ && r.height < 2) {
            r.height = 2;
        }
        r.positionElement(outlineDiv.current);
        rootdiv.appendChild(outlineDiv.current);
    };
    var onDragCancel = function (wasDragging) {
        var rootdiv = layout.getRootDiv();
        rootdiv.removeChild(outlineDiv.current);
    };
    var onDragStart = function () {
        return true;
    };
    var onDragMove = function (event) {
        var clientRect = layout.getDomRect();
        var pos = {
            x: event.clientX - clientRect.left,
            y: event.clientY - clientRect.top,
        };
        if (outlineDiv) {
            if (node.getOrientation() === Orientation_1.default.HORZ) {
                outlineDiv.current.style.top = getBoundPosition(pos.y - 4) + "px";
            }
            else {
                outlineDiv.current.style.left = getBoundPosition(pos.x - 4) + "px";
            }
        }
        if (layout.isRealtimeResize()) {
            updateLayout();
        }
    };
    var updateLayout = function () {
        var value = 0;
        if (outlineDiv) {
            if (node.getOrientation() === Orientation_1.default.HORZ) {
                value = outlineDiv.current.offsetTop;
            }
            else {
                value = outlineDiv.current.offsetLeft;
            }
        }
        if (parentNode instanceof BorderNode_1.default) {
            var pos = parentNode._calculateSplit(node, value);
            layout.doAction(Actions_1.default.adjustBorderSplit(node.getParent().getId(), pos));
        }
        else {
            var splitSpec = parentNode._calculateSplit(node, value);
            if (splitSpec !== undefined) {
                layout.doAction(Actions_1.default.adjustSplit(splitSpec));
            }
        }
    };
    var onDragEnd = function () {
        updateLayout();
        var rootdiv = layout.getRootDiv();
        rootdiv.removeChild(outlineDiv.current);
    };
    var getBoundPosition = function (p) {
        var bounds = pBounds.current;
        var rtn = p;
        if (p < bounds[0]) {
            rtn = bounds[0];
        }
        if (p > bounds[1]) {
            rtn = bounds[1];
        }
        return rtn;
    };
    var cm = layout.getClassName;
    var r = node.getRect();
    var style = r.styleWithPosition({
        cursor: node.getOrientation() === Orientation_1.default.HORZ ? "ns-resize" : "ew-resize",
    });
    var className = cm(Types_1.CLASSES.FLEXLAYOUT__SPLITTER) + " " + cm(Types_1.CLASSES.FLEXLAYOUT__SPLITTER_ + node.getOrientation().getName());
    if (parentNode instanceof BorderNode_1.default) {
        className += " " + cm(Types_1.CLASSES.FLEXLAYOUT__SPLITTER_BORDER);
    }
    else {
        if (node.getModel().getMaximizedTabset() !== undefined) {
            style.display = "none";
        }
    }
    var extra = node.getModel().getSplitterExtra();
    if (extra === 0) {
        return (React.createElement("div", { style: style, className: className, onTouchStart: onMouseDown, onMouseDown: onMouseDown }));
    }
    else {
        // add extended transparent div for hit testing
        // extends forward only, so as not to interfere with scrollbars
        var r2 = r.clone();
        r2.x = 0;
        r2.y = 0;
        if (node.getOrientation() === Orientation_1.default.VERT) {
            r2.width += extra;
        }
        else {
            r2.height += extra;
        }
        var style2 = r2.styleWithPosition({
            cursor: node.getOrientation() === Orientation_1.default.HORZ ? "ns-resize" : "ew-resize"
        });
        var className2 = cm(Types_1.CLASSES.FLEXLAYOUT__SPLITTER_EXTRA);
        return (React.createElement("div", { style: style, className: className },
            React.createElement("div", { style: style2, className: className2, onTouchStart: onMouseDown, onMouseDown: onMouseDown })));
    }
};
exports.Splitter = Splitter;
//# sourceMappingURL=Splitter.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/lib/view/Tab.js":
/*!*******************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/view/Tab.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Tab = void 0;
var React = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
var react_1 = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
var Actions_1 = __webpack_require__(/*! ../model/Actions */ "./node_modules/flexlayout-react/lib/model/Actions.js");
var TabSetNode_1 = __webpack_require__(/*! ../model/TabSetNode */ "./node_modules/flexlayout-react/lib/model/TabSetNode.js");
var Types_1 = __webpack_require__(/*! ../Types */ "./node_modules/flexlayout-react/lib/Types.js");
var ErrorBoundary_1 = __webpack_require__(/*! ./ErrorBoundary */ "./node_modules/flexlayout-react/lib/view/ErrorBoundary.js");
var I18nLabel_1 = __webpack_require__(/*! ../I18nLabel */ "./node_modules/flexlayout-react/lib/I18nLabel.js");
var __1 = __webpack_require__(/*! .. */ "./node_modules/flexlayout-react/lib/index.js");
/** @hidden @internal */
var Tab = function (props) {
    var layout = props.layout, selected = props.selected, node = props.node, factory = props.factory;
    var _a = React.useState(!props.node.isEnableRenderOnDemand() || props.selected), renderComponent = _a[0], setRenderComponent = _a[1];
    React.useLayoutEffect(function () {
        if (!renderComponent && selected) {
            // load on demand
            // console.log("load on demand: " + node.getName());
            setRenderComponent(true);
        }
    });
    var onMouseDown = function () {
        var parent = node.getParent();
        if (parent.getType() === TabSetNode_1.default.TYPE) {
            if (!parent.isActive()) {
                layout.doAction(Actions_1.default.setActiveTabset(parent.getId()));
            }
        }
    };
    var cm = layout.getClassName;
    var parentNode = node.getParent();
    var style = node._styleWithPosition({
        display: selected ? "block" : "none",
    });
    if (parentNode instanceof TabSetNode_1.default) {
        if (node.getModel().getMaximizedTabset() !== undefined && !parentNode.isMaximized()) {
            style.display = "none";
        }
    }
    var child;
    if (renderComponent) {
        child = factory(node);
    }
    var className = cm(Types_1.CLASSES.FLEXLAYOUT__TAB);
    if (parentNode instanceof __1.BorderNode) {
        className += " " + cm(Types_1.CLASSES.FLEXLAYOUT__TAB_BORDER);
        className += " " + cm(Types_1.CLASSES.FLEXLAYOUT__TAB_BORDER_ + parentNode.getLocation().getName());
    }
    return (React.createElement("div", { className: className, onMouseDown: onMouseDown, onTouchStart: onMouseDown, style: style },
        React.createElement(ErrorBoundary_1.ErrorBoundary, { message: props.layout.i18nName(I18nLabel_1.I18nLabel.Error_rendering_component) },
            React.createElement(react_1.Fragment, null, child))));
};
exports.Tab = Tab;
//# sourceMappingURL=Tab.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/lib/view/TabButton.js":
/*!*************************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/view/TabButton.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TabButton = void 0;
var React = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
var I18nLabel_1 = __webpack_require__(/*! ../I18nLabel */ "./node_modules/flexlayout-react/lib/I18nLabel.js");
var Actions_1 = __webpack_require__(/*! ../model/Actions */ "./node_modules/flexlayout-react/lib/model/Actions.js");
var Rect_1 = __webpack_require__(/*! ../Rect */ "./node_modules/flexlayout-react/lib/Rect.js");
var ICloseType_1 = __webpack_require__(/*! ../model/ICloseType */ "./node_modules/flexlayout-react/lib/model/ICloseType.js");
var Types_1 = __webpack_require__(/*! ../Types */ "./node_modules/flexlayout-react/lib/Types.js");
/** @hidden @internal */
var TabButton = function (props) {
    var layout = props.layout, node = props.node, show = props.show, selected = props.selected, iconFactory = props.iconFactory, titleFactory = props.titleFactory, icons = props.icons;
    var selfRef = React.useRef(null);
    var contentRef = React.useRef(null);
    var contentWidth = React.useRef(0);
    var onMouseDown = function (event) {
        if (!layout.getEditingTab()) {
            var message = layout.i18nName(I18nLabel_1.I18nLabel.Move_Tab, node.getName());
            layout.dragStart(event, message, node, node.isEnableDrag(), onClick, onDoubleClick);
        }
    };
    var onClick = function () {
        layout.doAction(Actions_1.default.selectTab(node.getId()));
    };
    var onDoubleClick = function (event) {
        if (node.isEnableRename()) {
            layout.setEditingTab(node);
            layout.getCurrentDocument().body.addEventListener("mousedown", onEndEdit);
            layout.getCurrentDocument().body.addEventListener("touchstart", onEndEdit);
        }
        // else {
        //     const parentNode = node.getParent() as TabSetNode;
        //     if (parentNode.canMaximize()) {
        //         layout.maximize(parentNode);
        //     }
        // }
    };
    var onEndEdit = function (event) {
        if (event.target !== contentRef.current) {
            layout.getCurrentDocument().body.removeEventListener("mousedown", onEndEdit);
            layout.getCurrentDocument().body.removeEventListener("touchstart", onEndEdit);
            layout.setEditingTab(undefined);
        }
    };
    var isClosable = function () {
        var closeType = node.getCloseType();
        if (selected || closeType === ICloseType_1.ICloseType.Always) {
            return true;
        }
        if (closeType === ICloseType_1.ICloseType.Visible) {
            // not selected but x should be visible due to hover
            if (window.matchMedia && window.matchMedia("(hover: hover) and (pointer: fine)").matches) {
                return true;
            }
        }
        return false;
    };
    var onClose = function (event) {
        if (isClosable()) {
            layout.doAction(Actions_1.default.deleteTab(node.getId()));
        }
        else {
            onClick();
        }
    };
    var onCloseMouseDown = function (event) {
        event.stopPropagation();
    };
    React.useLayoutEffect(function () {
        updateRect();
        if (layout.getEditingTab() === node) {
            contentRef.current.select();
        }
    });
    var updateRect = function () {
        // record position of tab in node
        var layoutRect = layout.getDomRect();
        var r = selfRef.current.getBoundingClientRect();
        node._setTabRect(new Rect_1.default(r.left - layoutRect.left, r.top - layoutRect.top, r.width, r.height));
        contentWidth.current = contentRef.current.getBoundingClientRect().width;
    };
    var onTextBoxMouseDown = function (event) {
        // console.log("onTextBoxMouseDown");
        event.stopPropagation();
    };
    var onTextBoxKeyPress = function (event) {
        // console.log(event, event.keyCode);
        if (event.keyCode === 27) {
            // esc
            layout.setEditingTab(undefined);
        }
        else if (event.keyCode === 13) {
            // enter
            layout.setEditingTab(undefined);
            layout.doAction(Actions_1.default.renameTab(node.getId(), event.target.value));
        }
    };
    var cm = layout.getClassName;
    var parentNode = node.getParent();
    var baseClassName = Types_1.CLASSES.FLEXLAYOUT__TAB_BUTTON;
    var classNames = cm(baseClassName);
    classNames += " " + cm(baseClassName + "_" + parentNode.getTabLocation());
    if (selected) {
        classNames += " " + cm(baseClassName + "--selected");
    }
    else {
        classNames += " " + cm(baseClassName + "--unselected");
    }
    if (node.getClassName() !== undefined) {
        classNames += " " + node.getClassName();
    }
    var leadingContent = iconFactory ? iconFactory(node) : undefined;
    var titleContent = node.getName();
    var name = node.getName();
    function isTitleObject(obj) {
        return obj.titleContent !== undefined;
    }
    if (titleFactory !== undefined) {
        var titleObj = titleFactory(node);
        if (titleObj !== undefined) {
            if (typeof titleObj === "string") {
                titleContent = titleObj;
                name = titleObj;
            }
            else if (isTitleObject(titleObj)) {
                titleContent = titleObj.titleContent;
                name = titleObj.name;
            }
            else {
                titleContent = titleObj;
            }
        }
    }
    if (typeof leadingContent === undefined && typeof node.getIcon() !== undefined) {
        leadingContent = React.createElement("img", { src: node.getIcon(), alt: "leadingContent" });
    }
    var buttons = [];
    // allow customization of leading contents (icon) and contents
    var renderState = { leading: leadingContent, content: titleContent, name: name, buttons: buttons };
    layout.customizeTab(node, renderState);
    node._setRenderedName(renderState.name);
    var content = (React.createElement("div", { ref: contentRef, className: cm(Types_1.CLASSES.FLEXLAYOUT__TAB_BUTTON_CONTENT) }, renderState.content));
    var leading = React.createElement("div", { className: cm(Types_1.CLASSES.FLEXLAYOUT__TAB_BUTTON_LEADING) }, renderState.leading);
    if (layout.getEditingTab() === node) {
        var contentStyle = { width: contentWidth + "px" };
        content = (React.createElement("input", { style: contentStyle, ref: contentRef, className: cm(Types_1.CLASSES.FLEXLAYOUT__TAB_BUTTON_TEXTBOX), type: "text", autoFocus: true, defaultValue: node.getName(), onKeyDown: onTextBoxKeyPress, onMouseDown: onTextBoxMouseDown, onTouchStart: onTextBoxMouseDown }));
    }
    if (node.isEnableClose()) {
        var closeTitle = layout.i18nName(I18nLabel_1.I18nLabel.Close_Tab);
        buttons.push(React.createElement("div", { key: "close", title: closeTitle, className: cm(Types_1.CLASSES.FLEXLAYOUT__TAB_BUTTON_TRAILING), onMouseDown: onCloseMouseDown, onClick: onClose, onTouchStart: onCloseMouseDown }, icons === null || icons === void 0 ? void 0 : icons.close));
    }
    return (React.createElement("div", { ref: selfRef, style: {
            visibility: show ? "visible" : "hidden",
        }, className: classNames, onMouseDown: onMouseDown, onTouchStart: onMouseDown, title: node.getHelpText() },
        leading,
        content,
        buttons));
};
exports.TabButton = TabButton;
//# sourceMappingURL=TabButton.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/lib/view/TabFloating.js":
/*!***************************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/view/TabFloating.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TabFloating = void 0;
var React = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
var Actions_1 = __webpack_require__(/*! ../model/Actions */ "./node_modules/flexlayout-react/lib/model/Actions.js");
var TabSetNode_1 = __webpack_require__(/*! ../model/TabSetNode */ "./node_modules/flexlayout-react/lib/model/TabSetNode.js");
var Types_1 = __webpack_require__(/*! ../Types */ "./node_modules/flexlayout-react/lib/Types.js");
var I18nLabel_1 = __webpack_require__(/*! ../I18nLabel */ "./node_modules/flexlayout-react/lib/I18nLabel.js");
/** @hidden @internal */
var TabFloating = function (props) {
    var layout = props.layout, selected = props.selected, node = props.node;
    var onMouseDown = function () {
        var parent = node.getParent();
        if (parent.getType() === TabSetNode_1.default.TYPE) {
            if (!parent.isActive()) {
                layout.doAction(Actions_1.default.setActiveTabset(parent.getId()));
            }
        }
    };
    var onClickFocus = function (event) {
        event.preventDefault();
        if (node.getWindow()) {
            node.getWindow().focus();
        }
    };
    var onClickDock = function (event) {
        event.preventDefault();
        layout.doAction(Actions_1.default.unFloatTab(node.getId()));
    };
    var cm = layout.getClassName;
    var style = node._styleWithPosition({
        display: selected ? "flex" : "none",
    });
    var message = layout.i18nName(I18nLabel_1.I18nLabel.Floating_Window_Message);
    var showMessage = layout.i18nName(I18nLabel_1.I18nLabel.Floating_Window_Show_Window);
    var dockMessage = layout.i18nName(I18nLabel_1.I18nLabel.Floating_Window_Dock_Window);
    return (React.createElement("div", { className: cm(Types_1.CLASSES.FLEXLAYOUT__TAB_FLOATING), onMouseDown: onMouseDown, onTouchStart: onMouseDown, style: style },
        React.createElement("div", { className: cm(Types_1.CLASSES.FLEXLAYOUT__TAB_FLOATING_INNER) },
            React.createElement("div", null, message),
            React.createElement("div", null,
                React.createElement("a", { href: "#", onClick: onClickFocus }, showMessage)),
            React.createElement("div", null,
                React.createElement("a", { href: "#", onClick: onClickDock }, dockMessage)))));
};
exports.TabFloating = TabFloating;
//# sourceMappingURL=TabFloating.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/lib/view/TabOverflowHook.js":
/*!*******************************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/view/TabOverflowHook.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.useTabOverflow = void 0;
var React = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
var Rect_1 = __webpack_require__(/*! ../Rect */ "./node_modules/flexlayout-react/lib/Rect.js");
var TabSetNode_1 = __webpack_require__(/*! ../model/TabSetNode */ "./node_modules/flexlayout-react/lib/model/TabSetNode.js");
var Orientation_1 = __webpack_require__(/*! ../Orientation */ "./node_modules/flexlayout-react/lib/Orientation.js");
/** @hidden @internal */
var useTabOverflow = function (node, orientation, toolbarRef, stickyButtonsRef) {
    var firstRender = React.useRef(true);
    var tabsTruncated = React.useRef(false);
    var lastRect = React.useRef(new Rect_1.default(0, 0, 0, 0));
    var selfRef = React.useRef(null);
    var _a = React.useState(0), position = _a[0], setPosition = _a[1];
    var userControlledLeft = React.useRef(false);
    var _b = React.useState([]), hiddenTabs = _b[0], setHiddenTabs = _b[1];
    // if selected node or tabset/border rectangle change then unset usercontrolled (so selected tab will be kept in view)
    React.useLayoutEffect(function () {
        userControlledLeft.current = false;
    }, [node.getSelectedNode(), node.getRect().width, node.getRect().height]);
    React.useLayoutEffect(function () {
        updateVisibleTabs();
    });
    React.useEffect(function () {
        var instance = selfRef.current;
        instance.addEventListener('wheel', onWheel);
        return function () {
            instance.removeEventListener('wheel', onWheel);
        };
    }, []);
    // needed to prevent default mouse wheel over tabset/border (cannot do with react event?)
    var onWheel = function (event) {
        event.preventDefault();
    };
    var getNear = function (rect) {
        if (orientation === Orientation_1.default.HORZ) {
            return rect.x;
        }
        else {
            return rect.y;
        }
    };
    var getFar = function (rect) {
        if (orientation === Orientation_1.default.HORZ) {
            return rect.getRight();
        }
        else {
            return rect.getBottom();
        }
    };
    var getSize = function (rect) {
        if (orientation === Orientation_1.default.HORZ) {
            return rect.width;
        }
        else {
            return rect.height;
        }
    };
    var updateVisibleTabs = function () {
        var tabMargin = 2;
        if (firstRender.current === true) {
            tabsTruncated.current = false;
        }
        var nodeRect = node instanceof TabSetNode_1.default ? node.getRect() : node.getTabHeaderRect();
        var lastChild = node.getChildren()[node.getChildren().length - 1];
        var stickyButtonsSize = stickyButtonsRef.current === null ? 0 : getSize(stickyButtonsRef.current.getBoundingClientRect());
        if (firstRender.current === true ||
            nodeRect.width !== lastRect.current.width || // incase rect changed between first render and second
            nodeRect.height !== lastRect.current.height) {
            lastRect.current = nodeRect;
            var enabled = node instanceof TabSetNode_1.default ? node.isEnableTabStrip() === true : true;
            var endPos = getFar(nodeRect) - stickyButtonsSize;
            if (toolbarRef.current !== null) {
                endPos -= getSize(toolbarRef.current.getBoundingClientRect());
            }
            if (enabled && node.getChildren().length > 0) {
                if (hiddenTabs.length === 0 && position === 0 && getFar(lastChild.getTabRect()) + tabMargin < endPos) {
                    return; // nothing to do all tabs are shown in available space
                }
                endPos -= hiddenTabs.length > 0 ? (orientation === Orientation_1.default.HORZ ? 10 : 0) : 45; // will need hidden tabs
                var shiftPos = 0;
                var selectedTab = node.getSelectedNode();
                if (selectedTab && !userControlledLeft.current) {
                    var selectedRect = selectedTab.getTabRect();
                    var selectedStart = getNear(selectedRect) - tabMargin;
                    var selectedEnd = getFar(selectedRect) + tabMargin;
                    // when selected tab is larger than available space then align left
                    if (getSize(selectedRect) + 2 * tabMargin >= endPos - getNear(nodeRect)) {
                        shiftPos = getNear(nodeRect) - selectedStart;
                    }
                    else {
                        if (selectedEnd > endPos || selectedStart < getNear(nodeRect)) {
                            if (selectedStart < getNear(nodeRect)) {
                                shiftPos = getNear(nodeRect) - selectedStart;
                            }
                            // use second if statement to prevent tab moving back then forwards if not enough space for single tab
                            if (selectedEnd + shiftPos > endPos) {
                                shiftPos = endPos - selectedEnd;
                            }
                        }
                    }
                }
                var extraSpace = Math.max(0, endPos - (getFar(lastChild.getTabRect()) + tabMargin + shiftPos));
                var newPosition = Math.min(0, position + shiftPos + extraSpace);
                // find hidden tabs
                var diff = newPosition - position;
                var hidden = [];
                for (var i = 0; i < node.getChildren().length; i++) {
                    var child = node.getChildren()[i];
                    if (getNear(child.getTabRect()) + diff < getNear(nodeRect) || getFar(child.getTabRect()) + diff > endPos) {
                        hidden.push({ node: child, index: i });
                    }
                }
                if (hidden.length > 0) {
                    tabsTruncated.current = true;
                }
                firstRender.current = false; // need to do a second render
                setHiddenTabs(hidden);
                setPosition(newPosition);
            }
        }
        else {
            firstRender.current = true;
        }
    };
    var onMouseWheel = function (event) {
        var delta = 0;
        if (Math.abs(event.deltaX) > Math.abs(event.deltaY)) {
            delta = -event.deltaX;
        }
        else {
            delta = -event.deltaY;
        }
        if (event.deltaMode === 1) {
            // DOM_DELTA_LINE	0x01	The delta values are specified in lines.
            delta *= 40;
        }
        setPosition(position + delta);
        userControlledLeft.current = true;
        event.stopPropagation();
    };
    return { selfRef: selfRef, position: position, userControlledLeft: userControlledLeft, hiddenTabs: hiddenTabs, onMouseWheel: onMouseWheel, tabsTruncated: tabsTruncated.current };
};
exports.useTabOverflow = useTabOverflow;
//# sourceMappingURL=TabOverflowHook.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/lib/view/TabSet.js":
/*!**********************************************************!*\
  !*** ./node_modules/flexlayout-react/lib/view/TabSet.js ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TabSet = void 0;
var React = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
var I18nLabel_1 = __webpack_require__(/*! ../I18nLabel */ "./node_modules/flexlayout-react/lib/I18nLabel.js");
var Actions_1 = __webpack_require__(/*! ../model/Actions */ "./node_modules/flexlayout-react/lib/model/Actions.js");
var PopupMenu_1 = __webpack_require__(/*! ../PopupMenu */ "./node_modules/flexlayout-react/lib/PopupMenu.js");
var TabButton_1 = __webpack_require__(/*! ./TabButton */ "./node_modules/flexlayout-react/lib/view/TabButton.js");
var TabOverflowHook_1 = __webpack_require__(/*! ./TabOverflowHook */ "./node_modules/flexlayout-react/lib/view/TabOverflowHook.js");
var Orientation_1 = __webpack_require__(/*! ../Orientation */ "./node_modules/flexlayout-react/lib/Orientation.js");
var Types_1 = __webpack_require__(/*! ../Types */ "./node_modules/flexlayout-react/lib/Types.js");
/** @hidden @internal */
var TabSet = function (props) {
    var node = props.node, layout = props.layout, iconFactory = props.iconFactory, titleFactory = props.titleFactory, icons = props.icons;
    var toolbarRef = React.useRef(null);
    var overflowbuttonRef = React.useRef(null);
    var tabbarInnerRef = React.useRef(null);
    var stickyButtonsRef = React.useRef(null);
    var _a = TabOverflowHook_1.useTabOverflow(node, Orientation_1.default.HORZ, toolbarRef, stickyButtonsRef), selfRef = _a.selfRef, position = _a.position, userControlledLeft = _a.userControlledLeft, hiddenTabs = _a.hiddenTabs, onMouseWheel = _a.onMouseWheel, tabsTruncated = _a.tabsTruncated;
    var onOverflowClick = function () {
        var element = overflowbuttonRef.current;
        PopupMenu_1.showPopup(layout.getRootDiv(), element, hiddenTabs, onOverflowItemSelect, layout.getClassName);
    };
    var onOverflowItemSelect = function (item) {
        layout.doAction(Actions_1.default.selectTab(item.node.getId()));
        userControlledLeft.current = false;
    };
    var onMouseDown = function (event) {
        var name = node.getName();
        if (name === undefined) {
            name = "";
        }
        else {
            name = ": " + name;
        }
        layout.doAction(Actions_1.default.setActiveTabset(node.getId()));
        if (!layout.getEditingTab()) {
            var message = layout.i18nName(I18nLabel_1.I18nLabel.Move_Tabset, name);
            layout.dragStart(event, message, node, node.isEnableDrag(), function (event2) { return undefined; }, onDoubleClick);
        }
    };
    var onInterceptMouseDown = function (event) {
        event.stopPropagation();
    };
    var onMaximizeToggle = function () {
        if (node.canMaximize()) {
            layout.maximize(node);
        }
    };
    var onClose = function () {
        layout.doAction(Actions_1.default.deleteTabset(node.getId()));
    };
    var onFloatTab = function () {
        if (selectedTabNode !== undefined) {
            layout.doAction(Actions_1.default.floatTab(selectedTabNode.getId()));
        }
    };
    var onDoubleClick = function (event) {
        if (node.canMaximize()) {
            layout.maximize(node);
        }
    };
    // Start Render
    var cm = layout.getClassName;
    // tabbar inner can get shifted left via tab rename, this resets scrollleft to 0
    if (tabbarInnerRef.current !== null && tabbarInnerRef.current.scrollLeft !== 0) {
        tabbarInnerRef.current.scrollLeft = 0;
    }
    var selectedTabNode = node.getSelectedNode();
    var style = node._styleWithPosition();
    if (node.getModel().getMaximizedTabset() !== undefined && !node.isMaximized()) {
        style.display = "none";
    }
    var tabs = [];
    if (node.isEnableTabStrip()) {
        for (var i = 0; i < node.getChildren().length; i++) {
            var child = node.getChildren()[i];
            var isSelected = node.getSelected() === i;
            tabs.push(React.createElement(TabButton_1.TabButton, { layout: layout, node: child, key: child.getId(), selected: isSelected, show: true, height: node.getTabStripHeight(), iconFactory: iconFactory, titleFactory: titleFactory, icons: icons }));
        }
    }
    var showHeader = node.getName() !== undefined;
    var stickyButtons = [];
    var buttons = [];
    var headerButtons = [];
    // allow customization of header contents and buttons
    var renderState = { headerContent: node.getName(), stickyButtons: stickyButtons, buttons: buttons, headerButtons: headerButtons };
    layout.customizeTabSet(node, renderState);
    var headerContent = renderState.headerContent;
    stickyButtons = renderState.stickyButtons;
    buttons = renderState.buttons;
    headerButtons = renderState.headerButtons;
    if (stickyButtons.length > 0) {
        if (tabsTruncated) {
            buttons = __spreadArray(__spreadArray([], stickyButtons), buttons);
        }
        else {
            tabs.push(React.createElement("div", { ref: stickyButtonsRef, key: "sticky_buttons_container", onMouseDown: onInterceptMouseDown, onTouchStart: onInterceptMouseDown, onDragStart: function (e) { e.preventDefault(); }, className: cm(Types_1.CLASSES.FLEXLAYOUT__TAB_TOOLBAR_STICKY_BUTTONS_CONTAINER) }, stickyButtons));
        }
    }
    var toolbar;
    if (hiddenTabs.length > 0) {
        var overflowTitle = layout.i18nName(I18nLabel_1.I18nLabel.Overflow_Menu_Tooltip);
        buttons.push(React.createElement("button", { key: "overflowbutton", ref: overflowbuttonRef, className: cm(Types_1.CLASSES.FLEXLAYOUT__TAB_BUTTON_OVERFLOW), title: overflowTitle, onClick: onOverflowClick, onMouseDown: onInterceptMouseDown, onTouchStart: onInterceptMouseDown }, icons === null || icons === void 0 ? void 0 :
            icons.more,
            hiddenTabs.length));
    }
    if (selectedTabNode !== undefined && layout.isSupportsPopout() && selectedTabNode.isEnableFloat() && !selectedTabNode.isFloating()) {
        var floatTitle = layout.i18nName(I18nLabel_1.I18nLabel.Float_Tab);
        buttons.push(React.createElement("button", { key: "float", title: floatTitle, className: cm(Types_1.CLASSES.FLEXLAYOUT__TAB_TOOLBAR_BUTTON) + " " + cm(Types_1.CLASSES.FLEXLAYOUT__TAB_TOOLBAR_BUTTON_FLOAT), onClick: onFloatTab, onMouseDown: onInterceptMouseDown, onTouchStart: onInterceptMouseDown }, icons === null || icons === void 0 ? void 0 : icons.popout));
    }
    if (node.canMaximize()) {
        var minTitle = layout.i18nName(I18nLabel_1.I18nLabel.Restore);
        var maxTitle = layout.i18nName(I18nLabel_1.I18nLabel.Maximize);
        var btns = showHeader ? headerButtons : buttons;
        btns.push(React.createElement("button", { key: "max", title: node.isMaximized() ? minTitle : maxTitle, className: cm(Types_1.CLASSES.FLEXLAYOUT__TAB_TOOLBAR_BUTTON) + " " + cm(Types_1.CLASSES.FLEXLAYOUT__TAB_TOOLBAR_BUTTON_ + (node.isMaximized() ? "max" : "min")), onClick: onMaximizeToggle, onMouseDown: onInterceptMouseDown, onTouchStart: onInterceptMouseDown }, node.isMaximized() ? icons === null || icons === void 0 ? void 0 : icons.restore : icons === null || icons === void 0 ? void 0 : icons.maximize));
    }
    if (!node.isMaximized() && node.isEnableClose()) {
        var title = layout.i18nName(I18nLabel_1.I18nLabel.Close_Tabset);
        var btns = showHeader ? headerButtons : buttons;
        btns.push(React.createElement("button", { key: "close", title: title, className: cm(Types_1.CLASSES.FLEXLAYOUT__TAB_TOOLBAR_BUTTON) + " " + cm(Types_1.CLASSES.FLEXLAYOUT__TAB_TOOLBAR_BUTTON_CLOSE), onClick: onClose, onMouseDown: onInterceptMouseDown, onTouchStart: onInterceptMouseDown }, icons === null || icons === void 0 ? void 0 : icons.closeTabset));
    }
    toolbar = (React.createElement("div", { key: "toolbar", ref: toolbarRef, className: cm(Types_1.CLASSES.FLEXLAYOUT__TAB_TOOLBAR), onMouseDown: onInterceptMouseDown, onTouchStart: onInterceptMouseDown, onDragStart: function (e) { e.preventDefault(); } }, buttons));
    var header;
    var tabStrip;
    var tabStripClasses = cm(Types_1.CLASSES.FLEXLAYOUT__TABSET_TABBAR_OUTER);
    if (node.getClassNameTabStrip() !== undefined) {
        tabStripClasses += " " + node.getClassNameTabStrip();
    }
    tabStripClasses += " " + Types_1.CLASSES.FLEXLAYOUT__TABSET_TABBAR_OUTER_ + node.getTabLocation();
    if (node.isActive() && !showHeader) {
        tabStripClasses += " " + cm(Types_1.CLASSES.FLEXLAYOUT__TABSET_SELECTED);
    }
    if (node.isMaximized() && !showHeader) {
        tabStripClasses += " " + cm(Types_1.CLASSES.FLEXLAYOUT__TABSET_MAXIMIZED);
    }
    if (showHeader) {
        var headerToolbar = (React.createElement("div", { key: "toolbar", ref: toolbarRef, className: cm(Types_1.CLASSES.FLEXLAYOUT__TAB_TOOLBAR), onMouseDown: onInterceptMouseDown, onTouchStart: onInterceptMouseDown, onDragStart: function (e) { e.preventDefault(); } }, headerButtons));
        var tabHeaderClasses = cm(Types_1.CLASSES.FLEXLAYOUT__TABSET_HEADER);
        if (node.isActive()) {
            tabHeaderClasses += " " + cm(Types_1.CLASSES.FLEXLAYOUT__TABSET_SELECTED);
        }
        if (node.isMaximized()) {
            tabHeaderClasses += " " + cm(Types_1.CLASSES.FLEXLAYOUT__TABSET_MAXIMIZED);
        }
        if (node.getClassNameHeader() !== undefined) {
            tabHeaderClasses += " " + node.getClassNameHeader();
        }
        header = (React.createElement("div", { className: tabHeaderClasses, style: { height: node.getHeaderHeight() + "px" }, onMouseDown: onMouseDown, onTouchStart: onMouseDown },
            React.createElement("div", { className: cm(Types_1.CLASSES.FLEXLAYOUT__TABSET_HEADER_CONTENT) }, headerContent),
            headerToolbar));
    }
    var tabStripStyle = { height: node.getTabStripHeight() + "px" };
    if (node.getTabLocation() === "top") {
        var top_1 = showHeader ? node.getHeaderHeight() + "px" : "0px";
        tabStripStyle["top"] = top_1;
    }
    else {
        tabStripStyle["bottom"] = "0px";
    }
    tabStrip = (React.createElement("div", { className: tabStripClasses, style: tabStripStyle, onMouseDown: onMouseDown, onTouchStart: onMouseDown },
        React.createElement("div", { ref: tabbarInnerRef, className: cm(Types_1.CLASSES.FLEXLAYOUT__TABSET_TABBAR_INNER) + " " + cm(Types_1.CLASSES.FLEXLAYOUT__TABSET_TABBAR_INNER_ + node.getTabLocation()) },
            React.createElement("div", { style: { left: position }, className: cm(Types_1.CLASSES.FLEXLAYOUT__TABSET_TABBAR_INNER_TAB_CONTAINER) + " " + cm(Types_1.CLASSES.FLEXLAYOUT__TABSET_TABBAR_INNER_TAB_CONTAINER_ + node.getTabLocation()) }, tabs)),
        toolbar));
    style = layout.styleFont(style);
    return (React.createElement("div", { ref: selfRef, style: style, className: cm(Types_1.CLASSES.FLEXLAYOUT__TABSET), onWheel: onMouseWheel },
        header,
        tabStrip));
};
exports.TabSet = TabSet;
//# sourceMappingURL=TabSet.js.map

/***/ }),

/***/ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/index.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/index.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "v1": () => (/* reexport safe */ _v1_js__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   "v3": () => (/* reexport safe */ _v3_js__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   "v4": () => (/* reexport safe */ _v4_js__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   "v5": () => (/* reexport safe */ _v5_js__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   "NIL": () => (/* reexport safe */ _nil_js__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   "version": () => (/* reexport safe */ _version_js__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   "validate": () => (/* reexport safe */ _validate_js__WEBPACK_IMPORTED_MODULE_6__["default"]),
/* harmony export */   "stringify": () => (/* reexport safe */ _stringify_js__WEBPACK_IMPORTED_MODULE_7__["default"]),
/* harmony export */   "parse": () => (/* reexport safe */ _parse_js__WEBPACK_IMPORTED_MODULE_8__["default"])
/* harmony export */ });
/* harmony import */ var _v1_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./v1.js */ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/v1.js");
/* harmony import */ var _v3_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./v3.js */ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/v3.js");
/* harmony import */ var _v4_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./v4.js */ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/v4.js");
/* harmony import */ var _v5_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./v5.js */ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/v5.js");
/* harmony import */ var _nil_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./nil.js */ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/nil.js");
/* harmony import */ var _version_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./version.js */ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/version.js");
/* harmony import */ var _validate_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./validate.js */ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/validate.js");
/* harmony import */ var _stringify_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./stringify.js */ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/stringify.js");
/* harmony import */ var _parse_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./parse.js */ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/parse.js");










/***/ }),

/***/ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/md5.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/md5.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/*
 * Browser-compatible JavaScript MD5
 *
 * Modification of JavaScript MD5
 * https://github.com/blueimp/JavaScript-MD5
 *
 * Copyright 2011, Sebastian Tschan
 * https://blueimp.net
 *
 * Licensed under the MIT license:
 * https://opensource.org/licenses/MIT
 *
 * Based on
 * A JavaScript implementation of the RSA Data Security, Inc. MD5 Message
 * Digest Algorithm, as defined in RFC 1321.
 * Version 2.2 Copyright (C) Paul Johnston 1999 - 2009
 * Other contributors: Greg Holt, Andrew Kepert, Ydnar, Lostinet
 * Distributed under the BSD License
 * See http://pajhome.org.uk/crypt/md5 for more info.
 */
function md5(bytes) {
  if (typeof bytes === 'string') {
    var msg = unescape(encodeURIComponent(bytes)); // UTF8 escape

    bytes = new Uint8Array(msg.length);

    for (var i = 0; i < msg.length; ++i) {
      bytes[i] = msg.charCodeAt(i);
    }
  }

  return md5ToHexEncodedArray(wordsToMd5(bytesToWords(bytes), bytes.length * 8));
}
/*
 * Convert an array of little-endian words to an array of bytes
 */


function md5ToHexEncodedArray(input) {
  var output = [];
  var length32 = input.length * 32;
  var hexTab = '0123456789abcdef';

  for (var i = 0; i < length32; i += 8) {
    var x = input[i >> 5] >>> i % 32 & 0xff;
    var hex = parseInt(hexTab.charAt(x >>> 4 & 0x0f) + hexTab.charAt(x & 0x0f), 16);
    output.push(hex);
  }

  return output;
}
/**
 * Calculate output length with padding and bit length
 */


function getOutputLength(inputLength8) {
  return (inputLength8 + 64 >>> 9 << 4) + 14 + 1;
}
/*
 * Calculate the MD5 of an array of little-endian words, and a bit length.
 */


function wordsToMd5(x, len) {
  /* append padding */
  x[len >> 5] |= 0x80 << len % 32;
  x[getOutputLength(len) - 1] = len;
  var a = 1732584193;
  var b = -271733879;
  var c = -1732584194;
  var d = 271733878;

  for (var i = 0; i < x.length; i += 16) {
    var olda = a;
    var oldb = b;
    var oldc = c;
    var oldd = d;
    a = md5ff(a, b, c, d, x[i], 7, -680876936);
    d = md5ff(d, a, b, c, x[i + 1], 12, -389564586);
    c = md5ff(c, d, a, b, x[i + 2], 17, 606105819);
    b = md5ff(b, c, d, a, x[i + 3], 22, -1044525330);
    a = md5ff(a, b, c, d, x[i + 4], 7, -176418897);
    d = md5ff(d, a, b, c, x[i + 5], 12, 1200080426);
    c = md5ff(c, d, a, b, x[i + 6], 17, -1473231341);
    b = md5ff(b, c, d, a, x[i + 7], 22, -45705983);
    a = md5ff(a, b, c, d, x[i + 8], 7, 1770035416);
    d = md5ff(d, a, b, c, x[i + 9], 12, -1958414417);
    c = md5ff(c, d, a, b, x[i + 10], 17, -42063);
    b = md5ff(b, c, d, a, x[i + 11], 22, -1990404162);
    a = md5ff(a, b, c, d, x[i + 12], 7, 1804603682);
    d = md5ff(d, a, b, c, x[i + 13], 12, -40341101);
    c = md5ff(c, d, a, b, x[i + 14], 17, -1502002290);
    b = md5ff(b, c, d, a, x[i + 15], 22, 1236535329);
    a = md5gg(a, b, c, d, x[i + 1], 5, -165796510);
    d = md5gg(d, a, b, c, x[i + 6], 9, -1069501632);
    c = md5gg(c, d, a, b, x[i + 11], 14, 643717713);
    b = md5gg(b, c, d, a, x[i], 20, -373897302);
    a = md5gg(a, b, c, d, x[i + 5], 5, -701558691);
    d = md5gg(d, a, b, c, x[i + 10], 9, 38016083);
    c = md5gg(c, d, a, b, x[i + 15], 14, -660478335);
    b = md5gg(b, c, d, a, x[i + 4], 20, -405537848);
    a = md5gg(a, b, c, d, x[i + 9], 5, 568446438);
    d = md5gg(d, a, b, c, x[i + 14], 9, -1019803690);
    c = md5gg(c, d, a, b, x[i + 3], 14, -187363961);
    b = md5gg(b, c, d, a, x[i + 8], 20, 1163531501);
    a = md5gg(a, b, c, d, x[i + 13], 5, -1444681467);
    d = md5gg(d, a, b, c, x[i + 2], 9, -51403784);
    c = md5gg(c, d, a, b, x[i + 7], 14, 1735328473);
    b = md5gg(b, c, d, a, x[i + 12], 20, -1926607734);
    a = md5hh(a, b, c, d, x[i + 5], 4, -378558);
    d = md5hh(d, a, b, c, x[i + 8], 11, -2022574463);
    c = md5hh(c, d, a, b, x[i + 11], 16, 1839030562);
    b = md5hh(b, c, d, a, x[i + 14], 23, -35309556);
    a = md5hh(a, b, c, d, x[i + 1], 4, -1530992060);
    d = md5hh(d, a, b, c, x[i + 4], 11, 1272893353);
    c = md5hh(c, d, a, b, x[i + 7], 16, -155497632);
    b = md5hh(b, c, d, a, x[i + 10], 23, -1094730640);
    a = md5hh(a, b, c, d, x[i + 13], 4, 681279174);
    d = md5hh(d, a, b, c, x[i], 11, -358537222);
    c = md5hh(c, d, a, b, x[i + 3], 16, -722521979);
    b = md5hh(b, c, d, a, x[i + 6], 23, 76029189);
    a = md5hh(a, b, c, d, x[i + 9], 4, -640364487);
    d = md5hh(d, a, b, c, x[i + 12], 11, -421815835);
    c = md5hh(c, d, a, b, x[i + 15], 16, 530742520);
    b = md5hh(b, c, d, a, x[i + 2], 23, -995338651);
    a = md5ii(a, b, c, d, x[i], 6, -198630844);
    d = md5ii(d, a, b, c, x[i + 7], 10, 1126891415);
    c = md5ii(c, d, a, b, x[i + 14], 15, -1416354905);
    b = md5ii(b, c, d, a, x[i + 5], 21, -57434055);
    a = md5ii(a, b, c, d, x[i + 12], 6, 1700485571);
    d = md5ii(d, a, b, c, x[i + 3], 10, -1894986606);
    c = md5ii(c, d, a, b, x[i + 10], 15, -1051523);
    b = md5ii(b, c, d, a, x[i + 1], 21, -2054922799);
    a = md5ii(a, b, c, d, x[i + 8], 6, 1873313359);
    d = md5ii(d, a, b, c, x[i + 15], 10, -30611744);
    c = md5ii(c, d, a, b, x[i + 6], 15, -1560198380);
    b = md5ii(b, c, d, a, x[i + 13], 21, 1309151649);
    a = md5ii(a, b, c, d, x[i + 4], 6, -145523070);
    d = md5ii(d, a, b, c, x[i + 11], 10, -1120210379);
    c = md5ii(c, d, a, b, x[i + 2], 15, 718787259);
    b = md5ii(b, c, d, a, x[i + 9], 21, -343485551);
    a = safeAdd(a, olda);
    b = safeAdd(b, oldb);
    c = safeAdd(c, oldc);
    d = safeAdd(d, oldd);
  }

  return [a, b, c, d];
}
/*
 * Convert an array bytes to an array of little-endian words
 * Characters >255 have their high-byte silently ignored.
 */


function bytesToWords(input) {
  if (input.length === 0) {
    return [];
  }

  var length8 = input.length * 8;
  var output = new Uint32Array(getOutputLength(length8));

  for (var i = 0; i < length8; i += 8) {
    output[i >> 5] |= (input[i / 8] & 0xff) << i % 32;
  }

  return output;
}
/*
 * Add integers, wrapping at 2^32. This uses 16-bit operations internally
 * to work around bugs in some JS interpreters.
 */


function safeAdd(x, y) {
  var lsw = (x & 0xffff) + (y & 0xffff);
  var msw = (x >> 16) + (y >> 16) + (lsw >> 16);
  return msw << 16 | lsw & 0xffff;
}
/*
 * Bitwise rotate a 32-bit number to the left.
 */


function bitRotateLeft(num, cnt) {
  return num << cnt | num >>> 32 - cnt;
}
/*
 * These functions implement the four basic operations the algorithm uses.
 */


function md5cmn(q, a, b, x, s, t) {
  return safeAdd(bitRotateLeft(safeAdd(safeAdd(a, q), safeAdd(x, t)), s), b);
}

function md5ff(a, b, c, d, x, s, t) {
  return md5cmn(b & c | ~b & d, a, b, x, s, t);
}

function md5gg(a, b, c, d, x, s, t) {
  return md5cmn(b & d | c & ~d, a, b, x, s, t);
}

function md5hh(a, b, c, d, x, s, t) {
  return md5cmn(b ^ c ^ d, a, b, x, s, t);
}

function md5ii(a, b, c, d, x, s, t) {
  return md5cmn(c ^ (b | ~d), a, b, x, s, t);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (md5);

/***/ }),

/***/ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/nil.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/nil.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ('00000000-0000-0000-0000-000000000000');

/***/ }),

/***/ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/parse.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/parse.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _validate_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./validate.js */ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/validate.js");


function parse(uuid) {
  if (!(0,_validate_js__WEBPACK_IMPORTED_MODULE_0__["default"])(uuid)) {
    throw TypeError('Invalid UUID');
  }

  var v;
  var arr = new Uint8Array(16); // Parse ########-....-....-....-............

  arr[0] = (v = parseInt(uuid.slice(0, 8), 16)) >>> 24;
  arr[1] = v >>> 16 & 0xff;
  arr[2] = v >>> 8 & 0xff;
  arr[3] = v & 0xff; // Parse ........-####-....-....-............

  arr[4] = (v = parseInt(uuid.slice(9, 13), 16)) >>> 8;
  arr[5] = v & 0xff; // Parse ........-....-####-....-............

  arr[6] = (v = parseInt(uuid.slice(14, 18), 16)) >>> 8;
  arr[7] = v & 0xff; // Parse ........-....-....-####-............

  arr[8] = (v = parseInt(uuid.slice(19, 23), 16)) >>> 8;
  arr[9] = v & 0xff; // Parse ........-....-....-....-############
  // (Use "/" to avoid 32-bit truncation when bit-shifting high-order bytes)

  arr[10] = (v = parseInt(uuid.slice(24, 36), 16)) / 0x10000000000 & 0xff;
  arr[11] = v / 0x100000000 & 0xff;
  arr[12] = v >>> 24 & 0xff;
  arr[13] = v >>> 16 & 0xff;
  arr[14] = v >>> 8 & 0xff;
  arr[15] = v & 0xff;
  return arr;
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (parse);

/***/ }),

/***/ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/regex.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/regex.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (/^(?:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|00000000-0000-0000-0000-000000000000)$/i);

/***/ }),

/***/ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/rng.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/rng.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ rng)
/* harmony export */ });
// Unique ID creation requires a high quality random # generator. In the browser we therefore
// require the crypto API and do not support built-in fallback to lower quality random number
// generators (like Math.random()).
var getRandomValues;
var rnds8 = new Uint8Array(16);
function rng() {
  // lazy load so that environments that need to polyfill have a chance to do so
  if (!getRandomValues) {
    // getRandomValues needs to be invoked in a context where "this" is a Crypto implementation. Also,
    // find the complete implementation of crypto (msCrypto) on IE11.
    getRandomValues = typeof crypto !== 'undefined' && crypto.getRandomValues && crypto.getRandomValues.bind(crypto) || typeof msCrypto !== 'undefined' && typeof msCrypto.getRandomValues === 'function' && msCrypto.getRandomValues.bind(msCrypto);

    if (!getRandomValues) {
      throw new Error('crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported');
    }
  }

  return getRandomValues(rnds8);
}

/***/ }),

/***/ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/sha1.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/sha1.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
// Adapted from Chris Veness' SHA1 code at
// http://www.movable-type.co.uk/scripts/sha1.html
function f(s, x, y, z) {
  switch (s) {
    case 0:
      return x & y ^ ~x & z;

    case 1:
      return x ^ y ^ z;

    case 2:
      return x & y ^ x & z ^ y & z;

    case 3:
      return x ^ y ^ z;
  }
}

function ROTL(x, n) {
  return x << n | x >>> 32 - n;
}

function sha1(bytes) {
  var K = [0x5a827999, 0x6ed9eba1, 0x8f1bbcdc, 0xca62c1d6];
  var H = [0x67452301, 0xefcdab89, 0x98badcfe, 0x10325476, 0xc3d2e1f0];

  if (typeof bytes === 'string') {
    var msg = unescape(encodeURIComponent(bytes)); // UTF8 escape

    bytes = [];

    for (var i = 0; i < msg.length; ++i) {
      bytes.push(msg.charCodeAt(i));
    }
  } else if (!Array.isArray(bytes)) {
    // Convert Array-like to Array
    bytes = Array.prototype.slice.call(bytes);
  }

  bytes.push(0x80);
  var l = bytes.length / 4 + 2;
  var N = Math.ceil(l / 16);
  var M = new Array(N);

  for (var _i = 0; _i < N; ++_i) {
    var arr = new Uint32Array(16);

    for (var j = 0; j < 16; ++j) {
      arr[j] = bytes[_i * 64 + j * 4] << 24 | bytes[_i * 64 + j * 4 + 1] << 16 | bytes[_i * 64 + j * 4 + 2] << 8 | bytes[_i * 64 + j * 4 + 3];
    }

    M[_i] = arr;
  }

  M[N - 1][14] = (bytes.length - 1) * 8 / Math.pow(2, 32);
  M[N - 1][14] = Math.floor(M[N - 1][14]);
  M[N - 1][15] = (bytes.length - 1) * 8 & 0xffffffff;

  for (var _i2 = 0; _i2 < N; ++_i2) {
    var W = new Uint32Array(80);

    for (var t = 0; t < 16; ++t) {
      W[t] = M[_i2][t];
    }

    for (var _t = 16; _t < 80; ++_t) {
      W[_t] = ROTL(W[_t - 3] ^ W[_t - 8] ^ W[_t - 14] ^ W[_t - 16], 1);
    }

    var a = H[0];
    var b = H[1];
    var c = H[2];
    var d = H[3];
    var e = H[4];

    for (var _t2 = 0; _t2 < 80; ++_t2) {
      var s = Math.floor(_t2 / 20);
      var T = ROTL(a, 5) + f(s, b, c, d) + e + K[s] + W[_t2] >>> 0;
      e = d;
      d = c;
      c = ROTL(b, 30) >>> 0;
      b = a;
      a = T;
    }

    H[0] = H[0] + a >>> 0;
    H[1] = H[1] + b >>> 0;
    H[2] = H[2] + c >>> 0;
    H[3] = H[3] + d >>> 0;
    H[4] = H[4] + e >>> 0;
  }

  return [H[0] >> 24 & 0xff, H[0] >> 16 & 0xff, H[0] >> 8 & 0xff, H[0] & 0xff, H[1] >> 24 & 0xff, H[1] >> 16 & 0xff, H[1] >> 8 & 0xff, H[1] & 0xff, H[2] >> 24 & 0xff, H[2] >> 16 & 0xff, H[2] >> 8 & 0xff, H[2] & 0xff, H[3] >> 24 & 0xff, H[3] >> 16 & 0xff, H[3] >> 8 & 0xff, H[3] & 0xff, H[4] >> 24 & 0xff, H[4] >> 16 & 0xff, H[4] >> 8 & 0xff, H[4] & 0xff];
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (sha1);

/***/ }),

/***/ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/stringify.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/stringify.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _validate_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./validate.js */ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/validate.js");

/**
 * Convert array of 16 byte values to UUID string format of the form:
 * XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX
 */

var byteToHex = [];

for (var i = 0; i < 256; ++i) {
  byteToHex.push((i + 0x100).toString(16).substr(1));
}

function stringify(arr) {
  var offset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
  // Note: Be careful editing this code!  It's been tuned for performance
  // and works in ways you may not expect. See https://github.com/uuidjs/uuid/pull/434
  var uuid = (byteToHex[arr[offset + 0]] + byteToHex[arr[offset + 1]] + byteToHex[arr[offset + 2]] + byteToHex[arr[offset + 3]] + '-' + byteToHex[arr[offset + 4]] + byteToHex[arr[offset + 5]] + '-' + byteToHex[arr[offset + 6]] + byteToHex[arr[offset + 7]] + '-' + byteToHex[arr[offset + 8]] + byteToHex[arr[offset + 9]] + '-' + byteToHex[arr[offset + 10]] + byteToHex[arr[offset + 11]] + byteToHex[arr[offset + 12]] + byteToHex[arr[offset + 13]] + byteToHex[arr[offset + 14]] + byteToHex[arr[offset + 15]]).toLowerCase(); // Consistency check for valid UUID.  If this throws, it's likely due to one
  // of the following:
  // - One or more input array values don't map to a hex octet (leading to
  // "undefined" in the uuid)
  // - Invalid input values for the RFC `version` or `variant` fields

  if (!(0,_validate_js__WEBPACK_IMPORTED_MODULE_0__["default"])(uuid)) {
    throw TypeError('Stringified UUID is invalid');
  }

  return uuid;
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (stringify);

/***/ }),

/***/ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/v1.js":
/*!********************************************************************************!*\
  !*** ./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/v1.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _rng_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./rng.js */ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/rng.js");
/* harmony import */ var _stringify_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./stringify.js */ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/stringify.js");

 // **`v1()` - Generate time-based UUID**
//
// Inspired by https://github.com/LiosK/UUID.js
// and http://docs.python.org/library/uuid.html

var _nodeId;

var _clockseq; // Previous uuid creation time


var _lastMSecs = 0;
var _lastNSecs = 0; // See https://github.com/uuidjs/uuid for API details

function v1(options, buf, offset) {
  var i = buf && offset || 0;
  var b = buf || new Array(16);
  options = options || {};
  var node = options.node || _nodeId;
  var clockseq = options.clockseq !== undefined ? options.clockseq : _clockseq; // node and clockseq need to be initialized to random values if they're not
  // specified.  We do this lazily to minimize issues related to insufficient
  // system entropy.  See #189

  if (node == null || clockseq == null) {
    var seedBytes = options.random || (options.rng || _rng_js__WEBPACK_IMPORTED_MODULE_0__["default"])();

    if (node == null) {
      // Per 4.5, create and 48-bit node id, (47 random bits + multicast bit = 1)
      node = _nodeId = [seedBytes[0] | 0x01, seedBytes[1], seedBytes[2], seedBytes[3], seedBytes[4], seedBytes[5]];
    }

    if (clockseq == null) {
      // Per 4.2.2, randomize (14 bit) clockseq
      clockseq = _clockseq = (seedBytes[6] << 8 | seedBytes[7]) & 0x3fff;
    }
  } // UUID timestamps are 100 nano-second units since the Gregorian epoch,
  // (1582-10-15 00:00).  JSNumbers aren't precise enough for this, so
  // time is handled internally as 'msecs' (integer milliseconds) and 'nsecs'
  // (100-nanoseconds offset from msecs) since unix epoch, 1970-01-01 00:00.


  var msecs = options.msecs !== undefined ? options.msecs : Date.now(); // Per 4.2.1.2, use count of uuid's generated during the current clock
  // cycle to simulate higher resolution clock

  var nsecs = options.nsecs !== undefined ? options.nsecs : _lastNSecs + 1; // Time since last uuid creation (in msecs)

  var dt = msecs - _lastMSecs + (nsecs - _lastNSecs) / 10000; // Per 4.2.1.2, Bump clockseq on clock regression

  if (dt < 0 && options.clockseq === undefined) {
    clockseq = clockseq + 1 & 0x3fff;
  } // Reset nsecs if clock regresses (new clockseq) or we've moved onto a new
  // time interval


  if ((dt < 0 || msecs > _lastMSecs) && options.nsecs === undefined) {
    nsecs = 0;
  } // Per 4.2.1.2 Throw error if too many uuids are requested


  if (nsecs >= 10000) {
    throw new Error("uuid.v1(): Can't create more than 10M uuids/sec");
  }

  _lastMSecs = msecs;
  _lastNSecs = nsecs;
  _clockseq = clockseq; // Per 4.1.4 - Convert from unix epoch to Gregorian epoch

  msecs += 12219292800000; // `time_low`

  var tl = ((msecs & 0xfffffff) * 10000 + nsecs) % 0x100000000;
  b[i++] = tl >>> 24 & 0xff;
  b[i++] = tl >>> 16 & 0xff;
  b[i++] = tl >>> 8 & 0xff;
  b[i++] = tl & 0xff; // `time_mid`

  var tmh = msecs / 0x100000000 * 10000 & 0xfffffff;
  b[i++] = tmh >>> 8 & 0xff;
  b[i++] = tmh & 0xff; // `time_high_and_version`

  b[i++] = tmh >>> 24 & 0xf | 0x10; // include version

  b[i++] = tmh >>> 16 & 0xff; // `clock_seq_hi_and_reserved` (Per 4.2.2 - include variant)

  b[i++] = clockseq >>> 8 | 0x80; // `clock_seq_low`

  b[i++] = clockseq & 0xff; // `node`

  for (var n = 0; n < 6; ++n) {
    b[i + n] = node[n];
  }

  return buf || (0,_stringify_js__WEBPACK_IMPORTED_MODULE_1__["default"])(b);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (v1);

/***/ }),

/***/ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/v3.js":
/*!********************************************************************************!*\
  !*** ./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/v3.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _v35_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./v35.js */ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/v35.js");
/* harmony import */ var _md5_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./md5.js */ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/md5.js");


var v3 = (0,_v35_js__WEBPACK_IMPORTED_MODULE_0__["default"])('v3', 0x30, _md5_js__WEBPACK_IMPORTED_MODULE_1__["default"]);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (v3);

/***/ }),

/***/ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/v35.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/v35.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DNS": () => (/* binding */ DNS),
/* harmony export */   "URL": () => (/* binding */ URL),
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _stringify_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./stringify.js */ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/stringify.js");
/* harmony import */ var _parse_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./parse.js */ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/parse.js");



function stringToBytes(str) {
  str = unescape(encodeURIComponent(str)); // UTF8 escape

  var bytes = [];

  for (var i = 0; i < str.length; ++i) {
    bytes.push(str.charCodeAt(i));
  }

  return bytes;
}

var DNS = '6ba7b810-9dad-11d1-80b4-00c04fd430c8';
var URL = '6ba7b811-9dad-11d1-80b4-00c04fd430c8';
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(name, version, hashfunc) {
  function generateUUID(value, namespace, buf, offset) {
    if (typeof value === 'string') {
      value = stringToBytes(value);
    }

    if (typeof namespace === 'string') {
      namespace = (0,_parse_js__WEBPACK_IMPORTED_MODULE_0__["default"])(namespace);
    }

    if (namespace.length !== 16) {
      throw TypeError('Namespace must be array-like (16 iterable integer values, 0-255)');
    } // Compute hash of namespace and value, Per 4.3
    // Future: Use spread syntax when supported on all platforms, e.g. `bytes =
    // hashfunc([...namespace, ... value])`


    var bytes = new Uint8Array(16 + value.length);
    bytes.set(namespace);
    bytes.set(value, namespace.length);
    bytes = hashfunc(bytes);
    bytes[6] = bytes[6] & 0x0f | version;
    bytes[8] = bytes[8] & 0x3f | 0x80;

    if (buf) {
      offset = offset || 0;

      for (var i = 0; i < 16; ++i) {
        buf[offset + i] = bytes[i];
      }

      return buf;
    }

    return (0,_stringify_js__WEBPACK_IMPORTED_MODULE_1__["default"])(bytes);
  } // Function#name is not settable on some platforms (#270)


  try {
    generateUUID.name = name; // eslint-disable-next-line no-empty
  } catch (err) {} // For CommonJS default export support


  generateUUID.DNS = DNS;
  generateUUID.URL = URL;
  return generateUUID;
}

/***/ }),

/***/ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/v4.js":
/*!********************************************************************************!*\
  !*** ./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/v4.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _rng_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./rng.js */ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/rng.js");
/* harmony import */ var _stringify_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./stringify.js */ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/stringify.js");



function v4(options, buf, offset) {
  options = options || {};
  var rnds = options.random || (options.rng || _rng_js__WEBPACK_IMPORTED_MODULE_0__["default"])(); // Per 4.4, set bits for version and `clock_seq_hi_and_reserved`

  rnds[6] = rnds[6] & 0x0f | 0x40;
  rnds[8] = rnds[8] & 0x3f | 0x80; // Copy bytes to buffer, if provided

  if (buf) {
    offset = offset || 0;

    for (var i = 0; i < 16; ++i) {
      buf[offset + i] = rnds[i];
    }

    return buf;
  }

  return (0,_stringify_js__WEBPACK_IMPORTED_MODULE_1__["default"])(rnds);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (v4);

/***/ }),

/***/ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/v5.js":
/*!********************************************************************************!*\
  !*** ./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/v5.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _v35_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./v35.js */ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/v35.js");
/* harmony import */ var _sha1_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./sha1.js */ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/sha1.js");


var v5 = (0,_v35_js__WEBPACK_IMPORTED_MODULE_0__["default"])('v5', 0x50, _sha1_js__WEBPACK_IMPORTED_MODULE_1__["default"]);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (v5);

/***/ }),

/***/ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/validate.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/validate.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _regex_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./regex.js */ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/regex.js");


function validate(uuid) {
  return typeof uuid === 'string' && _regex_js__WEBPACK_IMPORTED_MODULE_0__["default"].test(uuid);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (validate);

/***/ }),

/***/ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/version.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/version.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _validate_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./validate.js */ "./node_modules/flexlayout-react/node_modules/uuid/dist/esm-browser/validate.js");


function version(uuid) {
  if (!(0,_validate_js__WEBPACK_IMPORTED_MODULE_0__["default"])(uuid)) {
    throw TypeError('Invalid UUID');
  }

  return parseInt(uuid.substr(14, 1), 16);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (version);

/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_flexlayout-react_lib_index_js-node_modules_flexlayout-react_lib_view_Layout_js.149c1288052bde1f3ba5.js.map