import os
from setuptools import setup, find_packages

# Read the contents of README.md
this_directory = os.path.abspath(os.path.dirname(__file__))
with open(os.path.join(this_directory, 'README.md'), 'r', encoding='utf-8') as fh:
    long_description = fh.read()

setup(
    name="ai-git-cli",
    version="0.1.3",
    packages=find_packages(),
    python_requires='>=3.7',
    install_requires=[
        "GitPython>=3.1.0",
        "openai>=1.0.0",
        "rich>=12.0.0",
        "PyYAML>=6.0",
        "pydantic>=1.10.0",
    ],
    entry_points={
        "console_scripts": [
            "ai-git-cli=ai_git_cli.main:cli_main",
        ],
    },
    author='terminalgravity',
    author_email='jrinnfelke@gmail.com',
    description='An AI-powered Git commit message generator and manager.',
    long_description=long_description,
    long_description_content_type='text/markdown',
    url='https://github.com/TerminalGravity/ai-git-cli',
    classifiers=[
        'Programming Language :: Python :: 3',
        'Operating System :: OS Independent',
    ],
)