"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReadOnlyDBInstance = exports.ReadOnlyDBInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const rds_generated_1 = require("./rds.generated");
Object.defineProperty(exports, "ReadOnlyDBInstanceProperty", { enumerable: true, get: function () { return rds_generated_1.RosReadOnlyDBInstance; } });
/**
 * A ROS resource type:  `ALIYUN::RDS::ReadOnlyDBInstance`
 */
class ReadOnlyDBInstance extends ros.Resource {
    /**
     * Create a new `ALIYUN::RDS::ReadOnlyDBInstance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosReadOnlyDBInstance = new rds_generated_1.RosReadOnlyDBInstance(this, id, {
            category: props.category,
            engineVersion: props.engineVersion,
            privateIpAddress: props.privateIpAddress,
            zoneId: props.zoneId,
            resourceGroupId: props.resourceGroupId,
            vpcId: props.vpcId,
            dbInstanceClass: props.dbInstanceClass,
            vSwitchId: props.vSwitchId,
            payType: props.payType ? props.payType : 'Postpaid',
            dbInstanceStorageType: props.dbInstanceStorageType,
            dbInstanceId: props.dbInstanceId,
            dbInstanceStorage: props.dbInstanceStorage,
            dbInstanceDescription: props.dbInstanceDescription,
            tags: ros.tagFactory(props.tags),
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosReadOnlyDBInstance;
        this.attrConnectionString = rosReadOnlyDBInstance.attrConnectionString;
        this.attrDbInstanceId = rosReadOnlyDBInstance.attrDbInstanceId;
        this.attrPort = rosReadOnlyDBInstance.attrPort;
    }
}
exports.ReadOnlyDBInstance = ReadOnlyDBInstance;
//# sourceMappingURL=data:application/json;base64,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