"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrepayDBInstance = exports.PrepayDBInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const rds_generated_1 = require("./rds.generated");
Object.defineProperty(exports, "PrepayDBInstanceProperty", { enumerable: true, get: function () { return rds_generated_1.RosPrepayDBInstance; } });
/**
 * A ROS resource type:  `ALIYUN::RDS::PrepayDBInstance`
 */
class PrepayDBInstance extends ros.Resource {
    /**
     * Create a new `ALIYUN::RDS::PrepayDBInstance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosPrepayDBInstance = new rds_generated_1.RosPrepayDBInstance(this, id, {
            periodType: props.periodType ? props.periodType : 'Month',
            category: props.category,
            privateIpAddress: props.privateIpAddress,
            resourceGroupId: props.resourceGroupId,
            targetDedicatedHostIdForSlave: props.targetDedicatedHostIdForSlave,
            dbInstanceNetType: props.dbInstanceNetType ? props.dbInstanceNetType : 'Intranet',
            dbTimeZone: props.dbTimeZone,
            dedicatedHostGroupId: props.dedicatedHostGroupId,
            autoRenew: props.autoRenew ? props.autoRenew : false,
            port: props.port,
            encryptionKey: props.encryptionKey,
            preferredBackupPeriod: props.preferredBackupPeriod,
            slaveZoneIds: props.slaveZoneIds,
            dbIsIgnoreCase: props.dbIsIgnoreCase,
            dbInstanceStorage: props.dbInstanceStorage,
            commodityCode: props.commodityCode ? props.commodityCode : 'rds',
            dbMappings: props.dbMappings,
            connectionStringPrefix: props.connectionStringPrefix,
            multiAz: props.multiAz ? props.multiAz : false,
            maintainTime: props.maintainTime,
            engine: props.engine,
            tags: ros.tagFactory(props.tags),
            dbParamGroupId: props.dbParamGroupId,
            dbInstanceDescription: props.dbInstanceDescription,
            targetDedicatedHostIdForMaster: props.targetDedicatedHostIdForMaster,
            engineVersion: props.engineVersion,
            zoneId: props.zoneId,
            targetDedicatedHostIdForLog: props.targetDedicatedHostIdForLog,
            dbInstanceClass: props.dbInstanceClass,
            allocatePublicConnection: props.allocatePublicConnection,
            securityGroupId: props.securityGroupId,
            preferredBackupTime: props.preferredBackupTime,
            vSwitchId: props.vSwitchId,
            quantity: props.quantity ? props.quantity : 1,
            period: props.period ? props.period : 1,
            autoPay: props.autoPay ? props.autoPay : false,
            dbInstanceStorageType: props.dbInstanceStorageType,
            roleArn: props.roleArn,
            connectionStringType: props.connectionStringType ? props.connectionStringType : 'Inner',
            masterUserPassword: props.masterUserPassword,
            couponCode: props.couponCode,
            masterUserType: props.masterUserType ? props.masterUserType : 'Normal',
            vpcId: props.vpcId,
            sslSetting: props.sslSetting ? props.sslSetting : 'Disabled',
            masterUsername: props.masterUsername,
            connectionMode: props.connectionMode,
            sqlCollectorStatus: props.sqlCollectorStatus,
            backupRetentionPeriod: props.backupRetentionPeriod ? props.backupRetentionPeriod : 7,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosPrepayDBInstance;
        this.attrDbInstanceId = rosPrepayDBInstance.attrDbInstanceId;
        this.attrInnerConnectionString = rosPrepayDBInstance.attrInnerConnectionString;
        this.attrInnerIpAddress = rosPrepayDBInstance.attrInnerIpAddress;
        this.attrInnerPort = rosPrepayDBInstance.attrInnerPort;
        this.attrOrderId = rosPrepayDBInstance.attrOrderId;
        this.attrPublicConnectionString = rosPrepayDBInstance.attrPublicConnectionString;
        this.attrPublicIpAddress = rosPrepayDBInstance.attrPublicIpAddress;
        this.attrPublicPort = rosPrepayDBInstance.attrPublicPort;
    }
}
exports.PrepayDBInstance = PrepayDBInstance;
//# sourceMappingURL=data:application/json;base64,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