"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBInstanceSecurityIps = exports.DBInstanceSecurityIpsProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const rds_generated_1 = require("./rds.generated");
Object.defineProperty(exports, "DBInstanceSecurityIpsProperty", { enumerable: true, get: function () { return rds_generated_1.RosDBInstanceSecurityIps; } });
/**
 * A ROS resource type:  `ALIYUN::RDS::DBInstanceSecurityIps`
 */
class DBInstanceSecurityIps extends ros.Resource {
    /**
     * Create a new `ALIYUN::RDS::DBInstanceSecurityIps`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDBInstanceSecurityIps = new rds_generated_1.RosDBInstanceSecurityIps(this, id, {
            dbInstanceIpArrayAttribute: props.dbInstanceIpArrayAttribute,
            dbInstanceId: props.dbInstanceId,
            dbInstanceIpArrayName: props.dbInstanceIpArrayName,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDBInstanceSecurityIps;
        this.attrSecurityIps = rosDBInstanceSecurityIps.attrSecurityIps;
    }
}
exports.DBInstanceSecurityIps = DBInstanceSecurityIps;
//# sourceMappingURL=data:application/json;base64,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