"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBInstanceClone = exports.DBInstanceCloneProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const rds_generated_1 = require("./rds.generated");
Object.defineProperty(exports, "DBInstanceCloneProperty", { enumerable: true, get: function () { return rds_generated_1.RosDBInstanceClone; } });
/**
 * A ROS resource type:  `ALIYUN::RDS::DBInstanceClone`
 */
class DBInstanceClone extends ros.Resource {
    /**
     * Create a new `ALIYUN::RDS::DBInstanceClone`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDBInstanceClone = new rds_generated_1.RosDBInstanceClone(this, id, {
            periodType: props.periodType ? props.periodType : 'Month',
            category: props.category,
            privateIpAddress: props.privateIpAddress,
            dedicatedHostGroupId: props.dedicatedHostGroupId,
            port: props.port,
            backupId: props.backupId,
            instanceNetworkType: props.instanceNetworkType,
            restoreTime: props.restoreTime,
            dbNames: props.dbNames,
            preferredBackupPeriod: props.preferredBackupPeriod,
            dbInstanceId: props.dbInstanceId,
            securityIpList: props.securityIpList,
            dbInstanceStorage: props.dbInstanceStorage,
            backupType: props.backupType,
            dbMappings: props.dbMappings,
            connectionStringPrefix: props.connectionStringPrefix,
            maintainTime: props.maintainTime,
            tags: ros.tagFactory(props.tags),
            dbInstanceDescription: props.dbInstanceDescription,
            zoneId: props.zoneId,
            dbInstanceClass: props.dbInstanceClass,
            allocatePublicConnection: props.allocatePublicConnection,
            preferredBackupTime: props.preferredBackupTime,
            vSwitchId: props.vSwitchId,
            securityGroupId: props.securityGroupId,
            period: props.period ? props.period : 1,
            payType: props.payType ? props.payType : 'Postpaid',
            dbInstanceStorageType: props.dbInstanceStorageType,
            connectionStringType: props.connectionStringType ? props.connectionStringType : 'Inner',
            restoreTable: props.restoreTable,
            masterUserPassword: props.masterUserPassword,
            masterUserType: props.masterUserType ? props.masterUserType : 'Normal',
            vpcId: props.vpcId,
            sslSetting: props.sslSetting ? props.sslSetting : 'Disabled',
            masterUsername: props.masterUsername,
            sqlCollectorStatus: props.sqlCollectorStatus,
            backupRetentionPeriod: props.backupRetentionPeriod ? props.backupRetentionPeriod : 7,
            tableMeta: props.tableMeta,
            timeoutInMinutes: props.timeoutInMinutes ? props.timeoutInMinutes : 120,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDBInstanceClone;
        this.attrDbInstanceId = rosDBInstanceClone.attrDbInstanceId;
        this.attrInnerConnectionString = rosDBInstanceClone.attrInnerConnectionString;
        this.attrInnerIpAddress = rosDBInstanceClone.attrInnerIpAddress;
        this.attrInnerPort = rosDBInstanceClone.attrInnerPort;
        this.attrPublicConnectionString = rosDBInstanceClone.attrPublicConnectionString;
        this.attrPublicIpAddress = rosDBInstanceClone.attrPublicIpAddress;
        this.attrPublicPort = rosDBInstanceClone.attrPublicPort;
    }
}
exports.DBInstanceClone = DBInstanceClone;
//# sourceMappingURL=data:application/json;base64,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