"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBInstance = exports.DBInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const rds_generated_1 = require("./rds.generated");
Object.defineProperty(exports, "DBInstanceProperty", { enumerable: true, get: function () { return rds_generated_1.RosDBInstance; } });
/**
 * A ROS resource type:  `ALIYUN::RDS::DBInstance`
 */
class DBInstance extends ros.Resource {
    /**
     * Create a new `ALIYUN::RDS::DBInstance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDBInstance = new rds_generated_1.RosDBInstance(this, id, {
            periodType: props.periodType ? props.periodType : 'Month',
            category: props.category,
            privateIpAddress: props.privateIpAddress,
            resourceGroupId: props.resourceGroupId,
            targetDedicatedHostIdForSlave: props.targetDedicatedHostIdForSlave,
            dbInstanceNetType: props.dbInstanceNetType ? props.dbInstanceNetType : 'Intranet',
            dbTimeZone: props.dbTimeZone,
            dedicatedHostGroupId: props.dedicatedHostGroupId,
            port: props.port,
            encryptionKey: props.encryptionKey,
            preferredBackupPeriod: props.preferredBackupPeriod,
            slaveZoneIds: props.slaveZoneIds,
            securityIpList: props.securityIpList,
            dbIsIgnoreCase: props.dbIsIgnoreCase,
            dbInstanceStorage: props.dbInstanceStorage,
            dbMappings: props.dbMappings,
            connectionStringPrefix: props.connectionStringPrefix,
            multiAz: props.multiAz ? props.multiAz : false,
            maintainTime: props.maintainTime,
            engine: props.engine,
            tags: ros.tagFactory(props.tags),
            dbParamGroupId: props.dbParamGroupId,
            dbInstanceDescription: props.dbInstanceDescription,
            targetDedicatedHostIdForMaster: props.targetDedicatedHostIdForMaster,
            engineVersion: props.engineVersion,
            zoneId: props.zoneId,
            targetDedicatedHostIdForLog: props.targetDedicatedHostIdForLog,
            dbInstanceClass: props.dbInstanceClass,
            allocatePublicConnection: props.allocatePublicConnection,
            securityGroupId: props.securityGroupId,
            preferredBackupTime: props.preferredBackupTime,
            vSwitchId: props.vSwitchId,
            period: props.period ? props.period : 1,
            payType: props.payType ? props.payType : 'Postpaid',
            dbInstanceStorageType: props.dbInstanceStorageType,
            roleArn: props.roleArn,
            connectionStringType: props.connectionStringType ? props.connectionStringType : 'Inner',
            masterUserPassword: props.masterUserPassword,
            masterUserType: props.masterUserType ? props.masterUserType : 'Normal',
            vpcId: props.vpcId,
            sslSetting: props.sslSetting ? props.sslSetting : 'Disabled',
            masterUsername: props.masterUsername,
            connectionMode: props.connectionMode,
            sqlCollectorStatus: props.sqlCollectorStatus,
            backupRetentionPeriod: props.backupRetentionPeriod ? props.backupRetentionPeriod : 7,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDBInstance;
        this.attrDbInstanceId = rosDBInstance.attrDbInstanceId;
        this.attrInnerConnectionString = rosDBInstance.attrInnerConnectionString;
        this.attrInnerIpAddress = rosDBInstance.attrInnerIpAddress;
        this.attrInnerPort = rosDBInstance.attrInnerPort;
        this.attrPublicConnectionString = rosDBInstance.attrPublicConnectionString;
        this.attrPublicIpAddress = rosDBInstance.attrPublicIpAddress;
        this.attrPublicPort = rosDBInstance.attrPublicPort;
    }
}
exports.DBInstance = DBInstance;
//# sourceMappingURL=data:application/json;base64,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