<a name="readme-top"></a>

<!-- [![Contributors][contributors-shield]][contributors-url]
[![Forks][forks-shield]][forks-url] -->
[![Stargazers][stars-shield]][stars-url]
[![Issues][issues-shield]][issues-url]
[![MIT License][license-shield]][license-url]


<!-- PROJECT LOGO -->
<br />
<div align="center">
  <a href="https://github.com/othneildrew/Best-README-Template">
    <img src="images/logo.png" alt="Logo" width="80" height="80">
  </a>

  <h3 align="center">Airgapper</h3>

  <p align="center">
    Taking the shet pain out of air-gapped environments.
    <br />
    <a href="https://github.com/othneildrew/Best-README-Template"><strong>Explore the docs »</strong></a>
    <br />
    <br />
    <a href="https://github.com/othneildrew/Best-README-Template">View Demo</a>
    ·
    <a href="https://github.com/othneildrew/Best-README-Template/issues/new?labels=bug&template=bug-report---.md">Report Bug</a>
    ·
    <a href="https://github.com/othneildrew/Best-README-Template/issues/new?labels=enhancement&template=feature-request---.md">Request Feature</a>
  </p>
</div>


<!-- TABLE OF CONTENTS -->
<details>
  <summary>Table of Contents</summary>
  <ol>
    <li>
      <a href="#about-the-project">About The Project</a>
      <ul>
        <li><a href="#built-with">Built With</a></li>
      </ul>
    </li>
    <li>
      <a href="#getting-started">Getting Started</a>
      <ul>
        <li><a href="#prerequisites">Prerequisites</a></li>
        <li><a href="#installation">Installation</a></li>
      </ul>
    </li>
    <li><a href="#usage">Usage</a></li>
    <li><a href="#roadmap">Roadmap</a></li>
    <li><a href="#contributing">Contributing</a></li>
    <li><a href="#license">License</a></li>
    <li><a href="#contact">Contact</a></li>
    <li><a href="#acknowledgments">Acknowledgments</a></li>
  </ol>
</details>


<!-- ABOUT THE PROJECT -->
## About Airgapper

[![Product Name Screen Shot][product-screenshot]](https://example.com)

Taking the shet pain out of airgapped environment.


<p align="right">(<a href="#readme-top">back to top</a>)</p>

## Feature Matrix

<table class="tg" align=center>
  <thead>
  <tr>
    <th class="tg-repo">Packages<br>/<br>Hosted Repositories</th>
    <th class="tg-repo" align=center>
      <span>Nexus</span><br>
      <img height="48px" src="https://www.sonatype.com/hubfs/2019%20Product%20logo/Product%20Logo%20SVGs/NexusRepo_Vertical.svg">
    </th>
    <th class="tg-repo" align=center>
      <span>Harbor</span><br>
      <img height="48px" src="https://landscape.cncf.io/logos/de4f2dfd628db72e7d482ff0d9d22f0615f800a222ce7c8d6d2b5a147da77883.svg">
    </th>
  </tr></thead>
<tbody>
  <tr>
    <td class="tg-package" align=center>
      <span>Python Package (pypi)</span><br>
      <img height="32px" src="https://cdn.svgporn.com/logos/python.svg">
    </td>
    <td class="tg-normal" align=center>
      <img class="tick-icon" src="https://cdn-icons-png.flaticon.com/512/2550/2550322.png" height=32px width=32px >
    </td>
    <td class="tg-NA" align=center>
      <img class="cross-icon" src="https://cdn-icons-png.flaticon.com/512/3389/3389149.png" height=32px width=32px >
    </td> 
    <!-- &#x274C;< -->
      <!-- <img height="64px" src="https://cdn3.iconfinder.com/data/icons/meteocons/512/n-a-512.png"> -->
  </tr>
  <tr>
    <td class="tg-package" align=center>
      <span>Maven Java Packages</span><br> 
      <img height="32px" src="https://cdn.svgporn.com/logos/maven.svg">
    </td>
    <td class="tg-normal" align=center>
      <img class="tick-icon" src="https://cdn-icons-png.flaticon.com/512/2550/2550322.png" height=32px width=32px >
    </td>
    <td class="tg-NA" align=center>
      <img class="cross-icon" src="https://cdn-icons-png.flaticon.com/512/3389/3389149.png" height=32px width=32px >
    </td> 
  </tr>
  <tr>
    <td class="tg-package" align=center>
      <span>Docker Image</span><br>
      <img height="32px" src="https://cdn.svgporn.com/logos/docker-icon.svg">
    </td>
    <td class="tg-normal" align=center>
      <img class="tick-icon" src="https://cdn-icons-png.flaticon.com/512/2550/2550322.png" height=32px width=32px >
    </td>
    <td class="tg-normal" align=center>
      <img class="tick-icon" src="https://cdn-icons-png.flaticon.com/512/2550/2550322.png" height=32px width=32px >
    </td>
  </tr>
  <tr>
    <td class="tg-package" align=center>
      <span>Helm Chart</span><br>
      <img height="32px" src="https://cdn.svgporn.com/logos/helm.svg">
    </td>
    <td class="tg-normal" align=center>
      <img class="wip-icon" src="https://cdn-icons-png.flaticon.com/512/10295/10295925.png" height=32px width=32px>    
    </td>
    <td class="tg-normal" align=center>
      <img class="wip-icon" src="https://cdn-icons-png.flaticon.com/512/10295/10295925.png" height=32px width=32px>    
    </td>
  </tr>
  <tr>
    <td class="tg-package" align=center>
      <span>Bitnami Helm Charts</span><br>
      <img height="32px" src="https://cdn.svgporn.com/logos/bitnami.svg">
    </td>
    <td class="tg-normal" align=center>
      <img class="wip-icon" src="https://cdn-icons-png.flaticon.com/512/10295/10295925.png" height=32px width=32px>    
    </td>
    <td class="tg-normal" align=center>
      <img class="tick-icon" src="https://cdn-icons-png.flaticon.com/512/2550/2550322.png" height=32px width=32px >
    </td>
  </tr>
</tbody>
</table>



<!-- GETTING STARTED -->
## Getting Started

Just download package from pypi repository. Its that easy!
  ```sh
  pip install airgapper
  ```

The package will use existing tools (docker, mvn etc.) to automate the downloading and uploading of library packages.

### Prerequisites

The following are the prerequisites when working with different libraries

#### Python
- Python 3.7+
- [Requests Library](https://pypi.org/project/requests/)

#### Docker
- [Docker Engine](https://docs.docker.com/engine/)

#### Bitnami Helm
- [Docker Engine](https://docs.docker.com/engine/)
- [Bitnami Helm Distribution Tool](https://github.com/vmware-labs/distribution-tooling-for-helm) 

### Installation

_Below is an example of how you can instruct your audience on installing and setting up your app. This template doesn't rely on any external dependencies or services._

1. Get a free API Key at [https://example.com](https://example.com)
2. Clone the repo
   ```sh
   git clone https://github.com/your_username_/Project-Name.git
   ```
3. Install NPM packages
   ```sh
   npm install
   ```
4. Enter your API in `config.js`
   ```js
   const API_KEY = 'ENTER YOUR API';
   ```

<p align="right">(<a href="#readme-top">back to top</a>)</p>



<!-- USAGE EXAMPLES -->
## Usage

Use this space to show useful examples of how a project can be used. Additional screenshots, code examples and demos work well in this space. You may also link to more resources.

### Maven

#### Download
1. Search for maven/gradle plugin package at [Maven Repository](https://mvnrepository.com)
2. Select version and copy xml snippet into pom.xml
    <details><summary>pom.xml example</summary>
        ```xml
        pom.xml

        <project>
            <modelVersion>4.0.0</modelVersion>
            <groupId>com.example</groupId>
            <artifactId>sample-project</artifactId>
            <version>1.0-SNAPSHOT</version>
            <name>Sample Project</name>

            <dependencies>
                <!-- Gson Library for JSON processing -->
                <dependency>
                    <groupId>com.google.code.gson</groupId>
                    <artifactId>gson</artifactId>
                    <version>2.8.9</version>
                </dependency>
            </dependencies>
        </project>
        ```
    </details>

3. Download
    ```sh
    airgapper maven download pom.xml -o ./output-directory
    ```
#### Upload
1. Inject required environment variables.
2. Upload
    ```sh
    airgapper maven upload ./output-directory \
        "-a",
        "nexus", # Application
        "-r",
        "http://nexus.local.arpa:8080", # Application URL 
        "--repo",
        "maven-hosted", # Repository Name
    ```

_For more examples, please refer to the [Documentation](https://example.com)_

<p align="right">(<a href="#readme-top">back to top</a>)</p>



<!-- ROADMAP -->
## Roadmap

- [ ] Add Maven support
  - [ ] Add gradle plugins support
- [ ] Add generic Helm chart support
  - [ ] Handle recursive subdependencies

See the [open issues](https://github.com/othneildrew/Best-README-Template/issues) for a full list of proposed features (and known issues).


<!-- LICENSE -->
## License
Distributed under the MIT License. See `LICENSE.txt` for more information.
<p align="right">(<a href="#readme-top">back to top</a>)</p>


<!-- MARKDOWN LINKS & IMAGES -->
<!-- https://www.markdownguide.org/basic-syntax/#reference-style-links -->
[contributors-shield]: https://img.shields.io/github/contributors/puggrammer/airgapper.svg?style=for-the-badge
[contributors-url]: https://github.com/puggrammer/airgapper/graphs/contributors
[forks-shield]: https://img.shields.io/github/forks/puggrammer/airgapper.svg?style=for-the-badge
[forks-url]: https://github.com/puggrammer/airgapper/network/members
[stars-shield]: https://img.shields.io/github/stars/puggrammer/airgapper.svg?style=for-the-badge
[stars-url]: https://github.com/puggrammer/airgapper/stargazers
[issues-shield]: https://img.shields.io/github/issues/puggrammer/airgapper.svg?style=for-the-badge
[issues-url]: https://github.com/puggrammer/airgapper/issues
[license-shield]: https://img.shields.io/github/license/puggrammer/airgapper.svg?style=for-the-badge
[license-url]: https://github.com/puggrammer/airgapper/blob/master/LICENSE.txt
<!-- [linkedin-shield]: https://img.shields.io/badge/-LinkedIn-black.svg?style=for-the-badge&logo=linkedin&colorB=555
[linkedin-url]: https://linkedin.com/in/othneildrew -->
[product-screenshot]: images/screenshot.png
