# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['positions_backtester']

package_data = \
{'': ['*']}

install_requires = \
['pandas>=1.4.0,<2.0.0', 'tqdm>=4.64.0,<5.0.0']

setup_kwargs = {
    'name': 'positions-backtester',
    'version': '0.1.4',
    'description': 'Package to backtest trading strategies (dataframe with positions) with execution costs modeling',
    'long_description': '=====================\npositions_backtester\n=====================\n\n.. image:: https://img.shields.io/github/last-commit/stas-prokopiev/positions_backtester\n   :target: https://img.shields.io/github/last-commit/stas-prokopiev/positions_backtester\n   :alt: GitHub last commit\n\n.. image:: https://img.shields.io/github/license/stas-prokopiev/positions_backtester\n    :target: https://github.com/stas-prokopiev/positions_backtester/blob/master/LICENSE.txt\n    :alt: GitHub license<space><space>\n\n.. image:: https://img.shields.io/pypi/v/positions_backtester\n   :target: https://img.shields.io/pypi/v/positions_backtester\n   :alt: PyPI\n\n.. image:: https://img.shields.io/pypi/pyversions/positions_backtester\n   :target: https://img.shields.io/pypi/pyversions/positions_backtester\n   :alt: PyPI - Python Version\n\n\n.. contents:: **Table of Contents**\n\nShort Overview.\n=========================\npositions_backtester is a python package (**py>=3.7**) to backtest trading strategies (dataframe with positions) with execution costs modeling\n\n| This package is trying to solve a problem of slow trading with fast data.\n| Let\'s say that you want to update your trading position once in a hour, day, week, ...\n| But you have data with much higher time resolution - minutes, seconds, miliseconds\n| Then you can give the wanted positions dataframe with the tick with which you want to trade\n| And higher resolution will be used to calculate approximate execution prices\n| (Which are just the mean price over the choosen execution time period)\n\nInstallation via pip:\n======================\n\n.. code-block:: bash\n\n    pip install positions_backtester\n\nHow to use it\n===========================\n\nHow to backtest your dataframe with positions\n-----------------------------------------------\n\n.. code-block:: python\n\n    from positions_backtester import run_backtest\n\n    df_backtest_res = run_backtest(\n        df_positions_short : pd.DataFrame,\n        df_execution_prices_full : pd.DataFrame,\n        is_to_neutralize : bool=True,\n        td_trading_delay : Optional[datetime.timedelta]=None,\n        td_execution_duration : Optional[datetime.timedelta]=None,\n        const_trading_fees_percent : float=0.01,\n    )\n\n!!! **df_execution_prices_full should have the same indices as df_positions_short**\n\n\nArguments:\n\n#. **df_positions_short**:\n    | pd.DataFrame\n    | Positions we want to take with the frequency with which we want to change our positions\n#. **df_execution_prices_full**:\n    | pd.DataFrame\n    | Prices of assets in higher resolution\n    | Higher resolution needed for more pricise execution evaluation\n#. **is_to_neutralize=True,**:\n    | bool\n    | Flag if to have long-short equal positions\n#. **td_trading_delay=None**:\n    | datetime.timedelta\n    | Delay needed to calculate the wanted positions\n#. **td_execution_duration**:\n    | datetime.timedelta\n    | How long should the execution take\n    | Execution price will be the mean price over execution time period\n#. **const_trading_fees_percent**:\n    | float\n    | Broker trading fees\n\nInputs:\n-----------------------------------------------\n\ndf_positions_short\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n\n..\n    This is a comment\n\n    .. raw:: html\n\n    <embed>\n        <table border="1" class="dataframe">\n        <thead>\n            <tr style="text-align: right;">\n            <th></th>\n            <th>asset_1</th>\n            <th>asset_2</th>\n            <th>asset_3</th>\n            </tr>\n            <tr>\n            <th>Close datetime</th>\n            <th></th>\n            <th></th>\n            <th></th>\n            </tr>\n        </thead>\n        <tbody>\n            <tr>\n            <th>2021-07-06 22:00:00+00:00</th>\n            <td>0.285602</td>\n            <td>NaN</td>\n            <td>NaN</td>\n            </tr>\n            <tr>\n            <th>2021-07-06 23:00:00+00:00</th>\n            <td>0.296204</td>\n            <td>NaN</td>\n            <td>NaN</td>\n            </tr>\n            <tr>\n            <th>2021-07-07 00:00:00+00:00</th>\n            <td>0.294426</td>\n            <td>NaN</td>\n            <td>NaN</td>\n            </tr>\n        </tbody>\n        </table>\n    </embed>\n\n\ndf_prices_full\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n\n..\n    This is a comment\n    .. raw:: html\n\n    <embed>\n        <table border="1" class="dataframe">\n        <thead>\n            <tr style="text-align: right;">\n            <th></th>\n            <th>asset_1</th>\n            <th>asset_2</th>\n            <th>asset_3</th>\n            </tr>\n            <tr>\n            <th>Close datetime</th>\n            <th></th>\n            <th></th>\n            <th></th>\n            </tr>\n        </thead>\n        <tbody>\n            <tr>\n            <th>2021-07-06 23:57:00+00:00</th>\n            <td>317.86</td>\n            <td>57.00</td>\n            <td>15.488</td>\n            </tr>\n            <tr>\n            <th>2021-07-06 23:58:00+00:00</th>\n            <td>317.11</td>\n            <td>57.04</td>\n            <td>15.480</td>\n            </tr>\n            <tr>\n            <th>2021-07-06 23:59:00+00:00</th>\n            <td>316.49</td>\n            <td>57.01</td>\n            <td>15.459</td>\n            </tr>\n        </tbody>\n        </table>\n    </embed>\n\n\nOutput: df_backtest_res\n-----------------------------------------------\n\n..\n    This is a comment\n    .. raw:: html\n\n    <embed>\n        <table border="1" class="dataframe">\n        <thead>\n            <tr style="text-align: right;">\n            <th></th>\n            <th>PNL before_costs</th>\n            <th>PNL execution_fee</th>\n            <th>PNL const_trading_fee</th>\n            <th>PNL after_costs</th>\n            <th>PNL half_costs</th>\n            <th>trading_volume</th>\n            <th>booksize</th>\n            <th>max weight</th>\n            <th>long count</th>\n            <th>short count</th>\n            </tr>\n            <tr>\n            <th>Close datetime</th>\n            <th></th>\n            <th></th>\n            <th></th>\n            <th></th>\n            <th></th>\n            <th></th>\n            </tr>\n        </thead>\n        <tbody>\n            <tr>\n            <th>2021-07-06 20:00:00+00:00</th>\n            <td>-0.002108</td>\n            <td>-0.004361</td>\n            <td>0.000003</td>\n            <td>0.002250</td>\n            <td>0.000071</td>\n            <td>0.034720</td>\n            <td>1.0</td>\n            <td>0.14</td>\n            <td>33</td>\n            <td>200</td>\n            <td>0.5</td>\n            <td>0.5</td>\n            </tr>\n            <tr>\n            <th>2021-07-06 21:00:00+00:00</th>\n            <td>-0.005282</td>\n            <td>-0.000222</td>\n            <td>0.000005</td>\n            <td>-0.005065</td>\n            <td>-0.005174</td>\n            <td>0.053568</td>\n            <td>1.0</td>\n            <td>0.11</td>\n            <td>32</td>\n            <td>198</td>\n            <td>0.5</td>\n            <td>0.5</td>\n            </tr>\n        </tbody>\n        </table>\n    </embed>\n\n\nFormulas\n===========================\n\n| PNL before_costs = (previous_position) * (price_change_%)\n| trading_volume = abs(new_wanted_position - previous_position)\n| PNL const_trading_fee = trading_volume * broker_commision\n| PNL execution_fee = (new_wanted_position - previous_position) * (execution_price - current_price)\n| PNL after_costs = PNL before_costs - (PNL const_trading_fee + PNL execution_fee)\n| PNL half_costs = PNL before_costs - (PNL const_trading_fee + PNL execution_fee) / 2.0\n\nLinks\n=====\n\n    * `PYPI <https://pypi.org/project/positions_backtester/>`_\n    * `GitHub <https://github.com/stas-prokopiev/positions_backtester>`_\n\nProject local Links\n===================\n\n    * `CHANGELOG <https://github.com/stas-prokopiev/positions_backtester/blob/master/CHANGELOG.rst>`_.\n    * `CONTRIBUTING <https://github.com/stas-prokopiev/positions_backtester/blob/master/CONTRIBUTING.rst>`_.\n\nContacts\n========\n\n    * Email: stas.prokopiev@gmail.com\n    * `vk.com <https://vk.com/stas.prokopyev>`_\n    * `Facebook <https://www.facebook.com/profile.php?id=100009380530321>`_\n\nLicense\n=======\n\nThis project is licensed under the MIT License.',
    'author': 'stanislav',
    'author_email': 'stas.prokopiev@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/stas-prokopiev/positions_backtester',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
