"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TextractClassificationConfigurator = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const dynamodb = require("aws-cdk-lib/aws-dynamodb");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const sfn = require("aws-cdk-lib/aws-stepfunctions");
const tasks = require("aws-cdk-lib/aws-stepfunctions-tasks");
const cfnCustomResourceConfiguratorPrefill_1 = require("./cfnCustomResourceConfiguratorPrefill");
/**
 * Looks for a matching DOCYMENT_TYPE in the configurationTableName
 * and sets the CONFIG value (when found) to the context, so subsequent calls to
 * Textract use those values.
 *
 * This is an entry from the default config
 * AWS_PAYSTUBS,"{""queriesConfig"": [{""alias"": ""PAYSTUB_PERIOD_START_DATE"", ""text"": ""What is the Pay Period Start Date?""}, {""alias"": ""PAYSTUB_PERIOD_END_DATE"", ""text"": ""What is the Pay Period End Date?""}, {""alias"": ""PAYSTUB_PERIOD_PAY_DATE"", ""text"": ""What is the Pay Date?""}, {""alias"": ""PAYSTUB_PERIOD_EMPLOYEE_NAME"", ""text"": ""What is the Employee Name?""}, {""alias"": ""PAYSTUB_PERIOD_COMPANY_NAME"", ""text"": ""What is the company Name?""}, {""alias"": ""PAYSTUB_PERIOD_CURRENT_GROSS_PAY"", ""text"": ""What is the Current Gross Pay?""}, {""alias"": ""PAYSTUB_PERIOD_YTD_GROSS_PAY"", ""text"": ""What is the YTD Gross Pay?""}, {""alias"": ""PAYSTUB_PERIOD_REGULAR_HOURLY_RATE"", ""text"": ""What is the regular hourly rate?""}, {""alias"": ""PAYSTUB_PERIOD_HOLIDAY_RATE"", ""text"": ""What is the holiday rate?""}], ""textractFeatures"": [""QUERIES""]}"
 *
 * So, if the "classification"."documentType" in the Step Function Input is AWS_PAYSTUBS
 * then it will set the queriesConfig in the manifest for the subsequent Textract Calls in the Step Function flow
 *
 * Input: "classification"."documentType"
 * Output: config set to manifest
 *
 * Example (Python)
 * ```
    configurator_task = tcdk.TextractClassificationConfigurator(
        self, f"{workflow_name}-Configurator",
    )

 * ```
 */
class TextractClassificationConfigurator extends sfn.StateMachineFragment {
    constructor(parent, id, props) {
        super(parent, id);
        var lambdaMemoryMB = props.lambdaMemoryMB === undefined ? 1024 : props.lambdaMemoryMB;
        var lambdaTimeout = props.lambdaTimeout === undefined ? 900 : props.lambdaTimeout;
        var lambdaLogLevel = props.lambdaLogLevel === undefined ? 'DEBUG' : props.lambdaLogLevel;
        if (props.configurationTable === undefined) {
            this.configurationTable = new dynamodb.Table(this, 'TextractConfigurationTable', {
                partitionKey: {
                    name: 'DOCUMENT_TYPE',
                    type: dynamodb.AttributeType.STRING,
                },
                removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
                billingMode: dynamodb.BillingMode.PAY_PER_REQUEST,
            });
            this.configurationTableName = this.configurationTable.tableName;
            const configurationInitFunction = new cfnCustomResourceConfiguratorPrefill_1.TextractConfiguration(this, 'DocTypeConfig', {
                configuration_table: this.configurationTable.tableName,
            });
            configurationInitFunction.node.addDependency(this.configurationTable);
        }
        else {
            this.configurationTable = props.configurationTable;
            this.configurationTableName = props.configurationTable.tableName;
        }
        this.configuratorFunction = new lambda.DockerImageFunction(this, 'ClassificationConfigurator', {
            code: lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../lambda/configurator/')),
            memorySize: lambdaMemoryMB,
            architecture: lambda.Architecture.X86_64,
            timeout: aws_cdk_lib_1.Duration.seconds(lambdaTimeout),
            environment: {
                CONFIGURATION_TABLE: this.configurationTable.tableName,
                LOG_LEVEL: lambdaLogLevel,
            },
        });
        this.configuratorFunction.addToRolePolicy(new iam.PolicyStatement({
            actions: ['dynamodb:PutItem', 'dynamodb:GetItem'],
            resources: [this.configurationTable.tableArn],
        }));
        this.configuratorFunctionLogGroupName = this.configuratorFunction.logGroup.logGroupName;
        const configuratorLambdaInvoke = new tasks.LambdaInvoke(this, id, {
            lambdaFunction: this.configuratorFunction,
            timeout: aws_cdk_lib_1.Duration.seconds(100),
            outputPath: '$.Payload',
        });
        this.startState = configuratorLambdaInvoke;
        this.endStates = [configuratorLambdaInvoke];
    }
}
exports.TextractClassificationConfigurator = TextractClassificationConfigurator;
_a = JSII_RTTI_SYMBOL_1;
TextractClassificationConfigurator[_a] = { fqn: "amazon-textract-idp-cdk-constructs.TextractClassificationConfigurator", version: "0.0.15" };
//# sourceMappingURL=data:application/json;base64,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