"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RdsServerlessInit = void 0;
const path = require("path");
const cdk = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const customResources = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
class RdsServerlessInit extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.rdsServerlessInit = new lambda.DockerImageFunction(this, id + 'ServerlessInit', {
            code: lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../lambda/rds_serverless_init/')),
            memorySize: 128,
            architecture: lambda.Architecture.X86_64,
            timeout: cdk.Duration.seconds(600),
            // securityGroups: props.securityGroups,
            environment: {
                LOG_LEVEL: 'DEBUG',
                SECRET_ARN: props.dbClusterSecretARN,
                CLUSTER_ARN: props.dbClusterARN,
            },
        });
        this.rdsServerlessInit.role?.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonRDSDataFullAccess'));
        this.rdsServerlessInit.addToRolePolicy(new iam.PolicyStatement({
            actions: [
                'secretsmanager:GetSecretValue',
            ],
            resources: [props.dbClusterSecretARN],
        }));
        const provider = new customResources.Provider(this, 'Provider', {
            onEventHandler: this.rdsServerlessInit,
        });
        const resource = new cdk.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            properties: props,
        });
        this.response = resource.getAtt('Response').toString();
    }
}
exports.RdsServerlessInit = RdsServerlessInit;
//# sourceMappingURL=data:application/json;base64,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