import * as ec2 from 'aws-cdk-lib/aws-ec2';
import * as rds from 'aws-cdk-lib/aws-rds';
import { Construct } from 'constructs';
export interface RDSAuroraServerlessProps {
    /** VPC to install the database into */
    readonly vpc: ec2.IVpc;
}
export declare class RDSAuroraServerless extends Construct {
    readonly props: RDSAuroraServerlessProps;
    dbCluster: rds.IServerlessCluster;
    auroraSecurityGroup: ec2.ISecurityGroup;
    lambdaSecurityGroup: ec2.ISecurityGroup;
    constructor(scope: Construct, id: string, props: RDSAuroraServerlessProps);
}
