import * as lambda from 'aws-cdk-lib/aws-lambda';
import { Construct } from 'constructs';
export interface TextractConfigurationProps {
    readonly configuration_table: string;
    /** Function used to initialize the DynamoDB table for the Classification Configuration
     *  The Function has to implement CloudFormation Custom Resource https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-custom-resources-lambda.html
    */
    readonly configurationInitFunction?: lambda.IFunction;
}
/**
 * CloudFormation Custom Resources importing default configuration values from default_config.csv
 * into DynamoDB table.
 * Used by the Configuration Construct to configure Textrat features.
 * The DynamoDB table can be configured to your requirements.
 * The configuration has to match the manifest format.
 * Essentially the Configuration construct looks up the classification
 * and if a match is found in the DynamoDB table, configures the context
 * manifest object to include the configuration.
 *
 */
export declare class TextractConfiguration extends Construct {
    configurationInitFunction: lambda.IFunction;
    response: string;
    constructor(scope: Construct, id: string, props: TextractConfigurationProps);
}
