#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_sns_1 = require("aws-cdk-lib/aws-sns");
const budget_notifier_1 = require("./budget_notifier");
const NotificationType_1 = require("./NotificationType");
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, 'BudgetNotifierStack');
const topic = new aws_sns_1.Topic(stack, 'topic');
const statement = new aws_iam_1.PolicyStatement({
    effect: aws_iam_1.Effect.ALLOW,
    principals: [new aws_iam_1.ServicePrincipal('budgets.amazonaws.com')],
    actions: ['SNS:Publish'],
    sid: 'Allow budget to publish to SNS',
    resources: [topic.topicArn],
});
topic.addToResourcePolicy(statement);
new budget_notifier_1.BudgetNotifier(stack, 'notifier', {
    topicArn: topic.topicArn,
    availabilityZones: ['eu-central-1'],
    costCenter: 'MyCostCenter',
    limit: 10,
    unit: 'USD',
    threshold: 15,
    notificationType: NotificationType_1.NotificationType.FORECASTED,
});
//# sourceMappingURL=data:application/json;base64,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