from random import randint

from mona_sdk import Client, MonaSingleMessage

# Es monitor test
client_id = "e8018061-0559-4b22-b041-f10ef5848cd6"
secret_key = "9df5eefb-de6d-4529-b79a-60b398353449"

CONTEXT_CLASSES = [
    "SMADAR_TEST_IN_CONFIG_SAMPLED",
    "SMADAR_TEST_IN_CONFIG_SAMPLED_NOT_TAKEN",
    "SMADAR_TEST_TAKES_DEFAULT",
    "SMADAR_TEST_IN_CONFIG_FULLY_TAKEN",
]
NUMBER_OF_MESSAGES_PER_CONTEXT_CLASS = 10000


def random_with_N_digits(n):
    range_start = 10 ** (n - 1)
    range_end = (10 ** n) - 1
    return randint(range_start, range_end)


# Let's have 4 context classes - the 4th will take the default value (0.7).
my_mona_client = Client(
    api_key=client_id,
    secret=secret_key,
    user_id="ef3a7c1a-cf94-489b-8c69-5075136003f2",
    # should_use_authentication=False,
    # should_use_ssl=False,
    # override_rest_api_host="rest-api host address",
    sampling_config_name="smadar_neti_test"
)


for context_class in CONTEXT_CLASSES:
    messages = []
    for i in range(NUMBER_OF_MESSAGES_PER_CONTEXT_CLASS):
        messages.append(
            MonaSingleMessage(
                message={"sampled": "true"},
                contextClass=context_class,
                contextId=str(random_with_N_digits(10)),
            )
        )

    succeed_to_export = my_mona_client.export_batch(messages)
    print(f"\n{context_class}: {succeed_to_export}")
