import asyncio
import json
from concurrent.futures import ThreadPoolExecutor

from mona_sdk import MonaSingleMessage
from mona_sdk.async_client import AsyncClient


async def main():
    client_id = "40c08ee6-f411-41b1-9752-80d98897aae6"
    secret_key = "5694fad0-e372-488e-89cf-22ed8693a5a2"
    user_id = "01971934-5acd-4888-9894-071e32fa867c"
    loop = asyncio.get_event_loop()

    with ThreadPoolExecutor(max_workers=1) as executor:

        async_client = AsyncClient(
            client_id, secret_key, user_id=user_id, event_loop=loop, executor=executor
        )

        print("Starting test ...")

        # is_active
        is_active = await async_client.is_active_async()
        print(f"is_active: {is_active}")

        # sampling factors
        sampling_factors = await async_client.get_sampling_factors_async()
        print(f"sampling_factors: {sampling_factors}")
        events = {
            "userId": user_id,
            "messages": [
                {
                    "arcClass": "arcClassName",
                    "contextId": "ID_123",
                    "message": {
                        "company-id": "79sg7723-0253438g3453",
                        "browser": "chrome",
                        "text_length": 50,
                        "top_tagged_brand": "adidas",
                    },
                },
                {
                    "arcClass": "arcClassName",
                    "contextId": "ID_123",
                    "message": {"coutry": "usa"},
                },
                {
                    "arcClass": "arcClassName",
                    "contextId": "ID_124",
                    "message": {
                        "company-id": "2435f32-02ve3538g5232",
                        "browser": "safari",
                        "text_length": 30,
                        "top_tagged_brand": "nike",
                    },
                },
            ],
        }
        suggested_config = (
            await async_client.get_suggested_config_from_user_input_async(events)
        )
        print(f"suggested_config: {suggested_config}")
        mona_messages = [
            MonaSingleMessage(
                message={"smadar_test": "1"},
                contextClass="SMADAR_TEST2",
                contextId="903c97aagfd6812b4c8e32fa",
            ),
            MonaSingleMessage(
                message={"smadar_test": "2"},
                contextClass="SMADAR_TEST1",
                contextId="903c97aagfd6812b48gj27df",
            ),
            MonaSingleMessage(
                message={
                    "smadar_test": "3"
                },
                contextClass="SMADAR_TEST1",
            ),
            MonaSingleMessage(
                message={
                    "smadar_test": "4"
                },
                contextClass="SMADAR_TEST_NOT_IN_SAMPLING_CONFIG",
            ),
            MonaSingleMessage(
                message={"smadar_test": "5"},
                contextClass="SMADAR_TEST_NOT_IN_SAMPLING_CONFIG",
                contextId="10jjf8e4gfd681204j38f7gb",
            ),
        ]
        # export (Single msg)
        export_res = await async_client.export_async(mona_messages[0])
        print(f"export res: {export_res}")
        # export batch
        export_batch_res = await async_client.export_batch_async(mona_messages)
        print(f"export batch res: {export_batch_res}")

        res = async_client.get_config()
        print(f"get_config res: {res}")

        config = {} # TODO: filll!!!!

        res = async_client.validate_config(
                config
        )
        print(f"validate_config res: {res}")

        with open("/home/smadar/workspace/mona-sdk/mona_sdk/mona_config_smadar_turorial.json") as fd:
            config = json.load(fd)
        if config["01971934-5acd-4888-9894-071e32fa867c"]["LOAN_APPLICATION_TUTORIAL"]["feature_9"]["bucket_size"] == 200:
            config["01971934-5acd-4888-9894-071e32fa867c"]["LOAN_APPLICATION_TUTORIAL"][
                "feature_9"]["bucket_size"] = 100


        # upload_config
        #res = async_client.upload_config(config, commit_message="smadar async test", author="smadar")

        # Upload_config_per_context_class
        #upload_config_per_context_class(self, author, commit_message, context_class, config)
        #get_config_history(self, number_of_revisions=UNPROVIDED_VALUE))
        #create_sampling_factor()
#
        #get_suggested_config_from_user_input(self, events)


    print("... Done!")


asyncio.run(main())
