/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.UniversalIsomorphismTester;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.isomorphism.mcss.RMap;
import org.openscience.cdk.qsar.AtomValenceTool;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.ChiIndexUtilsTest")
class PaDELChiIndexUtils {
    PaDELChiIndexUtils() {
    }

    /*
     * WARNING - void declaration
     */
    public static List<List<Integer>> getFragments(IAtomContainer iAtomContainer, QueryAtomContainer[] queryAtomContainerArray) {
        void list;
        ArrayList<List<Integer>> arrayList = new ArrayList<List<Integer>>();
        Object arrayList2 = queryAtomContainerArray;
        int n = ((QueryAtomContainer[])arrayList2).length;
        boolean bl = false;
        while (list < n) {
            QueryAtomContainer queryAtomContainer = arrayList2[list];
            List<List<RMap>> list2 = null;
            try {
                list2 = UniversalIsomorphismTester.getSubgraphMaps(iAtomContainer, queryAtomContainer);
            }
            catch (CDKException cDKException) {
                cDKException.printStackTrace();
            }
            if (list2 != null && list2.size() != 0) {
                arrayList.addAll(PaDELChiIndexUtils.getUniqueBondSubgraphs(list2, iAtomContainer));
            }
            ++list;
        }
        arrayList2 = new ArrayList();
        block3: for (List list3 : arrayList) {
            for (QueryAtomContainer queryAtomContainer : queryAtomContainerArray) {
                if (list3.size() != queryAtomContainer.getAtomCount()) continue;
                arrayList2.add(list3);
                continue block3;
            }
        }
        return arrayList2;
    }

    public static double evalSimpleIndex(IAtomContainer iAtomContainer, List<List<Integer>> list) {
        double d = 0.0;
        for (List<Integer> list2 : list) {
            double d2 = 1.0;
            for (Integer n : list2) {
                IAtom iAtom = iAtomContainer.getAtom(n);
                int n2 = iAtomContainer.getConnectedAtomsCount(iAtom);
                d2 *= (double)n2;
            }
            if (d2 == 0.0) continue;
            d += 1.0 / Math.sqrt(d2);
        }
        return d;
    }

    public static double evalValenceIndex(IAtomContainer iAtomContainer, List list) throws CDKException {
        try {
            IsotopeFactory isotopeFactory = IsotopeFactory.getInstance(DefaultChemObjectBuilder.getInstance());
            isotopeFactory.configureAtoms(iAtomContainer);
        }
        catch (IOException iOException) {
            throw new CDKException("IO problem occured when using the CDK atom config\n" + iOException.getMessage(), iOException);
        }
        double d = 0.0;
        for (Object e : list) {
            ArrayList arrayList = (ArrayList)e;
            double d2 = 1.0;
            for (Object e2 : arrayList) {
                double d3;
                int n = (Integer)e2;
                IAtom iAtom = iAtomContainer.getAtom(n);
                String string = iAtom.getSymbol();
                if (string.equals("S") && (d3 = PaDELChiIndexUtils.deltavSulphur(iAtom, iAtomContainer)) != -1.0) {
                    d2 *= d3;
                    continue;
                }
                if (string.equals("P") && (d3 = PaDELChiIndexUtils.deltavPhosphorous(iAtom, iAtomContainer)) != -1.0) {
                    d2 *= d3;
                    continue;
                }
                int n2 = iAtom.getAtomicNumber();
                int n3 = PaDELChiIndexUtils.getValenceElectronCount(iAtom);
                int n4 = iAtom.getImplicitHydrogenCount();
                double d4 = (double)(n3 - n4) / (double)(n2 - n3 - 1);
                d2 *= d4;
            }
            if (d2 == 0.0) continue;
            d += 1.0 / Math.sqrt(d2);
        }
        return d;
    }

    private static int getValenceElectronCount(IAtom iAtom) {
        int n = AtomValenceTool.getValence(iAtom);
        return n - iAtom.getFormalCharge();
    }

    @TestMethod(value="testDeltaVSuplhurSO,testDeltaVSulphurSO2")
    protected static double deltavSulphur(IAtom iAtom, IAtomContainer iAtomContainer) {
        if (!iAtom.getSymbol().equals("S")) {
            return -1.0;
        }
        List<IAtom> list = iAtomContainer.getConnectedAtomsList(iAtom);
        for (IAtom object : list) {
            if (!object.getSymbol().equals("S") || iAtomContainer.getBond(iAtom, object).getOrder() != IBond.Order.SINGLE) continue;
            return 0.89;
        }
        int n = 0;
        for (IAtom iAtom2 : list) {
            if (!iAtom2.getSymbol().equals("O") || iAtomContainer.getBond(iAtom, iAtom2).getOrder() != IBond.Order.DOUBLE) continue;
            ++n;
        }
        if (n == 1) {
            return 1.33;
        }
        if (n == 2) {
            return 2.67;
        }
        return -1.0;
    }

    private static double deltavPhosphorous(IAtom iAtom, IAtomContainer iAtomContainer) {
        if (!iAtom.getSymbol().equals("P")) {
            return -1.0;
        }
        List<IAtom> list = iAtomContainer.getConnectedAtomsList(iAtom);
        int n = 0;
        if (list.size() == 4) {
            ++n;
        }
        for (IAtom iAtom2 : list) {
            if (iAtom2.getSymbol().equals("O") && iAtomContainer.getBond(iAtom, iAtom2).getOrder() == IBond.Order.DOUBLE) {
                ++n;
            }
            if (iAtomContainer.getBond(iAtom, iAtom2).getOrder() != IBond.Order.SINGLE) continue;
            ++n;
        }
        if (n == 5) {
            return 2.22;
        }
        return -1.0;
    }

    private static List<List<Integer>> getUniqueBondSubgraphs(List list, IAtomContainer iAtomContainer) {
        Object object;
        Object object2;
        Object object3;
        Object object422;
        ArrayList arrayList = new ArrayList();
        for (Object object422 : list) {
            List list2 = (List)object422;
            ArrayList<Integer> list3 = new ArrayList<Integer>();
            object3 = list2.iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                object = (RMap)object2;
                list3.add(((RMap)object).getId1());
            }
            Collections.sort(list3);
            arrayList.add(list3);
        }
        HashSet hashSet = new HashSet(arrayList);
        arrayList = new ArrayList(hashSet);
        object422 = new ArrayList();
        for (List list2 : arrayList) {
            object3 = list2;
            object2 = new ArrayList();
            object = object3.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                int n = (Integer)e;
                for (IAtom iAtom : iAtomContainer.getBond(n).atoms()) {
                    Integer n2 = iAtomContainer.getAtomNumber(iAtom);
                    if (object2.contains(n2)) continue;
                    object2.add(n2);
                }
            }
            object422.add(object2);
        }
        return object422;
    }
}

