"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.performGraphFilterPlan = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const constructs_1 = require("constructs");
const core_1 = require("../core");
const filters_1 = require("./filters");
const presets = require("./presets");
const types_1 = require("./types");
__exportStar(require("./types"), exports);
__exportStar(require("./filters"), exports);
/**
 * Perform graph filter plan on store.
 *
 * This operation is performed *in-place* and is destructive, therefore can only be applied
 * on stores that allow destructive mutations.
 * @param {Graph.Store} store - The store to perform filter plan against
 * @param {IGraphFilterPlan} plan - The filter plan to apply
 * @throws Error is store does not allow destructive mutations
 * @destructive
 */
function performGraphFilterPlan(store, plan) {
    filters_1.verifyFilterable(store);
    if (plan.focus) {
        presets.focusFilter(store, plan);
    }
    if (plan.preset) {
        switch (plan.preset) {
            case types_1.FilterPreset.NON_EXTRANEOUS: {
                presets.nonExtraneousFilterPreset(store);
                break;
            }
            case types_1.FilterPreset.COMPACT: {
                presets.compactFilterPreset(store);
                break;
            }
        }
    }
    if (plan.filters) {
        for (const filter of plan.filters) {
            if (typeof filter === "function") {
                // IGraphStoreFilter
                filter(store);
            }
            else {
                // IGraphFilter
                const inverse = filter.inverse === true;
                const allNodes = filter.allNodes != null ? filter.allNodes : plan.allNodes === true;
                const nodes = store.root.findAll({
                    order: plan.order || constructs_1.ConstructOrder.PREORDER,
                    predicate: (node) => {
                        if (allNodes)
                            return true;
                        // by default only return Resources and CfnResources
                        return (core_1.Graph.ResourceNode.isResourceNode(node) ||
                            core_1.Graph.CfnResourceNode.isCfnResourceNode(node));
                    },
                });
                if (filter.node) {
                    for (const node of nodes) {
                        if (node.isDestroyed)
                            continue;
                        const match = filter.node(node);
                        if ((match && inverse) || (!match && !inverse)) {
                            switch (filter.strategy || types_1.FilterStrategy.PRUNE) {
                                case types_1.FilterStrategy.PRUNE: {
                                    node.mutateDestroy();
                                    break;
                                }
                                case types_1.FilterStrategy.COLLAPSE: {
                                    node.mutateCollapse();
                                    break;
                                }
                                case types_1.FilterStrategy.COLLAPSE_TO_PARENT: {
                                    node.mutateCollapseToParent();
                                    break;
                                }
                            }
                        }
                    }
                }
                if (filter.edge) {
                    const edges = store.edges;
                    for (const edge of edges) {
                        if (edge.isDestroyed)
                            continue;
                        const match = filter.edge(edge);
                        if ((match && inverse) || (!match && !inverse)) {
                            edge.mutateDestroy();
                        }
                    }
                }
            }
        }
    }
}
exports.performGraphFilterPlan = performGraphFilterPlan;
//# sourceMappingURL=data:application/json;base64,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