"use strict";
/* eslint-disable max-len */
const core_1 = require("@aws-cdk/core");
const util_1 = require("../lib/util");
module.exports = {
    arnForParameterName: {
        'simple names': {
            'concrete parameterName and no physical name (sep is "/")'(test) {
                const stack = new core_1.Stack();
                test.deepEqual(stack.resolve(util_1.arnForParameterName(stack, 'myParam', undefined)), {
                    'Fn::Join': ['', ['arn:', { Ref: 'AWS::Partition' }, ':ssm:', { Ref: 'AWS::Region' }, ':', { Ref: 'AWS::AccountId' }, ':parameter/myParam']],
                });
                test.done();
            },
            'token parameterName and concrete physical name (no additional "/")'(test) {
                const stack = new core_1.Stack();
                test.deepEqual(stack.resolve(util_1.arnForParameterName(stack, core_1.Token.asString({ Ref: 'Boom' }), { physicalName: 'myParam' })), {
                    'Fn::Join': ['', ['arn:', { Ref: 'AWS::Partition' }, ':ssm:', { Ref: 'AWS::Region' }, ':', { Ref: 'AWS::AccountId' }, ':parameter/', { Ref: 'Boom' }]],
                });
                test.done();
            },
            'token parameterName, explicit "/" separator'(test) {
                const stack = new core_1.Stack();
                test.deepEqual(stack.resolve(util_1.arnForParameterName(stack, core_1.Token.asString({ Ref: 'Boom' }), { simpleName: true })), {
                    'Fn::Join': ['', ['arn:', { Ref: 'AWS::Partition' }, ':ssm:', { Ref: 'AWS::Region' }, ':', { Ref: 'AWS::AccountId' }, ':parameter/', { Ref: 'Boom' }]],
                });
                test.done();
            },
        },
        'path names': {
            'concrete parameterName and no physical name (sep is "/")'(test) {
                const stack = new core_1.Stack();
                test.deepEqual(stack.resolve(util_1.arnForParameterName(stack, '/foo/bar', undefined)), {
                    'Fn::Join': ['', ['arn:', { Ref: 'AWS::Partition' }, ':ssm:', { Ref: 'AWS::Region' }, ':', { Ref: 'AWS::AccountId' }, ':parameter/foo/bar']],
                });
                test.done();
            },
            'token parameterName and concrete physical name (no sep)'(test) {
                const stack = new core_1.Stack();
                test.deepEqual(stack.resolve(util_1.arnForParameterName(stack, core_1.Token.asString({ Ref: 'Boom' }), { physicalName: '/foo/bar' })), {
                    'Fn::Join': ['', ['arn:', { Ref: 'AWS::Partition' }, ':ssm:', { Ref: 'AWS::Region' }, ':', { Ref: 'AWS::AccountId' }, ':parameter', { Ref: 'Boom' }]],
                });
                test.done();
            },
            'token parameterName, explicit "" separator'(test) {
                const stack = new core_1.Stack();
                test.deepEqual(stack.resolve(util_1.arnForParameterName(stack, core_1.Token.asString({ Ref: 'Boom' }), { simpleName: false })), {
                    'Fn::Join': ['', ['arn:', { Ref: 'AWS::Partition' }, ':ssm:', { Ref: 'AWS::Region' }, ':', { Ref: 'AWS::AccountId' }, ':parameter', { Ref: 'Boom' }]],
                });
                test.done();
            },
        },
        'fails if explicit separator is not defined and parameterName is a token'(test) {
            const stack = new core_1.Stack();
            test.throws(() => util_1.arnForParameterName(stack, core_1.Token.asString({ Ref: 'Boom' })), /Unable to determine ARN separator for SSM parameter since the parameter name is an unresolved token. Use "fromAttributes" and specify "simpleName" explicitly/);
            test.done();
        },
    },
};
//# sourceMappingURL=data:application/json;base64,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