# Generated by Django 3.2.13 on 2023-03-08 15:19

import ckeditor.fields
import ckeditor_uploader.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('ddm', '0037_auto_20230227_1117'),
    ]

    operations = [
        migrations.AddField(
            model_name='donationblueprint',
            name='json_extraction_root',
            field=models.CharField(blank=True, default='', max_length=200),
        ),
        migrations.AlterField(
            model_name='donationblueprint',
            name='description',
            field=models.TextField(help_text='A description of which kind of data will be extracted by this Blueprint (e.g., "The title of your watched videos will be collected together with the time when you watched it."). Will be visible to participants.', null=True),
        ),
        migrations.AlterField(
            model_name='donationblueprint',
            name='file_uploader',
            field=models.ForeignKey(blank=True, help_text='The File Uploader through which the related file will be uploaded.', null=True, on_delete=django.db.models.deletion.SET_NULL, to='ddm.fileuploader', verbose_name='Associated File Uploader'),
        ),
        migrations.AlterField(
            model_name='donationblueprint',
            name='name',
            field=models.CharField(help_text='Name for this File Blueprint. Will be visible to participants, so pick an informative name (e.g., "Watch History").', max_length=250),
        ),
        migrations.AlterField(
            model_name='donationblueprint',
            name='regex_path',
            field=models.TextField(blank=True, help_text='The path where the file is expected to be located in the uploaded ZIP folder. You can use Regex to, e.g., add wildcard characters or to match files in different languages. Consult the documentation for some examples.', null=True, verbose_name='File path'),
        ),
        migrations.AlterField(
            model_name='donationproject',
            name='briefing_consent_enabled',
            field=models.BooleanField(default=False, help_text='Enable this option to obtain explicit consent from participant, that they want to start the study.', verbose_name='Briefing Consent Mandatory'),
        ),
        migrations.AlterField(
            model_name='donationproject',
            name='briefing_text',
            field=ckeditor_uploader.fields.RichTextUploadingField(blank=True, help_text='This text will be displayed to participants in the first step before beginning the data donation. Here, you should introduce your study, who is responsible for the study, provide a quick summary of what your participants will be asked to do in the next steps, etc.', null=True, verbose_name='Briefing Text'),
        ),
        migrations.AlterField(
            model_name='donationproject',
            name='contact_information',
            field=ckeditor.fields.RichTextField(help_text='Please provide the contact information of the person responsible for the conduction of this study (Name, professional address, e-mail, tel, ...). The contact information will be accessible for participants during the data donation. The field is mandatory.', null=True, verbose_name='Contact information'),
        ),
        migrations.AlterField(
            model_name='donationproject',
            name='data_protection_statement',
            field=ckeditor.fields.RichTextField(help_text='Please provide a data protection statement for your data donation collection. This should include the purpose for which the data is collected, how it will be stored, and who will have access to the data. The field is mandatory.', null=True, verbose_name='Data Protection Statement'),
        ),
        migrations.AlterField(
            model_name='donationproject',
            name='debriefing_text',
            field=ckeditor_uploader.fields.RichTextUploadingField(blank=True, help_text='This text will be displayed to participants on the last page of the study (i.e., after the data donation and the questionnaire).', null=True, verbose_name='Debriefing Text'),
        ),
        migrations.AlterField(
            model_name='donationproject',
            name='name',
            field=models.CharField(help_text='Project Name - for internal organisation only (can still be changed later).', max_length=50),
        ),
        migrations.AlterField(
            model_name='donationproject',
            name='slug',
            field=models.SlugField(help_text='Identifier that is included in the URL through which participants can access the project (e.g, https://root.url/url-identifier).', unique=True, verbose_name='URL Identifier'),
        ),
        migrations.AlterField(
            model_name='processingrule',
            name='comparison_operator',
            field=models.CharField(blank=True, choices=[('==', 'Equal (==)'), ('!=', 'Not Equal (!=)'), ('>', 'Greater than (>)'), ('<', 'Smaller than (<)'), ('>=', 'Greater than or equal (>=)'), ('<=', 'Smaller than or equal (<=)'), ('regex-delete-match', 'Delete match (regex)'), ('regex-replace-match', 'Replace match (regex)'), ('regex-delete-row', 'Delete row when match (regex)')], default=None, max_length=24, null=True, verbose_name='Extraction Operator'),
        ),
        migrations.AlterField(
            model_name='processingrule',
            name='comparison_value',
            field=models.TextField(blank=True, help_text='The value against which the data contained in the indicated field will be compared according to the selected comparison logic.'),
        ),
        migrations.AlterField(
            model_name='processingrule',
            name='execution_order',
            field=models.IntegerField(help_text='The order in which the extraction steps are executed.'),
        ),
        migrations.AlterField(
            model_name='processingrule',
            name='field',
            field=models.TextField(help_text='The field on which the rule will be applied (just as a string without quotes).If a field is mentioned in a rule, it will be kept in the data that are sent to the server.'),
        ),
        migrations.AlterField(
            model_name='processingrule',
            name='name',
            field=models.CharField(help_text='An informative name for this rule. Only used internally.', max_length=250),
        ),
        migrations.AlterField(
            model_name='questionbase',
            name='question_type',
            field=models.CharField(choices=[('generic', 'Generic Question'), ('single_choice', 'Single Choice Question'), ('multi_choice', 'Multi Choice Question'), ('matrix', 'Matrix Question'), ('semantic_diff', 'Semantic Differential'), ('open', 'Open Question'), ('transition', 'Text Block')], default='generic', max_length=20),
        ),
        migrations.AlterField(
            model_name='questionbase',
            name='text',
            field=ckeditor_uploader.fields.RichTextUploadingField(blank=True, help_text='If a question is linked to a File Blueprint, data points from the donated data associated with the linked donation blueprint can be included in the question text. This data can be included as "{{ data }}" in the question text. It is possible to subset the data object (e.g., to include the last datapoint you can use {{ data.0 }} or include advanced rendering options included in the Django templating engine. For a more comprehensive overview and examples see [LINK TO BE INCLUDED]. Additionally, information directly related to the participant can be included in the question text. This information can be referenced as "{{ participant }}".', null=True),
        ),
    ]
