"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegSsmParameters = exports.IntegTesting = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const _1 = require("./");
class IntegTesting {
    constructor() {
        const app = new aws_cdk_lib_1.App();
        const envJP = {
            region: 'ap-northeast-1',
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const envUS = {
            region: 'us-west-2',
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        // first stack in JP
        const stackJP = new aws_cdk_lib_1.Stack(app, 'demo-stack-jp', { env: envJP });
        new aws_cdk_lib_1.CfnOutput(stackJP, 'TopicName', { value: 'foo' });
        // second stack in US
        const stackUS = new aws_cdk_lib_1.Stack(app, 'demo-stack-us', { env: envUS });
        // ensure the dependency
        stackUS.addDependency(stackJP);
        // get the stackJP stack outputs from stackUS
        const outputs = new _1.RemoteOutputs(stackUS, 'Outputs', {
            stack: stackJP,
            alwaysUpdate: false,
        });
        const remoteOutputValue = outputs.get('TopicName');
        // the value should be exactly the same with the output value of `TopicName`
        new aws_cdk_lib_1.CfnOutput(stackUS, 'RemoteTopicName', { value: remoteOutputValue });
        this.stack = [stackJP, stackUS];
    }
}
exports.IntegTesting = IntegTesting;
class IntegSsmParameters {
    constructor() {
        const app = new aws_cdk_lib_1.App();
        const envJP = {
            region: 'ap-northeast-1',
            account: '111111111111',
        };
        const envUS = {
            region: 'us-west-2',
            account: '222222222222',
        };
        // first stack in JP
        const producerStackName = 'demo-stack-jp';
        const stackJP = new aws_cdk_lib_1.Stack(app, producerStackName, { env: envJP });
        const parameterPath = `/${envJP.account}/${envJP.region}/${producerStackName}`;
        new aws_cdk_lib_1.aws_ssm.StringParameter(stackJP, 'foo1', {
            parameterName: `${parameterPath}/foo1`,
            stringValue: 'bar1',
        });
        new aws_cdk_lib_1.aws_ssm.StringParameter(stackJP, 'foo2', {
            parameterName: `${parameterPath}/foo2`,
            stringValue: 'bar2',
        });
        new aws_cdk_lib_1.aws_ssm.StringParameter(stackJP, 'foo3', {
            parameterName: `${parameterPath}/foo3`,
            stringValue: 'bar3',
        });
        // allow US account to assume this readonly role to get parameters
        const cdkReadOnlyRole = new aws_cdk_lib_1.aws_iam.Role(stackJP, 'readOnlyRole', {
            assumedBy: new aws_cdk_lib_1.aws_iam.AccountPrincipal(envUS.account),
            roleName: aws_cdk_lib_1.PhysicalName.GENERATE_IF_NEEDED,
            managedPolicies: [aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMReadOnlyAccess')],
        });
        // second stack in US
        const stackUS = new aws_cdk_lib_1.Stack(app, 'demo-stack-us', { env: envUS });
        // ensure the dependency
        stackUS.addDependency(stackJP);
        // get remote parameters by path from SSM parameter store
        const parameters = new _1.RemoteParameters(stackUS, 'Parameters', {
            path: parameterPath,
            region: stackJP.region,
            // assume this role for cross-account parameters
            role: aws_cdk_lib_1.aws_iam.Role.fromRoleArn(stackUS, 'readOnlyRole', cdkReadOnlyRole.roleArn),
        });
        const foo1 = parameters.get(`${parameterPath}/foo1`);
        const foo2 = parameters.get(`${parameterPath}/foo2`);
        const foo3 = parameters.get(`${parameterPath}/foo3`);
        new aws_cdk_lib_1.CfnOutput(stackUS, 'foo1Output', { value: foo1 });
        new aws_cdk_lib_1.CfnOutput(stackUS, 'foo2Output', { value: foo2 });
        new aws_cdk_lib_1.CfnOutput(stackUS, 'foo3Output', { value: foo3 });
        this.stack = [stackJP, stackUS];
    }
}
exports.IntegSsmParameters = IntegSsmParameters;
new IntegTesting();
new IntegSsmParameters();
//# sourceMappingURL=data:application/json;base64,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