from huobi.model.trade.order_list_item import OrderListItem


class OrderDetailReq:
    """
    The order update received by subscription of order update.

    :member
        symbol: The symbol you subscribed.
        timestamp: The UNIX formatted timestamp generated by server in UTC.
        topic : request topic
        client_req_id : client request id
        data: The order detail.

    """

    def __init__(self):
        self.ts = 0
        self.topic = ""
        self.cid = ""
        self.data = OrderListItem()


    def print_object(self, format_data=""):
        from huobi.utils.print_mix_object import PrintBasic
        PrintBasic.print_basic(self.ts, format_data + "Timestamp")
        PrintBasic.print_basic(self.cid, format_data + "Client Req ID")
        PrintBasic.print_basic(self.topic, format_data + "Topic")
        self.data.print_object("\t")