"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Flow = exports.FlowProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const appflow_generated_1 = require("./appflow.generated");
Object.defineProperty(exports, "FlowProperty", { enumerable: true, get: function () { return appflow_generated_1.RosFlow; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::AppFlow::Flow`, which is used to create a flow.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosFlow`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-appflow-flow
 */
class Flow extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosFlow = new appflow_generated_1.RosFlow(this, id, {
            flowId: props.flowId,
            parameters: props.parameters,
            flowDesc: props.flowDesc,
            flowName: props.flowName,
            launchFlow: props.launchFlow === undefined || props.launchFlow === null ? true : props.launchFlow,
            flowStatus: props.flowStatus === undefined || props.flowStatus === null ? 'Enable' : props.flowStatus,
            templateId: props.templateId,
            template: props.template,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosFlow;
        this.attrFlowId = rosFlow.attrFlowId;
        this.attrWebhookAddress = rosFlow.attrWebhookAddress;
    }
}
exports.Flow = Flow;
//# sourceMappingURL=data:application/json;base64,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