"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChatbotModel = exports.ChatbotModelProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const appflow_generated_1 = require("./appflow.generated");
Object.defineProperty(exports, "ChatbotModelProperty", { enumerable: true, get: function () { return appflow_generated_1.RosChatbotModel; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::AppFlow::ChatbotModel`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosChatbotModel`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-appflow-chatbotmodel
 */
class ChatbotModel extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosChatbotModel = new appflow_generated_1.RosChatbotModel(this, id, {
            status: props.status,
            chatbotId: props.chatbotId,
            parameters: props.parameters,
            userAuthConfigId: props.userAuthConfigId,
            modelActionId: props.modelActionId,
            modelId: props.modelId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosChatbotModel;
        this.attrChatbotModelId = rosChatbotModel.attrChatbotModelId;
    }
}
exports.ChatbotModel = ChatbotModel;
//# sourceMappingURL=data:application/json;base64,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