"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Chatbot = exports.ChatbotProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const appflow_generated_1 = require("./appflow.generated");
Object.defineProperty(exports, "ChatbotProperty", { enumerable: true, get: function () { return appflow_generated_1.RosChatbot; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::AppFlow::Chatbot`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosChatbot`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-appflow-chatbot
 */
class Chatbot extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosChatbot = new appflow_generated_1.RosChatbot(this, id, {
            chatbotConfig: props.chatbotConfig,
            chatbotName: props.chatbotName,
            chatbotIcon: props.chatbotIcon,
            chatbotDesc: props.chatbotDesc,
            from: props.from,
            templateId: props.templateId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosChatbot;
        this.attrChatbotId = rosChatbot.attrChatbotId;
    }
}
exports.Chatbot = Chatbot;
//# sourceMappingURL=data:application/json;base64,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