# coding: utf-8

"""
    Aliro Q.Network

    This is an api for the Aliro Q.Network  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: nick@aliroquantum.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from aliro_quantum_networking.configuration import Configuration


class SubmissionAqnBaseGlobalSettings(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'excitation_rate': 'float',
        'purification_protocol_name': 'str'
    }

    attribute_map = {
        'excitation_rate': 'excitationRate',
        'purification_protocol_name': 'purificationProtocolName'
    }

    def __init__(self, excitation_rate=80000000, purification_protocol_name='BBPSSW_X', local_vars_configuration=None):  # noqa: E501
        """SubmissionAqnBaseGlobalSettings - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._excitation_rate = None
        self._purification_protocol_name = None
        self.discriminator = None

        if excitation_rate is not None:
            self.excitation_rate = excitation_rate
        if purification_protocol_name is not None:
            self.purification_protocol_name = purification_protocol_name

    @property
    def excitation_rate(self):
        """Gets the excitation_rate of this SubmissionAqnBaseGlobalSettings.  # noqa: E501

        Maximum frequency of excitation for quantum memories (Hz)  # noqa: E501

        :return: The excitation_rate of this SubmissionAqnBaseGlobalSettings.  # noqa: E501
        :rtype: float
        """
        return self._excitation_rate

    @excitation_rate.setter
    def excitation_rate(self, excitation_rate):
        """Sets the excitation_rate of this SubmissionAqnBaseGlobalSettings.

        Maximum frequency of excitation for quantum memories (Hz)  # noqa: E501

        :param excitation_rate: The excitation_rate of this SubmissionAqnBaseGlobalSettings.  # noqa: E501
        :type: float
        """
        if (self.local_vars_configuration.client_side_validation and
                excitation_rate is not None and excitation_rate < 0):  # noqa: E501
            raise ValueError("Invalid value for `excitation_rate`, must be a value greater than or equal to `0`")  # noqa: E501

        self._excitation_rate = excitation_rate

    @property
    def purification_protocol_name(self):
        """Gets the purification_protocol_name of this SubmissionAqnBaseGlobalSettings.  # noqa: E501

        - BBPSSW_X - BBPSSW correcting for bit flips. - BBPSSW_Z - BBPSSW correcting for phase flips. - DSDP - DSSP_X - DSSP correcting for bit flips. - DSSP_Z - DSSP correcting for phase flips. - SSDP   # noqa: E501

        :return: The purification_protocol_name of this SubmissionAqnBaseGlobalSettings.  # noqa: E501
        :rtype: str
        """
        return self._purification_protocol_name

    @purification_protocol_name.setter
    def purification_protocol_name(self, purification_protocol_name):
        """Sets the purification_protocol_name of this SubmissionAqnBaseGlobalSettings.

        - BBPSSW_X - BBPSSW correcting for bit flips. - BBPSSW_Z - BBPSSW correcting for phase flips. - DSDP - DSSP_X - DSSP correcting for bit flips. - DSSP_Z - DSSP correcting for phase flips. - SSDP   # noqa: E501

        :param purification_protocol_name: The purification_protocol_name of this SubmissionAqnBaseGlobalSettings.  # noqa: E501
        :type: str
        """
        allowed_values = ["BBPSSW_X", "BBPSSW_Z", "SSDP", "DSSP_X", "DSSP_Z", "DSDP"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and purification_protocol_name not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `purification_protocol_name` ({0}), must be one of {1}"  # noqa: E501
                .format(purification_protocol_name, allowed_values)
            )

        self._purification_protocol_name = purification_protocol_name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SubmissionAqnBaseGlobalSettings):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SubmissionAqnBaseGlobalSettings):
            return True

        return self.to_dict() != other.to_dict()
