# coding: utf-8

"""
    Aliro Q.Network

    This is an api for the Aliro Q.Network  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: nick@aliroquantum.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from aliro_quantum_networking.configuration import Configuration


class QuantumConnection(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'attenuation': 'float',
        'dark_count_rate': 'float',
        'distance': 'float',
        'efficiency': 'float',
        'error_models': 'list[ErrorModel]',
        'name': 'str',
        'node_from': 'str',
        'node_to': 'str'
    }

    attribute_map = {
        'attenuation': 'attenuation',
        'dark_count_rate': 'darkCountRate',
        'distance': 'distance',
        'efficiency': 'efficiency',
        'error_models': 'errorModels',
        'name': 'name',
        'node_from': 'nodeFrom',
        'node_to': 'nodeTo'
    }

    def __init__(self, attenuation=0.001, dark_count_rate=None, distance=1000, efficiency=1, error_models=None, name=None, node_from=None, node_to=None, local_vars_configuration=None):  # noqa: E501
        """QuantumConnection - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._attenuation = None
        self._dark_count_rate = None
        self._distance = None
        self._efficiency = None
        self._error_models = None
        self._name = None
        self._node_from = None
        self._node_to = None
        self.discriminator = None

        if attenuation is not None:
            self.attenuation = attenuation
        if dark_count_rate is not None:
            self.dark_count_rate = dark_count_rate
        if distance is not None:
            self.distance = distance
        if efficiency is not None:
            self.efficiency = efficiency
        if error_models is not None:
            self.error_models = error_models
        if name is not None:
            self.name = name
        self.node_from = node_from
        self.node_to = node_to

    @property
    def attenuation(self):
        """Gets the attenuation of this QuantumConnection.  # noqa: E501


        :return: The attenuation of this QuantumConnection.  # noqa: E501
        :rtype: float
        """
        return self._attenuation

    @attenuation.setter
    def attenuation(self, attenuation):
        """Sets the attenuation of this QuantumConnection.


        :param attenuation: The attenuation of this QuantumConnection.  # noqa: E501
        :type: float
        """
        if (self.local_vars_configuration.client_side_validation and
                attenuation is not None and attenuation < 0):  # noqa: E501
            raise ValueError("Invalid value for `attenuation`, must be a value greater than or equal to `0`")  # noqa: E501

        self._attenuation = attenuation

    @property
    def dark_count_rate(self):
        """Gets the dark_count_rate of this QuantumConnection.  # noqa: E501


        :return: The dark_count_rate of this QuantumConnection.  # noqa: E501
        :rtype: float
        """
        return self._dark_count_rate

    @dark_count_rate.setter
    def dark_count_rate(self, dark_count_rate):
        """Sets the dark_count_rate of this QuantumConnection.


        :param dark_count_rate: The dark_count_rate of this QuantumConnection.  # noqa: E501
        :type: float
        """
        if (self.local_vars_configuration.client_side_validation and
                dark_count_rate is not None and dark_count_rate < 0):  # noqa: E501
            raise ValueError("Invalid value for `dark_count_rate`, must be a value greater than or equal to `0`")  # noqa: E501

        self._dark_count_rate = dark_count_rate

    @property
    def distance(self):
        """Gets the distance of this QuantumConnection.  # noqa: E501

        The distance in meters  # noqa: E501

        :return: The distance of this QuantumConnection.  # noqa: E501
        :rtype: float
        """
        return self._distance

    @distance.setter
    def distance(self, distance):
        """Sets the distance of this QuantumConnection.

        The distance in meters  # noqa: E501

        :param distance: The distance of this QuantumConnection.  # noqa: E501
        :type: float
        """
        if (self.local_vars_configuration.client_side_validation and
                distance is not None and distance < 0):  # noqa: E501
            raise ValueError("Invalid value for `distance`, must be a value greater than or equal to `0`")  # noqa: E501

        self._distance = distance

    @property
    def efficiency(self):
        """Gets the efficiency of this QuantumConnection.  # noqa: E501


        :return: The efficiency of this QuantumConnection.  # noqa: E501
        :rtype: float
        """
        return self._efficiency

    @efficiency.setter
    def efficiency(self, efficiency):
        """Sets the efficiency of this QuantumConnection.


        :param efficiency: The efficiency of this QuantumConnection.  # noqa: E501
        :type: float
        """
        if (self.local_vars_configuration.client_side_validation and
                efficiency is not None and efficiency > 1):  # noqa: E501
            raise ValueError("Invalid value for `efficiency`, must be a value less than or equal to `1`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                efficiency is not None and efficiency < 0):  # noqa: E501
            raise ValueError("Invalid value for `efficiency`, must be a value greater than or equal to `0`")  # noqa: E501

        self._efficiency = efficiency

    @property
    def error_models(self):
        """Gets the error_models of this QuantumConnection.  # noqa: E501


        :return: The error_models of this QuantumConnection.  # noqa: E501
        :rtype: list[ErrorModel]
        """
        return self._error_models

    @error_models.setter
    def error_models(self, error_models):
        """Sets the error_models of this QuantumConnection.


        :param error_models: The error_models of this QuantumConnection.  # noqa: E501
        :type: list[ErrorModel]
        """

        self._error_models = error_models

    @property
    def name(self):
        """Gets the name of this QuantumConnection.  # noqa: E501


        :return: The name of this QuantumConnection.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this QuantumConnection.


        :param name: The name of this QuantumConnection.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def node_from(self):
        """Gets the node_from of this QuantumConnection.  # noqa: E501


        :return: The node_from of this QuantumConnection.  # noqa: E501
        :rtype: str
        """
        return self._node_from

    @node_from.setter
    def node_from(self, node_from):
        """Sets the node_from of this QuantumConnection.


        :param node_from: The node_from of this QuantumConnection.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and node_from is None:  # noqa: E501
            raise ValueError("Invalid value for `node_from`, must not be `None`")  # noqa: E501

        self._node_from = node_from

    @property
    def node_to(self):
        """Gets the node_to of this QuantumConnection.  # noqa: E501


        :return: The node_to of this QuantumConnection.  # noqa: E501
        :rtype: str
        """
        return self._node_to

    @node_to.setter
    def node_to(self, node_to):
        """Sets the node_to of this QuantumConnection.


        :param node_to: The node_to of this QuantumConnection.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and node_to is None:  # noqa: E501
            raise ValueError("Invalid value for `node_to`, must not be `None`")  # noqa: E501

        self._node_to = node_to

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QuantumConnection):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, QuantumConnection):
            return True

        return self.to_dict() != other.to_dict()
