# TapoPlugAPI

Tapo Plug Api is a python warper that can be easily be integrated in any project to control the TP-Link P100 and P105 plugs.

The endpoints of the plugs were discovered after a reverse engineering of the firmware Tapo 1.3.2 Build 20210122 Rel.
Other endpoints not exploited still need to be integrated in this library, but due to lack of information of which parameter to use for each requests I could'n integrate them now (the full list of the endpoints after the examples).

If you also want to have fun with the firmware the link is also after the examples.

[![PyPI Version](https://badge.fury.io/py/netsparker-api.svg)](https://pypi.python.org/pypi/netsparker_api)
### Dependencies:
* Python 3.3+
* requests module (install via pip)
* The dependencies can be satisfied via `pip install -r requirements.txt`

### Quick Install
```
pip install tapo-plug
```

### Endpoints:

* Get device information

```python 
from tapo import tapoPlugApi
  
device = {
    "tapoIp": "DEVICE IP",
    "tapoEmail": "ENTER YOUR TP-LINK EMAIL",
    "tapoPassword": "ENTER YOUR TP-LINK PWD"
}
  
  my_info = tapoApi.getDeviceInfo(device)
  print(my_info)
```

* Get device running information

```python 
from tapo import tapoPlugApi
  
device = {
    "tapoIp": "DEVICE IP",
    "tapoEmail": "ENTER YOUR TP-LINK EMAIL",
    "tapoPassword": "ENTER YOUR TP-LINK PWD"
}
  
  my_info = tapoApi.getDeviceRunningInfo(device)
  print(my_info)
```

* Turn ON the plug.

```python
from tapo import tapoPlugApi
  
device = {
    "tapoIp": "DEVICE IP",
    "tapoEmail": "ENTER YOUR TP-LINK EMAIL",
    "tapoPassword": "ENTER YOUR TP-LINK PWD"
}
  
  my_info = tapoApi.plugOn(device)
  print(my_info)
```
* Turn OFF the plug.

```python
from tapo import tapoPlugApi
  
device = {
    "tapoIp": "DEVICE IP",
    "tapoEmail": "ENTER YOUR TP-LINK EMAIL",
    "tapoPassword": "ENTER YOUR TP-LINK PWD"
}
  
  my_info = tapoApi.plugOff(device)
  print(my_info)
```

* Get plug time usage.

```python
from tapo import tapoPlugApi
  
device = {
    "tapoIp": "DEVICE IP",
    "tapoEmail": "ENTER YOUR TP-LINK EMAIL",
    "tapoPassword": "ENTER YOUR TP-LINK PWD"
}
  
  my_info = tapoApi.getPlugUsage(device)
  print(my_info)
```

* Change plug alias.

```python
from tapo import tapoPlugApi
  
device = {
    "tapoIp": "DEVICE IP",
    "tapoEmail": "ENTER YOUR TP-LINK EMAIL",
    "tapoPassword": "ENTER YOUR TP-LINK PWD",
    "nickname": "My Awesome Plug!",
}
  
  my_info = tapoApi.setNickname(device)
  print(my_info)
```

* Turn OFF the LED.

```python
from tapo import tapoPlugApi
  
device = {
    "tapoIp": "DEVICE IP",
    "tapoEmail": "ENTER YOUR TP-LINK EMAIL",
    "tapoPassword": "ENTER YOUR TP-LINK PWD"
}
  
  my_info = tapoApi.ledOff(device)
  print(my_info)
```

* Turn ON the LED.

```python
from tapo import tapoPlugApi
  
device = {
    "tapoIp": "DEVICE IP",
    "tapoEmail": "ENTER YOUR TP-LINK EMAIL",
    "tapoPassword": "ENTER YOUR TP-LINK PWD"
}
  
  my_info = tapoApi.ledOn(device)
  print(my_info)
```
* Get LED status (ON/OFF).
```python
from tapo import tapoPlugApi
  
device = {
    "tapoIp": "DEVICE IP",
    "tapoEmail": "ENTER YOUR TP-LINK EMAIL",
    "tapoPassword": "ENTER YOUR TP-LINK PWD"
}
  
  my_info = tapoApi.getLedInfo(device)
  print(my_info)
```

* Automatically turns OFF the device when the provided delay is expired.
```python
from tapo import tapoPlugApi
  
device = {
    "tapoIp": "DEVICE IP",
    "tapoEmail": "ENTER YOUR TP-LINK EMAIL",
    "tapoPassword": "ENTER YOUR TP-LINK PWD",
    "delay":"60" #seconds
}
  
  my_info = tapoApi.plugOffCountdown(device)
  print(my_info)
```

* Automatically turns ON the device when the provided delay is expired.
```python
from tapo import tapoPlugApi
  
device = {
    "tapoIp": "DEVICE IP",
    "tapoEmail": "ENTER YOUR TP-LINK EMAIL",
    "tapoPassword": "ENTER YOUR TP-LINK PWD",
    "delay":"60" #seconds
}
  
  my_info = tapoApi.plugOnCountdown(device)
  print(my_info)
```

* Get some diagnostic information's.
```python
from tapo import tapoPlugApi
  
device = {
    "tapoIp": "DEVICE IP",
    "tapoEmail": "ENTER YOUR TP-LINK EMAIL",
    "tapoPassword": "ENTER YOUR TP-LINK PWD"
}
  
  my_info = tapoApi.getDiagnoseStatus(device)
  print(my_info)
```

* Should get device log, but always empty for me, I leave it here just in case...
```python
from tapo import tapoPlugApi
  
device = {
    "tapoIp": "DEVICE IP",
    "tapoEmail": "ENTER YOUR TP-LINK EMAIL",
    "tapoPassword": "ENTER YOUR TP-LINK PWD"
}
  
  my_info = tapoApi.getPlugLog(device)
  print(my_info)
```

* Can't really tell for what this id used for now.
```python
from tapo import tapoPlugApi
  
device = {
    "tapoIp": "DEVICE IP",
    "tapoEmail": "ENTER YOUR TP-LINK EMAIL",
    "tapoPassword": "ENTER YOUR TP-LINK PWD"
}
  
  my_info = tapoApi.qsComponentNego(device)
  print(my_info)
```

Endpoints List         | Endpoints List         |
-------------| -----------|
get_device_info | remove_antitheft_rules |
get_device_running_info |  set_antitheft_all_enable |
set_device_info |     unbindDevice  |   
device_reset |  setAlias | 
device_reboot |   passthrough |
get_latest_fw |  multipleRequest |
fw_download |  getWifiBasic |
get_fw_download_state |   getFwCurrentVer |
component_nego |  getFwDownloadProgress |
qs_component_nego |  module.negotiate |
set_qs_info |  module.query |
set_qs_extra_info |  module.execute |
get_device_time |  module.config |
set_device_time |  get_factory_info |
get_wireless_scan_info |  get_diagnose_status |
set_wireless_info |  account_sync |
get_schedule_rules |  sync_env |
add_schedule_rule |  set_device_log | 
edit_schedule_rule |  get_device_log |
remove_schedule_rules |  set_flash_log |
set_schedule_all_enable |  get_flash_log |
get_next_event |  get_led_info |
get_schedule_day_runtime |  set_led_info |
get_schedule_month_runtime |  connect_cloud |
remove_all_schedule_runtime |  get_connect_cloud_state |
get_countdown_rules |  get_ffs_info |
add_countdown_rule |  close_device_ble |
edit_countdown_rule |  heart_beat |
remove_countdown_rules |  get_device_usage |
get_antitheft_rules |  close_device_ble |
add_antitheft_rule |  set_inherit_info |
edit_antitheft_rule |  get_inherit_info|
exec_atcmd |  I think the function exec_atcmd is one of the most interesting because the function name mean it is possible to send AT commands directly to the device, in theory. I've tried everything but nothing worked... In any case all the compatible AT commands are also listed in the firmware, if someone can find how to use it... PLEASE ping me!|


Tapo P105 1.3.2 firmware:
http://download.tplinkcloud.com/firmware/P105_1.3.2_20210122_r57063_up_signed_1615802824400.bin
### Building modules:

* To build a package to install via `pip` or `easy_install`, execute:
    * `python setup.py sdist`
* The resulting build will be in `$PWD/dist/Netsparker_Rest_API-<version>.tar.gz`
